/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.processors;

import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.SearchException;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class DefaultSearchProcessor
extends SearchProcessor {
    private Map<String, Comparator<SimpleHash>> comparators;

    public DefaultSearchProcessor(RequestProcessorSettings settings) {
        super(settings);
        this.initComparators();
    }

    private void initComparators() {
        this.comparators = new HashMap<String, Comparator<SimpleHash>>();
        this.comparators.put("lastmodified", new SimpleHashComparator("lastmodified"));
        this.comparators.put("filename", new SimpleHashComparator("src"));
    }

    @Override
    public RendererTextResponse search(Parameters parameters, HttpSession session) {
        RendererTextResponse result;
        try {
            boolean authenticated = false;
            UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
            Object sessionidObj = null;
            String sessionid = null;
            if (session != null) {
                sessionidObj = session.getAttribute("id");
            }
            if (uai != null && session != null && sessionidObj != null) {
                sessionid = (String)sessionidObj;
                authenticated = uai.validateSession(sessionid) == UserAuthenticationInterface.SessionStatus.VALID;
            }
            boolean authorized = false;
            if (authenticated || parameters.getAssetURLPath() != null) {
                authorized = true;
            }
            if (!authorized) {
                result = new RendererTextResponse();
                result.setStatus(403);
            } else {
                result = this.search(parameters, uai, session);
            }
        }
        catch (NotConfiguredException e) {
            result = new RendererTextResponse();
            result.setStatus(503);
        }
        return result;
    }

    private RendererTextResponse search(Parameters parameters, UserAuthenticationInterface uai, HttpSession session) {
        RendererTextResponse textResult = new RendererTextResponse();
        SolrSearcher sdb = this.settings.getSolrSearcher();
        if (sdb != null) {
            String assetPath = parameters.get(Parameters.General.source);
            SourceConnectorReader assetPathConnector = null;
            if (assetPath != null) {
                assetPathConnector = this.settings.getSourceConnectorFromAssetURLPath(assetPath);
            }
            List<String> validConnectors = this.getValidConnectors(uai, session, assetPathConnector);
            try {
                SearchProcessor.SearchResult sr;
                String listTemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "image_list.xml";
                Template template = this.settings.getTemplateCache().getTemplate(TemplateType.LIST, listTemplate + ".ftl");
                TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
                String staticTypeFilter = templateAttrs.getStaticTypeFilter();
                if (!validConnectors.isEmpty()) {
                    SolrUpdater supd;
                    int from = 0;
                    int length = 0;
                    if (parameters.contains(Parameters.Search.limit)) {
                        String[] lparams = parameters.get(Parameters.Search.limit).split(",");
                        from = Integer.parseInt(lparams[0]);
                        length = Integer.parseInt(lparams[1]);
                    }
                    String searchString = parameters.get(Parameters.Search.query);
                    if (session != null && uai.validateSession((String)session.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.VALID && this.settings.getServletContext().getAttribute("SolrUpdater") != null && (supd = (SolrUpdater)this.settings.getServletContext().getAttribute("SolrUpdater")).isEnabled()) {
                        supd.waitForPseudoFlush();
                    }
                    sr = sdb.search(searchString, assetPath, validConnectors, staticTypeFilter, from, length, parameters.get(Parameters.Sorting.sortfield), parameters.get(Parameters.Sorting.sortorder));
                } else {
                    sr = new SearchProcessor.SearchResult();
                }
                this.renderResult(sr.resultList, textResult, null, sr.totalResults, template);
                textResult.setStatus(200);
            }
            catch (IOException e) {
                this.settings.getFSILogger().logException(e, 3186, e.getClass().getName() + ": " + e.getLocalizedMessage());
                textResult.setStatus(500);
                textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
            }
            catch (TemplateModelException e) {
                this.settings.getFSILogger().logException((Exception)((Object)e), 3186, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
                textResult.setStatus(500);
                textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
            }
            catch (TemplateException e) {
                this.settings.getFSILogger().logException((Exception)((Object)e), 3186, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
                textResult.setStatus(500);
                textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
            }
            catch (SearchException e) {
                textResult.setStatus(e.getCode());
                textResult.setBody("{\"statuscode\":\"" + e.getCode() + "\",\"cause\":\"" + e.getMessage() + "\"}");
            }
        } else {
            textResult.setStatus(503);
            textResult.setBody("{\"statuscode\":\"503\",\"cause\":\"Search disabled\"}");
        }
        return textResult;
    }

    private class SimpleHashComparator
    implements Comparator<SimpleHash> {
        private final String fieldname;

        private SimpleHashComparator(String fieldname) {
            this.fieldname = fieldname;
        }

        @Override
        public int compare(SimpleHash o1, SimpleHash o2) {
            int result = 0;
            try {
                if (o1.get(this.fieldname) == null || o2.get(this.fieldname) == null) {
                    if (o1.get(this.fieldname) == null && o2.get(this.fieldname) == null) {
                        result = 0;
                    } else if (o1.get(this.fieldname) == null) {
                        result = -1;
                    } else if (o2.get(this.fieldname) == null) {
                        result = 1;
                    }
                } else {
                    TemplateModel tm1 = o1.get(this.fieldname);
                    TemplateModel tm2 = o2.get(this.fieldname);
                    if (tm1 instanceof SimpleScalar) {
                        String s1 = ((SimpleScalar)tm1).getAsString();
                        String s2 = ((SimpleScalar)tm2).getAsString();
                        result = s1.compareTo(s2);
                    } else if (tm1 instanceof SimpleNumber) {
                        Number n1 = ((SimpleNumber)tm1).getAsNumber();
                        Number n2 = ((SimpleNumber)tm2).getAsNumber();
                        if (n1 instanceof Long) {
                            result = ((Long)n1).compareTo((Long)n2);
                        } else if (n1 instanceof Integer) {
                            result = ((Integer)n1).compareTo((Integer)n2);
                        } else if (n1 instanceof Double) {
                            result = ((Double)n1).compareTo((Double)n2);
                        } else if (n1 instanceof Float) {
                            result = ((Float)n1).compareTo((Float)n2);
                        }
                    }
                }
            }
            catch (TemplateModelException e) {
                DefaultSearchProcessor.this.settings.getFSILogger().logException((Exception)((Object)e), 3186, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
            }
            return result;
        }
    }
}

