/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.processors;

import com.neptunelabs.fsiframework.helpers.Escaper;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;

public abstract class SearchProcessor {
    protected final RequestProcessorSettings settings;

    SearchProcessor(RequestProcessorSettings settings) {
        this.settings = settings;
    }

    public abstract RendererTextResponse search(Parameters var1, HttpSession var2);

    protected List<String> getValidConnectors(UserAuthenticationInterface uai, HttpSession session, SourceConnectorReader assetPathConnector) {
        ArrayList<String> validConnectors = new ArrayList<String>();
        if (assetPathConnector == null) {
            Set<String> connectorNames = this.settings.getSourceConnectorNames();
            for (String connectorName : connectorNames) {
                SourceConnectorReader connector = this.settings.getSourceConnector(connectorName);
                PermissionSet ps = uai.getPermissions(connector, session, true);
                if (!ps.list.searchResults.booleanValue() || !ps.list.connector.booleanValue()) continue;
                validConnectors.add(connectorName);
            }
        } else {
            PermissionSet ps = uai.getPermissions(assetPathConnector, session, true);
            if (ps.list.searchResults.booleanValue()) {
                validConnectors.add(assetPathConnector.getPrefix());
            }
        }
        return validConnectors;
    }

    protected void renderResult(List<MetaData> results, RendererTextResponse response, String message, int totalCount, Template template) throws IOException, TemplateModelException, TemplateException {
        StringBuffer eTagModifier = new StringBuffer();
        SimpleHash templateData = new SimpleHash();
        ArrayList<SimpleHash> list = new ArrayList<SimpleHash>(100);
        TemplateAttributes templateAttributes = new TemplateAttributes(this.settings.getFSILogger(), template);
        templateAttributes.setRendererResponseContentType(response);
        Escaper.EscaperType staticEscape = templateAttributes.getStaticEscape();
        if (results != null) {
            for (MetaData metaData : results) {
                list.add(this.getSimpleHashFromMetaData(metaData, staticEscape, eTagModifier));
            }
        }
        templateData.put("currentDir", (Object)this.escapeString("/", staticEscape));
        SimpleHash summary = new SimpleHash();
        summary.put("entryCount", (Object)totalCount);
        summary.put("imageCount", (Object)totalCount);
        summary.put("directoryCount", (Object)0);
        summary.put("completeCount", (Object)totalCount);
        summary.put("lastModified", (Object)System.currentTimeMillis());
        if (message != null) {
            summary.put("message", (Object)this.escapeString(message, staticEscape));
        }
        templateData.put("summary", (Object)summary);
        SimpleSequence finallist = new SimpleSequence();
        for (SimpleHash s : list) {
            finallist.add((Object)s);
        }
        templateData.put("ilist", (Object)finallist);
        this.renderTemplate(template, templateData, response);
        response.setETagModifier(eTagModifier.toString());
    }

    private void renderTemplate(Template template, SimpleHash templateData, RendererTextResponse response) throws TemplateException, IOException, TemplateModelException {
        try (StringWriterFast sw = new StringWriterFast();){
            TemplateModel cctm;
            Environment env = template.createProcessingEnvironment((Object)templateData, (Writer)sw);
            env.process();
            TemplateModel cttm = env.getVariable("ContentType");
            if (cttm != null) {
                response.setContentType(cttm.toString());
            }
            if ((cctm = env.getVariable("CacheControl")) != null) {
                response.setHeader("Cache-Control", cctm.toString());
            }
            sw.flush();
            sw.close();
            response.setBody(sw.toString());
        }
    }

    private SimpleHash getSimpleHashFromMetaData(MetaData metadata, Escaper.EscaperType escapeType, StringBuffer eTagModifier) {
        SimpleHash entry = new SimpleHash();
        String assetURLPath = this.escapeString(metadata.getAssetURLPath(), escapeType);
        eTagModifier.append(assetURLPath);
        entry.put("src", (Object)assetURLPath);
        if (metadata instanceof ImageMetaData) {
            ImageMetaData imd = (ImageMetaData)metadata;
            if (imd.getWidth() > 0) {
                int width = imd.getWidth();
                entry.put("width", (Object)width);
                eTagModifier.append(width);
            }
            if (imd.getHeight() > 0) {
                int height = imd.getHeight();
                entry.put("height", (Object)height);
                eTagModifier.append(height);
            }
            entry.put("alpha", (Object)Boolean.toString(imd.hasAlpha()));
            if (imd.getImportStatus() != 0) {
                entry.put("importstatus", (Object)imd.getImportStatus());
                eTagModifier.append(imd.getImportStatus());
            }
        }
        entry.put("lastmodified", (Object)metadata.getLastModified());
        eTagModifier.append(metadata.getLastModified());
        if (metadata instanceof FileMetaData) {
            entry.put("size", (Object)((FileMetaData)metadata).getSourceFileSize());
        }
        if (metadata instanceof DirectoryMetaData) {
            entry.put("type", (Object)"directory");
        } else {
            entry.put("type", (Object)"file");
        }
        return entry;
    }

    private String escapeString(String str, Escaper.EscaperType type) {
        String result;
        if (str == null) {
            return "";
        }
        switch (type) {
            case XML: {
                result = Escaper.escapeForXML(str);
                break;
            }
            case XMLURI: {
                result = Escaper.escapeForXMLURI(str);
                break;
            }
            case URIXML: {
                result = Escaper.escapeForURIXML(str);
                break;
            }
            case JSON: {
                result = Escaper.escapeForJSON(str);
                break;
            }
            default: {
                result = str;
            }
        }
        return result;
    }

    public static class SearchResult {
        public List<MetaData> resultList = null;
        public int totalResults = 0;
    }
}

