/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.processors;

import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.DataTypeMapping;
import com.neptunelabs.fsiserver.search.SearchException;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SimpleSearchProcessor
extends SearchProcessor {
    public SimpleSearchProcessor(RequestProcessorSettings settings) {
        super(settings);
    }

    @Override
    public RendererTextResponse search(Parameters parameters, HttpSession session) {
        RendererTextResponse result;
        try {
            boolean authenticated = false;
            UserAuthenticationInterface uai = this.settings.getUserAuthenticationInterface();
            Object sessionidObj = null;
            if (session != null) {
                sessionidObj = session.getAttribute("id");
            }
            if (uai != null && session != null && sessionidObj != null) {
                authenticated = uai.validateSession((String)session.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.VALID;
            }
            boolean authorized = false;
            if (authenticated || parameters.getAssetURLPath() != null) {
                authorized = true;
            }
            if (!authorized) {
                result = new RendererTextResponse();
                result.setStatus(403);
            } else {
                result = this.search(parameters, uai, session);
            }
        }
        catch (NotConfiguredException e) {
            result = new RendererTextResponse();
            result.setStatus(503);
        }
        return result;
    }

    private Set<String> parseQuery(String searchstr) {
        HashSet<String> result = new HashSet<String>();
        if (searchstr != null) {
            boolean quoteopen = false;
            String tokenstr = "";
            for (int i = 0; i < searchstr.length(); ++i) {
                char c = searchstr.charAt(i);
                if (c == '\"') {
                    boolean bl = quoteopen = !quoteopen;
                }
                if (c == ' ' && !quoteopen) {
                    if (tokenstr.trim().length() <= 0) continue;
                    result.add(tokenstr);
                    tokenstr = "";
                    continue;
                }
                tokenstr = tokenstr + c;
            }
            if (tokenstr.trim().length() > 0) {
                result.add(tokenstr);
            }
        }
        return result;
    }

    private RendererTextResponse search(Parameters parameters, UserAuthenticationInterface uai, HttpSession session) {
        RendererTextResponse textResult = new RendererTextResponse();
        Set<String> contexts = this.parseContext(parameters.get(Parameters.Search.context));
        if (contexts.size() == 0) {
            textResult.setStatus(400);
            textResult.setStatusMessage("Unknown or missing context.");
            textResult.setBody("Unknown or missing context.");
        } else {
            Set<String> searchterms = this.parseQuery(parameters.get(Parameters.Search.query));
            if (searchterms.size() == 0) {
                textResult.setStatus(400);
                textResult.setStatusMessage("Invalid or empty search query.");
                textResult.setBody("Invalid or empty search query.");
            } else {
                SolrSearcher sdb = this.settings.getSolrSearcher();
                try {
                    String listTemplate = parameters.contains(Parameters.General.template) ? parameters.get(Parameters.General.template) : "image_list.xml";
                    Template template = this.settings.getTemplateCache().getTemplate(TemplateType.LIST, listTemplate + ".ftl");
                    TemplateAttributes templateAttrs = new TemplateAttributes(this.settings.getFSILogger(), template);
                    String staticTypeFilter = templateAttrs.getStaticTypeFilter();
                    if (sdb != null) {
                        SearchProcessor.SearchResult sr;
                        String assetPath;
                        SourceConnectorReader assetPathConnector;
                        List<String> validConnectors;
                        String limitStr;
                        String[] limitStrParts;
                        int limit = -1;
                        int offset = -1;
                        if (parameters.contains(Parameters.Search.limit) && (limitStrParts = (limitStr = parameters.get(Parameters.Search.limit)).split(",")).length == 2) {
                            offset = Integer.parseInt(limitStrParts[0]);
                            limit = Integer.parseInt(limitStrParts[1]);
                        }
                        if (!(validConnectors = this.getValidConnectors(uai, session, assetPathConnector = this.settings.getSourceConnectorFromAssetURLPath(assetPath = parameters.get(Parameters.General.source)))).isEmpty()) {
                            SolrUpdater supd;
                            String searchString = parameters.get(Parameters.Search.query);
                            if (session != null && uai.validateSession((String)session.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.VALID && this.settings.getServletContext().getAttribute("SolrUpdater") != null && (supd = (SolrUpdater)this.settings.getServletContext().getAttribute("SolrUpdater")).isEnabled()) {
                                supd.waitForPseudoFlush();
                            }
                            sr = sdb.search(searchString, assetPath, validConnectors, contexts, staticTypeFilter, offset, limit, parameters.get(Parameters.Sorting.sortfield), parameters.get(Parameters.Sorting.sortorder));
                        } else {
                            sr = new SearchProcessor.SearchResult();
                        }
                        this.renderResult(sr.resultList, textResult, null, sr.totalResults, template);
                    } else {
                        this.renderResult(null, textResult, this.settings.getFSILogger().getLogMessage(3213, new Object[0]), 0, template);
                    }
                    textResult.setStatus(200);
                }
                catch (NoSuchFileException e) {
                    textResult.setStatus(404);
                    textResult.setBody("{\"statuscode\":\"404\",\"cause\":\"" + e.getMessage() + "\"}");
                }
                catch (IOException e) {
                    this.settings.getFSILogger().logException(e, 3186, e.getClass().getName() + ": " + e.getLocalizedMessage());
                    textResult.setStatus(500);
                    textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
                }
                catch (TemplateModelException e) {
                    this.settings.getFSILogger().logException((Exception)((Object)e), 3186, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
                    textResult.setStatus(500);
                    textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
                }
                catch (TemplateException e) {
                    this.settings.getFSILogger().logException((Exception)((Object)e), 3186, ((Object)((Object)e)).getClass().getName() + ": " + e.getLocalizedMessage());
                    textResult.setStatus(500);
                    textResult.setBody("{\"statuscode\":\"500\",\"cause\":\"" + e.getMessage() + "\"}");
                }
                catch (SearchException e) {
                    textResult.setStatus(e.getCode());
                    textResult.setBody("{\"statuscode\":\"" + e.getCode() + "\",\"cause\":\"" + e.getMessage() + "\"}");
                }
            }
        }
        return textResult;
    }

    private Set<String> parseContext(String contextParam) {
        HashSet<String> result = new HashSet<String>();
        if (contextParam != null) {
            String[] contexts = contextParam.split(",");
            Set<String> validContextNames = DataTypeMapping.getInstance().getValidContexts();
            for (String context : contexts) {
                String trimmedContext = context.trim();
                if (!validContextNames.contains(trimmedContext)) continue;
                result.add(trimmedContext);
            }
        }
        return result;
    }
}

