/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SearchDatabaseSolr {
    final FSILogger logger;
    final String name;
    private PoolingHttpClientConnectionManager connectionManager;
    private String solrServerURI;
    private String solrCore;
    private int maxConnections;
    protected static final String CONSTANT_ASSETURLPATH = "asset.fullpath";
    protected static final String CONSTANT_CONNECTOR = "file.connector";
    protected static final String CONSTANT_PATH = "file.path";
    protected static final String CONSTANT_FILENAME = "file.name";
    protected static final String CONSTANT_FILEPREFIX = "file.prefix";
    protected static final String CONSTANT_FILESUFFIX = "file.suffix";
    private final Pattern charsetPattern = Pattern.compile("charset=(.+)[; ]*", 2);
    private HttpHost targetHost = null;
    private HttpHost proxy = null;
    private CredentialsProvider proxyProvider = null;
    private CredentialsProvider authenticationProvider = null;
    private AuthCache authenticationCache = null;
    private HttpClientContext localContext = null;
    protected volatile boolean initiated;
    private final boolean error = false;
    protected CloseableHttpClient httpClient;

    public SearchDatabaseSolr(FSILogger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public void init() {
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(this.maxConnections);
        this.connectionManager.setDefaultMaxPerRoute(this.maxConnections);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.proxy != null) {
            httpClientBuilder.setProxy(this.proxy);
        }
        if (this.proxyProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(this.proxyProvider);
        }
        httpClientBuilder.setUserAgent(this.name);
        if (this.authenticationCache != null) {
            this.localContext = HttpClientContext.create();
            this.localContext.setAuthCache(this.authenticationCache);
            if (this.authenticationProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(this.authenticationProvider);
            }
        }
        this.httpClient = httpClientBuilder.build();
        this.initiated = true;
    }

    public boolean isInitiated() {
        return this.initiated;
    }

    public void setConnection(String solrServerURI, String core, int maxConnections) throws IllegalArgumentException {
        this.solrServerURI = solrServerURI.endsWith("/") ? solrServerURI : solrServerURI + "/";
        URI uri = URI.create(solrServerURI);
        int port = uri.getPort();
        if (port <= 0) {
            port = 80;
        }
        this.targetHost = new HttpHost(uri.getHost(), port, uri.getScheme());
        this.solrCore = core;
        this.maxConnections = maxConnections;
    }

    public String getSolrServerURI() {
        return this.solrServerURI;
    }

    public String getSolrCore() {
        return this.solrCore;
    }

    public void setProxy(boolean enabled, String hostname, int port, boolean ssl, boolean auth, String username, String password) throws IllegalArgumentException {
        if (!enabled) {
            if (port == 0) {
                port = 8080;
            }
            String proxyScheme = ssl ? "http" : "https";
            this.proxy = new HttpHost(hostname, port, proxyScheme);
            if (auth) {
                this.proxyProvider = new BasicCredentialsProvider();
                this.proxyProvider.setCredentials(new AuthScope(hostname, port), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        } else {
            this.proxyProvider = null;
        }
    }

    public void setAuthentication(boolean enabled, String type, String username, String password) throws IllegalArgumentException {
        if (enabled) {
            if (type.equalsIgnoreCase("digest")) {
                DigestScheme digestAuth = new DigestScheme();
                this.authenticationCache.put(this.targetHost, (AuthScheme)digestAuth);
            } else {
                BasicScheme basicAuth = new BasicScheme();
                this.authenticationCache.put(this.targetHost, (AuthScheme)basicAuth);
            }
            if (username != null && username.length() > 0) {
                this.authenticationProvider = new BasicCredentialsProvider();
                this.authenticationProvider.setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        } else {
            this.authenticationCache = null;
        }
    }

    public boolean hasError() {
        return false;
    }

    public void halt() {
        this.initiated = false;
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
    }

    private URI buildAdminURI(String path) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.solrServerURI + "admin/" + path);
        URI result = builder.build();
        return result;
    }

    protected URI buildURI(String path) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.solrServerURI + this.solrCore + path);
        URI result = builder.build();
        return result;
    }

    /*
     * Exception decompiling
     */
    private SolrResponse executeAdminRequest(String requestString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SolrResponse getSystemStatusJSON() {
        return this.executeAdminRequest("system?wt=json");
    }

    public SolrResponse getCoreStatusJSON() {
        return this.executeAdminRequest("cores?wt=json&action=status&core=" + this.solrCore);
    }

    public Set<String> getCoreAssetList(int offset, int length) throws IOException {
        HashSet<String> result = new HashSet<String>();
        String query = "q=*:*&sort=asset.fullpath+asc&fl=asset.fullpath&start=" + offset + "&rows=" + length;
        SolrResponse solrResponse = this.searchJSON(query);
        if (solrResponse.statusCode == 200) {
            try {
                JSONObject solrResponseJSON = new JSONObject(new String(solrResponse.responseBytes, solrResponse.encoding));
                JSONObject responseContent = solrResponseJSON.getJSONObject("response");
                int resultRows = length;
                int numRows = responseContent.getInt("numFound");
                if (numRows - offset < length) {
                    resultRows = numRows - offset;
                }
                JSONArray docs = responseContent.getJSONArray("docs");
                for (int i = 0; i < resultRows; ++i) {
                    String assetURLPath = docs.getJSONObject(i).getString(CONSTANT_ASSETURLPATH);
                    result.add(assetURLPath);
                }
            }
            catch (JSONException e) {
                throw new IOException("Invalid response from Solr Server: " + e.getLocalizedMessage());
            }
        } else {
            if (solrResponse.statusCode == 0) {
                throw new IOException("Invalid response from Solr Server: " + solrResponse.errorMessage);
            }
            throw new IOException("Invalid response from Solr Server: " + solrResponse.statusCode);
        }
        return result;
    }

    private Charset getEncodingFromHeaders(Header[] headers) {
        String ct;
        Matcher mat;
        Charset encoding = FileOperations.charsetISO8859_15;
        if (headers != null && (mat = this.charsetPattern.matcher(ct = headers[0].getValue())).find()) {
            try {
                encoding = Charset.forName(mat.group(1));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return encoding;
    }

    /*
     * Exception decompiling
     */
    protected SolrResponse searchJSON(String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

