/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.neptunelabs.fsiframework.helpers.StringUtils;
import com.neptunelabs.fsiframework.helpers.URLEncoderFast;
import com.neptunelabs.fsiserver.search.SearchException;
import com.neptunelabs.fsiserver.search.SearchToken;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SolrSearcher {
    private final SearchDatabaseSolr solr;
    private final DateFormat iso8601Formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public SolrSearcher(SearchDatabaseSolr sds) {
        this.solr = sds;
    }

    public SearchProcessor.SearchResult search(String searchString, String assetPath, List<String> allowedConnectors, String typeFilter, int from, int length, String sortfield, String sortorder) throws SearchException {
        return this.search(searchString, assetPath, allowedConnectors, null, typeFilter, from, length, sortfield, sortorder);
    }

    public SearchProcessor.SearchResult search(String searchString, String assetPath, List<String> allowedConnectors, Set<String> fields, String typeFilter, int from, int length, String sortfield, String sortorder) throws SearchException {
        StringBuilder query = new StringBuilder();
        boolean isConditionSet = false;
        if (searchString != null && ((searchString = searchString.toLowerCase()).contains("<") || searchString.contains(">"))) {
            searchString = this.solrizeSearchString(searchString);
        }
        if (allowedConnectors != null || assetPath != null) {
            StringBuilder select = this.buildRequest(searchString, 0, 1, null, null, null);
            SearchProcessor.SearchResult preresult = this.executeSearchRequest(select.toString());
            if (preresult.totalResults == 0) {
                return new SearchProcessor.SearchResult();
            }
        }
        if (allowedConnectors != null && allowedConnectors.size() > 0) {
            if (allowedConnectors.size() == 1) {
                query.append("file.connector");
                query.append(':');
                query.append("\"" + allowedConnectors.get(0) + "\"");
            } else {
                query.append('(');
                for (int i = 0; i < allowedConnectors.size(); ++i) {
                    query.append("file.connector");
                    query.append(':');
                    query.append("\"" + allowedConnectors.get(i) + "\"");
                    if (i + 1 >= allowedConnectors.size()) continue;
                    query.append(" OR ");
                }
                query.append(')');
            }
            isConditionSet = true;
        }
        if (typeFilter != null && typeFilter.trim().length() > 0) {
            query.append(" AND file.type:\"" + typeFilter + "\"");
        }
        if (assetPath != null) {
            if (isConditionSet) {
                query.append(" AND ");
            } else {
                isConditionSet = true;
            }
            if (assetPath.startsWith("/")) {
                assetPath = assetPath.substring(1);
            }
            if (assetPath.endsWith("/")) {
                assetPath = assetPath.substring(0, assetPath.length() - 1);
            }
            query.append("file.path");
            query.append(':');
            query.append("\"" + assetPath + "\"");
        }
        if (searchString != null) {
            if (isConditionSet) {
                query.append(" AND ");
            } else {
                isConditionSet = true;
            }
            query.append("(" + searchString + ")");
        }
        String queryStr = query.toString();
        StringBuilder select = this.buildRequest(queryStr, from, length, fields, sortfield, sortorder);
        SearchProcessor.SearchResult result = this.executeSearchRequest(select.toString());
        return result;
    }

    private SearchProcessor.SearchResult executeSearchRequest(String s) throws SearchException {
        SearchProcessor.SearchResult result;
        SolrResponse response = this.solr.searchJSON(s);
        try {
            if (response.statusCode != 200) {
                if (response.statusCode == 0) {
                    throw new SearchException(503, response.errorMessage);
                }
                if (response.errorMessage == null) {
                    response.errorMessage = "Invalid search string or error in database.";
                }
                throw new SearchException(response.statusCode, response.errorMessage);
            }
            result = this.solrResponseToSearchResult(response);
        }
        catch (JSONException e) {
            throw new SearchException(500, "Invalid response " + e.getLocalizedMessage());
        }
        return result;
    }

    private StringBuilder buildRequest(String queryStr, int from, int length, Set<String> fields, String sortfield, String sortorder) {
        String sortfieldStr;
        StringBuilder select = new StringBuilder();
        select.append("q=");
        URLEncoderFast encoder = new URLEncoderFast("", false);
        select.append(encoder.escape(queryStr));
        if (fields != null) {
            select.append("&qf=" + StringUtils.join(fields, '+'));
        }
        if (from > 0) {
            select.append("&start=");
            select.append(from);
        }
        if (length > 0) {
            select.append("&rows=");
            select.append(length);
        }
        if (sortfield != null && (sortfieldStr = this.getSortFieldFromQuery(sortfield)) != null) {
            String sortorderStr = this.getSortOrderFromQuery(sortorder);
            select.append("&sort=" + sortfieldStr + "+" + sortorderStr);
        }
        return select;
    }

    private String getSortOrderFromQuery(String sortorder) {
        String lcSortOrder = sortorder.toLowerCase().trim();
        if (lcSortOrder.equals("desc")) {
            return "desc";
        }
        return "asc";
    }

    private String getSortFieldFromQuery(String sortfield) {
        String lcSortfield = sortfield.toLowerCase().trim();
        if (lcSortfield.equals("filename")) {
            return "file.fullpath";
        }
        if (lcSortfield.equals("width")) {
            return "file.width";
        }
        if (lcSortfield.equals("height")) {
            return "file.height";
        }
        if (lcSortfield.equals("filesize")) {
            return "file.size";
        }
        if (lcSortfield.equals("lastmodified")) {
            return "file.lastmodified";
        }
        if (lcSortfield.equals("importstatus")) {
            return "file.status";
        }
        return null;
    }

    private SearchProcessor.SearchResult solrResponseToSearchResult(SolrResponse solrResponse) throws JSONException {
        SearchProcessor.SearchResult result = new SearchProcessor.SearchResult();
        if (solrResponse.responseBytes != null) {
            JSONObject solrResponseJSON = new JSONObject(new String(solrResponse.responseBytes, solrResponse.encoding));
            JSONObject responseContent = solrResponseJSON.getJSONObject("response");
            result.totalResults = responseContent.getInt("numFound");
            JSONArray documents = responseContent.getJSONArray("docs");
            result.resultList = new ArrayList<MetaData>();
            for (int i = 0; i < documents.length(); ++i) {
                String iso8601DateString;
                MetaData md;
                JSONObject document = documents.getJSONObject(i);
                if (document.has("file.height")) {
                    ImageMetaData imd = new ImageMetaData();
                    imd.setHeight(document.getInt("file.height"));
                    imd.setWidth(document.getInt("file.width"));
                    imd.setSourceFileSize(document.getLong("file.size"));
                    if (document.has("file.status")) {
                        imd.setImportStatus((byte)document.getInt("file.status"));
                    }
                    md = imd;
                } else if (document.has("file.size")) {
                    FileMetaData fmd = new FileMetaData();
                    fmd.setSourceFileSize(document.getLong("file.size"));
                    md = fmd;
                } else {
                    md = document.getString("file.type").equals("directory") ? new DirectoryMetaData() : new MetaData();
                }
                md.setAssetURLPath(document.getString("asset.fullpath"));
                if (document.has("file.lastmodified") && (iso8601DateString = document.getString("file.lastmodified")) != null) {
                    try {
                        md.setLastModified(this.iso8601Formatter.parse(iso8601DateString).getTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                result.resultList.add(md);
            }
        }
        return result;
    }

    private String solrizeSearchString(String searchString) {
        List<SearchToken> tokenList = this.parseSearchString(searchString);
        String result = "";
        for (SearchToken token : tokenList) {
            result = result + token.getTokenForSolr() + " ";
        }
        return result;
    }

    private List<SearchToken> parseSearchString(String searchstr) {
        boolean quoteopen = false;
        ArrayList<SearchToken> result = new ArrayList<SearchToken>();
        if (searchstr != null) {
            String tokenstr = "";
            for (int i = 0; i < searchstr.length(); ++i) {
                char c = searchstr.charAt(i);
                if (c == '\"') {
                    boolean bl = quoteopen = !quoteopen;
                }
                if (c == ' ' && !quoteopen) {
                    if (tokenstr.trim().length() <= 0) continue;
                    result.add(new SearchToken(tokenstr));
                    tokenstr = "";
                    continue;
                }
                tokenstr = tokenstr + c;
            }
            if (tokenstr.trim().length() > 0) {
                result.add(new SearchToken(tokenstr));
            }
        }
        return result;
    }
}

