/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.neptunelabs.fsiframework.helpers.StringUtils;
import com.neptunelabs.fsiframework.helpers.URLEncoderFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.search.AsyncDatabaseJob;
import com.neptunelabs.fsiserver.search.DeleteAssetMetadataJob;
import com.neptunelabs.fsiserver.search.InsertMetadataJob;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrException;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SolrUpdater
extends Thread {
    private static final int COMMIT_DOC_TIME = 30000;
    private static final int COMMIT_DOC_COUNT = 1000;
    private static final int COMMIT_DOC_MAX = 10000;
    private Timer committer = null;
    private CommitterTask committerTask = null;
    private final LinkedBlockingQueue<AsyncDatabaseJob> asyncJobQueue = new LinkedBlockingQueue(10000);
    final ConcurrentLinkedQueue<UpdateCommand> cmdQueue = new ConcurrentLinkedQueue();
    private final SourceManagerSettings settings;
    private final SearchDatabaseSolr solr;
    final FSILogger logger;
    private final AtomicInteger processingJobs = new AtomicInteger(0);
    private boolean enabled;
    private volatile boolean logged = false;
    private volatile boolean running = false;
    private volatile long jobCounter = Long.MIN_VALUE;

    public SolrUpdater(SourceManagerSettings settings, SearchDatabaseSolr sds, String name) {
        this.settings = settings;
        this.solr = sds;
        this.logger = settings.getFSILogger();
        this.setName(name);
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasError() {
        return this.enabled && this.solr.hasError();
    }

    @Override
    public void run() {
        this.committerTask = new CommitterTask();
        this.committer = new Timer(this.getName() + "-Committer", true);
        this.committer.scheduleAtFixedRate((TimerTask)this.committerTask, 5000L, 1000L);
        this.running = true;
        while (this.running) {
            try {
                AsyncDatabaseJob job = this.asyncJobQueue.take();
                this.processingJobs.incrementAndGet();
                if (job != null) {
                    if (job instanceof InsertMetadataJob) {
                        this.insertMetaData((InsertMetadataJob)job);
                    } else if (job instanceof DeleteAssetMetadataJob) {
                        this.deleteAsset((DeleteAssetMetadataJob)job);
                    } else if (this.logger != null) {
                        this.logger.log(3185, "asyncJobQueue", "Unknown Async Database Job-Type" + job.getClass().getName());
                    }
                } else {
                    SolrUpdater.yield();
                }
                this.processingJobs.decrementAndGet();
            }
            catch (SolrException e) {
                this.logger.logException(e, 3185, "");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void halt() {
        this.running = false;
        if (this.enabled) {
            this.interrupt();
            if (this.committer != null) {
                this.committer.cancel();
                this.committer.purge();
            }
            this.solr.halt();
        }
    }

    private boolean insertMetaData(InsertMetadataJob job) throws SolrException {
        boolean result = false;
        this.waitFlushingCMDQueue();
        Map<String, String> metadata = job.getMetaData();
        String assetURLPath = job.getAssetURLPath();
        String[] parts = assetURLPath.split("/", 2);
        String connector = parts[0];
        int lioSlash = assetURLPath.lastIndexOf(47);
        if (lioSlash != -1) {
            String tosuffix;
            String toprefix;
            String tofullname = assetURLPath.substring(lioSlash + 1).trim();
            String filePath = assetURLPath.substring(0, lioSlash).trim();
            int indexOfDot = tofullname.lastIndexOf(".");
            if (indexOfDot > 0) {
                toprefix = tofullname.substring(0, indexOfDot);
                tosuffix = tofullname.substring(indexOfDot + 1);
            } else {
                toprefix = tofullname;
                tosuffix = null;
            }
            try {
                JSONObject jsonAddCmd = new JSONObject();
                JSONObject jsonDocObj = new JSONObject();
                jsonDocObj.put("id", (Object)assetURLPath);
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    String key = entry.getKey();
                    String cleanedKey = SolrUpdater.cleanKey(key);
                    if (entry.getValue() == null || cleanedKey == null) continue;
                    jsonDocObj.put(cleanedKey, (Object)entry.getValue());
                }
                jsonDocObj.put("asset.fullpath", (Object)assetURLPath);
                jsonDocObj.put("file.fullpath", (Object)assetURLPath.toLowerCase());
                jsonDocObj.put("file.connector", (Object)connector);
                jsonDocObj.put("file.path", (Object)filePath);
                String filename = tofullname.toLowerCase();
                jsonDocObj.put("file.name", (Object)filename);
                jsonDocObj.put("file.prefix", (Object)toprefix.toLowerCase());
                if (tosuffix != null) {
                    jsonDocObj.put("file.suffix", (Object)tosuffix.toLowerCase());
                }
                jsonAddCmd.put("doc", (Object)jsonDocObj);
                if (job.isExplicitLogEnabled()) {
                    this.cmdQueue.offer(new UpdateCommand("add", jsonAddCmd, assetURLPath));
                } else {
                    this.cmdQueue.offer(new UpdateCommand("add", jsonAddCmd));
                }
            }
            catch (JSONException e) {
                throw new SolrException((Object)((Object)e) + " for " + assetURLPath);
            }
        }
        return false;
    }

    private boolean deleteAsset(DeleteAssetMetadataJob job) throws SolrException {
        boolean result = false;
        String lastAssetURLPath = null;
        try {
            JSONArray jsonAddCmd = new JSONArray();
            Iterator<String> iterator = job.getAssetURLPaths().iterator();
            while (iterator.hasNext()) {
                String assetURLPath;
                lastAssetURLPath = assetURLPath = iterator.next();
                JSONObject entry = new JSONObject();
                if (assetURLPath.endsWith("*")) {
                    entry.put("query", (Object)("asset.fullpath:" + assetURLPath));
                } else {
                    entry.put("id", (Object)assetURLPath);
                }
                jsonAddCmd.put((Object)entry);
            }
            this.cmdQueue.offer(new UpdateCommand("delete", jsonAddCmd));
        }
        catch (JSONException e) {
            throw new SolrException((Object)((Object)e) + " for " + lastAssetURLPath);
        }
        return false;
    }

    private static String cleanKey(String key) {
        return key.toLowerCase().replace(" ", "_").replace("/", "_or_");
    }

    /*
     * Exception decompiling
     */
    SolrResponse updateJSON(String jsonString, boolean getResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean setMetaDataASync(String assetURLPath, Map<String, String> metadata, boolean explicitLog) {
        if (this.enabled) {
            if (assetURLPath.endsWith("/")) {
                assetURLPath = assetURLPath.substring(0, assetURLPath.length() - 1);
            }
            InsertMetadataJob job = new InsertMetadataJob(assetURLPath, metadata, explicitLog);
            return this.insertJob(job);
        }
        this.logToSDBCheck(explicitLog ? assetURLPath : null);
        return true;
    }

    public boolean deleteAssetWithPrefixAsync(String assetURLPathPrefix) {
        if (this.enabled) {
            DeleteAssetMetadataJob job = new DeleteAssetMetadataJob(assetURLPathPrefix + "*");
            return this.insertJob(job);
        }
        return true;
    }

    public boolean deleteAssetAsync(String assetURLPath) {
        if (this.enabled) {
            if (assetURLPath.endsWith("/")) {
                assetURLPath = assetURLPath.substring(0, assetURLPath.length() - 1);
            }
            DeleteAssetMetadataJob job = new DeleteAssetMetadataJob(assetURLPath);
            return this.insertJob(job);
        }
        this.logToSDBCheck(null);
        return true;
    }

    public boolean deleteAssetsAsync(Set<String> assetURLPaths) {
        if (this.enabled) {
            HashSet<String> toDelete = new HashSet<String>();
            for (String assetURLPath : assetURLPaths) {
                if (assetURLPath.endsWith("/")) {
                    toDelete.add(assetURLPath.substring(0, assetURLPath.length() - 1));
                    continue;
                }
                toDelete.add(assetURLPath);
            }
            DeleteAssetMetadataJob job = new DeleteAssetMetadataJob(toDelete);
            return this.insertJob(job);
        }
        this.logToSDBCheck(null);
        return true;
    }

    private boolean insertJob(AsyncDatabaseJob job) {
        boolean result = true;
        try {
            job.setJobCounter(this.jobCounter++);
            this.asyncJobQueue.put(job);
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    public void waitForPseudoFlush() {
        if (this.asyncJobQueue.size() > 0) {
            long currentCounter = this.jobCounter;
            boolean wait = true;
            do {
                AsyncDatabaseJob job;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl = wait = this.asyncJobQueue.size() > 0;
                if (!wait || (job = this.asyncJobQueue.peek()) == null || job.getJobCounter() < currentCounter) continue;
                wait = false;
            } while (wait);
        }
        while (this.processingJobs.get() > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.committerTask.forceCommit();
    }

    private void waitFlushingCMDQueue() {
        if (this.cmdQueue.size() > 10000) {
            while (this.cmdQueue.size() > 10000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public boolean entryExists(String assetURLPath) throws SolrException, IOException {
        boolean result = false;
        if (this.enabled) {
            URLEncoderFast encoder = new URLEncoderFast("", false);
            String query = "q=asset.fullpath:" + encoder.escape("\"" + assetURLPath + "\"") + "&fl=asset.fullpath";
            SolrResponse solrResponse = this.solr.searchJSON(query);
            if (solrResponse.statusCode == 200 && solrResponse.responseBytes != null) {
                try {
                    JSONObject solrResponseJSON = new JSONObject(new String(solrResponse.responseBytes, solrResponse.encoding));
                    JSONObject responseContent = solrResponseJSON.getJSONObject("response");
                    int numRows = responseContent.getInt("numFound");
                    result = numRows == 1;
                }
                catch (JSONException e) {
                    throw new SolrException("Invalid response from Solr Server: " + e.getLocalizedMessage());
                }
            } else {
                String errMsg = solrResponse.errorMessage != null ? "Invalid response from Solr Server: " + solrResponse.errorMessage + " for: " + assetURLPath + " Q:" + query : "Invalid statusCode from Solr Server: " + solrResponse.statusCode + " for: " + assetURLPath + " Q:" + query;
                throw new SolrException(errMsg);
            }
        }
        return result;
    }

    public void resetLoggingStatus() {
        this.logged = false;
    }

    void logToSDBCheck(String explicitLogPath) {
        try {
            Path checkfile = this.settings.getStorageLocation().resolve(".sdbcheck");
            if (explicitLogPath != null && explicitLogPath.length() > 0) {
                if (!explicitLogPath.endsWith("\n")) {
                    explicitLogPath = explicitLogPath + "\n";
                }
                FileOperations.writeTextFileContent(checkfile, explicitLogPath, FileOperations.charsetUTF8, true);
            } else if (!this.logged) {
                if (Files.notExists(checkfile, new LinkOption[0])) {
                    FileOperations.writeTextFileContent(checkfile, "", FileOperations.charsetUTF8, false);
                }
                this.logged = true;
            }
        }
        catch (IOException e) {
            this.logger.logException(e, 3238, e.getLocalizedMessage());
        }
    }

    private class UpdateCommand {
        private final String cmd;
        private final JSONObject object;
        private final JSONArray array;
        private final String explicitLog;

        UpdateCommand(String cmd, JSONObject object) {
            this.cmd = cmd;
            this.object = object;
            this.explicitLog = null;
            this.array = null;
        }

        UpdateCommand(String cmd, JSONArray array) {
            this.cmd = cmd;
            this.object = null;
            this.explicitLog = null;
            this.array = array;
        }

        UpdateCommand(String cmd, JSONObject object, String explicitLog) {
            this.cmd = cmd;
            this.object = object;
            this.explicitLog = explicitLog;
            this.array = null;
        }

        boolean isExplicitLogSet() {
            return this.explicitLog != null;
        }

        String getExplicitLog() {
            return this.explicitLog;
        }

        String getCmd() {
            return this.cmd;
        }

        String getDocument() throws JSONException {
            if (this.object != null) {
                return this.object.toString(1);
            }
            return this.array.toString(1);
        }
    }

    private class CommitterTask
    extends TimerTask {
        private long lastSync = System.currentTimeMillis();

        @Override
        public void run() {
            this.doCommit(false);
        }

        public void forceCommit() {
            this.doCommit(true);
        }

        private void doCommit(boolean force) {
            long currentTime = System.currentTimeMillis();
            int cmdQueueCount = Math.min(1000, SolrUpdater.this.cmdQueue.size());
            long time = currentTime - this.lastSync;
            if (cmdQueueCount > 0 && (force || time >= 30000L || cmdQueueCount == 1000)) {
                this.lastSync = currentTime;
                ArrayList<String> explicitLogPaths = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                for (int c = 0; c < cmdQueueCount; ++c) {
                    UpdateCommand cmd = SolrUpdater.this.cmdQueue.poll();
                    StringBuilder cmdBuilder = new StringBuilder();
                    try {
                        if (cmd.isExplicitLogSet()) {
                            explicitLogPaths.add(cmd.getExplicitLog());
                        }
                        cmdBuilder.append('\"');
                        cmdBuilder.append(cmd.getCmd());
                        cmdBuilder.append('\"');
                        cmdBuilder.append(':');
                        cmdBuilder.append(cmd.getDocument());
                        if (c + 1 < cmdQueueCount) {
                            cmdBuilder.append(',');
                            cmdBuilder.append('\n');
                        }
                        sb.append(cmdBuilder.toString());
                        continue;
                    }
                    catch (JSONException e) {
                        SolrUpdater.this.logger.logException((Exception)((Object)e), 3261, e.getLocalizedMessage());
                    }
                }
                sb.append(",\n\"commit\": {}\n}");
                String cmdSet = sb.toString();
                SolrResponse response = SolrUpdater.this.updateJSON(cmdSet, false);
                if (response.statusCode != 200) {
                    SolrUpdater.this.logToSDBCheck(StringUtils.join(explicitLogPaths, '\n'));
                }
            }
        }
    }
}

