/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractImporterService;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Image;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

class AbstractImageService
extends AbstractImporterService {
    AbstractImageService() {
    }

    protected ActionResponse testUpload(Image image) {
        ActionResponse response = new ActionResponse();
        String assetURLPath = image.getTargetPath();
        try {
            HttpSession session = this.getSession();
            SourceConnectorReader targetConnector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
            PermissionSet targetPermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(targetConnector, session, true);
            Path target = this.relativePathStringToFile(assetURLPath, targetConnector);
            if (targetPermissions == null || Files.notExists(target, new LinkOption[0]) && !targetPermissions.write.upload.booleanValue() || Files.exists(target, new LinkOption[0]) && !targetPermissions.write.overwrite.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (Files.exists(target, new LinkOption[0])) {
                response.setStatusCode(102);
            } else {
                Path parentFile = target.getParent();
                if (Files.exists(parentFile, new LinkOption[0])) {
                    boolean canwrite = Files.isWritable(parentFile);
                    if (canwrite) {
                        if (FileOperations.getUsableSpace(parentFile) > image.getFileSize()) {
                            response.setStatusCode(202);
                        } else {
                            response.setStatusCode(413);
                            response.setCause("Not enough space left on device");
                        }
                    } else {
                        response.setStatusCode(403);
                        response.setCause("You are not allowed to upload files to this directory.");
                    }
                } else {
                    response.setStatusCode(404);
                    response.setCause("Target directory does not exist.");
                }
            }
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return response;
    }

    protected ActionResponse handleZipUpload(String targetPath, SourceConnectorReader targetConnector, Path tmpfile) throws WebApplicationException {
        if (targetPath.contains("..")) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ActionResponse response = new ActionResponse();
        String dirname = tmpfile.getFileName().toString().substring(0, tmpfile.getFileName().toString().lastIndexOf(46));
        Path tmpdir = tmpfile.getParent().resolve(dirname);
        List<ZipImageEntry> zipimages = this.unzip(tmpfile, tmpdir);
        for (ZipImageEntry image : zipimages) {
            this.handleUpload(targetPath + "/" + image.relativeImagePath, targetConnector, image.lastmodified, image.source);
            if (!Files.exists(image.source, new LinkOption[0])) continue;
            try {
                Files.delete(image.source);
            }
            catch (IOException e) {
                this.getSourceManagerSettings().getFSILogger().log(3200, image.source);
            }
        }
        try {
            FileOperations.deleteDir(tmpdir);
            Files.deleteIfExists(tmpfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        response.setStatusCode(201);
        return response;
    }

    private List<ZipImageEntry> unzip(Path source, Path destinationDir) throws WebApplicationException {
        ArrayList<ZipImageEntry> result = new ArrayList<ZipImageEntry>();
        boolean zipBomb = false;
        try {
            ZipFile zipFile = new ZipFile(source.toFile());
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements() && !zipBomb) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                Path destination = destinationDir.resolve(entry.getName());
                if (Files.notExists(destination.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.getSourceManagerSettings().getFSILogger().log(3199, destination.getParent());
                    }
                }
                if (entry.isDirectory()) continue;
                if (entry.getCompressedSize() < entry.getSize() / 15L) {
                    zipBomb = true;
                }
                byte[] data = new byte[4096];
                try (BufferedOutputStream dest = new BufferedOutputStream(Files.newOutputStream(destination, new OpenOption[0]), 4096);
                     BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int currentByte;
                    while ((currentByte = is.read(data, 0, 4096)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                }
                FileOperations.setSafeLastModified(destination, entry.getTime());
                ZipImageEntry imageentry = new ZipImageEntry(entry.getName(), entry.getTime(), destination);
                result.add(imageentry);
            }
            zipFile.close();
            if (zipBomb) {
                FileOperations.deleteDir(destinationDir);
            }
        }
        catch (IOException e) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 114, destinationDir + "." + e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new WebApplicationException((Throwable)e, 415);
        }
        if (zipBomb) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 115, destinationDir);
            throw new WebApplicationException(415);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionResponse handleUpload(String targetPath, SourceConnectorReader targetConnector, long lastModified, Path tmpfilePath) {
        ActionResponse response;
        block26: {
            if (targetPath.contains("/..")) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            response = new ActionResponse();
            ScannerPauseReason spr = new ScannerPauseReason(targetPath.substring(0, targetPath.lastIndexOf("/")), ScannerPauseReason.ModificationType.FILE);
            String pauseKey = "PK6-" + targetPath.hashCode();
            this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
            try {
                boolean written;
                Path target = this.relativePathStringToFile(targetPath, targetConnector);
                this.getSourceManagerSettings().getFSILogger().log(3163, targetPath);
                if (Files.notExists(target.getParent(), new LinkOption[0])) {
                    this.createDirectory(targetPath.substring(0, targetPath.lastIndexOf(47)), targetConnector);
                    if (Files.notExists(target.getParent(), new LinkOption[0])) {
                        this.cancelConverterJob(targetPath, this.getSession());
                    }
                }
                try {
                    Files.deleteIfExists(target);
                }
                catch (IOException e) {
                    this.getSourceManagerSettings().getFSILogger().log(3200, target);
                }
                try {
                    FileOperations.move(tmpfilePath, target);
                    written = true;
                }
                catch (IOException e) {
                    written = false;
                }
                if (written) {
                    boolean lmset = FileOperations.setSafeLastModified(target, lastModified);
                    if (lmset) {
                        this.getSourceManagerSettings().getFSILogger().log(3164, targetPath);
                    } else {
                        this.getSourceManagerSettings().getFSILogger().log(3169, targetPath);
                    }
                    SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(targetPath, this.getSession());
                    if (!connector.isVirtualViewerConnector()) {
                        boolean fileAccepted;
                        if (targetPath.startsWith("/")) {
                            targetPath = targetPath.substring(1);
                        }
                        try {
                            fileAccepted = this.getSourceManager().getScannerDaemon().manuallySubmitNewJob(connector, target);
                        }
                        catch (IOException e) {
                            fileAccepted = false;
                        }
                        if (fileAccepted) {
                            if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                                String profilename = connector.getPrefix();
                                String strippedimagepath = targetPath.substring(profilename.length());
                                this.getSourceManager().handlePingRequest(strippedimagepath, profilename);
                                response.setStatusCode(201);
                            } else {
                                response.setStatusCode(201);
                            }
                            break block26;
                        }
                        try {
                            Files.deleteIfExists(target);
                        }
                        catch (IOException e) {
                            this.getSourceManagerSettings().getFSILogger().log(3200, target);
                        }
                        response.setStatusCode(415);
                        response.setCause("Unsupported filetype or broken image");
                        break block26;
                    }
                    this.clearRelatedPublishingSetsCache(targetPath);
                    this.clearRelatedPublishingSetsCache(targetPath.substring(0, targetPath.lastIndexOf("/")));
                    response.setStatusCode(201);
                    break block26;
                }
                response.setStatusCode(403);
                response.setCause("Forbidden");
            }
            catch (NotConfiguredException e) {
                response.setStatusCode(503);
                response.setCause("Not Configured");
            }
            finally {
                this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
            }
        }
        try {
            Files.deleteIfExists(tmpfilePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }

    private boolean createDirectory(String path, SourceConnectorReader targetConnector) throws NotConfiguredException {
        boolean result = false;
        Path target = this.relativePathStringToFile(path, targetConnector);
        if (target != null) {
            if (Files.exists(target, new LinkOption[0])) {
                result = !Files.isRegularFile(target, new LinkOption[0]);
            } else {
                if (Files.notExists(target.getParent(), new LinkOption[0])) {
                    this.createDirectory(path.substring(0, path.lastIndexOf(47)), targetConnector);
                }
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                    Path dirlistfile = this.getStorageHelperV1002().getDirectoryFile(path);
                    ArrayList<PoolEntry> tmp1 = new ArrayList<PoolEntry>();
                    String parentAssetURLPath = URL.getParentAssetURLPath(path);
                    Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
                    this.getSourceManager().getImageListFileWriter().updateEntries(dirlistfile, path, parentDirlistFile, parentAssetURLPath, tmp1, FileOperations.getSafeLastModified(target));
                    this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(path, false);
                    String parentpath = path.substring(0, path.lastIndexOf("/", path.length() - 2)) + "/";
                    Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(parentpath);
                    ArrayList<PoolEntry> tmp2 = new ArrayList<PoolEntry>();
                    tmp2.add(new PoolDirectoryEntry(target.getFileName().toString(), FileOperations.getSafeLastModified(target), 0L, 0L));
                    String parentAssetURLPath2 = URL.getParentAssetURLPath(parentpath);
                    Path parentDirlistFile2 = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath2);
                    this.getSourceManager().getImageListFileWriter().updateEntries(parentdirlistfile, parentpath, parentDirlistFile2, parentAssetURLPath2, tmp2, FileOperations.getSafeLastModified(target.getParent()));
                    this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(parentpath, false);
                    result = true;
                }
                catch (IOException e) {
                    result = false;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    private static class ZipImageEntry {
        long lastmodified;
        Path source;
        String relativeImagePath;

        ZipImageEntry(String relativeImagePath, long lastmodified, Path source) {
            this.lastmodified = lastmodified;
            this.source = source;
            this.relativeImagePath = relativeImagePath;
        }
    }
}

