/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.service.AbstractService;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageStatusUpdater;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileReader;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileWriter;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

abstract class AbstractImporterService
extends AbstractService {
    AbstractImporterService() {
    }

    protected MainManager getSourceManager() {
        return (MainManager)this.getSourceManagerSettings().getServletContext().getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
    }

    protected void cancelConverterJob(String assetURLPath, HttpSession session) throws NotConfiguredException {
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
        if (connector != null && !connector.isVirtualViewerConnector()) {
            Path sourceFile = connector.getInboxDirectory().getPath().resolve(assetURLPath.substring(connector.getPrefix().length() + 1));
            PathCached fp = new PathCached(sourceFile);
            FileImportJob compare = new FileImportJob(QueueType.API, null, fp, null, null, assetURLPath, Converter_V1002.evaluatePriority(QueueType.API), false);
            this.getSourceManager().getConverterManager().removeJob(compare);
        }
    }

    private Path relativePathToStorageDir(String path) {
        return this.getSourceManagerSettings().getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(path)).resolve(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionResponse copyDirectory(String from, String to) throws CorruptStorageException, NotConfiguredException {
        if (!from.substring(1).contains("/") || !to.substring(1).contains("/")) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ActionResponse result = new ActionResponse();
        if (!(from = URL.cleanUpSourceParameter(from)).endsWith("/")) {
            from = from + "/";
        }
        if (!(to = URL.cleanUpSourceParameter(to)).endsWith("/")) {
            to = to + "/";
        }
        HttpSession session = this.getSession();
        SourceManagerSettings settings = this.getSourceManagerSettings();
        SourceConnectorReader srcConnector = settings.getSourceConnectorFromAssetURLPath(from, session);
        SourceConnectorReader destConnector = settings.getSourceConnectorFromAssetURLPath(to, session);
        PermissionSet srcPermissions = settings.getUserAuthenticationInterface().getPermissions(srcConnector, session, true);
        PermissionSet destPermissions = settings.getUserAuthenticationInterface().getPermissions(destConnector, session, true);
        if (!(srcPermissions.read.copy.booleanValue() && srcPermissions.list.files.booleanValue() && srcPermissions.list.directories.booleanValue() && destPermissions.write.paste.booleanValue())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (to.startsWith(from)) {
            result.setStatusCode(409);
            result.setCause("Failed to rename directory");
            return result;
        }
        Path fromDirectory = this.relativePathStringToFile(from, srcConnector);
        if (Files.notExists(fromDirectory, new LinkOption[0])) {
            result.setStatusCode(404);
            result.setCause("Source directory not found.");
            return result;
        }
        Path toDirectory = this.relativePathStringToFile(to, destConnector);
        if (Files.exists(toDirectory, new LinkOption[0]) && !destPermissions.write.overwrite.booleanValue()) {
            return result;
        }
        String toDir = to.substring(0, to.length() - 1);
        String toParent = to.substring(0, toDir.lastIndexOf("/"));
        ScannerPauseReason spr = new ScannerPauseReason(toParent, ScannerPauseReason.ModificationType.DIRECTORY);
        String pauseKey = "PK9-" + toDir.hashCode();
        this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
        try {
            boolean success = this.recursiveDirCopy(from, to, srcConnector, destConnector);
            if (success) {
                result.setStatusCode(200);
            } else {
                result.setStatusCode(415);
                result.setCause("Some files could not be copied, because the filetype is not allowed in the target profile.");
                result.setDetails("Some files could not be copied, because the filetype is not allowed in the target profile.");
            }
        }
        catch (NotConfiguredException e) {
            result.setStatusCode(503);
            result.setCause("Server not configured.");
        }
        finally {
            this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
        }
        return result;
    }

    private boolean recursiveDirCopy(String src, String dest, SourceConnectorReader srcConnector, SourceConnectorReader destConnector) throws NotConfiguredException {
        boolean success = true;
        Path srcDir = this.relativePathStringToFile(src, srcConnector);
        Path destDir = this.relativePathStringToFile(dest, destConnector);
        try {
            Files.createDirectories(destDir, new FileAttribute[0]);
            if (destConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                Path dirlistfile = this.getStorageHelperV1002().getDirectoryFile(dest);
                ArrayList<PoolEntry> tmp1 = new ArrayList<PoolEntry>();
                String parentAssetURLPath = URL.getParentAssetURLPath(dest);
                Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
                this.getSourceManager().getImageListFileWriter().updateEntries(dirlistfile, dest, parentDirlistFile, parentAssetURLPath, tmp1, FileOperations.getSafeLastModified(destDir));
            }
            List<PathCached> dirContents = FileOperations.listAllFiles(srcDir);
            int files = 0;
            int subdirectories = 0;
            for (PathCached dirEntry : dirContents) {
                if (dirEntry.isDirectory()) {
                    success &= this.recursiveDirCopy(src + dirEntry.getFileName(), dest + dirEntry.getFileName(), srcConnector, destConnector);
                    ++subdirectories;
                    continue;
                }
                boolean acceptFile = true;
                if (destConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
                    Path targetFile = this.relativePathStringToFile(dest + dirEntry.getFileName(), destConnector);
                    PathCached fileProps = new PathCached(targetFile);
                    ImageFormatScanner ifs = ImageFormatScanner.getInstance();
                    ImageFormat format = ifs.scanFile(fileProps);
                    if (format.type == ImageFormat.Type.UNK || (format.type != ImageFormat.Type.TIF || format.type != ImageFormat.Type.FPX) && destConnector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
                        acceptFile = false;
                    }
                }
                if (acceptFile) {
                    success &= this.copyFileUnconditional(src + dirEntry.getFileName(), dest + dirEntry.getFileName(), srcConnector, destConnector, true);
                    ++files;
                    continue;
                }
                success = false;
            }
            String destParent = dest.substring(0, dest.lastIndexOf("/", dest.length() - 2)) + "/";
            Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(destParent);
            ArrayList<PoolEntry> tmp2 = new ArrayList<PoolEntry>();
            tmp2.add(new PoolDirectoryEntry(destDir.getFileName().toString(), FileOperations.getSafeLastModified(destDir), files, subdirectories));
            String parentAssetURLPath = URL.getParentAssetURLPath(destParent);
            Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
            this.getSourceManager().getImageListFileWriter().updateEntries(parentdirlistfile, destParent, parentDirlistFile, parentAssetURLPath, tmp2, FileOperations.getSafeLastModified(destDir.getParent()));
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    protected boolean moveFile(String sourceAssetURLPath, String targetAssetURLPath, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector, boolean updatedirlist, boolean overwrite) throws NotConfiguredException {
        Path orgfrom;
        boolean success = true;
        if (sourceAssetURLPath.startsWith("/")) {
            sourceAssetURLPath = sourceAssetURLPath.substring(1);
        }
        if (targetAssetURLPath.startsWith("/")) {
            targetAssetURLPath = targetAssetURLPath.substring(1);
        }
        if (Files.notExists(orgfrom = sourceAssetURLPath.startsWith("_downloads") ? this.relativePathStringToFile(sourceAssetURLPath + ".download", sourceConnector) : this.relativePathStringToFile(sourceAssetURLPath, sourceConnector), new LinkOption[0])) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (Files.isDirectory(orgfrom, new LinkOption[0])) {
            throw new IllegalArgumentException("Source file is a directory.");
        }
        Path orgto = this.relativePathStringToFile(targetAssetURLPath, targetConnector);
        if (overwrite && Files.exists(orgto, new LinkOption[0])) {
            try {
                Files.deleteIfExists(orgto);
            }
            catch (IOException e) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
        }
        if (Files.notExists(orgto.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(orgto, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getSourceManagerSettings().getFSILogger().log(3199, orgto.getParent());
            }
        }
        if (!sourceAssetURLPath.startsWith("_download")) {
            this.cancelConverterJob(sourceAssetURLPath, this.getSession());
        }
        try {
            Files.move(orgfrom, orgto, new CopyOption[0]);
            if (sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                success = targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE ? this.moveStorageFile(sourceAssetURLPath, targetAssetURLPath, sourceConnector, targetConnector, updatedirlist) : this.removeStorageFile(sourceAssetURLPath, sourceConnector);
            } else {
                if (updatedirlist && !sourceAssetURLPath.startsWith("_download")) {
                    this.moveDirlistEntryV1002(sourceAssetURLPath, targetAssetURLPath, sourceConnector, targetConnector);
                }
                if (targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                    this.triggerImport(targetConnector, orgto);
                }
                success = true;
            }
            if (sourceAssetURLPath.startsWith("_download")) {
                Path jobfile = this.relativePathStringToFile(sourceAssetURLPath + ".job", sourceConnector);
                Files.delete(jobfile);
            }
            if (success) {
                success = this.moveCustomMetadata(sourceAssetURLPath, targetAssetURLPath);
            }
            if (success) {
                success = this.moveSearchDatabaseContents(sourceConnector, sourceAssetURLPath, targetConnector, targetAssetURLPath);
            }
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    protected boolean copyFileUnconditional(String sourceAssetURLPath, String targetAssetURLPath, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector, boolean overwrite) throws CorruptStorageException, NotConfiguredException {
        boolean success = false;
        Path orgfrom = sourceAssetURLPath.startsWith("_downloads") ? this.relativePathStringToFile(sourceAssetURLPath + ".download", sourceConnector) : this.relativePathStringToFile(sourceAssetURLPath, sourceConnector);
        if (Files.notExists(orgfrom, new LinkOption[0])) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (Files.isDirectory(orgfrom, new LinkOption[0])) {
            throw new IllegalArgumentException("Source file is a directory.");
        }
        Path orgto = this.relativePathStringToFile(targetAssetURLPath, targetConnector);
        if (overwrite && Files.exists(orgto, new LinkOption[0])) {
            try {
                Files.delete(orgto);
            }
            catch (IOException e) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
        }
        if (Files.exists(orgto, new LinkOption[0])) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        if (Files.notExists(orgto.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(orgto, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getSourceManagerSettings().getFSILogger().log(3199, orgto.getParent());
            }
        }
        if (success = FileOperations.copy(this.getSourceManagerSettings().getFSILogger(), orgfrom, orgto)) {
            if (sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                success = targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE ? this.copyStorageFile(sourceAssetURLPath, targetAssetURLPath) : true;
            } else {
                try {
                    if (!sourceAssetURLPath.startsWith("_downloads") && !sourceConnector.isVirtualViewerConnector()) {
                        this.copyDirListEntryV1002(sourceAssetURLPath, targetAssetURLPath);
                    } else {
                        this.getSourceManagerSettings().getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, URL.getParentAssetURLPath(targetAssetURLPath));
                    }
                    if (targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                        this.triggerImport(targetConnector, orgto);
                        success = true;
                    }
                }
                catch (IOException e) {
                    success = false;
                }
            }
            if (success && !sourceAssetURLPath.startsWith("_config") && !targetAssetURLPath.startsWith("_config")) {
                success = this.copyCustomMetadata(sourceAssetURLPath, targetAssetURLPath);
            }
            if (success && !sourceAssetURLPath.startsWith("_config") && !targetAssetURLPath.startsWith("_config")) {
                success = this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(targetAssetURLPath, false);
            }
        }
        return success;
    }

    private boolean copyCustomMetadata(String fromAssetURLPath, String toAssetURLPath) {
        Path baseMetadataLocation = this.getSourceManagerSettings().getMetaDataLocation();
        Path fromMetaDataFile = baseMetadataLocation.resolve(fromAssetURLPath + ".meta");
        if (Files.exists(fromMetaDataFile, new LinkOption[0])) {
            Path toMetaDataFile = baseMetadataLocation.resolve(toAssetURLPath + ".meta");
            try {
                return FileOperations.copy(fromMetaDataFile, toMetaDataFile);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    protected boolean moveCustomMetadata(String fromAssetURLPath, String toAssetURLPath) {
        Path fromMetaDataFile;
        Path baseMetadataLocation = this.getSourceManagerSettings().getMetaDataLocation();
        if (fromAssetURLPath.endsWith("/")) {
            fromAssetURLPath = fromAssetURLPath.substring(0, fromAssetURLPath.length() - 1);
        }
        if (toAssetURLPath.endsWith("/")) {
            toAssetURLPath = toAssetURLPath.substring(0, toAssetURLPath.length() - 1);
        }
        if (Files.exists(fromMetaDataFile = baseMetadataLocation.resolve(fromAssetURLPath + ".meta"), new LinkOption[0])) {
            Path toMetaDataFile = baseMetadataLocation.resolve(toAssetURLPath + ".meta");
            try {
                FileOperations.move(fromMetaDataFile, toMetaDataFile);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private boolean copyStorageFile(String from, String to) throws NotConfiguredException {
        boolean result = false;
        if (!(result |= this.copyStorageFileV1002(from, to)) && this.getSourceManagerSettings().isMigrationModeEnabled()) {
            try {
                this.triggerImport(to);
                result = true;
            }
            catch (IOException e) {
                result = false;
            }
        }
        return result;
    }

    private boolean copyStorageFileV1002(String from, String to) throws NotConfiguredException {
        boolean result = false;
        try {
            result = this.getSourceManagerSettings().getStorageManager().copyStorageFile(from, to);
            this.copyDirListEntryV1002(from, to);
            this.checkForRequiredReimport(from, to);
            this.getSourceManagerSettings().getFSILogger().log(3167, from);
        }
        catch (IOException ioe) {
            result = false;
        }
        return result;
    }

    private void copyDirListEntryV1002(String from, String to) throws NotConfiguredException, NoSuchFileException, IOException {
        Path orgfrom = this.relativePathStringToFile(from, null);
        Path orgto = this.relativePathStringToFile(to, null);
        String assetURLPath = from.substring(0, from.lastIndexOf("/"));
        Path fromDirList = this.getStorageHelperV1002().getDirectoryFile(assetURLPath);
        PoolList fromPoolList = this.getSourceManager().getImageListFileReader().getListFileContents(fromDirList, assetURLPath);
        PoolEntry pe = null;
        if (fromPoolList.containsDirectory(orgfrom.getFileName().toString())) {
            pe = fromPoolList.getDirectories().get(orgfrom.getFileName().toString());
        } else if (fromPoolList.containsImageFilename(orgfrom.getFileName().toString())) {
            pe = fromPoolList.getImage(orgfrom.getFileName().toString());
            pe.type = ImageListFileWriter.ListEntryType.FILE;
            pe.name = orgto.getFileName().toString();
        }
        String targetDirectoryAssetURL = to.substring(0, to.lastIndexOf("/"));
        Path toDirList = this.getStorageHelperV1002().getDirectoryFile(targetDirectoryAssetURL);
        ArrayList<PoolEntry> tmp = new ArrayList<PoolEntry>();
        tmp.add(pe);
        String parentAssetURLPath = URL.getParentAssetURLPath(targetDirectoryAssetURL);
        Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
        this.getSourceManager().getImageListFileWriter().updateEntries(toDirList, targetDirectoryAssetURL, parentDirlistFile, parentAssetURLPath, tmp, FileOperations.getSafeLastModified(orgto.getParent()));
    }

    protected boolean moveSearchDatabaseContents(SourceConnectorReader fromConnector, String fromAssetURLPath, SourceConnectorReader toConnector, String toAssetURLPath) throws NotConfiguredException {
        boolean success = true;
        SolrUpdater sdb = this.getSourceManagerSettings().getSolrUpdater();
        if (sdb != null && !sdb.hasError()) {
            if (!fromConnector.isVirtualViewerConnector()) {
                sdb.deleteAssetAsync(fromAssetURLPath);
            }
            if (!toConnector.isVirtualViewerConnector()) {
                success = this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(toAssetURLPath, false);
            }
        }
        return success;
    }

    protected boolean moveStorageFile(String sourceAssetURLPath, String targetAssetURLPath, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector, boolean updatedirlist) throws NotConfiguredException {
        boolean result = false;
        if (this.getSourceManagerSettings().isMigrationModeEnabled()) {
            result |= this.moveStorageFileV1001(sourceAssetURLPath, targetAssetURLPath, sourceConnector, targetConnector, updatedirlist);
        }
        if (!result) {
            result |= this.moveStorageFileV1002(sourceAssetURLPath, targetAssetURLPath, sourceConnector, targetConnector, updatedirlist);
        }
        return result;
    }

    protected boolean removeStorageFile(String assetURLPath, SourceConnectorReader connector) throws NotConfiguredException {
        boolean result = false;
        if (this.getSourceManagerSettings().isMigrationModeEnabled()) {
            result |= this.removeStorageFileV1001(assetURLPath);
        }
        if (!result) {
            result |= this.removeStorageFileV1002(assetURLPath, connector);
        }
        return result;
    }

    private boolean removeStorageFileV1001(String assetURLPath) {
        boolean success = this.getSourceManager().getDeleteDaemon().removeStorageFileV1001(assetURLPath);
        return success;
    }

    private boolean removeStorageFileV1002(String assetURLPath, SourceConnectorReader connector) throws NotConfiguredException {
        boolean success = false;
        try {
            success = this.getSourceManager().getDeleteDaemon().removeStorageFileV1002(assetURLPath, connector, true);
            this.removeDirlistEntryV1002(assetURLPath, connector);
        }
        catch (IOException e) {
            this.getSourceManagerSettings().getFSILogger().log(3248, assetURLPath, e.getLocalizedMessage());
            success = false;
        }
        return success;
    }

    private boolean moveStorageFileV1002(String sourceAssetURLPath, String targetAssetURLPath, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector, boolean updatedirlist) throws NotConfiguredException {
        boolean result = false;
        Path fromEis = this.getStorageHelperV1002().getEisFile(sourceAssetURLPath);
        Path toEis = this.getStorageHelperV1002().getEisFile(targetAssetURLPath);
        try {
            result = this.getSourceManagerSettings().getStorageManager().moveStorageFile(fromEis, sourceAssetURLPath, toEis, targetAssetURLPath);
            if (updatedirlist) {
                this.moveDirlistEntryV1002(sourceAssetURLPath, targetAssetURLPath, sourceConnector, targetConnector);
            }
            this.checkForRequiredReimport(sourceAssetURLPath, targetAssetURLPath);
            this.getSourceManagerSettings().getFSILogger().log(3166, sourceAssetURLPath);
        }
        catch (IOException ioe) {
            result = false;
        }
        return result;
    }

    private void checkForRequiredReimport(String from, String to) throws CorruptStorageException, NotConfiguredException, IOException {
        boolean reimportRequired = false;
        SourceConnectorReader sourceProfile = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(from, this.getSession());
        SourceConnectorReader destinationProfile = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(to, this.getSession());
        if (sourceProfile.getTileFormat() != destinationProfile.getTileFormat()) {
            reimportRequired = true;
        } else if (sourceProfile.getTileFormat() == TileCompression.JPEG && sourceProfile.getQuality() != destinationProfile.getQuality()) {
            reimportRequired = true;
        }
        if (reimportRequired) {
            SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(to);
            this.scheduleImageForReimport(connector, to);
        }
    }

    private void removeDirlistEntryV1002(String assetURLPath, SourceConnectorReader connector) throws NotConfiguredException {
        Path orgfrom = this.relativePathStringToFile(assetURLPath, connector);
        String parentPath = assetURLPath.substring(0, assetURLPath.lastIndexOf("/"));
        Path fromDirList = this.getStorageHelperV1002().getDirectoryFile(parentPath);
        String parentAssetURLPath = URL.getParentAssetURLPath(parentPath);
        Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
        this.getSourceManager().getImageListFileWriter().removeEntry(fromDirList, parentPath, parentdirlistfile, parentAssetURLPath, orgfrom.getFileName().toString(), FileOperations.getSafeLastModified(orgfrom.getParent()));
    }

    private void moveDirlistEntryV1002(String sourceAssetURLPath, String targetAssetURLPath, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector) throws NotConfiguredException, NoSuchFileException, IOException {
        Path orgfrom = this.relativePathStringToFile(sourceAssetURLPath, sourceConnector);
        Path orgto = this.relativePathStringToFile(targetAssetURLPath, targetConnector);
        String fromParentPath = sourceAssetURLPath.substring(0, sourceAssetURLPath.lastIndexOf("/"));
        Path fromDirList = this.getStorageHelperV1002().getDirectoryFile(fromParentPath);
        PoolList fromPoolList = this.getSourceManager().getImageListFileReader().getListFileContents(fromDirList, fromParentPath);
        PoolEntry pe = null;
        if (fromPoolList.containsDirectory(orgfrom.getFileName().toString())) {
            pe = fromPoolList.getDirectories().get(orgfrom.getFileName().toString());
        } else if (fromPoolList.containsImageFilename(orgfrom.getFileName().toString())) {
            pe = fromPoolList.getImage(orgfrom.getFileName().toString());
            pe.type = ImageListFileWriter.ListEntryType.FILE;
            pe.name = orgto.getFileName().toString();
        }
        String sourceParentAssetURLPath = URL.getParentAssetURLPath(fromParentPath);
        Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(sourceParentAssetURLPath);
        this.getSourceManager().getImageListFileWriter().removeEntry(fromDirList, fromParentPath, parentdirlistfile, sourceParentAssetURLPath, orgfrom.getFileName().toString(), FileOperations.getSafeLastModified(orgfrom.getParent()));
        String targetDirectoryAssetURL = targetAssetURLPath.substring(0, targetAssetURLPath.lastIndexOf("/"));
        Path toDirList = this.getStorageHelperV1002().getDirectoryFile(targetDirectoryAssetURL);
        ArrayList<PoolEntry> tmp = new ArrayList<PoolEntry>();
        tmp.add(pe);
        String targetParentAssetURLPath = URL.getParentAssetURLPath(targetDirectoryAssetURL);
        Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(targetParentAssetURLPath);
        this.getSourceManager().getImageListFileWriter().updateEntries(toDirList, targetDirectoryAssetURL, parentDirlistFile, targetParentAssetURLPath, tmp, FileOperations.getSafeLastModified(orgto.getParent()));
    }

    private boolean moveStorageFileV1001(String from, String to, SourceConnectorReader sourceConnector, SourceConnectorReader targetConnector, boolean updatedirlist) throws NotConfiguredException {
        Path poolfrom = this.relativePathToStorageDir(from);
        Path poolto = this.relativePathToStorageDir(to);
        if (Files.notExists(poolto.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(poolto.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getSourceManagerSettings().getFSILogger().log(3199, poolto.getParent());
            }
        }
        boolean success = true;
        try {
            Files.move(poolfrom, poolto, new CopyOption[0]);
            if (updatedirlist) {
                try {
                    Path orgfrom = this.relativePathStringToFile(from, sourceConnector);
                    Path orgto = this.relativePathStringToFile(to, targetConnector);
                    String fromparentrelpath = from.substring(0, from.lastIndexOf("/", from.length() - 2)) + "/";
                    Path parentfrompooldir = this.relativePathToStorageDir(fromparentrelpath);
                    Path fromdirlistfile = parentfrompooldir.resolve("dirlist");
                    String toparentrelpath = to.substring(0, to.lastIndexOf("/", to.length() - 2)) + "/";
                    Path parenttopooldir = this.relativePathToStorageDir(toparentrelpath);
                    Path todirlistfile = parenttopooldir.resolve("dirlist");
                    PoolList fromPoolList = this.getSourceManager().getImageListFileReader().getListFileContents(fromdirlistfile, fromparentrelpath);
                    PoolEntry pe = null;
                    if (fromPoolList.containsDirectory(orgfrom.getFileName().toString())) {
                        pe = fromPoolList.getDirectories().get(orgfrom.getFileName().toString());
                    } else if (fromPoolList.containsImageFilename(orgfrom.getFileName().toString())) {
                        pe = fromPoolList.getImage(orgfrom.getFileName().toString());
                        pe.type = ImageListFileWriter.ListEntryType.FILE;
                        pe.name = orgto.getFileName().toString();
                    }
                    String sourceParentAssetURLPath = URL.getParentAssetURLPath(fromparentrelpath);
                    Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(sourceParentAssetURLPath);
                    this.getSourceManager().getImageListFileWriter().removeEntry(fromdirlistfile, fromparentrelpath, parentdirlistfile, sourceParentAssetURLPath, orgfrom.getFileName().toString(), FileOperations.getSafeLastModified(orgfrom.getParent()));
                    ArrayList<PoolEntry> tmp = new ArrayList<PoolEntry>();
                    tmp.add(pe);
                    this.getSourceManager().getImageListFileWriter().updateEntries(todirlistfile, toparentrelpath, null, null, tmp, FileOperations.getSafeLastModified(orgto.getParent()));
                }
                catch (IOException e) {
                    this.getSourceManagerSettings().getFSILogger().log(3175, "movePoolFile", e.getLocalizedMessage());
                }
            }
            this.getSourceManagerSettings().getFSILogger().log(3166, from);
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    protected int scheduleImageForReimport(SourceConnectorReader connector, String assetURLPath) throws CorruptStorageException, NotConfiguredException, IOException {
        if (connector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGE) {
            return 0;
        }
        Path sourceFile = this.relativePathStringToFile(assetURLPath, connector);
        if (!this.getSourceManagerSettings().getMainManager().getScannerDaemon().isAcceptedFileForStorageConnector(sourceFile)) {
            return 0;
        }
        Path eisFile = this.getStorageHelperV1002().getEisFile(assetURLPath);
        try {
            EISImageStatusUpdater statusUpdater = new EISImageStatusUpdater();
            statusUpdater.setAssetURLPath(assetURLPath);
            statusUpdater.setNewStatus((short)4);
            this.getSourceManagerSettings().getStorageManager().executeStorageDataProvider(eisFile, statusUpdater);
        }
        catch (Exception e) {
            this.getSourceManagerSettings().getStorageManager().removeFromStorage(eisFile, assetURLPath);
            EISImageWriter eisImageWriter = new EISImageWriter(this.getSourceManagerSettings(), 4, -1);
            eisImageWriter.setAssetURLPath(assetURLPath);
            this.getSourceManagerSettings().getStorageManager().executeStorageDataProvider(eisFile, eisImageWriter);
        }
        PoolFileEntry entry = new PoolFileEntry(sourceFile.getFileName().toString(), FileOperations.getSafeLastModified(sourceFile), Files.size(sourceFile), -1, -1, 4);
        String parentPath = assetURLPath.substring(0, assetURLPath.lastIndexOf("/"));
        Path dirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentPath);
        this.getSourceManager().getImageListFileWriter().updateEntry(dirlistFile, parentPath, null, null, entry, -1L);
        this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(parentPath, false);
        Path directory = sourceFile.getParent();
        this.getSourceManager().getScannerDaemon().triggerDirectoryCheck(directory, parentPath);
        return 1;
    }

    protected int clearCustomMetadata(String assetURLPath) throws NotConfiguredException, IOException {
        Path baseMetadataLocation = this.getSourceManagerSettings().getMetaDataLocation();
        Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
        Files.deleteIfExists(metaDataFile);
        this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(assetURLPath, true);
        this.getSourceManagerSettings().getStorageManager().getStorageLogger().log('A', StorageLogger.LogCMD.U, assetURLPath);
        return 1;
    }

    protected ActionResponse deleteMetaData(String assetURLPath, MultivaluedMap<String, String> formParams) throws NotConfiguredException {
        MultivaluedHashMap newMap = new MultivaluedHashMap();
        for (String key : formParams.keySet()) {
            newMap.put((Object)key, null);
        }
        return this.saveMetaData(assetURLPath, (MultivaluedMap<String, String>)newMap);
    }

    protected ActionResponse restoreMetaData(String assetURLPath, MultivaluedMap<String, String> formParams) throws NotConfiguredException {
        HttpSession session = this.getSession();
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
        PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
        if (!ps.write.extendedMetadata.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Path f = this.relativePathStringToFile(assetURLPath, connector);
        if (Files.notExists(f, new LinkOption[0])) {
            ActionResponse result = new ActionResponse();
            result.setStatusCode(404);
            result.setCause("File Not Found.");
            return result;
        }
        ActionResponse result = new ActionResponse();
        Path baseMetadataLocation = this.getSourceManagerSettings().getMetaDataLocation();
        Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
        if (Files.exists(metaDataFile, new LinkOption[0])) {
            try {
                CustomMetaDataFileReader reader = new CustomMetaDataFileReader(this.getSourceManagerSettings(), metaDataFile);
                Map<String, String> metadata = reader.getDataSet();
                for (String key : formParams.keySet()) {
                    metadata.remove(key);
                }
                CustomMetaDataFileWriter writer = new CustomMetaDataFileWriter(this.getSourceManagerSettings(), metaDataFile);
                writer.setData(metadata);
                result.setStatusCode(200);
            }
            catch (IOException ioe) {
                this.getSourceManagerSettings().getFSILogger().log(3254, metaDataFile);
                result.setStatusCode(500);
                result.setCause("Error saving metadata.");
                return result;
            }
        } else {
            result.setStatusCode(200);
        }
        return result;
    }

    protected ActionResponse saveMetaData(String assetURLPath, MultivaluedMap<String, String> formParams) throws NotConfiguredException {
        HashMap<String, String> metadata;
        HttpSession session = this.getSession();
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
        PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
        if (!ps.write.extendedMetadata.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Path f = this.relativePathStringToFile(assetURLPath, connector);
        if (Files.notExists(f, new LinkOption[0])) {
            ActionResponse result = new ActionResponse();
            result.setStatusCode(404);
            result.setCause("File Not Found.");
            return result;
        }
        ActionResponse result = new ActionResponse();
        Path baseMetadataLocation = this.getSourceManagerSettings().getMetaDataLocation();
        Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
        if (Files.exists(metaDataFile, new LinkOption[0])) {
            CustomMetaDataFileReader reader = new CustomMetaDataFileReader(this.getSourceManagerSettings(), metaDataFile);
            try {
                metadata = reader.getDataSet();
            }
            catch (IOException ioe) {
                this.getSourceManagerSettings().getFSILogger().log(3253, metaDataFile);
                result.setStatusCode(500);
                result.setCause("Error reading existing metadata.");
                return result;
            }
        } else {
            metadata = new HashMap();
        }
        for (String key : formParams.keySet()) {
            if (!key.startsWith("iptc.") && !key.startsWith("exif.") && !key.startsWith("fsi.")) continue;
            String value = (String)formParams.getFirst((Object)key);
            metadata.put(key, value);
        }
        CustomMetaDataFileWriter writer = new CustomMetaDataFileWriter(this.getSourceManagerSettings(), metaDataFile);
        try {
            writer.setData(metadata);
            SolrUpdater sdb = this.getSourceManagerSettings().getSolrUpdater();
            if (sdb != null) {
                sdb.deleteAssetAsync(assetURLPath);
            }
            result.setStatusCode(200);
        }
        catch (IOException e) {
            this.getSourceManagerSettings().getFSILogger().logException(e, 3254, metaDataFile);
            result.setStatusCode(500);
            result.setCause("Error saving metadata.");
            return result;
        }
        this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(assetURLPath, true);
        this.getSourceManagerSettings().getStorageManager().getStorageLogger().log('A', StorageLogger.LogCMD.U, assetURLPath);
        return result;
    }

    private void triggerImport(String assetURLPath) throws NotConfiguredException, IOException {
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, this.getSession());
        Path sourceFile = this.relativePathStringToFile(assetURLPath, connector);
        this.triggerImport(connector, sourceFile);
    }

    private void triggerImport(SourceConnectorReader connector, Path sourceFile) throws NotConfiguredException, IOException {
        this.getSourceManager().getScannerDaemon().manuallySubmitNewJob(connector, sourceFile);
    }
}

