/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Pref;
import com.neptunelabs.fsiserver.utils.service.PrefsResponse;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;

abstract class AbstractService {
    @Context
    private ServletContext servletContext;
    @Context
    protected HttpServletRequest request;
    protected static final Random random = new Random();
    protected static final CacheControl defaultCacheControl = AbstractService.initCacheControl();
    private SourceManagerSettings sourceManagerSettings;
    private RequestProcessorSettings requestProcessorSettings;
    private FSILogger apiLogger;
    private String serverStartupError = null;

    AbstractService() {
    }

    protected HttpSession getSession() {
        HttpSession result = null;
        if (this.request != null) {
            result = this.request.getSession(true);
        }
        return result;
    }

    protected String getHost() {
        String result = "";
        if (this.request != null) {
            result = this.request.getRemoteAddr();
        }
        return result;
    }

    protected String getUser() {
        String result = "";
        UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
        HttpSession session = this.getSession();
        if (uai != null && session != null) {
            result = uai.getUser((String)session.getAttribute("id"));
        }
        return result;
    }

    protected Set<String> getUserGroupsWithoutDefault() {
        Set<String> allUserGroups = this.getUserGroups();
        allUserGroups.remove("users");
        allUserGroups.remove("public");
        return allUserGroups;
    }

    protected Set<String> getUsers() {
        UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
        Set<String> result = uai.getUsers();
        return result;
    }

    protected Set<String> getUserGroups() {
        TreeSet<String> result = new TreeSet<String>();
        String username = this.getUser();
        if (username != null) {
            UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
            Collection<Group> groups = uai.getGroups().values();
            for (Group g : groups) {
                Set<String> users = g.getUsers();
                if (!users.contains(username)) continue;
                result.add(g.getName());
            }
        }
        return result;
    }

    protected boolean changeUser(String username) {
        UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
        HttpSession session = this.getSession();
        Object idO = session.getAttribute("id");
        if (idO != null) {
            String sessionID = (String)idO;
            return uai.changeUser(sessionID, username);
        }
        return false;
    }

    protected String getServerStartupError() {
        return this.serverStartupError;
    }

    protected FSILogger getAPILogger() {
        if (this.apiLogger != null) {
            return this.apiLogger;
        }
        this.getSourceManagerSettings();
        if (this.sourceManagerSettings != null) {
            this.apiLogger = this.sourceManagerSettings.getAPILogger();
        }
        return this.apiLogger;
    }

    protected SourceManagerSettings getSourceManagerSettings() {
        if (this.sourceManagerSettings != null) {
            return this.sourceManagerSettings;
        }
        Object o = this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
        if (o != null) {
            MainManager importer = (MainManager)o;
            this.sourceManagerSettings = importer.getSettings();
        }
        if (this.sourceManagerSettings == null) {
            Object coreStartupErrorO;
            Object importerStartupErrorO = this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.startError");
            if (importerStartupErrorO != null) {
                this.serverStartupError = (String)importerStartupErrorO;
            }
            if (this.serverStartupError == null && (coreStartupErrorO = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.startError")) != null) {
                this.serverStartupError = (String)coreStartupErrorO;
            }
            if (this.serverStartupError == null) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return this.sourceManagerSettings;
    }

    protected MainProcessor getRequestProcessor() {
        Object o = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
        if (o != null) {
            return (MainProcessor)o;
        }
        return null;
    }

    protected RequestProcessorSettings getRequestProcessorSettings() {
        if (this.requestProcessorSettings != null) {
            return this.requestProcessorSettings;
        }
        Object o = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.MainProcessor");
        if (o == null) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        MainProcessor rp = (MainProcessor)o;
        this.requestProcessorSettings = rp.getRequestProcessorSettings();
        return this.requestProcessorSettings;
    }

    protected StorageHelperV1002 getStorageHelperV1002() {
        return this.getSourceManagerSettings().getStorageHelper();
    }

    protected boolean validateSession() {
        boolean result = false;
        if (this.getSourceManagerSettings() != null) {
            UserAuthenticationInterface.SessionStatus ss;
            Object idO;
            UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
            HttpSession session = this.getSession();
            if (session != null && uai != null && (idO = session.getAttribute("id")) != null && (ss = uai.validateSession((String)idO)) == UserAuthenticationInterface.SessionStatus.VALID) {
                result = true;
            }
        }
        return result;
    }

    protected Map<String, String> getBasicUserSystemPrefs(Path configdir) {
        Path defaultPrefsFile = configdir.resolve("defaultprefs.xml");
        Map<String, String> prefsMap = this.getPrefsFromFile(defaultPrefsFile);
        Path userprefsdir = configdir.resolve("userprefs");
        Path userPrefsFile = userprefsdir.resolve(this.getUser() + ".xml");
        if (Files.exists(userPrefsFile, new LinkOption[0])) {
            Map<String, String> userPrefs = this.getPrefsFromFile(userPrefsFile);
            for (Map.Entry<String, String> pref : userPrefs.entrySet()) {
                if (pref.getValue() != null && !pref.getValue().equals("null")) {
                    prefsMap.put(pref.getKey(), pref.getValue());
                    continue;
                }
                if (pref.getValue() != null && !pref.getValue().equals("null")) continue;
                prefsMap.remove(pref.getKey());
            }
        }
        return prefsMap;
    }

    protected Map<String, String> getPrefsFromFile(Path file) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Document doc = FileOperations.getXMLFileContent(this.getAPILogger(), file);
                String xml = XMLOperations.elementNamesToLowerCase(this.getAPILogger(), doc);
                PrefsResponse contents = XMLOperations.unmarshalJAXB(xml, PrefsResponse.class);
                for (Pref p : contents.prefs) {
                    result.put(p.name, p.value);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected Path relativePathStringToFile(String assetURLPath, SourceConnectorReader connector) throws NotConfiguredException {
        Path file;
        block14: {
            if (assetURLPath.contains("/..")) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (assetURLPath.startsWith("/")) {
                assetURLPath = assetURLPath.substring(1);
            }
            String[] parts = assetURLPath.split("/");
            HttpSession session = this.getSession();
            if (connector == null) {
                connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
            }
            file = null;
            if (connector == null) break block14;
            if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
                UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
                Map<String, PublishingSet> pSetMap = uai.getUserPublishingSets(session);
                try {
                    file = this.getViewerConfigAssetFromAssetURLPath(assetURLPath, pSetMap);
                }
                catch (NoSuchFileException e) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            } else if (assetURLPath.startsWith("_download")) {
                file = this.getStorageHelperV1002().getDownloadsFolder();
                for (int i = 1; i < parts.length; ++i) {
                    file = file.resolve(parts[i]);
                }
            } else if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                file = this.getSourceManagerSettings().getWorkDirectory();
                for (int i = 1; i < parts.length; ++i) {
                    file = file.resolve(parts[i]);
                }
            } else {
                file = connector.getInboxDirectory().getPath();
                for (int i = 1; i < parts.length; ++i) {
                    file = file.resolve(parts[i]);
                }
            }
        }
        return file;
    }

    protected void clearRelatedPublishingSetsCache(String assetURLPath) {
        if (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
            UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
            HttpSession session = this.getSession();
            Map<String, PublishingSet> pSetMap = uai.getUserPublishingSets(session);
            String setname = this.extractPublishingSetNameFromAssetURLPath(assetURLPath);
            PublishingSet referenceSet = pSetMap.get(setname);
            String referenceViewerPath = referenceSet.viewerpath.value;
            ArrayList<String> relevantSetnames = new ArrayList<String>();
            List<PublishingSet> allSets = uai.getAllUserPublishingSets();
            for (PublishingSet pSet : allSets) {
                if (!referenceViewerPath.equals(pSet.viewerpath.value)) continue;
                relevantSetnames.add(pSet.getName());
            }
            String prefix = "_configs/" + setname;
            String pathInSet = assetURLPath.substring(prefix.length());
            HashSet<String> pathsToClear = new HashSet<String>();
            for (String name : relevantSetnames) {
                pathsToClear.add("_configs/" + name + pathInSet);
            }
            StorageLogger storageLogger = this.getSourceManagerSettings().getStorageManager().getStorageLogger();
            for (String pathToClear : pathsToClear) {
                storageLogger.log('D', StorageLogger.LogCMD.U, pathToClear);
            }
            prefix = "_viewers/" + setname;
            pathInSet = assetURLPath.substring(prefix.length());
            pathsToClear = new HashSet();
            for (String name : relevantSetnames) {
                pathsToClear.add("_viewers/" + name + pathInSet);
            }
            for (String pathToClear : pathsToClear) {
                storageLogger.log('D', StorageLogger.LogCMD.U, pathToClear);
            }
        }
    }

    protected String generateSalt() {
        StringBuilder saltsb = new StringBuilder();
        for (int c = 0; c < 8; ++c) {
            saltsb.append(String.format("%08x", random.nextLong()));
        }
        return saltsb.toString();
    }

    protected Response buildResponse(ActionResponse response) {
        Response.ResponseBuilder rb = Response.status((int)response.getStatusCode());
        rb.entity((Object)response);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    private static CacheControl initCacheControl() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setProxyRevalidate(true);
        cc.setMustRevalidate(true);
        cc.setNoStore(true);
        cc.setPrivate(true);
        return cc;
    }

    private String extractPublishingSetNameFromAssetURLPath(String assetURLPath) {
        if (!assetURLPath.startsWith("_configs") && !assetURLPath.startsWith("_viewers")) {
            return null;
        }
        String setname = assetURLPath.substring(9);
        int slashPosition = setname.indexOf("/");
        if (slashPosition > 0) {
            setname = setname.substring(0, slashPosition);
        }
        return setname;
    }

    private Path getViewerConfigAssetFromAssetURLPath(String assetURLPath, Map<String, PublishingSet> publishingSetMap) throws NoSuchFileException {
        Path viewerPath;
        String setname = this.extractPublishingSetNameFromAssetURLPath(assetURLPath);
        PublishingSet pSet = publishingSetMap.get(setname);
        if (pSet == null || pSet.viewerpath == null || pSet.viewerpath.value == null) {
            throw new NoSuchFileException(assetURLPath);
        }
        Path basePath = viewerPath = ServletUtils.getRealPath(this.getSourceManagerSettings().getServletContext(), pSet.viewerpath.value);
        if (assetURLPath.startsWith("_configs")) {
            basePath = viewerPath.resolve("config");
        }
        if (Files.notExists(basePath, new LinkOption[0])) {
            throw new NoSuchFileException(basePath.toString());
        }
        String restPath = assetURLPath.startsWith("_configs") ? assetURLPath.substring(9 + setname.length()) : assetURLPath.substring(8 + setname.length());
        if (restPath.startsWith("/")) {
            restPath = restPath.substring(1);
        }
        Path target = basePath;
        if (restPath.length() > 0) {
            target = basePath.resolve(restPath);
        }
        return target;
    }
}

