/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractImporterService;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Directory;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/directory/")
public final class DirectoryService
extends AbstractImporterService
implements Serializable {
    private static final long serialVersionUID = -8061277343399746611L;

    @GET
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/xml", "application/json"})
    public Response listDirectory(@PathParam(value="directorypath") String path) {
        Response.ResponseBuilder rb;
        block12: {
            if (!(path = URL.cleanUpSourceParameter(path)).endsWith("/")) {
                path = path + "/";
            }
            try {
                HttpSession session = this.getSession();
                SourceManagerSettings settings = this.getSourceManagerSettings();
                SourceConnectorReader connector = settings.getSourceConnectorFromAssetURLPath(path, session);
                PermissionSet permissions = settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (permissions == null || !permissions.list.files.booleanValue() && !permissions.list.directories.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                java.nio.file.Path orgtarget = this.relativePathStringToFile(path, connector);
                if (orgtarget != null) {
                    Directory dir = new Directory();
                    try {
                        List<PathCached> list = FileOperations.listAllFiles(orgtarget);
                        if (list != null) {
                            for (PathCached entry : list) {
                                if (entry.isRegularFile() && permissions.list.files.booleanValue()) {
                                    Directory.ImageEntry ie = new Directory.ImageEntry();
                                    ie.lastModified = entry.lastModified();
                                    ie.name = entry.getFileName();
                                    ie.size = entry.size();
                                    dir.images.add(ie);
                                    continue;
                                }
                                if (!entry.isDirectory() || !permissions.list.directories.booleanValue()) continue;
                                Directory.DirEntry de = new Directory.DirEntry();
                                de.name = entry.getFileName();
                                dir.directories.add(de);
                            }
                        } else {
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                        rb = Response.ok((Object)dir);
                        break block12;
                    }
                    catch (NoSuchFileException e) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    catch (IOException e) {
                        throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                    }
                }
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return rb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/xml", "application/json"})
    public Response createDirectory(@PathParam(value="directorypath") String path) {
        ActionResponse result;
        block29: {
            if (!(path = URL.cleanUpSourceParameter(path)).endsWith("/")) {
                path = path + "/";
            }
            result = new ActionResponse();
            try {
                if (path.contains("/..")) {
                    result.setStatusCode(403);
                    result.setCause("Invalid path value.");
                    break block29;
                }
                String parentDir = path.substring(0, path.length() - 1);
                parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                HttpSession session = this.getSession();
                SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(path, session);
                PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (permissions == null || !permissions.write.createDirectory.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                String pauseKey = null;
                if (!connector.isVirtualViewerConnector()) {
                    ScannerPauseReason spr = new ScannerPauseReason(parentDir, ScannerPauseReason.ModificationType.DIRECTORY);
                    pauseKey = "PK3" + parentDir.hashCode();
                    this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
                }
                try {
                    block30: {
                        java.nio.file.Path target = this.relativePathStringToFile(path, connector);
                        if (target != null) {
                            if (Files.exists(target, new LinkOption[0])) {
                                if (Files.isRegularFile(target, new LinkOption[0])) {
                                    result.setStatusCode(409);
                                    result.setCause("Failed to create directory.");
                                } else if (Files.isWritable(target)) {
                                    result.setStatusCode(409);
                                    result.setCause("Directory already exists.");
                                } else {
                                    result.setStatusCode(409);
                                    result.setCause("Directory already exists but is not readable.");
                                }
                            } else {
                                try {
                                    Files.createDirectories(target, new FileAttribute[0]);
                                    if (Files.exists(target, new LinkOption[0])) {
                                        if (!connector.isVirtualViewerConnector()) {
                                            try {
                                                String parentname;
                                                String parentOfParentPath;
                                                java.nio.file.Path dirlistfile = this.getStorageHelperV1002().getDirectoryFile(path);
                                                String parentpath = path.substring(0, path.lastIndexOf("/", path.length() - 2));
                                                java.nio.file.Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(parentpath);
                                                if (Files.notExists(parentdirlistfile, new LinkOption[0])) {
                                                    this.createDirectory(parentpath);
                                                }
                                                this.getSourceManager().getImageListFileWriter().updateEntries(dirlistfile, path, parentdirlistfile, parentpath, new ArrayList<PoolEntry>(), FileOperations.getSafeLastModified(target));
                                                int losPosParent = parentpath.lastIndexOf("/", parentpath.length() - 2);
                                                if (losPosParent > -1) {
                                                    parentOfParentPath = parentpath.substring(0, losPosParent);
                                                    parentname = parentpath.substring(losPosParent + 1);
                                                } else {
                                                    parentOfParentPath = "/";
                                                    parentname = parentpath;
                                                }
                                                java.nio.file.Path parentOfParentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(parentOfParentPath);
                                                try {
                                                    PoolList pl = this.getSourceManager().getImageListFileReader().getListFileContents(parentOfParentDirlistFile, parentOfParentPath);
                                                    PoolDirectoryEntry pde = pl.getDirectory(parentname);
                                                    ++pde.subdirectories;
                                                    ArrayList<PoolEntry> pel = new ArrayList<PoolEntry>();
                                                    pel.add(pde);
                                                    this.getSourceManager().getImageListFileWriter().updateEntries(parentOfParentDirlistFile, parentOfParentPath, null, null, pel, -1L);
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                                this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(path, false);
                                                result.setStatusCode(200);
                                            }
                                            catch (NotConfiguredException e) {
                                                result.setStatusCode(503);
                                                result.setCause("Server not configured.");
                                            }
                                            break block30;
                                        }
                                        this.clearRelatedPublishingSetsCache(parentDir);
                                        result.setStatusCode(200);
                                        break block30;
                                    }
                                    result.setStatusCode(500);
                                    result.setCause("Failed to create directory");
                                }
                                catch (IOException e) {
                                    result.setStatusCode(500);
                                    result.setCause("Failed to create directory: " + e.getLocalizedMessage());
                                }
                            }
                        } else {
                            result.setStatusCode(409);
                            result.setCause("Failed to create directory");
                        }
                    }
                    if (pauseKey != null) {
                        this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
                    }
                }
                catch (Throwable throwable) {
                    if (pauseKey != null) {
                        this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
                    }
                    throw throwable;
                }
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return this.buildResponse(result);
    }

    @DELETE
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteDirectory(@PathParam(value="directorypath") String path) {
        return this.buildResponse(this.deleteDirectory(path, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse deleteDirectory(String path, boolean permanent) {
        ActionResponse response = new ActionResponse();
        if (this.validateSession()) {
            try {
                path = URL.cleanUpSourceParameter(path);
                if (!path.substring(1).contains("/")) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                if (path.startsWith("_trash") || path.startsWith("_downloads")) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                HttpSession session = this.getSession();
                SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(path, session);
                PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
                if (permissions == null || permanent && !permissions.write.delete.booleanValue() || !permanent && !permissions.write.moveToTrash.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                java.nio.file.Path sourceDir = this.relativePathStringToFile(path, connector);
                if (sourceDir != null) {
                    if (Files.isWritable(sourceDir) && path.contains("/")) {
                        if (!connector.isVirtualViewerConnector()) {
                            ScannerPauseReason spr = new ScannerPauseReason(path, ScannerPauseReason.ModificationType.DELETE);
                            String pauseKey = "PK4-" + path.hashCode();
                            this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
                            try {
                                this.getSourceManager().getConverterManager().cancelJobsByPrefix(path);
                                if (permanent) {
                                    this.getSourceManager().getDeleteDaemon().delete(sourceDir, path, connector);
                                } else {
                                    this.getSourceManager().getDeleteDaemon().moveToTrash(sourceDir, path, connector);
                                }
                                if (this.getSourceManager().getSettings().getSolrUpdater() != null) {
                                    this.getSourceManager().getSettings().getSolrUpdater().deleteAssetWithPrefixAsync(path + "/");
                                    this.getSourceManager().getSettings().getSolrUpdater().deleteAssetAsync(path);
                                }
                                response.setStatusCode(200);
                            }
                            catch (IOException e) {
                                response.setStatusCode(409);
                                response.setCause("Could not delete item");
                                response.setDetails("Could not delete file " + sourceDir);
                            }
                            catch (NotConfiguredException e) {
                                response.setStatusCode(503);
                            }
                            finally {
                                this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
                            }
                        }
                        try {
                            FileOperations.deleteDir(sourceDir);
                            this.clearRelatedPublishingSetsCache(path);
                            this.clearRelatedPublishingSetsCache(path.substring(0, path.lastIndexOf("/")));
                            response.setStatusCode(200);
                        }
                        catch (IOException e) {
                            this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
                            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                        }
                    }
                    response.setStatusCode(403);
                    response.setCause("Forbidden");
                }
                response.setStatusCode(409);
                response.setCause("Could not delete item");
                response.setDetails("full path for " + path + " is null");
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        } else {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return response;
    }

    @POST
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/xml", "application/json"})
    public Response post(@PathParam(value="directorypath") String source, @FormParam(value="cmd") String cmd, @FormParam(value="to") String to, @FormParam(value="reimport") String reimport, MultivaluedMap<String, String> formParams) {
        ActionResponse response = null;
        source = URL.cleanUpSourceParameter(source);
        try {
            if (cmd != null && cmd.equalsIgnoreCase("reimport") || reimport != null && (reimport.equalsIgnoreCase("true") || reimport.equals("1"))) {
                response = this.reimportDirectory(source, formParams);
            } else if (cmd != null && cmd.equalsIgnoreCase("copy")) {
                response = this.copyDirectory(source, to);
            } else if (cmd != null && cmd.equalsIgnoreCase("saveMetaData")) {
                formParams.remove((Object)"cmd");
                response = this.saveMetaData(source, formParams);
            } else if (cmd != null && cmd.equalsIgnoreCase("deleteMetaData")) {
                formParams.remove((Object)"cmd");
                response = this.deleteMetaData(source, formParams);
            } else if (cmd != null && cmd.equalsIgnoreCase("restoreMetaData")) {
                formParams.remove((Object)"cmd");
                response = this.restoreMetaData(source, formParams);
            } else if (cmd != null && cmd.equalsIgnoreCase("trash")) {
                formParams.remove((Object)"cmd");
                response = this.deleteDirectory(source, false);
            } else if (to != null) {
                response = this.moveDirectory(source, to);
            } else {
                response = new ActionResponse();
                response.setStatusCode(400);
                response.setCause("Unknown command.");
            }
        }
        catch (NotConfiguredException e) {
            response = new ActionResponse();
            response.setStatusCode(503);
            response.setCause("Server not configured.");
        }
        catch (CorruptStorageException e) {
            this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return this.buildResponse(response);
    }

    private ActionResponse reimportDirectory(String source, MultivaluedMap<String, String> formParams) {
        ActionResponse response;
        try {
            String options;
            boolean imageReimport = false;
            boolean metadataReimport = false;
            String string = options = formParams.containsKey((Object)"options") ? ((String)formParams.getFirst((Object)"options")).toLowerCase() : null;
            if (options == null || options.contains("image")) {
                imageReimport = true;
            }
            if (options != null && options.contains("metaData")) {
                metadataReimport = true;
            }
            HttpSession session = this.getSession();
            SourceManagerSettings settings = this.getSourceManagerSettings();
            SourceConnectorReader connector = settings.getSourceConnectorFromAssetURLPath(source, session);
            PermissionSet permissions = settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
            if (permissions == null || !permissions.tasks.reimportFiles.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            int count = this.recursiveReimport(connector, source, imageReimport, metadataReimport);
            response = new ActionResponse();
            response.setStatusCode(200);
            response.setDetails(String.valueOf(count));
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 113, count, source);
        }
        catch (NotConfiguredException | IOException e) {
            response = new ActionResponse();
            response.setStatusCode(503);
            response.setCause("Server not configured.");
        }
        return response;
    }

    private int recursiveReimport(SourceConnectorReader connector, String assetURLPath, boolean reimportImage, boolean clearMetadata) throws CorruptStorageException, NotConfiguredException, IOException {
        int count = 0;
        if (clearMetadata) {
            this.clearCustomMetadata(assetURLPath);
        }
        java.nio.file.Path orgDir = this.relativePathStringToFile(assetURLPath, connector);
        List<PathCached> list = FileOperations.listAllFiles(orgDir);
        for (PathCached f : list) {
            if (f.isDirectory()) {
                count += this.recursiveReimport(connector, assetURLPath + "/" + f.getFileName(), reimportImage, clearMetadata);
                continue;
            }
            int x = 0;
            if (reimportImage) {
                x += this.scheduleImageForReimport(connector, assetURLPath + "/" + f.getFileName());
            }
            if (clearMetadata) {
                x += this.clearCustomMetadata(assetURLPath);
            }
            if (x <= 0) continue;
            ++count;
        }
        return count;
    }

    private List<String> buildFileListForMove(String dirURLPath) throws NotConfiguredException {
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(dirURLPath, this.getSession());
        ArrayList<String> result = new ArrayList<String>();
        result.add(dirURLPath);
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
            this.buildFileListFromStorage(dirURLPath, result);
        } else {
            java.nio.file.Path sourceDir = this.relativePathStringToFile(dirURLPath, connector);
            try {
                this.buildFileListFromSources(dirURLPath, sourceDir, result);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private void buildFileListFromStorage(String dirURLPath, List<String> result) throws NotConfiguredException {
        java.nio.file.Path poolfromdirlist = this.getStorageHelperV1002().getDirectoryFile(dirURLPath);
        try {
            this.getSourceManager().getImageListFileWriter().forceClearingBuffer(dirURLPath);
            PoolList pl = this.getSourceManager().getImageListFileReader().getListFileContents(poolfromdirlist, dirURLPath);
            for (PoolEntry poolEntry : pl.getFilesAsCollection()) {
                result.add(dirURLPath + poolEntry.name);
            }
            for (String string : pl.getDirectoryNameSet()) {
                String subdirname = dirURLPath + string + "/";
                result.add(subdirname);
                this.buildFileListFromStorage(subdirname, result);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buildFileListFromSources(String prefix, java.nio.file.Path directory, List<String> result) throws IOException, NotConfiguredException {
        for (PathCached f : FileOperations.listAllFiles(directory)) {
            String name = f.getFileName();
            result.add(prefix + name);
            if (!f.isDirectory()) continue;
            this.buildFileListFromSources(prefix + name + "/", f.getPath(), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse moveDirectory(String from, String to) {
        ActionResponse result;
        block35: {
            if (!from.substring(1).contains("/") || !to.substring(1).contains("/")) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            result = new ActionResponse();
            if (!from.endsWith("/")) {
                from = from + "/";
            }
            if (!to.endsWith("/")) {
                to = to + "/";
            }
            try {
                HttpSession session = this.getSession();
                SourceManagerSettings settings = this.getSourceManagerSettings();
                SourceConnectorReader srcConnector = settings.getSourceConnectorFromAssetURLPath(from, session);
                SourceConnectorReader destConnector = settings.getSourceConnectorFromAssetURLPath(to, session);
                PermissionSet srcPermissions = settings.getUserAuthenticationInterface().getPermissions(srcConnector, session, true);
                PermissionSet destPermissions = settings.getUserAuthenticationInterface().getPermissions(destConnector, session, true);
                if (srcConnector == destConnector) {
                    if (srcPermissions == null || !srcPermissions.write.moveWithinConnector.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                } else {
                    if (!(srcPermissions != null && srcPermissions.read.copy.booleanValue() && srcPermissions.list.files.booleanValue() && srcPermissions.list.directories.booleanValue() && srcPermissions.write.delete.booleanValue())) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                    if (destPermissions == null || !destPermissions.write.paste.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }
                if (to.startsWith(from)) {
                    result.setStatusCode(409);
                    result.setCause("Failed to rename directory");
                    return result;
                }
                java.nio.file.Path orgfrom = this.relativePathStringToFile(from, srcConnector);
                if (orgfrom == null || Files.notExists(orgfrom, new LinkOption[0])) {
                    result.setStatusCode(404);
                    result.setCause("Source directory not found.");
                    return result;
                }
                java.nio.file.Path orgto = this.relativePathStringToFile(to, destConnector);
                if (orgto != null) {
                    if (!orgfrom.equals(orgto) && Files.notExists(orgto, new LinkOption[0])) {
                        String fromDir = from.substring(0, from.length() - 1);
                        ScannerPauseReason spr1 = new ScannerPauseReason(fromDir, ScannerPauseReason.ModificationType.DELETE);
                        String fromParent = from.substring(0, fromDir.lastIndexOf("/"));
                        ScannerPauseReason spr2 = new ScannerPauseReason(fromParent, ScannerPauseReason.ModificationType.DIRECTORY);
                        String toDir = to.substring(0, to.length() - 1);
                        String toParent = to.substring(0, toDir.lastIndexOf("/"));
                        if (!srcPermissions.write.rename.booleanValue() && fromParent.equals(toParent)) {
                            throw new WebApplicationException(Response.Status.FORBIDDEN);
                        }
                        List<String> originList = this.buildFileListForMove(from);
                        boolean sourcesMoved = false;
                        if (destConnector.isVirtualViewerConnector()) {
                            for (String assetURLPath : originList) {
                                if (assetURLPath.endsWith("/") || assetURLPath.endsWith(".xml") || assetURLPath.endsWith(".html")) continue;
                                result.setStatusCode(403);
                                result.setCause("Invalid File Type.");
                                return result;
                            }
                        }
                        ScannerPauseReason spr3 = new ScannerPauseReason(toParent, ScannerPauseReason.ModificationType.DIRECTORY);
                        String pauseKey = "PK5-" + fromDir.hashCode();
                        try {
                            this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr1, spr2, spr3);
                            if (Files.notExists(orgto.getParent(), new LinkOption[0])) {
                                Files.createDirectories(orgto.getParent(), new FileAttribute[0]);
                            }
                            Files.move(orgfrom, orgto, new CopyOption[0]);
                            this.getSourceManagerSettings().getFSILogger().log(3172, from, to);
                            sourcesMoved = true;
                            if (sourcesMoved) {
                                for (String originAssetURLPath : originList) {
                                    String relativePath = originAssetURLPath.substring(from.length());
                                    String targetAssetURLPath = to + relativePath;
                                    java.nio.file.Path targetFile = this.relativePathStringToFile(targetAssetURLPath, destConnector);
                                    if (Files.isRegularFile(targetFile, new LinkOption[0])) {
                                        if (srcConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE && destConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                                            this.moveStorageFile(originAssetURLPath, targetAssetURLPath, srcConnector, destConnector, false);
                                        } else if (srcConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE && destConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGE) {
                                            this.removeStorageFile(originAssetURLPath, srcConnector);
                                        }
                                    } else if (Files.isDirectory(targetFile, new LinkOption[0])) {
                                        if (srcConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGE && destConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                                            DirectoryImportJob job = new DirectoryImportJob(destConnector, targetFile, targetAssetURLPath, FileOperations.getSafeLastModified(targetFile), false, false);
                                            this.getSourceManager().getScannerDaemon().manuallySubmitDirectory(job);
                                        }
                                        java.nio.file.Path poolfromdirlist = this.getStorageHelperV1002().getDirectoryFile(originAssetURLPath);
                                        java.nio.file.Path pooltodirlist = this.getStorageHelperV1002().getDirectoryFile(targetAssetURLPath);
                                        this.getSourceManagerSettings().getStorageManager().moveStorageFile(poolfromdirlist, originAssetURLPath, pooltodirlist, targetAssetURLPath);
                                    }
                                    this.moveCustomMetadata(originAssetURLPath, targetAssetURLPath);
                                    this.moveSearchDatabaseContents(srcConnector, originAssetURLPath, destConnector, targetAssetURLPath);
                                }
                                if (!srcConnector.isVirtualViewerConnector()) {
                                    String fromparentrelpath = from.substring(0, from.lastIndexOf("/", from.length() - 2));
                                    java.nio.file.Path fromdirlistfile = this.getStorageHelperV1002().getDirectoryFile(fromparentrelpath);
                                    String parentAssetURLPath = URL.getParentAssetURLPath(fromparentrelpath);
                                    java.nio.file.Path parentdirlistfile = this.getStorageHelperV1002().getDirectoryFile(parentAssetURLPath);
                                    this.getSourceManager().getImageListFileWriter().forceClearingBuffer(fromparentrelpath);
                                    this.getSourceManager().getImageListFileWriter().removeEntry(fromdirlistfile, fromparentrelpath, parentdirlistfile, parentAssetURLPath, orgfrom.getFileName().toString(), FileOperations.getSafeLastModified(orgfrom.getParent()));
                                }
                                if (!destConnector.isVirtualViewerConnector()) {
                                    Pair<Long, Long> dirstats = FileOperations.countDirFiles(orgto);
                                    PoolDirectoryEntry newPoolDirEntry = new PoolDirectoryEntry(orgto.getFileName().toString(), FileOperations.getSafeLastModified(orgto), dirstats.getItem2(), dirstats.getItem1());
                                    String toparentrelpath = to.substring(0, to.lastIndexOf("/", to.length() - 2));
                                    java.nio.file.Path todirlistfile = this.getStorageHelperV1002().getDirectoryFile(toparentrelpath);
                                    PoolDirectoryEntry pe = new PoolDirectoryEntry(orgto.getFileName().toString(), FileOperations.getSafeLastModified(orgto), newPoolDirEntry.files, newPoolDirEntry.subdirectories);
                                    ArrayList<PoolEntry> tmp = new ArrayList<PoolEntry>();
                                    tmp.add(pe);
                                    String toParentAssetURLPath = URL.getParentAssetURLPath(toparentrelpath);
                                    java.nio.file.Path parentDirlistFile = this.getStorageHelperV1002().getDirectoryFile(toParentAssetURLPath);
                                    this.getSourceManager().getImageListFileWriter().updateEntries(todirlistfile, toparentrelpath, parentDirlistFile, toParentAssetURLPath, tmp, FileOperations.getSafeLastModified(orgto.getParent()));
                                    this.getSourceManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(toparentrelpath, false);
                                }
                                result.setStatusCode(200);
                            }
                            break block35;
                        }
                        catch (IOException e) {
                            this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
                            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                        }
                        catch (NotConfiguredException e) {
                            result.setStatusCode(503);
                            result.setCause("Storage not configured correctly");
                            break block35;
                        }
                        finally {
                            this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
                        }
                    }
                    this.getSourceManagerSettings().getFSILogger().log(3173, from, to);
                    result.setStatusCode(409);
                    result.setCause("Failed to rename directory");
                    break block35;
                }
                result.setStatusCode(409);
                result.setCause("Failed to rename directory");
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return result;
    }
}

