/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.service.AbstractImageService;
import com.neptunelabs.fsiserver.service.utils.FileUploadListener;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashList;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Image;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

@Path(value="{prefix:image|file}")
public final class FileService
extends AbstractImageService
implements Serializable {
    private static final long serialVersionUID = -4705969088032646226L;
    private static final MediaType APPLICATION_ZIP = new MediaType("application", "zip");
    private static final MediaType APPLICATION_X_ZIP_COMPRESSED = new MediaType("application", "x-zip-compressed");
    private static final MediaType APPLICATION_X_ZIP = new MediaType("application", "x-zip");

    @GET
    @Path(value="/{filepath:.+?}/")
    @Produces(value={"*/*"})
    public Response getFile(@PathParam(value="filepath") String path, @QueryParam(value="info") String infoRequestParam) {
        String assetURLPath = URL.cleanUpSourceParameter(path);
        try {
            HttpSession session = this.getSession();
            SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
            PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
            if (this.checkIfInfoRequest(infoRequestParam)) {
                if (ps == null || !ps.read.basicMetadata.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                java.nio.file.Path imageSourceFile = this.relativePathStringToFile(assetURLPath, connector);
                return this.buildInfoResponse(assetURLPath, imageSourceFile);
            }
            if (ps == null || !ps.read.downloadSource.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (assetURLPath.startsWith("_downloads")) {
                return this.buildDownloadFileResponse(assetURLPath);
            }
            java.nio.file.Path imageSourceFile = this.relativePathStringToFile(assetURLPath, connector);
            return this.buildFileResponse(assetURLPath, imageSourceFile);
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Path(value="/{imagepath:.+?}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response post(@PathParam(value="imagepath") String source, @FormParam(value="to") String to, @FormParam(value="cmd") String cmd, @FormParam(value="force") String force, @FormParam(value="reimport") String reimport, @FormParam(value="overwrite") String overwrite, MultivaluedMap<String, String> formParams) {
        ActionResponse response;
        String assetURLPath = URL.cleanUpSourceParameter(source);
        if (cmd != null && cmd.equalsIgnoreCase("reimport") || reimport != null && (reimport.equalsIgnoreCase("true") || reimport.equals("1"))) {
            response = this.reimportFile(assetURLPath, formParams);
        } else if (cmd != null) {
            try {
                if (cmd.equalsIgnoreCase("restore")) {
                    boolean forceEnabled = force != null && (force.equalsIgnoreCase("true") || force.equals("1"));
                    response = this.restoreFromTrash(assetURLPath, forceEnabled);
                }
                if (cmd.equalsIgnoreCase("copy")) {
                    to = URL.cleanUpSourceParameter(to);
                    boolean overwriteEnabled = overwrite != null && (overwrite.equalsIgnoreCase("true") || overwrite.equals("1"));
                    response = this.moveOrCopyFile(assetURLPath, to, false, overwriteEnabled);
                }
                if (cmd.equalsIgnoreCase("saveMetaData")) {
                    formParams.remove((Object)"cmd");
                    response = this.saveMetaData(assetURLPath, formParams);
                }
                if (cmd.equalsIgnoreCase("deleteMetaData")) {
                    formParams.remove((Object)"cmd");
                    response = this.deleteMetaData(assetURLPath, formParams);
                }
                if (cmd.equalsIgnoreCase("restoreMetaData")) {
                    formParams.remove((Object)"cmd");
                    response = this.restoreMetaData(assetURLPath, formParams);
                }
                if (cmd.equalsIgnoreCase("trash")) {
                    formParams.remove((Object)"cmd");
                    if (assetURLPath.startsWith("_trash")) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                    if (assetURLPath.startsWith("_downloads")) {
                        response = this.handleDownloadsDeleteRequest(assetURLPath, false);
                    }
                    response = this.handleNormalDeleteFileRequest(assetURLPath, false);
                }
                if (to != null) {
                    to = URL.cleanUpSourceParameter(to);
                    boolean overwriteEnabled = overwrite != null && (overwrite.equalsIgnoreCase("true") || overwrite.equals("1"));
                    response = this.moveOrCopyFile(assetURLPath, to, true, overwriteEnabled);
                }
                response = new ActionResponse();
                response.setStatusCode(400);
                response.setCause("Unknown command.");
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
            catch (CorruptStorageException e) {
                this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        } else {
            response = new ActionResponse();
            response.setStatusCode(400);
            response.setCause("Unknown command.");
        }
        return this.buildResponse(response);
    }

    @DELETE
    @Path(value="/{filepath:.+?}")
    public Response deleteFile(@PathParam(value="filepath") String assetURLPath) {
        ActionResponse response;
        String cleanImagePath = URL.cleanUpSourceParameter(assetURLPath);
        try {
            response = cleanImagePath.startsWith("_trash") ? this.handleTrashDeleteRequest(cleanImagePath) : (cleanImagePath.startsWith("_downloads") ? this.handleDownloadsDeleteRequest(cleanImagePath, true) : this.handleNormalDeleteFileRequest(cleanImagePath, true));
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return this.buildResponse(response);
    }

    private Response uploadAsset(Image image, @PathParam(value="imagepath") String assetURLPath, SourceConnectorReader targetConnector) {
        ActionResponse response;
        if (!this.validateSession()) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, assetURLPath, "Not authorized");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String cleanImagePath = URL.cleanUpSourceParameter(assetURLPath);
        java.nio.file.Path tmpFile = this.getSourceManagerSettings().getWorkDirectory().resolve(image.hashCode() + "_" + System.currentTimeMillis());
        String uploadedFileSize = "unknown";
        try {
            FileOperations.writeFile(tmpFile, image.getData());
            uploadedFileSize = String.valueOf(Files.size(tmpFile));
            response = this.handleUpload(cleanImagePath, targetConnector, image.getLastModified(), tmpFile);
        }
        catch (IOException e) {
            response = this.determineUploadErrorCause(image.getFileSize(), tmpFile);
        }
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 110, assetURLPath, uploadedFileSize);
        } else {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, assetURLPath, response.getDetails());
        }
        return this.buildResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/{imagepath:.+?}")
    @Consumes(value={"*/*"})
    public Response uploadFileRaw(@Context HttpHeaders headers, @PathParam(value="imagepath") String assetURLPath, InputStream messagebody) {
        if (!this.validateSession()) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, assetURLPath, "Not authorized");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String targetPath = URL.cleanUpSourceParameter(assetURLPath);
        ActionResponse response = null;
        MediaType mimeType = headers.getMediaType();
        java.nio.file.Path tmpFile = null;
        java.nio.file.Path tmpzipFile = null;
        String uploadedFileSize = "unknown";
        try {
            ImageFormatScanner ifs;
            FileUploadListener fileUploadListener;
            HttpSession session2333332 = this.getSession();
            SourceConnectorReader targetConnector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(targetPath, session2333332);
            PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(targetConnector, session2333332, true);
            java.nio.file.Path targetFile = this.relativePathStringToFile(targetPath, targetConnector);
            if (Files.exists(targetFile, new LinkOption[0])) {
                if (permissions.write.overwrite == false) throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (Files.notExists(targetFile, new LinkOption[0]) && !permissions.write.upload.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (targetConnector.isVirtualViewerConnector() && !targetPath.endsWith(".xml") && !targetPath.endsWith(".html")) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
            tmpFile = this.getSourceManagerSettings().getWorkDirectory().resolve(random.nextLong() + "_" + System.currentTimeMillis());
            boolean messageDataSaved = false;
            if (mimeType.isCompatible(MediaType.APPLICATION_JSON_TYPE) || mimeType.equals((Object)MediaType.APPLICATION_XML_TYPE) || mimeType.equals((Object)MediaType.TEXT_XML_TYPE)) {
                byte[] content;
                block39: {
                    fileUploadListener = this.createFileUploadListener(headers);
                    this.registerFileUploadListener(targetPath, fileUploadListener);
                    content = this.saveStreamToByteArrayAndIncrementUploadListener(messagebody, fileUploadListener);
                    Image i = (Image)JAXB.unmarshal((InputStream)new ByteArrayInputStream(content), Image.class);
                    if (i == null || i.getData() == null || i.getData().length <= 0) break block39;
                    Response response2 = this.uploadAsset(i, targetPath, targetConnector);
                    try {
                        if (tmpFile != null) {
                            Files.deleteIfExists(tmpFile);
                        }
                        if (tmpzipFile != null) {
                            Files.deleteIfExists(tmpzipFile);
                        }
                        messagebody.close();
                        return response2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return response2;
                }
                try {
                    FileOperations.writeFile(tmpFile, content);
                    messageDataSaved = true;
                }
                catch (DataBindingException e) {
                    FileOperations.writeFile(tmpFile, content);
                    messageDataSaved = true;
                }
            }
            if (targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI ? !(ifs = ImageFormatScanner.getInstance()).hasMimeMapping(mimeType.toString()) && !this.isZip(mimeType) : targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION && !mimeType.isCompatible(new MediaType("image", "tiff")) && !mimeType.isCompatible(new MediaType("image", "fpx")) && !this.isZip(mimeType)) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
            if (!messageDataSaved) {
                fileUploadListener = this.createFileUploadListener(headers);
                this.registerFileUploadListener(targetPath, fileUploadListener);
                this.saveStreamToFileAndIncrementUploadListener(tmpFile, messagebody, fileUploadListener);
            }
            uploadedFileSize = String.valueOf(Files.size(tmpFile));
            List lmList = headers.getRequestHeader("Last-Modified");
            long lm = -1L;
            if (lmList != null) {
                try {
                    lm = Long.parseLong((String)lmList.get(0));
                }
                catch (NumberFormatException e) {
                    lm = -1L;
                }
            }
            if (lm == -1L) {
                lm = System.currentTimeMillis();
            }
            if (targetConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC && this.isZip(mimeType)) {
                tmpzipFile = tmpFile.resolveSibling(tmpFile.getFileName().toString() + ".zip");
                FileOperations.move(tmpFile, tmpzipFile);
                String dir = "";
                if (targetPath.endsWith("/") && targetPath.length() > 1) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                dir = targetPath.substring(0, targetPath.lastIndexOf("/"));
                response = this.handleZipUpload(dir, targetConnector, tmpzipFile);
            } else {
                response = this.handleUpload(targetPath, targetConnector, lm, tmpFile);
            }
            try {
                if (tmpFile != null) {
                    Files.deleteIfExists(tmpFile);
                }
                if (tmpzipFile != null) {
                    Files.deleteIfExists(tmpzipFile);
                }
                messagebody.close();
            }
            catch (IOException session2333332) {}
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            catch (IOException e2) {
                response = this.determineUploadErrorCause(0L, tmpFile);
            }
        }
        finally {
            try {
                if (tmpFile != null) {
                    Files.deleteIfExists(tmpFile);
                }
                if (tmpzipFile != null) {
                    Files.deleteIfExists(tmpzipFile);
                }
                messagebody.close();
            }
            catch (IOException iOException) {}
        }
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, targetPath, response.getDetails());
            return this.buildResponse(response);
        }
        this.getAPILogger().logAccess(this.getHost(), this.getUser(), 110, targetPath, uploadedFileSize);
        return this.buildResponse(response);
    }

    private Response buildDownloadFileResponse(String assetURLPath) {
        String[] parts = assetURLPath.split("/");
        if (parts[0].equals("_downloads")) {
            try {
                java.nio.file.Path downloadsFolder = this.getStorageHelperV1002().getDownloadsFolder();
                java.nio.file.Path jobFile = downloadsFolder.resolve(parts[1] + ".job");
                DownloadJob job = DownloadJob.createFromFile(jobFile);
                java.nio.file.Path downloadFile = downloadsFolder.resolve(parts[1] + ".download");
                if (job != null && Files.exists(downloadFile, new LinkOption[0])) {
                    Response.ResponseBuilder rb = Response.ok();
                    rb.header("Content-disposition", (Object)("attachment; filename=\"" + job.getName() + "\""));
                    rb.header("Content-length", (Object)job.getArchiveSize());
                    rb.type("application/force-download");
                    rb.lastModified(new Date(job.getLastModified()));
                    rb.entity((Object)Files.newInputStream(downloadFile, new OpenOption[0]));
                    return rb.build();
                }
                throw new WebApplicationException(404);
            }
            catch (NotConfiguredException e) {
                throw new WebApplicationException(503);
            }
            catch (IOException e) {
                throw new WebApplicationException(500);
            }
        }
        throw new WebApplicationException(404);
    }

    private ActionResponse handleDownloadsDeleteRequest(String assetURLPath, boolean permanent) {
        ActionResponse response;
        block8: {
            response = new ActionResponse();
            String[] parts = assetURLPath.split("/");
            if ("_downloads".equals(parts[0])) {
                try {
                    java.nio.file.Path downloadsFolder = this.getStorageHelperV1002().getDownloadsFolder();
                    java.nio.file.Path jobFile = downloadsFolder.resolve(parts[1] + ".job");
                    try {
                        DownloadJob job = DownloadJob.createFromFile(jobFile);
                        boolean permitted = false;
                        Set<String> jobgroups = job.getGroups();
                        Set<String> userGroups = this.getUserGroups();
                        jobgroups.retainAll(userGroups);
                        if (jobgroups.size() > 0) {
                            permitted = true;
                        }
                        if (permitted) {
                            java.nio.file.Path downloadFile = downloadsFolder.resolve(parts[1] + ".download");
                            Files.deleteIfExists(jobFile);
                            Files.deleteIfExists(downloadFile);
                            response.setStatusCode(200);
                            break block8;
                        }
                        response.setStatusCode(403);
                    }
                    catch (NoSuchFileException e) {
                        response.setStatusCode(404);
                    }
                    catch (IOException e) {
                        response.setStatusCode(500);
                    }
                }
                catch (NotConfiguredException e) {
                    throw new WebApplicationException(503);
                }
            }
        }
        return response;
    }

    private ActionResponse handleTrashDeleteRequest(String trashPath) throws NotConfiguredException {
        ActionResponse response;
        block5: {
            response = new ActionResponse();
            trashPath = trashPath.substring(7);
            String connectorName = trashPath.substring(0, trashPath.indexOf("/"));
            HttpSession session = this.getSession();
            SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(connectorName, session);
            PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
            if (ps.write.delete.booleanValue()) {
                try {
                    java.nio.file.Path trashFolder = this.getStorageHelperV1002().getTrashFolder(connector);
                    TrashList trashList = TrashList.getInstance(trashFolder.resolve(".trashlist"));
                    String trashID = trashPath.substring(connectorName.length() + 1);
                    if (trashList.removeEntry(trashID)) {
                        java.nio.file.Path sourceFile = trashFolder.resolve(trashID + ".src");
                        Files.deleteIfExists(sourceFile);
                        java.nio.file.Path eisFile = trashFolder.resolve(trashID + ".eis");
                        Files.deleteIfExists(eisFile);
                        java.nio.file.Path metaFile = trashFolder.resolve(trashID + ".meta");
                        Files.deleteIfExists(metaFile);
                        response.setStatusCode(200);
                        break block5;
                    }
                    response.setStatusCode(500);
                    response.setCause("Error removing entry from trash");
                }
                catch (NotConfiguredException | IOException e) {
                    response.setStatusCode(503);
                    response.setCause("Storage Not Configured");
                }
            } else {
                response.setStatusCode(403);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse handleNormalDeleteFileRequest(String assetURLPath, boolean permanent) throws NotConfiguredException {
        HttpSession session = this.getSession();
        SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
        PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
        if (ps == null || permanent && !ps.write.delete.booleanValue() || !permanent && !ps.write.moveToTrash.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ActionResponse response = new ActionResponse();
        java.nio.file.Path sourceFile = this.relativePathStringToFile(assetURLPath, connector);
        if (!Files.isRegularFile(sourceFile, new LinkOption[0])) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 118, assetURLPath);
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!Files.isWritable(sourceFile)) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 116, assetURLPath);
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String pauseKey = "PK1-" + assetURLPath.hashCode();
        ScannerPauseReason spr = new ScannerPauseReason(assetURLPath.substring(0, assetURLPath.lastIndexOf("/")), ScannerPauseReason.ModificationType.FILE);
        try {
            this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
            this.cancelConverterJob(assetURLPath, this.getSession());
            try {
                if (permanent) {
                    this.getSourceManager().getDeleteDaemon().delete(sourceFile, assetURLPath, connector);
                } else {
                    this.getSourceManager().getDeleteDaemon().moveToTrash(sourceFile, assetURLPath, connector);
                }
                response.setStatusCode(200);
            }
            catch (CorruptReverseLookupException e) {
                this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
            }
            catch (IOException e) {
                String msg = e.getLocalizedMessage();
                if (msg.contains("403")) {
                    response.setStatusCode(403);
                } else {
                    response.setStatusCode(409);
                }
                e.printStackTrace();
                response.setCause("Could not delete item");
                response.setDetails(msg + " " + sourceFile);
            }
            catch (NotConfiguredException e) {
                response.setStatusCode(503);
            }
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 115, assetURLPath);
        }
        finally {
            this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
        }
        return response;
    }

    private boolean checkIfInfoRequest(String infoRequestParam) {
        boolean isInfoRequest = false;
        if (infoRequestParam == null) {
            String accept = this.request.getHeader("Accept");
            if (accept != null && !accept.contains("*/*") && !accept.contains("image/")) {
                isInfoRequest = true;
            }
        } else {
            isInfoRequest = Boolean.parseBoolean(infoRequestParam);
        }
        return isInfoRequest;
    }

    private Response buildFileResponse(String assetURLPath, java.nio.file.Path imageSourceFile) {
        long lastmodified = 0L;
        this.getSourceManagerSettings().getFSILogger().log(3165, assetURLPath);
        InputStream result = null;
        if (imageSourceFile != null && Files.exists(imageSourceFile, new LinkOption[0])) {
            try {
                result = Files.newInputStream(imageSourceFile, new OpenOption[0]);
                lastmodified = FileOperations.getSafeLastModified(imageSourceFile);
                this.getAPILogger().logAccess(this.getHost(), this.getUser(), 130, assetURLPath, Files.size(imageSourceFile));
            }
            catch (IOException e) {
                this.getAPILogger().logAccess(this.getHost(), this.getUser(), 131, assetURLPath);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        } else {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 131, assetURLPath);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Response.ResponseBuilder rb = Response.ok();
        rb.header("Content-disposition", (Object)("attachment; filename=\"" + imageSourceFile.getFileName().toString() + "\""));
        try {
            rb.header("Content-length", (Object)Files.size(imageSourceFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rb.type("application/force-download");
        rb.lastModified(new Date(lastmodified));
        rb.entity((Object)result);
        return rb.build();
    }

    private Response buildInfoResponse(String imagepath, java.nio.file.Path imageSourceFile) {
        if (imageSourceFile != null && Files.exists(imageSourceFile, new LinkOption[0])) {
            Image i = new Image();
            i.setTargetPath(imagepath);
            try {
                i.setFileSize(Files.size(imageSourceFile));
                i.setLastModified(FileOperations.getSafeLastModified(imageSourceFile));
                return Response.ok((Object)i).build();
            }
            catch (IOException e) {
                return Response.status((int)500).build();
            }
        }
        return Response.status((int)404).build();
    }

    private boolean isZip(MediaType mimeType) {
        return mimeType.isCompatible(APPLICATION_ZIP) || mimeType.isCompatible(APPLICATION_X_ZIP_COMPRESSED) || mimeType.isCompatible(APPLICATION_X_ZIP);
    }

    private void registerFileUploadListener(String targetPath, FileUploadListener fileUploadListener) {
        HashMap<String, FileUploadListener> listeners;
        Object attr = this.getSession().getAttribute("uploadlisteners");
        if (attr != null) {
            listeners = (HashMap<String, FileUploadListener>)attr;
        } else {
            listeners = new HashMap<String, FileUploadListener>();
            this.getSession().setAttribute("uploadlisteners", listeners);
        }
        listeners.put(targetPath, fileUploadListener);
    }

    private FileUploadListener createFileUploadListener(HttpHeaders headers) {
        List lengthHeaders = headers.getRequestHeader("Content-Length");
        FileUploadListener fileUploadListener = lengthHeaders.size() > 0 ? new FileUploadListener(Long.parseLong((String)lengthHeaders.get(0))) : new FileUploadListener();
        return fileUploadListener;
    }

    private byte[] saveStreamToByteArrayAndIncrementUploadListener(InputStream stream, FileUploadListener listener) throws IOException {
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast();){
            int len;
            byte[] buf = new byte[1024];
            long saved = 0L;
            while ((len = stream.read(buf)) > 0) {
                baos.write(buf, 0, len);
                listener.update(saved += (long)len);
            }
            stream.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStreamToFileAndIncrementUploadListener(java.nio.file.Path targetFile, InputStream stream, FileUploadListener listener) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
            int len;
            byte[] buf = new byte[1024];
            long saved = 0L;
            while ((len = stream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                listener.update(saved += (long)len);
            }
        }
        finally {
            stream.close();
        }
    }

    private ActionResponse determineUploadErrorCause(long uploadedFileSize, java.nio.file.Path tmpFile) {
        ActionResponse response = new ActionResponse();
        boolean canwrite = Files.isWritable(tmpFile.getParent());
        if (canwrite) {
            if (FileOperations.getUsableSpace(tmpFile) < uploadedFileSize) {
                response.setStatusCode(413);
                response.setCause("Not enough space left on device");
            }
        } else {
            response.setStatusCode(403);
            response.setCause("You are not allowed to upload files to this directory.");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse restoreFromTrash(String assetURLPath, boolean force) throws NotConfiguredException, CorruptStorageException {
        if (!assetURLPath.startsWith("_trash")) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        HttpSession session = this.getSession();
        PermissionSet trashPermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions("_trash", session, true);
        if (trashPermissions == null || !trashPermissions.read.files.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        assetURLPath = assetURLPath.substring(7);
        int slashIndex = assetURLPath.indexOf("/");
        String profilename = assetURLPath.substring(0, slashIndex);
        String trashHash = assetURLPath.substring(slashIndex + 1);
        SourceConnectorReader originConnector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(profilename, session);
        PermissionSet originPermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(originConnector, session, true);
        if (originPermissions == null || !originPermissions.write.paste.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (originConnector == null) {
            ActionResponse response = new ActionResponse();
            response.setStatusCode(409);
            response.setCause("Connector no longer available.");
            return response;
        }
        try {
            java.nio.file.Path profileTrashFolder = this.getStorageHelperV1002().getTrashFolder(originConnector);
            String restorePath = this.getSourceManager().getDeleteDaemon().getRestorationPath(profileTrashFolder, trashHash);
            java.nio.file.Path originFile = this.relativePathStringToFile(restorePath, originConnector);
            if (Files.exists(originFile, new LinkOption[0]) && !originPermissions.write.overwrite.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (Files.exists(originFile, new LinkOption[0]) && !force) {
                ActionResponse response = new ActionResponse();
                response.setStatusCode(409);
                response.setCause("Restoration target exists.");
                return response;
            }
            String pauseKey = "PK1-" + restorePath.hashCode();
            ScannerPauseReason spr = new ScannerPauseReason(restorePath.substring(0, restorePath.lastIndexOf("/")), ScannerPauseReason.ModificationType.FILE);
            try {
                this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, spr);
                this.cancelConverterJob(restorePath, this.getSession());
                this.getSourceManager().getDeleteDaemon().restoreFileFromTrash(profileTrashFolder, trashHash, originConnector, originFile);
            }
            finally {
                this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
            }
            ActionResponse response = new ActionResponse();
            response.setStatusCode(200);
            return response;
        }
        catch (NoSuchFileException e) {
            e.printStackTrace();
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (NotConfiguredException | IOException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private ActionResponse reimportFile(String assetURLPath, MultivaluedMap<String, String> formParams) {
        ActionResponse response = new ActionResponse();
        try {
            int imagesScheduled;
            String options;
            HttpSession session = this.getSession();
            SourceConnectorReader connector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(assetURLPath, session);
            PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(connector, session, true);
            String string = options = formParams.containsKey((Object)"options") ? ((String)formParams.getFirst((Object)"options")).toLowerCase() : null;
            if (options == null || options.contains("image")) {
                if (ps == null || !ps.tasks.reimportFiles.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                imagesScheduled = this.scheduleImageForReimport(connector, assetURLPath);
                response.setStatusCode(200);
                response.setDetails(String.valueOf(imagesScheduled));
                this.getAPILogger().logAccess(this.getHost(), this.getUser(), 112, assetURLPath);
            }
            if (options != null && options.contains("metadata")) {
                if (ps == null || !ps.write.extendedMetadata.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                imagesScheduled = this.clearCustomMetadata(assetURLPath);
                response.setStatusCode(200);
                response.setDetails(String.valueOf(imagesScheduled));
                this.getAPILogger().logAccess(this.getHost(), this.getUser(), 112, assetURLPath);
            }
        }
        catch (IOException e) {
            this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
            response.setStatusCode(503);
            response.setCause("Storage corrupted.");
        }
        catch (NotConfiguredException e) {
            response.setStatusCode(503);
            response.setCause("Server not configured.");
        }
        return response;
    }

    private boolean isRenameRequest(String path1, String path2) {
        String dir1 = path1.substring(0, path1.lastIndexOf(47));
        String dir2 = path1.substring(0, path2.lastIndexOf(47));
        return dir1.equals(dir2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse moveOrCopyFile(String source, String to, boolean move, boolean overwrite) {
        HttpSession session = this.getSession();
        ActionResponse response = new ActionResponse();
        String pauseKey = "PK2-" + source.hashCode();
        try {
            SourceConnectorReader sourceConnector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(source, session);
            PermissionSet sourcePermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(sourceConnector, session, true);
            SourceConnectorReader targetConnector = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(to, session);
            PermissionSet targetPermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(targetConnector, session, true);
            if (sourcePermissions == null || targetPermissions == null) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (source.equals(to)) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            if (move) {
                if (!(sourceConnector == targetConnector || sourcePermissions.read.copy.booleanValue() && sourcePermissions.write.delete.booleanValue() && targetPermissions.write.paste.booleanValue())) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                if (sourceConnector == targetConnector) {
                    if (this.isRenameRequest(source, to) && !sourcePermissions.write.rename.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                    if (!sourcePermissions.write.moveWithinConnector.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }
            } else if (!sourcePermissions.read.copy.booleanValue() || !targetPermissions.write.paste.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (overwrite && !targetPermissions.write.overwrite.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (targetConnector.getMountType() != SourceConnectorReader.SourceConnectorType.STATIC) {
                java.nio.file.Path targetFile = this.relativePathStringToFile(to, targetConnector);
                PathCached fileProps = new PathCached(targetFile);
                ImageFormatScanner ifs = ImageFormatScanner.getInstance();
                ImageFormat format = ifs.scanFile(fileProps);
                if (format.type == ImageFormat.Type.UNK || format.type != ImageFormat.Type.TIF && format.type != ImageFormat.Type.FPX && targetConnector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
                    response.setStatusCode(415);
                    response.setCause("Unsupported filetype or broken image");
                    ActionResponse actionResponse = response;
                    return actionResponse;
                }
            } else if (targetConnector.isVirtualViewerConnector() && !to.endsWith(".xml") && !to.endsWith(".html")) {
                response.setStatusCode(415);
                response.setCause("Unsupported filetype.");
                ActionResponse targetFile = response;
                return targetFile;
            }
            String sourceDir = source.substring(0, source.lastIndexOf("/"));
            ScannerPauseReason r1 = new ScannerPauseReason(sourceDir, ScannerPauseReason.ModificationType.FILE);
            String destDir = to.substring(0, to.lastIndexOf("/"));
            ScannerPauseReason r2 = new ScannerPauseReason(destDir, ScannerPauseReason.ModificationType.FILE);
            this.getSourceManager().getScannerDaemon().pauseScanner(pauseKey, r1, r2);
            if (move) {
                if (!source.startsWith("_download")) {
                    this.cancelConverterJob(source, this.getSession());
                }
                if (this.moveFile(source, to, sourceConnector, targetConnector, true, overwrite)) {
                    response.setStatusCode(200);
                } else {
                    response.setStatusCode(409);
                    response.setCause("Could not move item");
                }
            } else if (this.copyFileUnconditional(source, to, sourceConnector, targetConnector, overwrite)) {
                response.setStatusCode(200);
            } else {
                response.setStatusCode(409);
                response.setCause("Could not copy item");
            }
        }
        catch (NotConfiguredException e) {
            response.setStatusCode(503);
            response.setCause("Server not configured.");
        }
        catch (CorruptStorageException e) {
            this.getSourceManager().getScannerDaemon().reportStorageCorruption(e);
            response.setStatusCode(503);
            response.setCause("Corrupt storage.");
        }
        finally {
            this.getSourceManager().getScannerDaemon().resumeScanner(pauseKey);
        }
        if (response.getStatusCode() == 200) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 120, source, to);
        } else {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 121, source, to);
        }
        return response;
    }
}

