/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.service.AbstractImageService;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="{prefix:icc}")
public final class ICCService
extends AbstractImageService
implements Serializable {
    private static final long serialVersionUID = -9152917183661928786L;

    @GET
    @Path(value="/{filepath:.+?}/")
    @Produces(value={"*/*"})
    public Response getICC(@PathParam(value="filepath") String assetURLPath) {
        try {
            HttpSession session = this.getSession();
            SourceManagerSettings settings = this.getSourceManagerSettings();
            SourceConnectorReader connector = settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
            PermissionSet ps = settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
            if (ps == null || !ps.read.iccProfiles.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            ImageBuilder imageBuilder = new ImageBuilder(settings, null, null, settings.getStorageLocation());
            assetURLPath = URL.cleanUpSourceParameter(assetURLPath);
            java.nio.file.Path imageSourceFile = this.relativePathStringToFile(assetURLPath, connector);
            MetaData md = imageBuilder.getImageMetaData(connector, assetURLPath, 2, true, session);
            if (md != null && md instanceof ImageMetaData) {
                ImageMetaData imd = (ImageMetaData)md;
                byte[] iccBytes = null;
                ICCProfileWrap ipw = imd.getICC();
                if (ipw != null) {
                    iccBytes = ipw.getBytes();
                }
                if (iccBytes != null && iccBytes.length > 0 && ipw != null) {
                    String filename = ipw.getName();
                    if (filename == null || filename.equals("")) {
                        String[] filenamePair = FileOperations.splitFilename(imageSourceFile.getFileName().toString());
                        filename = filenamePair[0];
                    }
                    Response.ResponseBuilder rb = Response.ok();
                    rb.header("Content-disposition", (Object)("attachment; filename=\"" + filename + ".icc\""));
                    rb.header("Content-length", (Object)iccBytes.length);
                    rb.type("application/force-download");
                    rb.lastModified(new Date(imd.getLastModified()));
                    rb.entity((Object)new ByteArrayInputStream(iccBytes));
                    return rb.build();
                }
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(503);
        }
        catch (NoSuchFileException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

