/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.service.AbstractImageService;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="{prefix:jobqueue}")
public final class JobQueueService
extends AbstractImageService
implements Serializable {
    private static final long serialVersionUID = -7027361946341987970L;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createJob(MultivaluedMap<String, String> formParams) {
        String cmd = (String)formParams.getFirst((Object)"cmd");
        formParams.remove((Object)"cmd");
        if (cmd.equalsIgnoreCase("createAndStart")) {
            this.checkPermissionsForNewJob(formParams);
            return this.buildResponse(this.createAndStartJob(formParams));
        }
        if (cmd.equalsIgnoreCase("cancel")) {
            ActionResponse response = this.cancelJob((String)formParams.getFirst((Object)"id"));
            return this.buildResponse(response);
        }
        if (cmd.equalsIgnoreCase("restart")) {
            ActionResponse response = this.restartJob((String)formParams.getFirst((Object)"id"));
            return this.buildResponse(response);
        }
        return null;
    }

    private void checkPermissionsForNewJob(MultivaluedMap<String, String> formParams) {
        HttpSession session = this.getSession();
        SourceManagerSettings settings = this.getSourceManagerSettings();
        try {
            SourceConnectorReader downloadConnector = settings.getSourceConnectorFromAssetURLPath("_downloads", session);
            PermissionSet ps = settings.getUserAuthenticationInterface().getPermissions(downloadConnector, session, true);
            if (ps == null || !ps.write.paste.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            boolean isRenderingJob = formParams.containsKey((Object)"renderingquery");
            HashMap<SourceConnectorReader, PermissionSet> permissionsCache = new HashMap<SourceConnectorReader, PermissionSet>();
            List filesList = (List)formParams.get((Object)"file");
            for (String assetURLPath : filesList) {
                SourceConnectorReader connector = settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
                PermissionSet permissions = (PermissionSet)permissionsCache.get(connector);
                if (permissions == null) {
                    permissions = settings.getUserAuthenticationInterface().getPermissions(connector, session, true);
                    permissionsCache.put(connector, permissions);
                }
                if (permissions != null && (!isRenderingJob || permissions.tasks.batchRendering.booleanValue() && permissions.read.renderedImages.booleanValue()) && (isRenderingJob || permissions.tasks.createArchive.booleanValue() && permissions.read.files.booleanValue())) continue;
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
        }
        catch (NotConfiguredException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private DownloadJob.ArchiveType determineArchiveType(MultivaluedMap<String, String> formParams) {
        DownloadJob.ArchiveType type = DownloadJob.ArchiveType.ZIP;
        if (formParams.containsKey((Object)"archivetype")) {
            String value = (String)formParams.getFirst((Object)"archivetype");
            if (value.equalsIgnoreCase("tar.gz")) {
                type = DownloadJob.ArchiveType.TAR_GZ;
            } else if (value.equalsIgnoreCase("tar.bz2")) {
                type = DownloadJob.ArchiveType.TAR_BZ2;
            }
        }
        return type;
    }

    private ActionResponse createAndStartJob(MultivaluedMap<String, String> formParams) {
        ActionResponse result = new ActionResponse();
        DownloadJobProcessor jobprocessor = this.getSourceManager().getJobProcessor();
        DownloadJob job = DownloadJob.createJob();
        job.setArchiveType(this.determineArchiveType(formParams));
        String jobname = (String)formParams.getFirst((Object)"name");
        switch (job.getArchiveType()) {
            case TAR_GZ: {
                job.setName(jobname + ".tar.gz");
                break;
            }
            case TAR_BZ2: {
                job.setName(jobname + ".tar.bz2");
                break;
            }
            default: {
                job.setName(jobname + ".zip");
            }
        }
        String username = this.getUser();
        job.setCreator(username);
        job.setGroups(this.getUserGroupsWithoutDefault());
        List filesList = (List)formParams.get((Object)"file");
        TreeSet<String> files = new TreeSet<String>();
        files.addAll(filesList);
        job.setFiles(files);
        job.setRenderingQuery((String)formParams.getFirst((Object)"renderingquery"));
        if (formParams.containsKey((Object)"scheduleDate")) {
            try {
                job.setScheduledStart(Long.parseLong((String)formParams.getFirst((Object)"scheduleDate")));
            }
            catch (NumberFormatException e) {
                result.setStatusCode(500);
                result.setCause("Invalid value for scheduleDate.");
                return result;
            }
        }
        if (formParams.containsKey((Object)"appendfileextension") && ((String)formParams.getFirst((Object)"appendfileextension")).equals("true")) {
            job.setReplaceFilenameExtension(false);
        } else {
            job.setReplaceFilenameExtension(true);
        }
        boolean success = jobprocessor.enqueueJob(job);
        if (success) {
            result.setStatusCode(200);
        } else {
            result.setStatusCode(500);
            result.setCause("Error enqueuing job.");
        }
        return result;
    }

    private ActionResponse cancelJob(String id) {
        DownloadJobProcessor jobprocessor = this.getSourceManager().getJobProcessor();
        boolean success = jobprocessor.cancelJob(id);
        ActionResponse result = new ActionResponse();
        if (success) {
            result.setStatusCode(200);
        } else {
            result.setStatusCode(500);
            result.setCause("Error cancelling job.");
        }
        return result;
    }

    private ActionResponse restartJob(String id) {
        ActionResponse result = new ActionResponse();
        if (id == null) {
            result.setStatusCode(404);
            result.setCause("No job id specified");
        } else {
            DownloadJobProcessor jobprocessor = this.getSourceManager().getJobProcessor();
            try {
                jobprocessor.restartJob(id);
                result.setStatusCode(200);
            }
            catch (NoSuchFileException e) {
                result.setStatusCode(404);
                result.setCause("Unknown job id");
            }
            catch (IOException e) {
                result.setStatusCode(500);
                result.setCause("Error reading job details from filesystem.");
            }
        }
        return result;
    }
}

