/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiframework.licensing.LicenceContainer;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.security.DigestUtils;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractService;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/licence/")
public class LicenceService
extends AbstractService
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;

    @PUT
    @Path(value="test")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response decodeLicence(String incomingXML) {
        Response.ResponseBuilder rb;
        HttpSession session = this.getSession();
        PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, session, true);
        if (permissions == null || !permissions.general.writeLicence.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        byte[] licBytes = incomingXML.getBytes(FileOperations.charsetUTF8);
        String containerHash = DigestUtils.sha256(licBytes);
        ByteArrayInputStream is = new ByteArrayInputStream(licBytes);
        LicenceContainer container = LicenceContainer.getInstance(is);
        List<RawLicence> rll = container.getRawLicences();
        Licence licence = new Licence();
        boolean decoded = false;
        boolean fsiViewerKeyFound = false;
        for (RawLicence rl : rll) {
            if (rl == null || rl.licence == null) continue;
            if (rl.appid == 22 && rl.version == SoftwareVersion.getMajorVersion()) {
                licence.decodeLicenceString(this.getSourceManagerSettings().getFSILogger(), rl.licence, SoftwareVersion.getKeyVersion(), 22, SoftwareVersion.getMajorVersion(), SoftwareVersion.readPublicKey(), rl.lastModified);
                decoded = true;
                continue;
            }
            if (rl.appid != 101 || rl.version != 6) continue;
            fsiViewerKeyFound = true;
        }
        if (decoded) {
            try {
                JSONObject json = this.getRequestProcessorSettings().getLicenceInfoAsJSON(licence, true, containerHash);
                json.put("fsi_viewer", fsiViewerKeyFound);
                rb = Response.ok((Object)json.toString(1), (MediaType)MediaType.APPLICATION_JSON_TYPE);
            }
            catch (NotConfiguredException e) {
                rb = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
            }
            catch (JSONException e) {
                rb = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            rb = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    @PUT
    @Path(value="install")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response installLicences(String incomingXML) {
        Response.ResponseBuilder rb;
        HttpSession session = this.getSession();
        PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, session, true);
        if (permissions == null || !permissions.general.writeLicence.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(incomingXML.getBytes(FileOperations.charsetUTF8));
            LicenceContainer container = LicenceContainer.getInstance(is);
            List<RawLicence> rll = container.getRawLicences();
            for (RawLicence rl : rll) {
                rl.lastModified = System.currentTimeMillis();
                this.getRequestProcessorSettings().getLicenceManager().addLicence(rl);
            }
            rb = Response.status((Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            rb = Response.status((Response.Status)Response.Status.FORBIDDEN);
            rb.type("text/html");
            rb.entity((Object)"Could not save licence to file.");
        }
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

