/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiserver.service.AbstractService;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.LDAPAuthentication;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.service.LoginResponse;
import com.neptunelabs.fsiserver.utils.service.SaltResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

@Path(value="/login/")
public class LoginService
extends AbstractService {
    @GET
    @Produces(value={"application/xml", "application/json"})
    public final Response salt() {
        Response.ResponseBuilder rb;
        LDAPAuthentication ldapUai;
        SourceManagerSettings settings = this.getSourceManagerSettings();
        UserAuthenticationInterface uai = settings != null ? settings.getUserAuthenticationInterface() : null;
        if (uai != null && uai instanceof LDAPAuthentication && (ldapUai = (LDAPAuthentication)uai).checkLDAPConfig() && settings != null) {
            settings.updateSourceConnectorAccessRules();
        }
        if (uai != null && uai.isKerberosAuthenticationEnabled()) {
            rb = Response.ok((Object)new SaltResponse("plain", null, this.getServerStartupError()));
        } else {
            String salt;
            if (this.getSession().getAttribute("salt") != null) {
                salt = (String)this.getSession().getAttribute("salt");
            } else {
                salt = this.generateSalt();
                this.getSession().setAttribute("salt", (Object)salt);
            }
            rb = Response.ok((Object)new SaltResponse("hash", salt, this.getServerStartupError()));
        }
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setProxyRevalidate(true);
        cc.setMustRevalidate(true);
        cc.setNoStore(true);
        cc.setPrivate(true);
        rb.cacheControl(cc);
        return rb.build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml", "application/json"})
    public final Response login(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        String state = "error";
        int messageCode = 0;
        String message = "";
        long expiry = 0L;
        if (this.getSourceManagerSettings() != null) {
            UserAuthenticationInterface uai = this.getSourceManagerSettings().getUserAuthenticationInterface();
            if (uai != null) {
                Object saltO = this.getSession().getAttribute("salt");
                String salt = (String)saltO;
                UserAuthenticationInterface.AuthenticationCode code = uai.validateCredentials(username, password, salt);
                if (code == UserAuthenticationInterface.AuthenticationCode.OK) {
                    String sessionid = uai.registerSession(username);
                    state = "success";
                    messageCode = 1;
                    this.getAPILogger().logAccess(this.getHost(), username, 100, new Object[0]);
                    this.getSession().setAttribute("id", (Object)sessionid);
                    expiry = System.currentTimeMillis() / 1000L + (long)this.getSession().getMaxInactiveInterval();
                    this.getSession().removeAttribute("salt");
                } else if (code == UserAuthenticationInterface.AuthenticationCode.UNKNOWN_USER) {
                    state = "failed";
                    messageCode = 5;
                    message = "Unknown User or password wrong";
                    this.getAPILogger().logAccess(this.getHost(), username, 101, new Object[0]);
                } else if (code == UserAuthenticationInterface.AuthenticationCode.WRONG_PASSWORD) {
                    state = "failed";
                    message = "Unknown User or password wrong";
                    messageCode = 6;
                    this.getAPILogger().logAccess(this.getHost(), username, 102, new Object[0]);
                } else if (code == UserAuthenticationInterface.AuthenticationCode.KERBEROS_AUTHENTICATION_FAILED) {
                    state = "failed";
                    message = "Unknown User or password wrong";
                    messageCode = 6;
                    this.getAPILogger().logAccess(this.getHost(), username, 102, new Object[0]);
                } else {
                    state = "failed";
                    message = "Authentication module unavailable";
                    messageCode = 7;
                    this.getAPILogger().logAccess(this.getHost(), username, 103, new Object[0]);
                }
            } else {
                message = "Authentication module unavailable";
                messageCode = 21;
            }
        } else {
            message = this.getServerStartupError() != null ? this.getServerStartupError() : "Authentication module unavailable";
            messageCode = 500;
        }
        String serverVersion = SoftwareVersion.getSoftware(true);
        Response.ResponseBuilder rb = Response.ok((Object)new LoginResponse(username, state, messageCode, message, expiry, "", serverVersion));
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setProxyRevalidate(true);
        cc.setMustRevalidate(true);
        cc.setNoStore(true);
        cc.setPrivate(true);
        rb.cacheControl(cc);
        return rb.build();
    }
}

