/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.service.AbstractImporterService;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Password;
import com.neptunelabs.fsiserver.utils.service.SaltResponse;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/password/")
public final class PasswordService
extends AbstractImporterService
implements Serializable {
    private static final long serialVersionUID = -7709019603957201866L;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getPasswordChangeSalt() {
        String salt;
        if (!this.validateSession()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        UserAuthenticationInterface uai = this.getSourceManager().getSettings().getUserAuthenticationInterface();
        if (!uai.isPasswordChangePossible()) {
            ActionResponse result = new ActionResponse();
            result.setStatusCode(403);
            result.setCause("Not supported by Configuration");
            result.setDetails("Passwords are managed externally.");
            Response.ResponseBuilder rb = Response.ok((Object)result);
            rb.cacheControl(defaultCacheControl);
            return rb.build();
        }
        if (this.getSession().getAttribute("passwordChangeSalt") != null) {
            salt = (String)this.getSession().getAttribute("passwordChangeSalt");
        } else {
            salt = this.generateSalt();
            this.getSession().setAttribute("passwordChangeSalt", (Object)salt);
        }
        Response.ResponseBuilder rb = Response.ok((Object)new SaltResponse(null, salt, null));
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/xml", "application/json"})
    public Response updatePassword(Password password) {
        if (!this.validateSession()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ActionResponse result = new ActionResponse();
        UserAuthenticationInterface uai = this.getSourceManager().getSettings().getUserAuthenticationInterface();
        if (uai.isPasswordChangePossible()) {
            if (this.getSession().getAttribute("passwordChangeSalt") != null) {
                String salt = (String)this.getSession().getAttribute("passwordChangeSalt");
                String oldPasswordHash = password.getOldPasswordHash();
                String username = this.getUser();
                UserAuthenticationInterface.AuthenticationCode authcode = uai.validateCredentials(username, oldPasswordHash, salt);
                this.getSession().removeAttribute("passwordChangeSalt");
                if (authcode == UserAuthenticationInterface.AuthenticationCode.OK) {
                    String passwordHash = password.getNewPasswordHash();
                    boolean success = uai.setUserPasswordHash(username, passwordHash);
                    if (success) {
                        result.setStatusCode(200);
                        this.getSourceManagerSettings().getAPILogger().log(140, username);
                    } else {
                        result.setStatusCode(500);
                        result.setCause("Unknown Error changing password.");
                        this.getSourceManagerSettings().getAPILogger().log(141, username);
                    }
                } else if (authcode == UserAuthenticationInterface.AuthenticationCode.WRONG_PASSWORD) {
                    result.setStatusCode(403);
                    result.setCause("Wrong password");
                    this.getSourceManagerSettings().getAPILogger().log(141, username);
                } else if (authcode == UserAuthenticationInterface.AuthenticationCode.UNKNOWN_USER) {
                    result.setStatusCode(409);
                    result.setCause("Unknown User");
                    this.getSourceManagerSettings().getAPILogger().log(141, username);
                } else if (authcode == UserAuthenticationInterface.AuthenticationCode.ERROR) {
                    result.setStatusCode(500);
                    result.setCause("Authentication Module is currently not available.");
                    this.getSourceManagerSettings().getAPILogger().log(141, username);
                }
            } else {
                result.setStatusCode(412);
                result.setCause("No Salt");
                result.setDetails("Please request a salt before attempting a password change.");
            }
        } else {
            result.setStatusCode(403);
            result.setCause("Not supported by Configuration");
            result.setDetails("Passwords are managed externally.");
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

