/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MimeHelper;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractImageService;
import com.neptunelabs.fsiserver.service.utils.FileUploadListener;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Image;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@Path(value="/postupload/")
public class PostUploadService
extends AbstractImageService
implements Serializable {
    private static final long serialVersionUID = 1708651260992139837L;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml", "application/json"})
    public final Response preupload(@FormParam(value="Filename") String filename, @FormParam(value="Dir") String targetdir, @FormParam(value="Lastmodified") String lastmodified, @FormParam(value="Filesize") String filesize) {
        String dir = URL.cleanUpSourceParameter(targetdir);
        ActionResponse response = new ActionResponse();
        if (dir != null && dir.length() > 1 && filename != null && filename.length() > 0) {
            try {
                Image image = new Image();
                long lm = lastmodified != null ? (lastmodified.contains(".") ? Long.parseLong(lastmodified.substring(0, lastmodified.indexOf("."))) : Long.parseLong(lastmodified)) : System.currentTimeMillis();
                if (lm < 124412296600L) {
                    lm *= 1000L;
                }
                image.setLastModified(lm);
                if (filesize != null) {
                    image.setFileSize(Long.parseLong(filesize));
                }
                image.setTargetPath(dir + "/" + filename);
                response = this.testUpload(image);
            }
            catch (WebApplicationException wae) {
                if (wae.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    response.setCause("Your Session is invalid");
                    response.setStatusCode(403);
                } else if (wae.getResponse().getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                    response.setCause("Access to requested directory forbidden");
                    response.setStatusCode(403);
                } else if (wae.getResponse().getStatus() == Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode()) {
                    response.setCause("File Type not supported here");
                    response.setStatusCode(415);
                }
            }
            catch (NumberFormatException nfe) {
                response.setCause("Invalid Parameter value");
                response.setStatusCode(400);
            }
        } else {
            response.setCause("Invalid Parameter value");
            response.setStatusCode(400);
        }
        Response.ResponseBuilder rb = Response.ok((Object)response);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/{imagepath:.+?}")
    @Consumes(value={"multipart/form-data"})
    public final Response postupload(@Context HttpServletRequest requestValue, @PathParam(value="imagepath") String imagepath) {
        String uploadedFileSize;
        boolean forceHTMLResponse;
        ActionResponse response;
        block73: {
            String cleanpath = URL.cleanUpSourceParameter(imagepath);
            response = new ActionResponse();
            forceHTMLResponse = false;
            if (!this.validateSession()) {
                this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, imagepath, "Not authorized");
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            uploadedFileSize = "unknown";
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)requestValue);
            if (!isMultipart) {
                response.setStatusCode(400);
                response.setCause("Not a multipart message");
            } else {
                HashMap<String, FileUploadListener> listeners;
                HttpSession session = this.getSession();
                HashMap<String, String> parameters = new HashMap<String, String>();
                DiskFileItemFactory factory = new DiskFileItemFactory();
                FileUploadListener listener = new FileUploadListener();
                Object attr = session.getAttribute("uploadlisteners");
                if (attr != null) {
                    listeners = (HashMap<String, FileUploadListener>)attr;
                } else {
                    listeners = new HashMap<String, FileUploadListener>();
                    session.setAttribute("uploadlisteners", listeners);
                }
                listeners.put(cleanpath, listener);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setFileSizeMax(0x20000000L);
                upload.setProgressListener((ProgressListener)listener);
                java.nio.file.Path tmpFile = null;
                java.nio.file.Path tmpzipFile = null;
                try {
                    SourceConnectorReader targetConnector2333332 = this.getSourceManagerSettings().getSourceConnectorFromAssetURLPath(cleanpath, session);
                    PermissionSet targetPermissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions(targetConnector2333332, session, true);
                    if (targetPermissions == null) throw new WebApplicationException(Response.Status.FORBIDDEN);
                    if (!targetPermissions.write.upload.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                    List items = upload.parseRequest(requestValue);
                    for (int i = 0; i < items.size(); ++i) {
                        FileItem item = (FileItem)items.get(i);
                        if (item.isFormField()) {
                            parameters.put(item.getFieldName(), item.getString());
                            continue;
                        }
                        try {
                            tmpFile = this.getSourceManagerSettings().getWorkDirectory().resolve("upload_" + System.nanoTime());
                            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));
                                 InputStream in = item.getInputStream();){
                                int len;
                                byte[] buf = new byte[1024];
                                while ((len = in.read(buf)) > 0) {
                                    ((OutputStream)out).write(buf, 0, len);
                                }
                                continue;
                            }
                        }
                        catch (IOException e) {
                            response.setStatusCode(500);
                            response.setCause("IOException during file upload: " + e.getLocalizedMessage());
                        }
                    }
                    String lastmodified = (String)parameters.get("Lastmodified");
                    String forceHTML = (String)parameters.get("ForceHTMLResponse");
                    forceHTMLResponse = Boolean.valueOf(forceHTML);
                    if (tmpFile == null) {
                        response.setStatusCode(500);
                        response.setCause("Error accessing temporary file");
                    } else {
                        uploadedFileSize = String.valueOf(Files.size(tmpFile));
                        long lm = System.currentTimeMillis();
                        try {
                            if (lastmodified != null) {
                                if (lastmodified.contains(".")) {
                                    lastmodified = lastmodified.substring(0, lastmodified.indexOf("."));
                                }
                                lm = Long.parseLong(lastmodified);
                            } else {
                                lm = System.currentTimeMillis();
                            }
                            if (lm < 124412296600L) {
                                lm *= 1000L;
                            }
                        }
                        catch (NumberFormatException e) {
                            response.setCause("Invalid Parameter value");
                            response.setStatusCode(400);
                        }
                        String type = MimeHelper.getMimeTypeByDeepScan(tmpFile);
                        if (type.equals("application/zip")) {
                            tmpzipFile = tmpFile.resolveSibling(tmpFile.getFileName().toString() + ".zip");
                            FileOperations.move(tmpFile, tmpzipFile);
                            String dir = "";
                            if (cleanpath.endsWith("/") && cleanpath.length() > 1) {
                                cleanpath = cleanpath.substring(0, cleanpath.length() - 1);
                            }
                            dir = cleanpath.substring(0, cleanpath.lastIndexOf("/"));
                            response = this.handleZipUpload(dir, targetConnector2333332, tmpzipFile);
                        } else {
                            response = this.handleUpload(cleanpath, targetConnector2333332, lm, tmpFile);
                        }
                        if (Files.exists(tmpFile, new LinkOption[0])) {
                            try {
                                Files.delete(tmpFile);
                            }
                            catch (IOException e) {
                                this.getSourceManagerSettings().getFSILogger().log(3200, tmpFile);
                            }
                        }
                    }
                    try {
                        if (tmpFile != null) {
                            Files.deleteIfExists(tmpFile);
                        }
                        if (tmpzipFile != null) {
                            Files.deleteIfExists(tmpzipFile);
                        }
                    }
                    catch (IOException targetConnector2333332) {}
                }
                catch (FileUploadException fue) {
                    response.setStatusCode(500);
                    response.setCause("FileUploadException during file upload: " + fue.getLocalizedMessage());
                    break block73;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (NotConfiguredException e) {
                        throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (tmpFile != null) {
                            Files.deleteIfExists(tmpFile);
                        }
                        if (tmpzipFile != null) {
                            Files.deleteIfExists(tmpzipFile);
                        }
                    }
                    catch (IOException fue) {}
                }
            }
        }
        StringBuilder responsesb = null;
        if (forceHTMLResponse) {
            responsesb = new StringBuilder();
            responsesb.append("<html><body>\n");
            responsesb.append("<response");
            responsesb.append(" statuscode=\"");
            responsesb.append(response.getStatusCode());
            responsesb.append("\"");
            if (response.getCause() != null) {
                responsesb.append(" cause=\"");
                responsesb.append(response.getCause());
                responsesb.append("\"");
            }
            responsesb.append(">\n");
            responsesb.append("</response>\n");
            responsesb.append("</body></html>\n");
        }
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 110, imagepath, uploadedFileSize);
        } else {
            this.getAPILogger().logAccess(this.getHost(), this.getUser(), 111, imagepath, response.getDetails());
        }
        Response.ResponseBuilder rb = forceHTMLResponse && responsesb != null ? Response.ok((Object)responsesb.toString()) : Response.ok((Object)response);
        rb.header("Content-Type", (Object)(forceHTMLResponse ? "text/html" : "application/xml"));
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

