/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractService;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.DownloadPresetsResponse;
import com.neptunelabs.fsiserver.utils.service.Pref;
import com.neptunelabs.fsiserver.utils.service.PrefsResponse;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;

@Path(value="/prefs/")
public class PrefsService
extends AbstractService
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;

    @GET
    @Path(value="/{prefsname:\\w+}")
    @Produces(value={"application/xml", "application/json"})
    public Response getPrefs(@PathParam(value="prefsname") String prefsname, @HeaderParam(value="Accept") String acceptHeader) {
        Response.ResponseBuilder rb;
        if (this.validateSession()) {
            if (prefsname.equalsIgnoreCase("system")) {
                PrefsResponse pr = this.handleSystemPrefsGetRequest();
                rb = pr.prefs.size() == 0 && acceptHeader.contains("application/json") ? Response.ok((Object)"{}") : Response.ok((Object)pr);
            } else {
                rb = prefsname.equalsIgnoreCase("publishing") ? this.handleCustomPrefsRequest("publishing") : (prefsname.equalsIgnoreCase("interface") ? this.handleCustomPrefsRequest("interface") : (prefsname.equalsIgnoreCase("preview") ? this.handleCustomPrefsRequest("preview") : (prefsname.equalsIgnoreCase("archivepresets") ? this.handleDownloadPresetsRequest("archivepresets.xml") : (prefsname.equalsIgnoreCase("batchpresets") ? this.handleDownloadPresetsRequest("batchpresets.xml") : Response.status((Response.Status)Response.Status.NOT_FOUND)))));
            }
        } else if (prefsname.equalsIgnoreCase("preview")) {
            rb = Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT);
            String requestURL = this.request.getRequestURL().toString();
            if (requestURL.endsWith("/")) {
                requestURL = requestURL.substring(0, requestURL.length() - 1);
            }
            String redirectLocation = requestURL.replace("service/prefs/preview", "#preview");
            rb = rb.header("Location", (Object)redirectLocation);
        } else {
            rb = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    @POST
    @Path(value="/{prefsname:\\w+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response savePrefsPerPost(@PathParam(value="prefsname") String prefsname, @FormParam(value="data") String incomingData) {
        return this.setPrefs(prefsname, incomingData);
    }

    @PUT
    @Path(value="/{prefsname:\\w+}")
    @Consumes(value={"application/json", "text/html"})
    @Produces(value={"application/json"})
    public Response setPrefs(@PathParam(value="prefsname") String prefsname, String incomingData) {
        ActionResponse response;
        if (this.validateSession()) {
            PermissionSet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, this.getSession(), true);
            if (!ps.general.writePreferences.booleanValue()) {
                response = new ActionResponse();
                response.setStatusCode(403);
                response.setCause("Forbidden");
            } else if (prefsname.equalsIgnoreCase("publishing")) {
                response = this.saveCustomPrefs("publishing", incomingData);
            } else if (prefsname.equalsIgnoreCase("interface")) {
                response = this.saveCustomPrefs("interface", incomingData);
            } else if (prefsname.equalsIgnoreCase("preview")) {
                response = this.saveCustomPrefs("preview", incomingData);
            } else {
                response = new ActionResponse();
                response.setStatusCode(403);
                response.setCause("Forbidden");
            }
        } else {
            response = new ActionResponse();
            response.setStatusCode(403);
            response.setCause("Not Authorized");
        }
        return this.buildResponse(response);
    }

    private java.nio.file.Path getCustomPrefsFile(String prefsname) {
        String username = this.getUser();
        java.nio.file.Path configdir = this.getSourceManagerSettings().getConfigHome();
        java.nio.file.Path userprefsdir = configdir.resolve("userprefs");
        java.nio.file.Path userdir = userprefsdir.resolve(username);
        String filename = prefsname.equals("preview") ? prefsname + ".html" : prefsname + ".json";
        return userdir.resolve(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse saveCustomPrefs(String prefsname, String content) {
        java.nio.file.Path prefsFile;
        boolean success = false;
        ActionResponse response = new ActionResponse();
        java.nio.file.Path path = prefsFile = this.getCustomPrefsFile(prefsname);
        synchronized (path) {
            success = FileOperations.writeTextFileContent(this.getSourceManagerSettings().getFSILogger(), prefsFile, content, FileOperations.charsetUTF8);
        }
        if (success) {
            response.setStatusCode(200);
        } else {
            response.setStatusCode(500);
            response.setCause("Could not save file");
        }
        return response;
    }

    private Response.ResponseBuilder handleDownloadPresetsRequest(String filename) {
        Response.ResponseBuilder rb;
        java.nio.file.Path configdir = this.getSourceManagerSettings().getConfigHome();
        java.nio.file.Path presetsFile = configdir.resolve(filename);
        if (Files.exists(presetsFile, new LinkOption[0])) {
            try {
                Document doc = FileOperations.getXMLFileContent(this.getAPILogger(), presetsFile);
                String xml = XMLOperations.elementNamesToLowerCase(this.getAPILogger(), doc);
                DownloadPresetsResponse response = XMLOperations.unmarshalJAXB(xml, DownloadPresetsResponse.class);
                rb = Response.ok();
                rb.entity((Object)response);
            }
            catch (IOException e) {
                rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
            }
        } else {
            rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        return rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response.ResponseBuilder handleCustomPrefsRequest(String prefsname) {
        long lastmodified;
        String result;
        java.nio.file.Path prefsFile = this.getCustomPrefsFile(prefsname);
        Response.ResponseBuilder rb = Response.ok();
        java.nio.file.Path path = prefsFile;
        synchronized (path) {
            try {
                result = FileOperations.getTextFileContent(prefsFile, FileOperations.charsetUTF8);
                lastmodified = FileOperations.getSafeLastModified(prefsFile);
            }
            catch (IOException e) {
                result = "{}";
                lastmodified = System.currentTimeMillis();
            }
        }
        rb = Response.ok();
        if (prefsname.equals("preview")) {
            rb.type("text/html");
        } else {
            rb.type("application/json");
        }
        rb.lastModified(new Date(lastmodified));
        rb.entity((Object)result);
        return rb;
    }

    private PrefsResponse handleSystemPrefsGetRequest() {
        PrefsResponse response = new PrefsResponse();
        java.nio.file.Path configdir = this.getSourceManagerSettings().getConfigHome();
        Map<String, String> prefsMap = this.getBasicUserSystemPrefs(configdir);
        for (Map.Entry<String, String> entry : prefsMap.entrySet()) {
            response.prefs.add(new Pref(entry.getKey(), entry.getValue()));
        }
        response.prefs.add(new Pref("batch-processing", String.valueOf(this.getSourceManagerSettings().getLicence().isBatchProcessingEnabled())));
        response.prefs.add(new Pref("search-enabled", String.valueOf(this.getRequestProcessorSettings().getSolrSearcher() != null)));
        response.prefs.add(new Pref("password-change-enabled", String.valueOf(this.getSourceManagerSettings().getUserAuthenticationInterface().isPasswordChangePossible())));
        return response;
    }
}

