/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.service.AbstractService;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/properties")
public class PropertyService
extends AbstractService
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;

    private String getEnabledItemsAsList(List<PropertySet.ItemType> list) {
        String result = "[";
        for (PropertySet.ItemType item : list) {
            if (!item.value) continue;
            result = result + "\"" + item.name + "\",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result + "]";
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProperties() {
        String result;
        HttpSession session = this.getSession();
        PropertySet ps = this.getSourceManagerSettings().getUserAuthenticationInterface().getProperties(null, session);
        if (ps == null) {
            result = "{\"properties\":{\"general\": [], \"custonMetadataFields\": [], \"hideApps\": [],\"\": [], \"hidePublishingTabs\": [],\"\": [],\"publishingSets\": [],\"custom\": []}}";
        } else {
            result = "{\"properties\":{\"general\": ";
            result = result + this.getEnabledItemsAsList(ps.general);
            result = result + ", \"customMetadataFields\": ";
            result = result + this.getEnabledItemsAsList(ps.custommetadatafields);
            result = result + ", \"hideApps\": ";
            result = result + this.getEnabledItemsAsList(ps.hideApps);
            result = result + ", \"hidePublishingTabs\": ";
            result = result + this.getEnabledItemsAsList(ps.hidePublishingTabs);
            result = result + ", \"publishingSets\": ";
            result = result + this.getEnabledItemsAsList(ps.publishingsets);
            result = result + ", \"custom\": ";
            result = result + this.getEnabledItemsAsList(ps.custom);
            result = result + "}}";
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

