/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.service.AbstractService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/publishingsets")
public class PublishingSetService
extends AbstractService
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;

    @GET
    @Produces(value={"application/json"})
    public Response getProperties() {
        String result = this.getPublishingSetsAsJSON(null);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getProperties(@FormParam(value="sets") String setsParam) {
        HashSet<String> setNames = new HashSet<String>();
        for (String sn : setsParam.split(",")) {
            setNames.add(sn);
        }
        String result = this.getPublishingSetsAsJSON(setNames);
        return Response.ok((Object)result).build();
    }

    private String getPublishingSetsAsJSON(Set<String> setNames) {
        HttpSession session = this.getSession();
        Map<String, PublishingSet> publishingSets = this.getSourceManagerSettings().getUserAuthenticationInterface().getUserPublishingSets(session);
        String result = "{\"publishingSets\": {";
        if (publishingSets != null) {
            for (Map.Entry<String, PublishingSet> entry : publishingSets.entrySet()) {
                if (setNames != null && !setNames.contains(entry.getKey())) continue;
                result = result + "\"" + entry.getKey() + "\": {";
                PublishingSet pSet = entry.getValue();
                if (pSet.comment != null) {
                    result = result + "\"comment\":\"" + pSet.comment + "\",";
                }
                if (pSet.viewerpath != null) {
                    result = result + "\"viewerPath\":\"" + pSet.viewerpath.value + "\",";
                }
                if (pSet.proxyURL != null) {
                    result = result + "\"proxyURL\":\"" + pSet.proxyURL.value + "\",";
                }
                if (pSet.proxyServerPattern != null) {
                    result = result + "\"proxyServerPattern\":\"" + pSet.proxyServerPattern.value + "\",";
                }
                if (pSet.proxyStaticPattern != null) {
                    result = result + "\"proxyStaticPattern\":\"" + pSet.proxyStaticPattern.value + "\",";
                }
                if (pSet.proxyJSPath != null) {
                    result = result + "\"proxyJSPath\":\"" + pSet.proxyJSPath.value + "\",";
                }
                if (pSet.proxyViewerPath != null) {
                    result = result + "\"proxyViewerPath\":\"" + pSet.proxyViewerPath.value + "\",";
                }
                if (pSet.proxyUserViewerBase != null) {
                    result = result + "\"proxyUserViewerBase\":\"" + pSet.proxyUserViewerBase.value + "\",";
                }
                if (result.endsWith(",")) {
                    result = result.substring(0, result.length() - 1);
                }
                result = result + "},";
            }
            if (result.endsWith(",")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        result = result + "}}";
        return result;
    }
}

