/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.moxy.json.MoxyJsonConfig;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

@ApplicationPath(value="service")
public final class ServiceApplication
extends ResourceConfig {
    public ServiceApplication() {
        this.register(MyObjectMapperProvider.class);
        this.register(new ShutdownListener());
        this.packages(new String[]{"com.neptunelabs.fsiserver.service"});
        this.initJerseyLogging();
    }

    private void initJerseyLogging() {
        Path logdirfile = null;
        String loghome = System.getProperty("log.home");
        String catalinabase = System.getProperty("catalina.base");
        String catalinahome = System.getProperty("catalina.home");
        String logBase = loghome != null && !loghome.equals("") ? loghome : (catalinabase != null && !catalinabase.equals("") ? catalinabase : (catalinahome != null && !catalinahome.equals("") ? catalinahome : null));
        if (logBase != null && Files.isWritable(logdirfile = Paths.get(logBase, "logs"))) {
            Path jerseylog = logdirfile.resolve("jersey3.log");
            try {
                FileHandler jerseyloghandler = new FileHandler(jerseylog.toFile().getAbsolutePath(), true);
                jerseyloghandler.setFormatter(new SimpleFormatter());
                Logger jul = Logger.getLogger("org.glassfish.jersey");
                jul.setUseParentHandlers(false);
                jul.addHandler(jerseyloghandler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Provider
    public static class MyObjectMapperProvider
    implements ContextResolver<MoxyJsonConfig> {
        private final MoxyJsonConfig config;

        public MyObjectMapperProvider() {
            HashMap<String, String> namespacePrefixMapper = new HashMap<String, String>();
            namespacePrefixMapper.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.config = new MoxyJsonConfig().setNamespacePrefixMapper(namespacePrefixMapper).setNamespaceSeparator(':');
        }

        public MoxyJsonConfig getContext(Class<?> objectType) {
            return this.config;
        }
    }

    public static class ShutdownListener
    implements ContainerLifecycleListener {
        public void onShutdown(Container arg0) {
            Logger jul = Logger.getLogger("org.glassfish.jersey");
            for (Handler h : jul.getHandlers()) {
                h.close();
            }
        }

        public void onStartup(Container arg0) {
        }

        public void onReload(Container arg0) {
        }
    }
}

