/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessor;
import com.neptunelabs.fsiserver.service.AbstractService;
import com.neptunelabs.fsiserver.utils.service.SessionRefreshResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/sessionrefresh/")
public class SessionRefreshService
extends AbstractService {
    @GET
    @Produces(value={"application/xml", "application/json"})
    public final Response refresh() {
        long expiry = this.validateSession() ? (long)this.getSession().getMaxInactiveInterval() : 0L;
        String serverVersion = SoftwareVersion.getSoftware(true);
        MainProcessor rp = this.getRequestProcessor();
        if (!rp.acceptsRequests()) {
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
            rb.cacheControl(defaultCacheControl);
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)new SessionRefreshResponse(expiry, System.currentTimeMillis(), serverVersion, this.getUser()));
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

