/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.service.AbstractImporterService;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import java.io.Serializable;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;

@Path(value="/user/")
public final class UserService
extends AbstractImporterService
implements Serializable {
    private static final long serialVersionUID = -7900814358055910809L;

    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    public Response getUsersAsJsonArray() {
        JSONArray userList = new JSONArray();
        HttpSession session = this.getSession();
        PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, session, true);
        if (permissions == null || !permissions.general.switchUser.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Set<String> users = this.getUsers();
        for (String user : users) {
            userList.put((Object)user);
        }
        Response.ResponseBuilder rb = Response.ok((Object)userList.toString());
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }

    @PUT
    @Path(value="change")
    @Produces(value={"application/json"})
    public Response changeUserInSession(String username) {
        ActionResponse result = new ActionResponse();
        HttpSession session = this.getSession();
        PermissionSet permissions = this.getSourceManagerSettings().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, session, true);
        if (permissions == null || !permissions.general.switchUser.booleanValue()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        boolean state = this.changeUser(username);
        if (!state) {
            result.setStatusCode(409);
        } else {
            result.setStatusCode(200);
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.cacheControl(defaultCacheControl);
        return rb.build();
    }
}

