/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.ConverterStatistics;
import com.neptunelabs.fsiserver.sourcemanager.ImageReaderFactory;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.guru.GuruMeditationHook;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedEvent;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedListener;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.JobResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagemanipulator.area.Flip;
import com.neptunelabs.imagemanipulator.area.Rotate90;
import com.neptunelabs.imagereader.ImageReader;
import com.neptunelabs.imagereader.MetaScanner;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.exif.ExifParser;
import com.neptunelabs.imagereader.exif.ExifTag;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public final class ConverterJob
implements Runnable,
PriorityExecutor.Important {
    private final int priority;
    private ConverterStatistics statistics;
    private final long converterJob;
    private ExecutorPool executorPool;
    private ImageListFileWriter listfilewriter;
    private IOController ioController;
    private StorageManager storageManager;
    private SwapPool swapPool;
    private ScannerDaemon scannerDaemon;
    private SystemMonitor systemMonitor;
    private SourceManagerSettings settings;
    private FSILogger logger;
    private ImageReaderFactory imageReaderFactory;
    private boolean prefetch = false;
    private long maxPrefetchSize = 0x2000000L;
    private GuruMeditationHook exceptionhandler;
    private EISImageWriter scwriter = null;
    private volatile boolean cancelJob = false;
    private final List<ConversionCompletedListener> listeners = new ArrayList<ConversionCompletedListener>();
    private ICCProfileWrap defaultCMYKICC = null;
    private ICCProfileWrap defaultRGBICC = null;
    private ICCProfileWrap defaultGrayICC = null;
    private boolean fallbackICCConversion = true;
    private ImageReader cir = null;
    private FileImportJob job;
    private static final DecimalFormat float2Num = new DecimalFormat("#.##");

    ConverterJob(int priority, long converterJobNumber, FileImportJob fiJob, long maxMemPerThread) {
        this.priority = priority;
        this.converterJob = converterJobNumber;
        this.job = fiJob;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setSettings(SourceManagerSettings settings) {
        this.settings = settings;
        this.ioController = settings.getIOController();
        this.executorPool = settings.getExecutorPool();
        this.logger = settings.getFSILogger();
        this.storageManager = settings.getStorageManager();
        this.systemMonitor = settings.getSystemMonitor();
    }

    public void setSwapPool(SwapPool swapPool) {
        this.swapPool = swapPool;
    }

    public void setImageListFileWriter(ImageListFileWriter listfilewriter) {
        this.listfilewriter = listfilewriter;
    }

    public void setImageReaderFactory(ImageReaderFactory imageReaderFactory) {
        this.imageReaderFactory = imageReaderFactory;
    }

    public void setConverterStatistics(ConverterStatistics statistics) {
        this.statistics = statistics;
    }

    public void setScannerDaemon(ScannerDaemon scannerDaemon) {
        this.scannerDaemon = scannerDaemon;
    }

    private void stop() {
        this.cancelJob = true;
        if (this.scwriter != null) {
            this.scwriter.cancel();
        }
        if (this.cir != null) {
            this.cir.shutdown();
        }
    }

    public void addConversionCompletedListener(ConversionCompletedListener listener) {
        this.listeners.add(listener);
    }

    public void setDefaultICCProfiles(ICCProfileWrap cmyk, ICCProfileWrap rgb, ICCProfileWrap gray) {
        this.defaultCMYKICC = cmyk;
        this.defaultRGBICC = rgb;
        this.defaultGrayICC = gray;
    }

    public void setUseFallbackICCConversion(boolean state) {
        this.fallbackICCConversion = state;
    }

    public void setPrefetch(boolean state, long maxSize) {
        this.prefetch = state;
        this.maxPrefetchSize = maxSize;
    }

    public void setExceptionHandler(GuruMeditationHook exceptionhandler) {
        this.exceptionhandler = exceptionhandler;
    }

    @Override
    public void run() {
        try {
            if (!this.cancelJob && this.job != null) {
                this.processJob();
            }
        }
        catch (CorruptReverseLookupException e) {
            if (this.scannerDaemon != null) {
                this.scannerDaemon.reportStorageCorruption(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.cancelJob) {
                this.logger.logException(e, 3189, e.getClass().getName() + ": " + e.getLocalizedMessage(), this.job != null ? this.job.getSourceFile().getAbsolutePath() : "unknown");
            }
        }
        finally {
            for (ConversionCompletedListener listener : this.listeners) {
                listener.conversionCompleted(new ConversionCompletedEvent(this.job));
            }
            this.stop();
        }
    }

    private void processJob() throws CorruptReverseLookupException, IOException, NotConfiguredException {
        Path oldFileLocation;
        this.prepareFileImportJobForConversion();
        this.job.status = FileImportJob.JobStatus.ACTIVE;
        long startTime = System.currentTimeMillis();
        if (this.job.importMode == FileImportJob.ImportMode.SKIP) {
            this.logger.log(3138, this.converterJob, this.job.id, this.job.getSourceFile());
        } else if (this.job.importMode == FileImportJob.ImportMode.CONVERT) {
            JobResult jobResult = this.importImage();
            if (jobResult.success) {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.SM_IMPORTED_IMAGES);
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.SM_PIXEL, jobResult.pixels);
            } else {
                this.systemMonitor.increaseAccumulator(SystemMonitor.Accumulators.SM_IMPORTED_SM_FAILED);
            }
            if (this.scannerDaemon != null) {
                this.scannerDaemon.updateSearchDatabaseEntryForAsset(this.job.assetURLPath, jobResult.metadata, jobResult.success ? (short)1 : 3);
            }
        }
        this.job.finishTime = System.currentTimeMillis();
        this.job.processTime = this.job.finishTime - startTime;
        if (this.settings.isMigrationModeEnabled() && Files.exists(oldFileLocation = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(this.job.assetURLPath)).resolve(this.job.assetURLPath), new LinkOption[0])) {
            FileOperations.deleteDir(oldFileLocation);
            FileOperations.removeEmptyParents(this.logger, oldFileLocation.getParent(), this.settings.getStorageLocation());
            this.logger.log(3223, oldFileLocation, this.job.getEisFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFileImportJobForConversion() throws IOException {
        if (this.job.importMode == FileImportJob.ImportMode.CONVERT || this.job.priority < 0 && this.job.importMode == FileImportJob.ImportMode.SKIP && this.job.skipReason == FileImportJob.SkipReason.QUEUED) {
            if (this.job.sourceConnector != null) {
                this.ioController.waitForRead();
                try (EISReader reader = new EISReader(this.job.assetURLPath, this.job.eisFile, this.settings, this.swapPool, this.executorPool, false);){
                    ImageMetaData imd = reader.getImageMetaData();
                    if (imd != null && imd.getImportStatus() == 1) {
                        long lastModified = this.job.getSourceFile().lastModified();
                        long filesize = this.job.getSourceFile().size();
                        if (imd.getLastModified() != lastModified || imd.getSourceFileSize() != filesize) {
                            this.job.importMode = FileImportJob.ImportMode.CONVERT;
                        } else {
                            this.job.importMode = FileImportJob.ImportMode.SKIP;
                            this.job.sourceWidth = imd.getWidth();
                            this.job.sourceHeight = imd.getHeight();
                        }
                    } else if (imd != null && imd.getImportStatus() == 3 && !this.job.reimportErrorImage) {
                        this.job.importMode = FileImportJob.ImportMode.SKIP;
                        this.job.skipReason = FileImportJob.SkipReason.ERROR;
                    } else if (imd == null) {
                        this.job.importMode = FileImportJob.ImportMode.CONVERT;
                        this.job.skipReason = FileImportJob.SkipReason.ERROR;
                    } else {
                        this.job.importMode = FileImportJob.ImportMode.CONVERT;
                    }
                }
                catch (NoSuchFileException e) {
                    this.job.importMode = FileImportJob.ImportMode.CONVERT;
                }
                catch (NotAValidEISFileException e) {
                    this.logger.log(3233, this.job.assetURLPath, e.getMessage());
                }
                catch (Exception e) {
                    this.logger.logException(e, 3233, this.job.assetURLPath, e.getMessage());
                    this.job.importMode = FileImportJob.ImportMode.CONVERT;
                }
                catch (Error e) {
                    this.logger.logError(e, 3233, this.job.assetURLPath, e.getMessage());
                    this.job.importMode = FileImportJob.ImportMode.CONVERT;
                }
                finally {
                    this.ioController.unlockRead();
                }
                if (this.job.importMode == FileImportJob.ImportMode.SKIP && this.job.dirlistFile != null) {
                    ArrayList<PoolEntry> poollist = new ArrayList<PoolEntry>();
                    byte importstatus = this.job.skipReason != FileImportJob.SkipReason.ERROR ? (byte)1 : 3;
                    poollist.add(new PoolFileEntry(this.job.getSourceFile().getFileName().toString(), this.job.getSourceFile().lastModified(), this.job.getSourceFile().size(), this.job.sourceWidth, this.job.sourceHeight, importstatus));
                    try {
                        String parentAssetURLPath = URL.getParentAssetURLPath(this.job.getDirectoryURLPath());
                        Path parentDirlistFile = this.settings.getStorageHelper().getDirectoryFile(parentAssetURLPath);
                        this.listfilewriter.updateEntries(this.job.dirlistFile, this.job.getDirectoryURLPath(), parentDirlistFile, parentAssetURLPath, poollist, -1L);
                    }
                    catch (NotConfiguredException notConfiguredException) {}
                }
            } else {
                this.job.importMode = FileImportJob.ImportMode.SKIP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobResult importImage() throws CorruptReverseLookupException, IOException, NotConfiguredException {
        long startTime;
        JobResult result;
        block26: {
            result = new JobResult();
            startTime = System.nanoTime();
            this.exceptionhandler.setImage(this.job.getSourceFile());
            try {
                FSIMetaData metaData;
                if (this.cancelJob) break block26;
                MetaScanner ms = new MetaScanner(this.logger, this.ioController);
                result.metadata = metaData = ms.scanImage(this.job.getSourceFile(), true);
                this.job.makeHistogram = this.job.sourceConnector.getMakeHistogram();
                this.cir = this.createImageReader(metaData);
                if (!this.cir.hasError() && !ms.hasError()) {
                    this.logger.log(3111, this.converterJob, this.job.getSourceFile(), metaData.getWidth(), metaData.getHeight(), this.job.getQueueType().toString());
                    long startReadTime = System.currentTimeMillis();
                    boolean success_read = this.readImage();
                    if (!this.cir.hasImage()) {
                        success_read = false;
                    }
                    long loadTime = System.currentTimeMillis() - startReadTime;
                    try {
                        this.applyExifOrientation(this.cir, metaData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.cancelJob) {
                        long saveTime;
                        if (success_read) {
                            this.job.sourceWidth = this.cir.getImage().getWidth();
                            this.job.sourceHeight = this.cir.getImage().getHeight();
                        }
                        if (success_read && this.job.sourceWidth > 0 && this.job.sourceHeight > 0) {
                            result.pixels = (long)this.job.sourceWidth * (long)this.job.sourceHeight;
                            long startWriteTime = System.currentTimeMillis();
                            this.saveToStorage(metaData);
                            saveTime = System.currentTimeMillis() - startWriteTime;
                            result.success = this.job.status == FileImportJob.JobStatus.COMPLETED;
                        } else {
                            this.logger.log(3114, this.converterJob, this.job.getSourceFile());
                            long startWriteTime = System.currentTimeMillis();
                            EISImageWriter eiw = new EISImageWriter(this.settings, 3, this.cir.getReaderVersion());
                            eiw.setAssetURLPath(this.job.assetURLPath);
                            eiw.setMetaData(result.metadata);
                            eiw.setJobType(this.job.format);
                            this.storageManager.executeStorageDataProvider(this.job.eisFile, eiw);
                            eiw.dispose();
                            saveTime = System.currentTimeMillis() - startWriteTime;
                            this.job.status = FileImportJob.JobStatus.FAILED;
                        }
                        this.updateListFile();
                        if (!this.cancelJob && this.job.status == FileImportJob.JobStatus.COMPLETED) {
                            this.logSuccessfulImport(metaData, this.job.eisFile, startTime, loadTime, saveTime);
                        }
                    }
                    break block26;
                }
                if (!this.cancelJob) {
                    this.logger.log(3114, this.converterJob, this.job.getSourceFile());
                    this.job.status = FileImportJob.JobStatus.FAILED;
                    this.updateListFile();
                    int readerVersion = this.cir.getReaderVersion();
                    if (readerVersion == 0) {
                        switch (this.job.getType()) {
                            case BMP: {
                                readerVersion = 258;
                                break;
                            }
                            case FPX: {
                                readerVersion = 259;
                                break;
                            }
                            case GIF: {
                                readerVersion = 258;
                                break;
                            }
                            case JPG: {
                                readerVersion = 258;
                                break;
                            }
                            case PNG: {
                                readerVersion = 258;
                                break;
                            }
                            case TIF: {
                                readerVersion = 259;
                                break;
                            }
                            default: {
                                readerVersion = -1;
                            }
                        }
                    }
                    EISImageWriter eiw = new EISImageWriter(this.settings, 3, readerVersion);
                    eiw.setAssetURLPath(this.job.assetURLPath);
                    eiw.setMetaData(result.metadata);
                    eiw.setJobType(this.job.format);
                    this.storageManager.executeStorageDataProvider(this.job.eisFile, eiw);
                    eiw.dispose();
                    result.success = true;
                }
            }
            catch (IOException ioe) {
                if (!this.cancelJob) {
                    this.job.status = FileImportJob.JobStatus.FAILED;
                    this.updateListFile();
                    EISImageWriter eiw = new EISImageWriter(this.settings, 3, this.cir != null ? this.cir.getReaderVersion() : -1);
                    eiw.setAssetURLPath(this.job.assetURLPath);
                    eiw.setMetaData(result.metadata);
                    eiw.setJobType(this.job.format);
                    this.storageManager.executeStorageDataProvider(this.job.eisFile, eiw);
                    eiw.dispose();
                    result.success = true;
                }
            }
            finally {
                if (this.cir != null) {
                    this.cir.destroy();
                    this.cir = null;
                }
            }
        }
        this.storageManager.getStorageLogger().log('A', StorageLogger.LogCMD.D, this.job.getAssetURLPath());
        result.time = System.currentTimeMillis() - startTime;
        return result;
    }

    private void updateListFile() throws NotConfiguredException, IOException {
        ArrayList<PoolEntry> list = new ArrayList<PoolEntry>();
        byte importStatus = 0;
        if (this.job.status == FileImportJob.JobStatus.COMPLETED) {
            importStatus = 1;
        } else if (this.job.status == FileImportJob.JobStatus.FAILED) {
            importStatus = 3;
        }
        list.add(new PoolFileEntry(this.job.getSourceFile().getFileName().toString(), this.job.getSourceFile().lastModified(), this.job.getSourceFile().size(), this.job.sourceWidth, this.job.sourceHeight, importStatus));
        if (this.job.dirlistFile != null && !this.cancelJob) {
            String parentAssetURLPath = URL.getParentAssetURLPath(this.job.getDirectoryURLPath());
            Path parentDirlistFile = this.settings.getStorageHelper().getDirectoryFile(parentAssetURLPath);
            this.listfilewriter.updateEntries(this.job.dirlistFile, this.job.getDirectoryURLPath(), parentDirlistFile, parentAssetURLPath, list, -1L);
        }
    }

    private void logSuccessfulImport(FSIMetaData metaData, Path eisFile, long startTime, long loadTime, long saveTime) {
        long conversionTime = (System.nanoTime() - startTime) / 1000000L;
        long pixel = (long)metaData.getWidth() * (long)metaData.getHeight();
        this.statistics.addCompleteImage(pixel);
        float[] cStat = this.statistics.getStats();
        this.logger.log(3113, this.converterJob, metaData.source, eisFile, conversionTime, loadTime, saveTime, this.cir.isMapped(), float2Num.format(cStat[0]), float2Num.format(cStat[1]));
    }

    private boolean readImage() {
        boolean success_read;
        try {
            this.cir.readImage(this.job.getPriority());
            success_read = !this.cir.hasError();
        }
        catch (Exception e) {
            this.cir.setError(true);
            success_read = false;
            this.logger.logException(e, 3116, this.converterJob, this.job.getSourceFile(), e.getLocalizedMessage());
        }
        catch (Error e) {
            this.cir.setError(true);
            success_read = false;
            this.logger.logError(e, 3116, this.converterJob, this.job.getSourceFile(), e.getLocalizedMessage());
        }
        return success_read;
    }

    private ImageReader createImageReader(FSIMetaData metaData) {
        ImageReader ir = this.imageReaderFactory.createImageReader(this.job, metaData, this.prefetch);
        ir.setPrefetch(this.prefetch, this.maxPrefetchSize);
        ir.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
        ir.setUseFallbackICCConversion(this.fallbackICCConversion);
        ir.setIOController(this.ioController);
        return ir;
    }

    private void applyExifOrientation(ImageReader cirValue, FSIMetaData metaData) {
        if (metaData.getExif() != null) {
            Object raw;
            ExifParser exifParser = ExifParser.getInstance(this.logger);
            exifParser.setName(metaData.source);
            exifParser.scanExif(metaData.getExif());
            ExifTag ef = exifParser.getTag(274);
            if (ef != null && (raw = ef.getRaw()) != null) {
                FSIImage image = cirValue.getImage();
                FSIImage rotatedImage = null;
                int o = (Integer)raw;
                switch (o) {
                    case 2: {
                        Flip flip = new Flip(this.logger, this.executorPool, this.priority);
                        rotatedImage = flip.transform(image, 0, true);
                        break;
                    }
                    case 3: {
                        Rotate90 rotate90 = new Rotate90(this.logger, this.executorPool, this.priority);
                        rotatedImage = rotate90.transform(image, 180, true);
                        break;
                    }
                    case 4: {
                        Flip flip = new Flip(this.logger, this.executorPool, this.priority);
                        rotatedImage = flip.transform(image, 1, true);
                        break;
                    }
                    case 5: {
                        Rotate90 rotate90 = new Rotate90(this.logger, this.executorPool, this.priority);
                        Flip flip = new Flip(this.logger, this.executorPool, this.priority);
                        rotatedImage = rotate90.transform(image, 90, true);
                        rotatedImage = flip.transform(rotatedImage, 0, false);
                        break;
                    }
                    case 6: {
                        Rotate90 rotate90 = new Rotate90(this.logger, this.executorPool, this.priority);
                        rotatedImage = rotate90.transform(image, 90, true);
                        break;
                    }
                    case 7: {
                        Rotate90 rotate90 = new Rotate90(this.logger, this.executorPool, this.priority);
                        Flip flip = new Flip(this.logger, this.executorPool, this.priority);
                        rotatedImage = rotate90.transform(image, 270, true);
                        rotatedImage = flip.transform(rotatedImage, 0, false);
                        break;
                    }
                    case 8: {
                        Rotate90 rotate90 = new Rotate90(this.logger, this.executorPool, this.priority);
                        rotatedImage = rotate90.transform(image, 270, true);
                    }
                }
                if (rotatedImage != null) {
                    image.dispose();
                    cirValue.setImage(rotatedImage);
                }
            }
        }
    }

    private void saveToStorage(FSIMetaData metaData) throws CorruptReverseLookupException {
        boolean success = false;
        try {
            this.scwriter = new EISImageWriter(this.logger, this.executorPool, this.settings.getStorageManager().getStorageLogger(), this.job.sourceConnector.getTileFormat(), this.job.sourceConnector.getTileSize(), this.job.sourceConnector.getLevelQuality(), this.job.sourceConnector.getJPEGPreparation(), this.job.getPriority(), this.cir.getReaderVersion());
            this.scwriter.setAssetURLPath(this.job.assetURLPath);
            this.scwriter.setJobType(this.job.format);
            this.scwriter.setSrcImageCount(1);
            this.scwriter.setImage(this.cir.getImage(), metaData);
            success = this.storageManager.executeStorageDataProvider(this.job.eisFile, this.scwriter);
        }
        finally {
            if (this.scwriter != null) {
                this.scwriter.dispose();
                this.scwriter = null;
            }
            this.cir.destroy();
        }
        this.job.status = success ? FileImportJob.JobStatus.COMPLETED : FileImportJob.JobStatus.FAILED;
    }

    public void halt() {
        if (!this.cancelJob) {
            this.logger.log(3119, this.converterJob);
        }
        this.cancelJob = true;
        if (this.scwriter != null) {
            this.scwriter.cancel();
        }
        if (this.cir != null) {
            this.cir.shutdown();
        }
    }

    public final QueueType getQueueType() {
        return this.job.getQueueType();
    }
}

