/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

public final class ConverterStatistics {
    private int lastTime;
    private long lastCTime;
    private final int[] hitBuffer = new int[60];
    private final long[] pixelBuffer = new long[60];

    public synchronized void addCompleteImage(long pixel) {
        long cTime = System.currentTimeMillis();
        int time = (int)(cTime / 1000L) % 60;
        int timeDiff = time - this.lastTime;
        if (cTime - this.lastCTime > 60000L) {
            this.clear(0, 60);
        } else if (timeDiff < 0) {
            int len = 60 - this.lastTime + time - 1;
            this.clear(time + 1, len);
            this.hitBuffer[time] = 1;
            this.pixelBuffer[time] = pixel;
        } else if (timeDiff > 0) {
            this.clear(time + 1, timeDiff - 1);
            this.hitBuffer[time] = 1;
            this.pixelBuffer[time] = pixel;
        } else {
            int n = time;
            this.hitBuffer[n] = this.hitBuffer[n] + 1;
            int n2 = time;
            this.pixelBuffer[n2] = this.pixelBuffer[n2] + pixel;
        }
        this.lastTime = time;
        this.lastCTime = cTime;
    }

    private int clear(int from, int len) {
        int pos = from;
        if (pos >= 60) {
            pos = 0;
        }
        int c = len;
        while (c-- > 0) {
            this.hitBuffer[pos] = 0;
            this.pixelBuffer[pos] = 0L;
            if (++pos < 60) continue;
            pos = 0;
        }
        return pos;
    }

    public float[] getStats() {
        float hitsPerMinute = 0.0f;
        float pixelPerMinute = 0.0f;
        long pixel = 0L;
        long hits = 0L;
        for (int c = 0; c < 60; ++c) {
            hits += (long)this.hitBuffer[c];
            pixel += this.pixelBuffer[c];
        }
        hitsPerMinute = hits;
        pixelPerMinute = (float)pixel / 1000000.0f;
        return new float[]{hitsPerMinute, pixelPerMinute};
    }
}

