/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityTaskComparator;
import com.neptunelabs.fsiframework.concurrent.PriorityThreadFactory;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.ConverterJob;
import com.neptunelabs.fsiserver.sourcemanager.ConverterStatistics;
import com.neptunelabs.fsiserver.sourcemanager.ImageReaderFactory;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.guru.GuruMeditationHook;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedEvent;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedListener;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.sourcemanager.small.LimitedJobList;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.MetaDataFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.ColorConverterCache;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.ICCDefaultReader;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter_V1002
extends Thread
implements ConversionCompletedListener {
    private static final int MAX_LIST_SIZE = 150;
    private static final int PRIO_PING = 0;
    private static final int PRIO_API = 0x20000000;
    private static final int PRIO_SCAN = 0x40000000;
    private static final int PRIO_SCAN_BIG = 0x60000000;
    private static final AtomicInteger cursorPing = new AtomicInteger(0);
    private static final AtomicInteger cursorAPI = new AtomicInteger(0x20000000);
    private static final AtomicInteger cursorScan = new AtomicInteger(0x40000000);
    private static final AtomicInteger cursorScanBig = new AtomicInteger(0x60000000);
    private static final int MIN_SENSE = Math.round(112.5f);
    private volatile boolean overloaded = false;
    private final long maxMemPerThread;
    private final SwapPool swapPool;
    private final ScannerDaemon scannerDaemon;
    private final SourceManagerSettings settings;
    private final GuruMeditationHook exceptionhandler;
    private final ExecutorPool executorPool;
    private final ConverterStatistics statistics;
    private final BufferedImageConverterThreaded biConverter;
    private final ColorConverterCache colorConverterCache;
    private final ImageReaderFactory imageReaderFactory;
    private final SystemMonitor systemMonitor;
    private final PriorityExecutor executorService;
    private final PriorityBlockingQueue<Runnable> importQueue;
    private final Map<String, Future<?>> importMap = Collections.synchronizedMap(new TreeMap());
    private volatile boolean runDaemon;
    private final boolean prefetch;
    private final long maxPrefetchSize;
    private final LimitedJobList<FileImportJob> recentJobs;
    private final ImageListFileWriter listfilewriter;
    private ICCProfileWrap defaultCMYKICC = null;
    private ICCProfileWrap defaultRGBICC = null;
    private ICCProfileWrap defaultGrayICC = null;
    private boolean fallbackICCConversion = true;
    private String status;
    private final AtomicLong totalConversionCounter = new AtomicLong(0L);

    protected Converter_V1002(GuruMeditationHook exceptionhandler, SourceManagerSettings settings, ExecutorPool executorPool, SwapPool swapPool, ScannerDaemon scannerDaemon, PluginLoader pluginLoader, MetaDataFileReader metadatareader, ImageListFileWriter listfilewriter, boolean running) {
        float memratio;
        this.setName("Converter");
        this.settings = settings;
        this.exceptionhandler = exceptionhandler;
        this.listfilewriter = listfilewriter;
        this.executorPool = executorPool;
        this.swapPool = swapPool;
        this.scannerDaemon = scannerDaemon;
        this.runDaemon = running;
        this.systemMonitor = settings.getSystemMonitor();
        int threads = settings.getConversionThreads();
        PriorityThreadFactory ptfIO = new PriorityThreadFactory("Converter", false, 1);
        this.importQueue = new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator());
        this.executorService = new PriorityExecutor(threads, threads, 10L, TimeUnit.MINUTES, this.importQueue, ptfIO);
        long maxMem = MemoryManager.getFreeHeapSpace();
        int maxProfileCaches = (int)Math.ceil((float)(maxMem - 0x9600000L) / 1048592.0f);
        if (maxProfileCaches < 2) {
            maxProfileCaches = 2;
        } else if (maxProfileCaches > 20) {
            maxProfileCaches = 20;
        }
        this.colorConverterCache = new ColorConverterCache(maxProfileCaches);
        settings.getServletContext().setAttribute("com.neptunelabs.imagereader.ColorConverterCache", (Object)this.colorConverterCache);
        this.biConverter = new BufferedImageConverterThreaded(settings.getFSILogger(), executorPool, this.colorConverterCache);
        this.imageReaderFactory = new ImageReaderFactory(settings.getFSILogger(), this, this.biConverter, swapPool, pluginLoader, settings.getByteOrder());
        this.recentJobs = new LimitedJobList(100);
        this.statistics = new ConverterStatistics();
        try {
            memratio = Math.max(0.9f, Float.valueOf(settings.getPrefsString("application", "maxscalememratio")).floatValue());
        }
        catch (NumberFormatException e) {
            memratio = 0.75f;
        }
        long SLOW_QUEUE_THRESHOLD = (long)(memratio * (float)Runtime.getRuntime().maxMemory());
        this.maxMemPerThread = SLOW_QUEUE_THRESHOLD / (long)settings.getConversionThreads();
        this.prefetch = settings.getPrefsBoolean("application", "prefetch");
        this.maxPrefetchSize = settings.getPrefsLong("application", "prefetchmaxsize");
        this.setupDefaultICCProfiles();
        this.status = "idle";
    }

    @Override
    public void run() {
        while (this.runDaemon) {
            try {
                if (this.importQueue.isEmpty()) {
                    cursorPing.set(0);
                    cursorAPI.set(0x20000000);
                    cursorScan.set(0x40000000);
                    cursorScanBig.set(0x60000000);
                }
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.halt();
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void setupDefaultICCProfiles() {
        this.setupDefaultCMYKProfile();
        this.setupDefaultRGBProfile();
        this.setupDefaultGrayProfile();
        this.fallbackICCConversion = this.settings.getPrefsBoolean("colormanagementsystem", "fallbackICCConversion");
    }

    private void setupDefaultGrayProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultGrayProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("gray") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultGrayICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "GRAY:" + e.getLocalizedMessage());
        }
    }

    private void setupDefaultRGBProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultRGBProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("rgb") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultRGBICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "RGB:" + e.getLocalizedMessage());
        }
    }

    private void setupDefaultCMYKProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultCMYKProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("cmyk") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultCMYKICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "CMYK:" + e.getLocalizedMessage());
        }
    }

    private Path getProfileFile(String profileIdentifier) {
        String profile = this.settings.getPrefsString("colormanagementsystem", profileIdentifier);
        if (profile != null && !profile.equals("auto")) {
            Path profilePath = Paths.get(profile, new String[0]);
            return profilePath.isAbsolute() ? Paths.get(profile, new String[0]) : this.settings.getWebInfPath().resolve(profile);
        }
        return null;
    }

    protected boolean enqueueJob(FileImportJob fiJob) {
        if (this.acceptFile(fiJob.getQueueType()) && !this.importMap.containsKey(fiJob.assetURLPath)) {
            this.prepareFileImportJobForConversion(fiJob);
            this.testForHugeImage(fiJob);
            int thePriority = Converter_V1002.evaluatePriority(fiJob.getQueueType());
            long position = this.totalConversionCounter.incrementAndGet();
            ConverterJob job = new ConverterJob(thePriority, position, fiJob, this.maxMemPerThread);
            job.setSettings(this.settings);
            job.setSwapPool(this.swapPool);
            job.setScannerDaemon(this.scannerDaemon);
            job.addConversionCompletedListener(this);
            job.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
            job.setUseFallbackICCConversion(this.fallbackICCConversion);
            job.setExceptionHandler(this.exceptionhandler);
            job.setPrefetch(this.prefetch, this.maxPrefetchSize);
            job.setImageListFileWriter(this.listfilewriter);
            job.setImageReaderFactory(this.imageReaderFactory);
            job.setConverterStatistics(this.statistics);
            this.importMap.put(fiJob.assetURLPath, this.executorService.submit(job));
            this.settings.getFSILogger().log(3143, position, fiJob.getSourceFile());
            return true;
        }
        return false;
    }

    private void testForHugeImage(FileImportJob job) {
        long memUsage;
        if (job.getQueueType() == QueueType.SCAN && ((memUsage = (long)job.sourceWidth * (long)job.sourceHeight * 8L) >= this.maxMemPerThread || (float)MemoryManager.getFreeHeapSpace() * 0.75f < (float)memUsage)) {
            job.setQueueType(QueueType.SCAN_BIG);
        }
    }

    public static int evaluatePriority(QueueType type) {
        if (type == QueueType.PING) {
            return cursorPing.incrementAndGet();
        }
        if (type == QueueType.API) {
            return cursorAPI.incrementAndGet();
        }
        if (type == QueueType.SCAN) {
            return cursorScan.incrementAndGet();
        }
        return cursorScanBig.incrementAndGet();
    }

    private boolean acceptFile(QueueType type) {
        if (type != QueueType.PING && type != QueueType.API) {
            this.overloaded = this.importQueue.size() >= 150;
            return this.runDaemon && !this.overloaded;
        }
        return this.runDaemon;
    }

    public boolean isFileBeingConverted(ConverterJob compare) {
        return this.importQueue.contains(compare);
    }

    public boolean removeJob(FileImportJob toRemove) {
        boolean found = false;
        if (this.importQueue.contains(toRemove)) {
            found = this.importQueue.remove(toRemove);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobsByPrefix(String prefix) {
        Map<String, Future<?>> map = this.importMap;
        synchronized (map) {
            ArrayList<String> toDelete = new ArrayList<String>();
            for (String key : this.importMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                toDelete.add(key);
            }
            for (String key : toDelete) {
                Future<?> job = this.importMap.remove(key);
                job.cancel(true);
            }
        }
    }

    private void prepareFileImportJobForConversion(FileImportJob job) {
        if (!job.format.isImage || job.getType() == ImageFormat.Type.UNK) {
            job.importMode = FileImportJob.ImportMode.SKIP;
            job.skipReason = FileImportJob.SkipReason.IGNORE;
        } else if (this.isFileBeingProcessed(job)) {
            job.importMode = FileImportJob.ImportMode.SKIP;
            job.skipReason = FileImportJob.SkipReason.QUEUED;
        }
    }

    public boolean isFileBeingProcessed(FileImportJob job) {
        return this.importMap.containsKey(job.assetURLPath);
    }

    void halt() {
        this.runDaemon = false;
        this.interrupt();
        this.importQueue.clear();
        this.executorService.shutdown();
    }

    void haltNow() {
        this.executorService.shutdownNow();
        if (this.biConverter != null) {
            this.biConverter.dispose();
        }
        if (this.colorConverterCache != null) {
            this.colorConverterCache.dispose();
        }
        this.status = "stopped";
        this.settings.getFSILogger().log(2012, "Converter");
    }

    public String getStatus() {
        return this.status;
    }

    protected List<FileImportJob> getRecentJobs() {
        FileImportJob[] list;
        ArrayList<FileImportJob> result = new ArrayList<FileImportJob>();
        for (FileImportJob element : list = (FileImportJob[])this.recentJobs.toArray(new FileImportJob[0])) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conversionCompleted(ConversionCompletedEvent event) {
        FileImportJob job = event.getJob();
        try {
            long sc = 0L;
            long nc = this.executorService.getActiveCount();
            this.systemMonitor.setProcessingImages(nc);
            this.systemMonitor.setProcessingSwapImages(0L);
            if (this.overloaded && this.importQueue.size() < MIN_SENSE) {
                this.overloaded = false;
            }
            if (job != null) {
                this.recentJobs.add(job);
            }
        }
        finally {
            if (job != null) {
                this.importMap.remove(job.assetURLPath);
            }
            this.totalConversionCounter.incrementAndGet();
        }
    }

    protected ExecutorPool getExecutorPool() {
        return this.executorPool;
    }

    public long getTotalConversions() {
        return this.totalConversionCounter.get();
    }

    public int getMaxListSize() {
        return 150;
    }

    public int getQueuedImages() {
        return this.importQueue.size();
    }

    boolean isOverloaded() {
        return this.overloaded;
    }

    public List<ConverterState> getCurrentJobStates() {
        ArrayList<ConverterState> result = new ArrayList<ConverterState>();
        return result;
    }

    long pingFile(String assetURLPath) throws NotConfiguredException {
        long result = -1L;
        if (!this.importMap.containsKey(assetURLPath)) {
            Path dirlistfile;
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            String pathWithoutPrefix = assetURLPath.substring(connector.getPrefix().length() + 1);
            Path sourceFile = connector.getInboxDirectory().resolve(pathWithoutPrefix);
            PathCached fp = new PathCached(sourceFile);
            ImageFormatScanner scanner = ImageFormatScanner.getInstance();
            ImageFormat format = scanner.scanFile(fp);
            Path eisFile = this.settings.getStorageHelper().getEisFile(assetURLPath);
            FileImportJob fij = new FileImportJob(QueueType.PING, connector, fp, format, eisFile, assetURLPath, Converter_V1002.evaluatePriority(QueueType.PING), false);
            fij.dirlistFile = dirlistfile = this.settings.getStorageHelper().getDirectoryFile(URL.getParentAssetURLPath(assetURLPath));
            if (this.enqueueJob(fij)) {
                result = this.totalConversionCounter.get();
                this.settings.getFSILogger().log(3193, assetURLPath, result);
            }
        }
        return result;
    }
}

