/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.deletepool.DeletePool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashList;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiservletframework.utils.URL;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteDaemon
extends Thread {
    private static final long INTERVAL = 300000L;
    public static final String TRASHLIST_FILENAME = ".trashlist";
    private final SourceManagerSettings settings;
    private final DeletePool deletePool;
    private final IOController ioController;
    private final Map<String, SourceConnectorReader> prefixProfileMap;
    private final ImageListFileReader imagelistfilereader;
    private final ImageListFileWriter imagelistfilewriter;
    private final StorageHelperV1002 storageHelper;
    private volatile boolean runDaemon = true;

    protected DeleteDaemon(SourceManagerSettings settings, DeletePool deletepool, IOController ioController, ImageListFileReader imagelistfilereader, ImageListFileWriter imagelistfilewriter) {
        this.settings = settings;
        this.deletePool = deletepool;
        this.ioController = ioController;
        this.imagelistfilereader = imagelistfilereader;
        this.imagelistfilewriter = imagelistfilewriter;
        this.storageHelper = settings.getStorageHelper();
        this.prefixProfileMap = new HashMap<String, SourceConnectorReader>();
        this.updateProfileMap();
        Path trashdir = settings.getTrashLocation();
        if (Files.notExists(trashdir, new LinkOption[0])) {
            try {
                Files.createDirectories(trashdir, new FileAttribute[0]);
            }
            catch (IOException e) {
                settings.getFSILogger().log(3199, trashdir);
            }
        }
    }

    void updateProfileMap() {
        Map<String, SourceConnectorReader> profiles = this.settings.getEnabledConnectors();
        for (Map.Entry<String, SourceConnectorReader> e : profiles.entrySet()) {
            SourceConnectorReader profile = e.getValue();
            this.prefixProfileMap.put(profile.getPrefix(), profile);
        }
    }

    @Override
    public void run() {
        while (this.runDaemon) {
            try {
                List<PathCached> files = FileOperations.listAllFiles(this.settings.getTrashLocation());
                if (files != null) {
                    for (PathCached file : files) {
                        if (!this.runDaemon) break;
                        this.deletePool.addFilepath(0, file.getPath(), true);
                    }
                }
                DeleteDaemon.sleep(300000L);
            }
            catch (IOException | InterruptedException exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStorageDirectory(String dirAssetURLPath, String storageVersion) throws CorruptReverseLookupException, NotConfiguredException, IOException {
        dirAssetURLPath = this.removeLeadingSlashesFromString(dirAssetURLPath);
        Pair<SourceConnectorReader, String> x = this.expandPath(dirAssetURLPath);
        long newLastModified = 0L;
        if (x != null) {
            SourceConnectorReader p = x.getItem1();
            String relativeInboxPath = x.getItem2();
            Path srcDir = p.getInboxDirectory().resolve(relativeInboxPath);
            this.ioController.waitForRead();
            try {
                newLastModified = Files.notExists(srcDir, new LinkOption[0]) ? FileOperations.getSafeLastModified(srcDir.getParent()) : FileOperations.getSafeLastModified(srcDir);
            }
            finally {
                this.ioController.unlockRead();
            }
        }
        String parentdirpath = this.determineParentPath(dirAssetURLPath);
        String entryName = dirAssetURLPath;
        if (entryName.endsWith("/")) {
            entryName = entryName.substring(0, entryName.length() - 1);
        }
        if (entryName.indexOf(47) != -1) {
            entryName = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        this.removeSubs(dirAssetURLPath, storageVersion);
        this.removeDirListDirEntry(parentdirpath, entryName, newLastModified, storageVersion);
        this.imagelistfilewriter.forceClearingBuffer(dirAssetURLPath);
    }

    private String determineParentPath(String dirPath) {
        int lslash = dirPath.lastIndexOf("/", dirPath.length() - 2);
        String parentdirpath = lslash != -1 ? dirPath.substring(0, lslash) : "/";
        return parentdirpath;
    }

    private String removeLeadingSlashesFromString(String dirPath) {
        while (dirPath.startsWith("/")) {
            dirPath = dirPath.substring(1);
        }
        return dirPath;
    }

    private void removeSubs(String assetURLPath, String storageVersion) throws CorruptReverseLookupException, NotConfiguredException, IOException {
        PoolList list;
        Path dirlistfile = null;
        dirlistfile = storageVersion.equals("V1002") ? this.storageHelper.getDirectoryFile(assetURLPath) : this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(assetURLPath)).resolve(assetURLPath).resolve("dirlist");
        try {
            list = this.imagelistfilereader.getListFileContents(dirlistfile, assetURLPath);
        }
        catch (IOException e) {
            list = null;
        }
        if (list != null) {
            Collection<PoolFileEntry> fileslist = list.getFilesAsCollection();
            HashSet<String> entriesToDeleteFromSDB = new HashSet<String>();
            for (PoolFileEntry pe : fileslist) {
                String imagePath = assetURLPath + "/" + pe.name;
                entriesToDeleteFromSDB.add(imagePath);
                if (storageVersion.equals("V1002")) {
                    Path eisFile = this.storageHelper.getEisFile(imagePath);
                    this.settings.getStorageManager().removeFromStorage(eisFile, imagePath);
                    continue;
                }
                Path imagedir = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(imagePath) + imagePath);
                Files.delete(imagedir);
            }
            Set<String> subdirlist = list.getDirectoryNameSet();
            for (String subdir : subdirlist) {
                if (subdir == null || subdir.length() <= 0) continue;
                if (!this.runDaemon) break;
                this.removeSubs(assetURLPath + "/" + subdir, storageVersion);
                entriesToDeleteFromSDB.add(assetURLPath + "/" + subdir);
            }
            if (this.settings.getSolrUpdater() != null && entriesToDeleteFromSDB.size() > 0) {
                this.settings.getSolrUpdater().deleteAssetsAsync(entriesToDeleteFromSDB);
            }
        }
        if (dirlistfile != null) {
            this.imagelistfilewriter.forceClearingBuffer(assetURLPath);
            this.settings.getStorageManager().removeFromStorage(dirlistfile, assetURLPath);
        }
    }

    private void removeDirListDirEntry(String dir, String entry, long lastmodified, String storageVersion) throws NotConfiguredException {
        if (dir != null && entry != null) {
            Path dirlistfile = null;
            dirlistfile = storageVersion.equals("V1002") ? this.storageHelper.getDirectoryFile(dir) : this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(dir) + dir).resolve("dirlist");
            String parentAssetURLPath = URL.getParentAssetURLPath(dir);
            Path parentdirlistfile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.removeEntry(dirlistfile, dir, parentdirlistfile, parentAssetURLPath, entry, lastmodified);
        }
    }

    public boolean removeStorageFileV1002(String assetURLPath, SourceConnectorReader connector, boolean forceImmediateWrite) throws NotConfiguredException, CorruptReverseLookupException, IOException {
        boolean success = false;
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
            Path eisFile = this.storageHelper.getEisFile(assetURLPath);
            success = this.settings.getStorageManager().removeFromStorage(eisFile, assetURLPath);
        }
        return success;
    }

    public void delete(Path sourceFile, String assetURLPath, SourceConnectorReader connector) throws CorruptReverseLookupException, IOException, NotConfiguredException {
        if (Files.isRegularFile(sourceFile, new LinkOption[0])) {
            this.deleteFile(sourceFile, assetURLPath, connector);
        } else {
            List<PathCached> list = FileOperations.listAllFiles(sourceFile);
            for (PathCached f : list) {
                this.delete(f.getPath(), assetURLPath + "/" + f.getFileName(), connector);
            }
            Files.delete(sourceFile);
            String directoryURLPath = URL.getParentAssetURLPath(assetURLPath);
            Path dirlistfile = this.storageHelper.getDirectoryFile(directoryURLPath);
            String parentAssetURLPath = URL.getParentAssetURLPath(directoryURLPath);
            Path parentdirlistfile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.removeEntry(dirlistfile, directoryURLPath, parentdirlistfile, parentAssetURLPath, sourceFile.getFileName().toString(), FileOperations.getSafeLastModified(sourceFile.getParent()));
            Path currentDirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
            this.imagelistfilewriter.forceClearingBuffer(assetURLPath);
            this.settings.getStorageManager().removeFromStorage(currentDirlistfile, assetURLPath);
        }
    }

    public void moveToTrash(Path sourceFile, String assetURLPath, SourceConnectorReader connector) throws CorruptReverseLookupException, IOException, NotConfiguredException {
        if (Files.isRegularFile(sourceFile, new LinkOption[0])) {
            this.moveFileToTrash(sourceFile, assetURLPath, connector);
        } else {
            List<PathCached> list = FileOperations.listAllFiles(sourceFile);
            for (PathCached f : list) {
                this.moveToTrash(f.getPath(), assetURLPath + "/" + f.getFileName(), connector);
            }
            Files.delete(sourceFile);
            if (!connector.isVirtualViewerConnector()) {
                String directoryURLPath = URL.getParentAssetURLPath(assetURLPath);
                Path dirlistfile = this.storageHelper.getDirectoryFile(directoryURLPath);
                String parentAssetURLPath = URL.getParentAssetURLPath(directoryURLPath);
                Path parentdirlistfile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
                this.imagelistfilewriter.removeEntry(dirlistfile, directoryURLPath, parentdirlistfile, parentAssetURLPath, sourceFile.getFileName().toString(), FileOperations.getSafeLastModified(sourceFile.getParent()));
                Path currentDirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
                this.imagelistfilewriter.forceClearingBuffer(assetURLPath);
                this.settings.getStorageManager().removeFromStorage(currentDirlistfile, assetURLPath);
            } else {
                this.settings.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, URL.getParentAssetURLPath(assetURLPath));
            }
        }
    }

    private void deleteFile(Path sourceFile, String assetURLPath, SourceConnectorReader connector) throws CorruptReverseLookupException, IOException, NotConfiguredException {
        if (Files.isDirectory(sourceFile, new LinkOption[0])) {
            throw new IllegalArgumentException("This method only can only handle files, not directories.");
        }
        if (Files.deleteIfExists(sourceFile)) {
            String name;
            String parentAssetURLPath;
            int sp;
            if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                this.removeStorageFileV1002(assetURLPath, connector, true);
            }
            long newLastModified = 0L;
            Path parentFile = sourceFile.getParent();
            if (Files.exists(parentFile, new LinkOption[0])) {
                this.ioController.waitForRead();
                newLastModified = FileOperations.getSafeLastModified(parentFile);
                this.ioController.unlockRead();
            }
            if ((sp = assetURLPath.lastIndexOf("/")) == -1) {
                parentAssetURLPath = "/";
                name = assetURLPath;
            } else {
                parentAssetURLPath = assetURLPath.substring(0, sp);
                name = assetURLPath.substring(sp);
            }
            if (connector != null && !connector.isVirtualViewerConnector()) {
                this.removeDirListFileEntryV1002(parentAssetURLPath, name, newLastModified);
                Path baseMetadataLocation = this.settings.getMetaDataLocation();
                Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
                Files.deleteIfExists(metaDataFile);
            } else {
                this.settings.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, parentAssetURLPath);
            }
            if (this.settings.getSolrUpdater() != null) {
                this.settings.getSolrUpdater().deleteAssetAsync(assetURLPath);
            }
        } else {
            throw new IOException("403 - Could not delete source file");
        }
    }

    private void moveFileToTrash(Path sourceFile, String assetURLPath, SourceConnectorReader connector) throws CorruptReverseLookupException, IOException, NotConfiguredException {
        String name;
        String parentAssetURLPath;
        int sp;
        if (Files.isDirectory(sourceFile, new LinkOption[0])) {
            throw new IllegalArgumentException("This method only can only handle files, not directories.");
        }
        Path connectorTrashFolder = this.storageHelper.getTrashFolder(connector);
        String baseHash = this.storageHelper.calculateTrashFileHash(assetURLPath);
        Path sourceTrashLocation = connectorTrashFolder.resolve(baseHash + ".src");
        int i = 1;
        String hash = baseHash;
        while (Files.exists(sourceTrashLocation, new LinkOption[0])) {
            hash = baseHash + "_" + i;
            ++i;
            sourceTrashLocation = connectorTrashFolder.resolve(hash + ".src");
        }
        long originalLMDate = FileOperations.getSafeLastModified(sourceFile);
        long originalSize = Files.size(sourceFile);
        Path parent = sourceTrashLocation.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        FileOperations.move(sourceFile, sourceTrashLocation);
        if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
            this.moveStorageContentToTrash(connectorTrashFolder, assetURLPath, hash, sourceFile);
        }
        long newLastModified = 0L;
        Path parentFile = sourceFile.getParent();
        if (Files.exists(parentFile, new LinkOption[0])) {
            this.ioController.waitForRead();
            newLastModified = FileOperations.getSafeLastModified(parentFile);
            this.ioController.unlockRead();
        }
        if ((sp = assetURLPath.lastIndexOf("/")) == -1) {
            parentAssetURLPath = "/";
            name = assetURLPath;
        } else {
            parentAssetURLPath = assetURLPath.substring(0, sp);
            name = assetURLPath.substring(sp);
        }
        if (connector != null && !connector.isVirtualViewerConnector()) {
            this.removeDirListFileEntryV1002(parentAssetURLPath, name, newLastModified);
            this.moveCustomMetadataToTrash(assetURLPath, hash, connectorTrashFolder);
        } else {
            this.settings.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, parentAssetURLPath);
        }
        TrashList trashList = TrashList.getInstance(connectorTrashFolder.resolve(TRASHLIST_FILENAME));
        int lastSlashPos = assetURLPath.lastIndexOf("/");
        String sourcePath = assetURLPath.substring(0, lastSlashPos);
        String filename = assetURLPath.substring(lastSlashPos + 1);
        trashList.addEntry(new TrashListEntry(sourcePath, filename, hash, originalLMDate, System.currentTimeMillis(), originalSize));
        this.settings.getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, "_trash");
        if (this.settings.getSolrUpdater() != null) {
            this.settings.getSolrUpdater().deleteAssetAsync(assetURLPath);
        }
    }

    public String getRestorationPath(Path profileTrashFolder, String trashHash) throws NoSuchFileException {
        Path trashlistfile = profileTrashFolder.resolve(TRASHLIST_FILENAME);
        TrashList trashList = TrashList.getInstance(trashlistfile);
        TrashListEntry tle = trashList.getEntryByHash(trashHash);
        if (tle != null) {
            return tle.originalDir + "/" + tle.originalFilename;
        }
        throw new NoSuchFileException(trashHash);
    }

    private void restoreDirectories(SourceConnectorReader connector, Path targetDirectory, String originalAssetURLPath) throws NotConfiguredException, IOException {
        if (!Files.exists(targetDirectory.getParent(), new LinkOption[0])) {
            this.restoreDirectories(connector, targetDirectory.getParent(), URL.getParentAssetURLPath(originalAssetURLPath));
        }
        Files.createDirectory(targetDirectory, new FileAttribute[0]);
        if (connector.getMountType().equals((Object)SourceConnectorReader.SourceConnectorType.STORAGE)) {
            Path dirlistfile = this.storageHelper.getDirectoryFile(originalAssetURLPath);
            String parentAssetURLPath = URL.getParentAssetURLPath(originalAssetURLPath);
            Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.updateEntry(dirlistfile, originalAssetURLPath, parentDirlistFile, parentAssetURLPath, null, System.currentTimeMillis());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreFileFromTrash(Path profileTrashFolder, String trashHash, SourceConnectorReader profile, Path targetFile) throws CorruptReverseLookupException, NoSuchFileException, IOException, NotConfiguredException {
        Path trashMetaFile;
        TrashList trashList = TrashList.getInstance(profileTrashFolder.resolve(TRASHLIST_FILENAME));
        TrashListEntry tle = trashList.getEntryByHash(trashHash);
        if (tle == null) throw new NoSuchFileException(trashHash);
        Path sourceFile = profileTrashFolder.resolve(trashHash + ".src");
        if (!Files.exists(sourceFile, new LinkOption[0])) throw new NoSuchFileException(sourceFile.toString());
        if (!Files.exists(targetFile.getParent(), new LinkOption[0])) {
            this.restoreDirectories(profile, targetFile.getParent(), tle.originalDir);
        }
        FileOperations.move(sourceFile, targetFile);
        Path eisFile = profileTrashFolder.resolve(trashHash + ".eis");
        String assetURLPath = tle.originalDir + "/" + tle.originalFilename;
        byte importStatus = 0;
        if (Files.exists(eisFile, new LinkOption[0])) {
            if (profile.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                Path targetEisFile = this.storageHelper.getEisFile(assetURLPath);
                boolean success = this.settings.getStorageManager().moveExternalFileToStorage(eisFile, assetURLPath, targetEisFile);
                importStatus = success ? (byte)1 : 2;
            } else {
                Files.delete(eisFile);
            }
        }
        if (Files.exists(trashMetaFile = profileTrashFolder.resolve(trashHash + ".meta"), new LinkOption[0])) {
            Path baseMetadataLocation = this.settings.getMetaDataLocation();
            Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
            FileOperations.move(trashMetaFile, metaDataFile);
        }
        trashList.removeEntry(trashHash);
        if (profile.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
            Path dirlistfile = this.storageHelper.getDirectoryFile(tle.originalDir);
            PoolFileEntry pe = new PoolFileEntry(tle.originalFilename, tle.originalLMDate, tle.sourceFileSize, -1, -1, importStatus);
            String parentAssetURLPath = URL.getParentAssetURLPath(tle.originalDir);
            Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.updateEntry(dirlistfile, tle.originalDir, parentDirlistFile, parentAssetURLPath, pe, tle.originalLMDate);
            this.settings.getMainManager().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(parentAssetURLPath, false);
        }
        this.getScannerDaemon().getMetaDataAndUpdateSearchDatabase(assetURLPath, false);
    }

    private ScannerDaemon getScannerDaemon() {
        MainManager importer = (MainManager)this.settings.getServletContext().getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
        return importer.getScannerDaemon();
    }

    private void moveCustomMetadataToTrash(String assetURLPath, String hash, Path profileTrashFolder) throws IOException {
        Path baseMetadataLocation = this.settings.getMetaDataLocation();
        Path metaDataFile = baseMetadataLocation.resolve(assetURLPath + ".meta");
        if (Files.exists(metaDataFile, new LinkOption[0])) {
            Path metadataTrashLocation = profileTrashFolder.resolve(hash + ".meta");
            FileOperations.move(metaDataFile, metadataTrashLocation);
        }
    }

    private void moveStorageContentToTrash(Path profileTrashFolder, String assetURLPath, String hash, Path sourceFile) throws CorruptReverseLookupException, NotConfiguredException, IOException {
        Path eisFile = this.storageHelper.getEisFile(assetURLPath);
        Path eisTrashLocation = profileTrashFolder.resolve(hash + ".eis");
        this.settings.getStorageManager().moveStorageFileToTrash(eisFile, assetURLPath, eisTrashLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStorageFileV1001(String assetURLPath) {
        Path target;
        boolean success = false;
        long newLastModified = 0L;
        Pair<SourceConnectorReader, String> x = this.expandPath(assetURLPath);
        if (x != null) {
            SourceConnectorReader p = x.getItem1();
            String relativeInboxPath = x.getItem2();
            Path srcFile = p.getInboxDirectory().resolve(relativeInboxPath);
            Path parentFile = srcFile.getParent();
            if (Files.exists(parentFile, new LinkOption[0])) {
                this.ioController.waitForRead();
                newLastModified = FileOperations.getSafeLastModified(parentFile);
                this.ioController.unlockRead();
            }
        }
        if (Files.exists(target = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(assetURLPath)).resolve(assetURLPath), new LinkOption[0])) {
            String name;
            String dir;
            int sp = assetURLPath.lastIndexOf("/");
            if (sp == -1) {
                dir = "/";
                name = assetURLPath;
            } else {
                dir = assetURLPath.substring(0, sp);
                name = assetURLPath.substring(sp);
            }
            this.removeDirListFileEntryV1001(dir, name, newLastModified);
            Path trashtarget = this.settings.getTrashLocation().resolve(Long.toString(System.currentTimeMillis()));
            this.ioController.waitForWrite();
            try {
                Files.move(target, trashtarget, new CopyOption[0]);
                success = true;
            }
            catch (IOException e) {
                success = false;
            }
            finally {
                this.ioController.unlockWrite();
            }
            if (!success) {
                this.deletePool.addFilepath(0, target, true);
            }
            if (this.settings.getSolrUpdater() != null) {
                this.settings.getSolrUpdater().deleteAssetAsync(assetURLPath);
            }
        }
        return success;
    }

    private void removeDirListFileEntryV1002(String dir, String entryname, long lastmodified) throws NotConfiguredException {
        Path dirlistfile = this.storageHelper.getDirectoryFile(dir);
        String parentAssetURLPath = URL.getParentAssetURLPath(dir);
        Path parentdirlistfile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
        this.imagelistfilewriter.removeEntry(dirlistfile, dir, parentdirlistfile, parentAssetURLPath, entryname, lastmodified);
    }

    void removeProfileFromStorageV1002(String profileName) throws NotConfiguredException, IOException {
        Path profileStorageDir = this.storageHelper.getProfileStorageBase(profileName);
        if (Files.exists(profileStorageDir, new LinkOption[0])) {
            FileOperations.deleteDir(profileStorageDir);
        }
    }

    private void removeDirListFileEntryV1001(String dir, String entryname, long lastmodified) {
        Path dirlistfile = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(dir) + dir).resolve("dirlist");
        try {
            String parentAssetURLPath = URL.getParentAssetURLPath(dir);
            Path parentdirlistfile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.removeEntry(dirlistfile, dir, parentdirlistfile, parentAssetURLPath, entryname, lastmodified);
        }
        catch (NotConfiguredException notConfiguredException) {
            // empty catch block
        }
    }

    private Pair<SourceConnectorReader, String> expandPath(String assetURLPath) {
        String profileprefix;
        int pos;
        Pair<SourceConnectorReader, String> result = null;
        if (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        if ((pos = assetURLPath.indexOf(47)) > 0 && this.prefixProfileMap.containsKey(profileprefix = assetURLPath.substring(0, pos))) {
            String relativeInboxPath = assetURLPath.substring(profileprefix.length());
            SourceConnectorReader p = this.prefixProfileMap.get(profileprefix);
            if (p != null) {
                result = new Pair<SourceConnectorReader, String>(p, relativeInboxPath);
            }
        }
        return result;
    }

    protected void halt() {
        this.runDaemon = false;
        this.interrupt();
    }
}

