/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import com.neptunelabs.imagereader.MetaScanner;
import com.neptunelabs.imagereader.exif.ExifParser;
import com.neptunelabs.imagereader.iptc.IptcDirectoryReader;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;

public final class DirectoryImportHandler
extends Thread {
    private final BlockingQueue<DirectoryImportJob> directoriesToHandle = new LinkedBlockingQueue<DirectoryImportJob>();
    private final SourceManagerSettings settings;
    private final SwapPool swapPool;
    private final ExecutorPool executorPool;
    private final ImageListFileReader imagelistfilereader;
    private final ImageListFileWriter imagelistfilewriter;
    private final Converter_V1002 converterDaemon;
    private final DeleteDaemon deleteDaemon;
    private final IOController ioController;
    private final StorageManager storageManager;
    private final FSILogger logger;
    private final ScannerDaemon scannerDaemon;
    private static final String[] ignoredFiles = new String[]{":2eDS_Store", ":2elocalized"};
    private static final String[] ignoreDirs = new String[]{".erez", "Network Trash Folder", "Temporary Items"};
    private static final int MIN_FILE_AGE = 7;
    private Pattern pat_protectedDirs = null;
    private Pattern pat_protectedFiles = null;
    private volatile DirectoryImportJob currentJob;
    volatile STATE state = STATE.IDLE;
    private boolean cancelCurrent = false;
    private final DateFormat iso8601Formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public DirectoryImportHandler(ScannerDaemon scannerDaemon, ImageListFileReader imagelistfilereader, ImageListFileWriter imagelistfilewriter, SourceManagerSettings settings, SwapPool swapPool, ExecutorPool executorPool, Converter_V1002 converterDaemon, DeleteDaemon deleteDaemon, IOController ioController, StorageManager storageManager) {
        this.imagelistfilereader = imagelistfilereader;
        this.imagelistfilewriter = imagelistfilewriter;
        this.settings = settings;
        this.swapPool = swapPool;
        this.executorPool = executorPool;
        this.converterDaemon = converterDaemon;
        this.deleteDaemon = deleteDaemon;
        this.ioController = ioController;
        this.setupProtectedDirs();
        this.setupProtectedFiles();
        this.iso8601Formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setDaemon(true);
        this.setName("Directory Import Handler");
        this.storageManager = storageManager;
        this.scannerDaemon = scannerDaemon;
        this.logger = settings.getFSILogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            if (this.state == STATE.STOPPING) {
                this.state = STATE.STOPPED;
                return;
            }
            try {
                this.state = STATE.IDLE;
                DirectoryImportJob job = this.directoriesToHandle.take();
                if (job != null) {
                    this.state = STATE.WORKING;
                    this.currentJob = job;
                    this.logger.log(3264, job.assetURLPath);
                    long jobStartTime = System.currentTimeMillis();
                    job.setStartTime(jobStartTime);
                    this.handleDirectory(job);
                    this.logger.log(3270, job.assetURLPath, System.currentTimeMillis() - jobStartTime, this.directoriesToHandle.size());
                    this.currentJob = null;
                    continue;
                }
                DirectoryImportHandler.yield();
                continue;
            }
            catch (InterruptedException e) {
                this.state = STATE.STOPPING;
                continue;
            }
            catch (NotConfiguredException e) {
                this.state = STATE.STOPPING;
                continue;
            }
            catch (CorruptStorageException e) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String processedDir = this.currentJob != null ? this.currentJob.directory.toAbsolutePath().toString() : "unknown directory";
                this.logger.log(3232, processedDir, e.getClass().getName() + " : " + e.getMessage());
                continue;
            }
            finally {
                this.currentJob = null;
                continue;
            }
            break;
        }
    }

    public void processJob(DirectoryImportJob job) throws CorruptStorageException, NotConfiguredException, IOException {
        if (!this.directoriesToHandle.contains(job)) {
            this.handleDirectory(job);
        }
    }

    private int getCurrentReaderVersion(ImageFormat.Type type) {
        int currentReader;
        switch (type) {
            case BMP: {
                currentReader = 258;
                break;
            }
            case FPX: {
                currentReader = 259;
                break;
            }
            case GIF: {
                currentReader = 258;
                break;
            }
            case JPG: {
                currentReader = 258;
                break;
            }
            case PNG: {
                currentReader = 258;
                break;
            }
            case TIF: {
                currentReader = 259;
                break;
            }
            default: {
                currentReader = -1;
            }
        }
        return currentReader;
    }

    public void cancelCurrent() {
        if (this.state != STATE.IDLE) {
            this.cancelCurrent = true;
        }
    }

    public DirectoryImportJob getCurrentJob() {
        return this.currentJob;
    }

    private void handleDirectory(DirectoryImportJob job) throws CorruptStorageException, NotConfiguredException, IOException {
        Path parentDirlistFile;
        PoolList poollist;
        Path dirlistfile;
        if (job.dirlistfile == null) {
            job.dirlistfile = this.settings.getStorageHelper().getDirectoryFile(job.assetURLPath);
        }
        if (Files.notExists(dirlistfile = job.dirlistfile, new LinkOption[0])) {
            poollist = new PoolList(dirlistfile, job.assetURLPath);
        } else {
            try {
                poollist = this.imagelistfilereader.getListFileContents(dirlistfile, job.assetURLPath);
            }
            catch (NoSuchFileException fnfe) {
                poollist = new PoolList(dirlistfile, job.assetURLPath);
            }
            catch (IOException e) {
                this.logger.log(3249, job.assetURLPath, dirlistfile);
                poollist = new PoolList(dirlistfile, job.assetURLPath);
            }
        }
        ArrayList<PoolEntry> entriesToBeUpdated = new ArrayList<PoolEntry>();
        Set<String> filenamesToCheckforDeletion = poollist.getImageNameSet();
        Set<String> dirnamesToCheckForDeletion = poollist.getDirectoryNameSet();
        LinkedList<FileImportJob> importJobsToSubmit = new LinkedList<FileImportJob>();
        Deque<PathCached> directoryContents = this.listAllFiles(job.directory);
        if (directoryContents == null) {
            if (Files.exists(job.directory, new LinkOption[0])) {
                directoryContents = new ArrayDeque<PathCached>();
            } else {
                this.deleteDaemon.removeStorageDirectory(job.assetURLPath, "V1002");
                return;
            }
        }
        int filePassCount = 0;
        int fileTotalCount = directoryContents.size();
        for (PathCached fp : directoryContents) {
            if (this.cancelCurrent) {
                this.cancelCurrent = false;
                return;
            }
            if (this.state == STATE.STOPPING) break;
            ++filePassCount;
            if (fp.isRegularFile()) {
                String assetURLPath;
                ImageFormatScanner ifs = ImageFormatScanner.getInstance();
                ImageFormat format = ifs.scanFile(fp);
                FileImportJob compare = new FileImportJob(QueueType.SCAN, fp, format, assetURLPath = job.assetURLPath + "/" + fp.getFileName());
                if (!this.converterDaemon.isFileBeingProcessed(compare)) {
                    if (job.sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                        boolean byPassChecks = false;
                        PoolFileEntry byPassCheckEntry = poollist.getImage(fp.getFileName());
                        if (byPassCheckEntry != null && byPassCheckEntry.importStatus == 2) {
                            byPassChecks = true;
                        }
                        if (byPassChecks || format.isImage && format.type != ImageFormat.Type.UNK && this.isValidFilename(fp, true)) {
                            PoolFileEntry pe;
                            ImageMetaData imd;
                            Path eisFile;
                            boolean writeTemporaryEISFile;
                            boolean importImage;
                            block123: {
                                importImage = false;
                                writeTemporaryEISFile = false;
                                eisFile = this.settings.getStorageHelper().getEisFile(assetURLPath);
                                imd = null;
                                if (job.repairMode || this.settings.isMigrationModeEnabled()) {
                                    if (Files.exists(eisFile, new LinkOption[0])) {
                                        Path realEISImageFile = this.storageManager.getRealEISImageFile(assetURLPath);
                                        if (realEISImageFile != null) {
                                            try (EISReader reader = new EISReader(assetURLPath, realEISImageFile, this.settings, this.swapPool, this.executorPool, false);){
                                                long eisSize;
                                                long srcSize;
                                                int currentReader;
                                                int readerVersion;
                                                imd = reader.getImageMetaData();
                                                if (job.recheckErrorImages && imd.getImportStatus() == 3 && (readerVersion = imd.getImageReaderVersion()) != (currentReader = this.getCurrentReaderVersion(format.type))) {
                                                    this.logger.log(3226, assetURLPath, "broken image and recheck enabled");
                                                    importImage = true;
                                                }
                                                if (imd == null) break block123;
                                                if (!importImage) {
                                                    if (imd.getImportStatus() == 4) {
                                                        this.logger.log(3226, assetURLPath, "status is reimport");
                                                        importImage = true;
                                                    } else if (imd.getImportStatus() == 2) {
                                                        this.logger.log(3226, assetURLPath, "status is queued");
                                                        importImage = true;
                                                    } else if (imd.getImportStatus() == 0) {
                                                        this.logger.log(3226, assetURLPath, "status is unknown");
                                                        importImage = true;
                                                    }
                                                }
                                                if (!importImage && (srcSize = fp.size()) != (eisSize = imd.getSourceFileSize())) {
                                                    this.logger.log(3226, assetURLPath, "filesize has changed " + srcSize + "!=" + eisSize + " in " + eisFile);
                                                    importImage = true;
                                                }
                                                if (!importImage) {
                                                    long eisLastModified = imd.getLastModified();
                                                    if (fp.lastModified() != eisLastModified) {
                                                        this.logger.log(3226, assetURLPath, "lm-date has changed");
                                                        importImage = true;
                                                    }
                                                }
                                            }
                                            catch (NoSuchFileException fnfe) {
                                                importImage = true;
                                                writeTemporaryEISFile = true;
                                            }
                                            catch (NotAValidEISFileException e) {
                                                Files.delete(realEISImageFile);
                                                this.logger.log(3226, assetURLPath, "corrupt storage file");
                                                importImage = true;
                                                writeTemporaryEISFile = true;
                                            }
                                            catch (IOException ioe) {
                                                this.logger.log(3227, assetURLPath, realEISImageFile, ioe.getLocalizedMessage());
                                            }
                                            catch (Exception e) {
                                                this.logger.log(3227, assetURLPath, realEISImageFile, e.getLocalizedMessage());
                                                writeTemporaryEISFile = true;
                                            }
                                        } else {
                                            importImage = true;
                                            writeTemporaryEISFile = true;
                                        }
                                    } else {
                                        this.logger.log(3226, assetURLPath, "new file");
                                        importImage = true;
                                        writeTemporaryEISFile = true;
                                    }
                                } else if (filenamesToCheckforDeletion.contains(fp.getFileName())) {
                                    long eisSize;
                                    long srcSize;
                                    pe = poollist.getImage(fp.getFileName());
                                    if (job.recheckErrorImages && pe.importStatus == 3) {
                                        if (Files.exists(eisFile, new LinkOption[0])) {
                                            Path realEISImageFile = this.storageManager.getRealEISImageFile(assetURLPath);
                                            if (realEISImageFile != null) {
                                                try (EISReader reader = new EISReader(assetURLPath, realEISImageFile, this.settings, this.swapPool, this.executorPool, false);){
                                                    imd = reader.getImageMetaData();
                                                    int readerVersion = imd.getImageReaderVersion();
                                                    int currentReader = this.getCurrentReaderVersion(format.type);
                                                    if (readerVersion != currentReader) {
                                                        this.logger.log(3226, assetURLPath, "broken image and recheck enabled");
                                                        importImage = true;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    importImage = true;
                                                }
                                            } else {
                                                importImage = true;
                                                writeTemporaryEISFile = true;
                                            }
                                        } else {
                                            importImage = true;
                                            writeTemporaryEISFile = true;
                                        }
                                    }
                                    if (!importImage) {
                                        if (pe.importStatus == 4) {
                                            this.logger.log(3226, assetURLPath, "status is reimport");
                                            importImage = true;
                                        } else if (pe.importStatus == 2) {
                                            this.logger.log(3226, assetURLPath, "status is queued");
                                            importImage = true;
                                        } else if (pe.importStatus == 0) {
                                            this.logger.log(3226, assetURLPath, "status is unknown");
                                            importImage = true;
                                        }
                                    }
                                    if (!importImage && (srcSize = fp.size()) != (eisSize = pe.filesize)) {
                                        this.logger.log(3226, assetURLPath, "filesize has changed " + srcSize + "!=" + eisSize + " in " + eisFile.toString());
                                        importImage = true;
                                    }
                                    if (!importImage) {
                                        long eisLastModified = pe.lastmodified;
                                        if (fp.lastModified() != eisLastModified) {
                                            this.logger.log(3226, assetURLPath, "lm-date has changed");
                                            importImage = true;
                                        }
                                    }
                                } else if (Files.exists(eisFile, new LinkOption[0])) {
                                    importImage = true;
                                } else {
                                    this.logger.log(3226, assetURLPath, "new file");
                                    importImage = true;
                                    writeTemporaryEISFile = true;
                                }
                            }
                            if (importImage) {
                                FileImportJob fileImportJob = new FileImportJob(QueueType.SCAN, job.sourceConnector, fp, format, eisFile, assetURLPath, Converter_V1002.evaluatePriority(QueueType.SCAN), job.recheckErrorImages);
                                fileImportJob.dirlistFile = dirlistfile;
                                if (writeTemporaryEISFile) {
                                    EISImageWriter eisWriter = new EISImageWriter(this.settings, 2, -1);
                                    eisWriter.setAssetURLPath(fileImportJob.assetURLPath);
                                    this.storageManager.executeStorageDataProvider(eisFile, eisWriter);
                                    PoolFileEntry pe2 = new PoolFileEntry(fp.getFileName(), fp.lastModified(), fp.size(), -1, -1, 2);
                                    entriesToBeUpdated.add(pe2);
                                }
                                importJobsToSubmit.add(fileImportJob);
                            } else if (job.repairMode && imd != null && ((pe = poollist.getImage(fp.getFileName())) == null || pe.filesize != imd.getSourceFileSize() || pe.importStatus != imd.getImportStatus() || pe.lastmodified != imd.getLastModified() || pe.width != imd.getWidth() || pe.height != imd.getHeight())) {
                                PoolFileEntry newPoolEntry = new PoolFileEntry(fp.getFileName(), fp.lastModified(), imd.getSourceFileSize(), imd.getWidth(), imd.getHeight(), imd.getImportStatus());
                                entriesToBeUpdated.add(newPoolEntry);
                            }
                        }
                    } else {
                        long sourceFileSize = fp.size();
                        PoolFileEntry pe = poollist.getImage(fp.getFileName());
                        if ((pe == null || pe.filesize != sourceFileSize || pe.lastmodified != fp.lastModified() || pe.importStatus != 1) && (job.sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC || job.sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION && format.isImage)) {
                            PoolFileEntry newPoolEntry = new PoolFileEntry(fp.getFileName(), fp.lastModified(), sourceFileSize, -1, -1, 1);
                            HashMap<String, String> metadata = new HashMap<String, String>();
                            metadata.put("file.type", "file");
                            metadata.put("file.name", fp.getFileName());
                            metadata.put("file.prefix", format.prefix);
                            metadata.put("file.suffix", format.suffix);
                            metadata.put("file.size", String.valueOf(sourceFileSize));
                            metadata.put("file.lastmodified", this.iso8601Formatter.format(new Date(fp.lastModified())));
                            if (job.sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION && this.state != STATE.STOPPING && this.isPyramidFileSupported(fp, format)) {
                                byte[] exif;
                                this.logger.log(3141, fp, filePassCount, fileTotalCount);
                                MetaScanner mscanner = new MetaScanner(this.settings.getFSILogger(), this.ioController);
                                FSIMetaData metaData = mscanner.scanImage(fp, false);
                                newPoolEntry.height = metaData.getHeight();
                                newPoolEntry.width = metaData.getWidth();
                                metadata.put("file.height", String.valueOf(metaData.getHeight()));
                                metadata.put("file.width", String.valueOf(metaData.getWidth()));
                                byte[] iptc = metaData.getIPTC();
                                if (iptc != null && iptc.length > 0) {
                                    Map<Pair<String, String>, String> iptcmap = IptcDirectoryReader.getIptcMap(iptc);
                                    for (Map.Entry<Pair<String, String>, String> entry : iptcmap.entrySet()) {
                                        metadata.put("iptc." + entry.getKey().getItem2(), entry.getValue());
                                    }
                                }
                                if ((exif = metaData.getExif()) != null && exif.length > 0) {
                                    ExifParser ep = ExifParser.getInstance(this.settings.getFSILogger());
                                    ep.setName(fp.getAbsolutePath().toString());
                                    ep.scanExif(exif);
                                    Map<Pair<Integer, String>, String> exifmap = ep.getShortMap();
                                    for (Map.Entry<Pair<Integer, String>, String> entry : exifmap.entrySet()) {
                                        metadata.put("exif." + entry.getKey().getItem2(), entry.getValue());
                                    }
                                }
                            }
                            if (this.state != STATE.STOPPING) {
                                boolean successUpdateDB;
                                if (this.settings.getSolrUpdater() != null && !(successUpdateDB = this.settings.getSolrUpdater().setMetaDataASync(job.assetURLPath + "/" + fp.getFileName(), metadata, false))) {
                                    this.logger.log(3236, job.assetURLPath + "/" + fp.getFileName());
                                }
                                entriesToBeUpdated.add(newPoolEntry);
                            }
                        }
                    }
                }
            } else if (this.isRecursableDir(fp) && this.state != STATE.STOPPING) {
                if (dirnamesToCheckForDeletion.contains(fp.getFileName())) {
                    dirnamesToCheckForDeletion.remove(fp.getFileName());
                } else {
                    entriesToBeUpdated.add(new PoolDirectoryEntry(fp.getFileName(), fp.lastModified(), 0L, 0L));
                }
            }
            filenamesToCheckforDeletion.remove(fp.getFileName());
        }
        if (this.state != STATE.STOPPING) {
            HashSet entriesToRemoveFromSDB = new HashSet();
            for (String filename : filenamesToCheckforDeletion) {
                String fileAssetURLPath = job.assetURLPath + "/" + filename;
                String parentAssetURLPath = URL.getParentAssetURLPath(job.assetURLPath);
                Path parentDirlistFile2 = this.settings.getStorageHelper().getDirectoryFile(parentAssetURLPath);
                this.imagelistfilewriter.removeEntry(dirlistfile, job.assetURLPath, parentDirlistFile2, parentAssetURLPath, filename, poollist.lastmodified);
                if (job.sourceConnector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE) {
                    try {
                        this.deleteDaemon.removeStorageFileV1002(fileAssetURLPath, job.sourceConnector, false);
                    }
                    catch (IOException e) {
                        this.settings.getFSILogger().logException(e, 3228, "remove", fileAssetURLPath, "");
                        e.printStackTrace();
                    }
                }
                entriesToRemoveFromSDB.add(fileAssetURLPath);
            }
            if (this.settings.getSolrUpdater() != null && entriesToRemoveFromSDB.size() > 0) {
                this.settings.getSolrUpdater().deleteAssetsAsync(entriesToRemoveFromSDB);
            }
        }
        if (this.state != STATE.STOPPING) {
            for (String directoryName : dirnamesToCheckForDeletion) {
                String assetURLPath = job.assetURLPath + "/" + directoryName;
                this.deleteDaemon.removeStorageDirectory(assetURLPath, "V1002");
            }
        }
        long lmDateToSet = job.lastModified;
        if (this.state == STATE.STOPPING) {
            lmDateToSet = -1L;
        }
        if (entriesToBeUpdated.size() > 0) {
            String parentAssetURLPath = URL.getParentAssetURLPath(job.assetURLPath);
            parentDirlistFile = this.settings.getStorageHelper().getDirectoryFile(parentAssetURLPath);
            this.imagelistfilewriter.updateEntries(dirlistfile, job.assetURLPath, parentDirlistFile, parentAssetURLPath, entriesToBeUpdated, lmDateToSet);
            this.scannerDaemon.getMetaDataAndUpdateSearchDatabase(job.assetURLPath, false);
        } else if (poollist.lastmodified != job.lastModified) {
            this.imagelistfilewriter.updateLastModified(dirlistfile, job.assetURLPath, lmDateToSet);
            this.scannerDaemon.getMetaDataAndUpdateSearchDatabase(job.assetURLPath, false);
        } else if (this.state != STATE.STOPPING) {
            String parentAssetURLPath = URL.getParentAssetURLPath(job.assetURLPath);
            parentDirlistFile = this.settings.getStorageHelper().getDirectoryFile(parentAssetURLPath);
            PoolList plist = this.imagelistfilereader.getListFileContents(dirlistfile, job.assetURLPath);
            PoolList parentlist = this.imagelistfilereader.getListFileContents(parentDirlistFile, parentAssetURLPath);
            String dirname = parentAssetURLPath.length() > 1 ? job.assetURLPath.substring(parentAssetURLPath.length() + 1) : job.assetURLPath;
            PoolDirectoryEntry entryInParent = parentlist.getDirectory(dirname);
            boolean update = false;
            if (entryInParent != null) {
                if (entryInParent.files != (long)plist.getFileCount()) {
                    entryInParent.files = plist.getFileCount();
                    update = true;
                }
                if (entryInParent.subdirectories != (long)plist.getDirectoryCount()) {
                    entryInParent.subdirectories = plist.getDirectoryCount();
                    update = true;
                }
                if (entryInParent.lastmodified != plist.lastmodified) {
                    entryInParent.lastmodified = plist.lastmodified;
                    update = true;
                }
            }
            if (update) {
                this.imagelistfilewriter.updateEntry(parentDirlistFile, parentAssetURLPath, null, null, entryInParent, -1L);
                this.scannerDaemon.getMetaDataAndUpdateSearchDatabase(parentAssetURLPath, false);
            }
        }
        if (importJobsToSubmit.size() > 0 && this.state != STATE.STOPPING) {
            block37: for (FileImportJob importJob : importJobsToSubmit) {
                while (!this.converterDaemon.enqueueJob(importJob)) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        continue block37;
                    }
                }
            }
        }
    }

    public boolean isValidFilename(PathCached fp, boolean checkLastModified) throws IOException {
        int t = (int)((System.currentTimeMillis() - fp.lastModified()) / 1000L);
        if (checkLastModified && (t > 7 || t < 0) || !checkLastModified) {
            if (!fp.isReadable()) {
                return false;
            }
            if (fp.isHidden()) {
                return false;
            }
            for (String ignoredFile : ignoredFiles) {
                if (!fp.getFileName().equals(ignoredFile)) continue;
                return false;
            }
            return this.pat_protectedFiles == null || !this.pat_protectedFiles.matcher(fp.getFileName()).find();
        }
        return false;
    }

    protected boolean isRecursableDir(PathCached fp) {
        if (!fp.isDirectory()) {
            return false;
        }
        if (fp.isHidden()) {
            return false;
        }
        for (String fuckDir : ignoreDirs) {
            if (!fp.getFileName().equals(fuckDir)) continue;
            return false;
        }
        return this.pat_protectedDirs == null || !this.pat_protectedDirs.matcher(fp.getFileName()).find();
    }

    private boolean isPyramidFileSupported(PathCached fp, ImageFormat format) {
        if (fp.isHidden()) {
            return false;
        }
        for (String ignoredFile : ignoredFiles) {
            if (!fp.getFileName().equals(ignoredFile)) continue;
            return false;
        }
        boolean pass = false;
        if (format.type == ImageFormat.Type.TIF) {
            pass = true;
        } else if (format.type == ImageFormat.Type.FPX) {
            pass = true;
        }
        return pass;
    }

    public boolean submitDirectory(SourceConnectorReader connector, Path directory, long directoryLastModified, String assetURLPath, boolean recheckErrorImages, boolean repairMode) {
        boolean result = false;
        DirectoryImportJob newJob = new DirectoryImportJob(connector, directory, assetURLPath, directoryLastModified, recheckErrorImages, repairMode);
        if ((this.currentJob == null || !newJob.equals(this.currentJob) && !this.directoriesToHandle.contains(newJob)) && (result = this.directoriesToHandle.offer(newJob))) {
            this.logger.log(3224, directory);
        }
        return result;
    }

    public boolean isDirectoryEnqueued(Path directory, String assetURLPath, boolean repairMode) {
        DirectoryImportJob compareJob = new DirectoryImportJob(null, null, assetURLPath, 0L, false, repairMode);
        boolean result = this.directoriesToHandle.contains(compareJob);
        if (!result) {
            result = compareJob.equals(this.currentJob);
        }
        return result;
    }

    private static void createProtectedFilesEntryPattern(String fileIn, StringBuilder protFileSB, boolean isNotLast) {
        String file = fileIn.replace(".", "\\.");
        file = file.replace("*", ".*");
        protFileSB.append(file);
        if (isNotLast) {
            protFileSB.append('|');
        }
    }

    private void setupProtectedDirs() {
        List<String> protDirsArray = this.settings.getPrefsValues("protected_dirs", "dir");
        if (protDirsArray != null) {
            StringBuilder protDirSB = new StringBuilder("^(");
            for (int p = 0; p < protDirsArray.size(); ++p) {
                DirectoryImportHandler.createProtectedFilesEntryPattern(protDirsArray.get(p), protDirSB, p + 1 < protDirsArray.size());
            }
            protDirSB.append(")$");
            String protDirStr = protDirSB.toString().trim();
            this.pat_protectedDirs = protDirStr.length() > 0 ? Pattern.compile(protDirStr) : null;
        }
    }

    private void setupProtectedFiles() {
        List<String> protFilesList = this.settings.getPrefsValues("protected_files", "protected_files");
        if (protFilesList != null && protFilesList.size() > 0) {
            StringBuilder protFileSB = new StringBuilder("^(");
            for (int p = 0; p < protFilesList.size(); ++p) {
                DirectoryImportHandler.createProtectedFilesEntryPattern(protFilesList.get(p), protFileSB, p + 1 < protFilesList.size());
            }
            protFileSB.append(")$");
            String protFileStr = protFileSB.toString().trim();
            this.pat_protectedFiles = protFileStr.length() > 0 ? Pattern.compile(protFileStr) : null;
        }
    }

    protected void shutdown() {
        this.state = STATE.STOPPING;
        this.interrupt();
    }

    private Deque<PathCached> listAllFiles(final Path baseDir) throws IOException {
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> result = new ArrayDeque<PathCached>();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (DirectoryImportHandler.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                if (baseDir.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                result.add(new PathCached(dir, attrs));
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (DirectoryImportHandler.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                if (attrs.isRegularFile()) {
                    result.add(new PathCached(file, attrs));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    private static enum STATE {
        IDLE,
        WORKING,
        STOPPING,
        STOPPED;

    }
}

