/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.imagereader.ImageReader;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.nio.ByteOrder;

class ImageReaderFactory {
    private final FSILogger logger;
    private final Converter_V1002 converterManager;
    private final SwapPool swapPool;
    private final BufferedImageConverterThreaded converter;
    private final PluginLoader pluginLoader;
    private final ByteOrder byteOrder;

    ImageReaderFactory(FSILogger logger, Converter_V1002 converterManager, BufferedImageConverterThreaded converter, SwapPool swapPool, PluginLoader pluginLoader, ByteOrder byteOrder) {
        this.logger = logger;
        this.converterManager = converterManager;
        this.converter = converter;
        this.swapPool = swapPool;
        this.pluginLoader = pluginLoader;
        this.byteOrder = byteOrder;
    }

    ImageReader createImageReader(FileImportJob importJob, FSIMetaData metaData, boolean prefetch) {
        long bytes;
        long freeHeap = MemoryManager.getFreeHeapSpace();
        boolean useSwap = (double)freeHeap * 0.75 < (double)(bytes = 4L * (long)metaData.getWidth() * (long)metaData.getHeight());
        ImageReader result = new ImageReader(this.logger, this.converterManager.getExecutorPool(), this.swapPool, this.converter, this.pluginLoader, metaData, useSwap, this.byteOrder, importJob.getType().name(), prefetch, importJob.makeHistogram);
        return result;
    }
}

