/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.helpers.RegexUtils;
import com.neptunelabs.fsiframework.helpers.deletepool.DeletePool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.JavaInformation;
import com.neptunelabs.fsiframework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiframework.systeminformation.VMVendor;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.search.SDBChecker;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.guru.GuruMeditationHook;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.MetaDataFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiservletframework.ExtendedServlet;
import com.neptunelabs.fsiservletframework.prerequisites.JavaEEServer;
import com.neptunelabs.fsiservletframework.prerequisites.Prerequisites;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.utils.ThreadLocalsCleaner;
import com.neptunelabs.imageioimpl.common.Register;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="SourceManager", loadOnStartup=3, urlPatterns={"/importer/*"}, initParams={@WebInitParam(name="autorestart", value="true")})
public final class MainManager
extends HttpServlet
implements ExtendedServlet {
    private static final long serialVersionUID = -8598334258291299121L;
    private final SystemInformation sysinfo = new SystemInformation();
    private transient SourceManagerSettings settings;
    private transient PluginLoader pluginLoader;
    private final transient Version version = new Version();
    private transient ScannerDaemon scannerDaemon = null;
    private transient SDBChecker sdbChecker = null;
    private transient Converter_V1002 converterManagerV1002 = null;
    private transient DownloadJobProcessor jobProcessor = null;
    private transient DeleteDaemon deleteDaemon = null;
    private transient DeletePool deletePool = null;
    private transient ServletFileEventCursor fileEventCursor = null;
    private transient ImageListFileReader imagelistfilereader = null;
    private transient ImageListFileWriter imagelistfilewriter = null;
    private transient IOController ioController = null;
    private transient StorageManager storageManager = null;
    private ServletContext servletContext = null;
    private volatile boolean running = false;
    private String servletInitErrorMessage = null;
    private String servletInitWarningMessage = null;
    private String servletRuntimeErrorMessage = null;
    private String servletRuntimeWarningMessage = null;
    private final String statisticsMessage;
    private transient GuruMeditationHook uncaughtExceptionLogger;
    private transient SwapPool swapPool;
    private long startTime = 0L;
    private Path regularTempDir;

    public MainManager() {
        this.statisticsMessage = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.startTime = System.currentTimeMillis();
        this.servletInitErrorMessage = null;
        this.servletInitWarningMessage = null;
        this.uncaughtExceptionLogger = new GuruMeditationHook((GenericServlet)this);
        try {
            this.servletContext = config.getServletContext();
            Path configHome = this.setupConfigHome();
            FSILogger logger = this.initFSILogger(configHome);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager", (Object)this);
            this.servletContext.setAttribute("AdministratorKeyStorePath", (Object)configHome.resolve("administrator.key"));
            SoftwareVersion.setSoftware(logger, this.version);
            logger.log(2001, SoftwareVersion.getSoftware(true), this.servletContext.getServerInfo(), this.sysinfo.getJVMVersionDetailedWithArch());
            logger.log(2935, "Vendor", this.sysinfo.getJVMInformation());
            JavaInformation ji = new JavaInformation();
            List<String> aList = ji.getStartOptions();
            StringBuilder jvmSb = new StringBuilder();
            for (int i = 0; i < aList.size(); ++i) {
                jvmSb.append(aList.get(i));
                if (i >= aList.size() - 1) continue;
                jvmSb.append(' ');
            }
            logger.log(2935, "Start Options", jvmSb.toString());
            MemoryManager memManager = MemoryManager.getInstance();
            long maxYoungGen = memManager.getMaxYoungGen();
            if (maxYoungGen > 0L) {
                logger.log(2935, "Max Old/Young Gen", FormatBytes.byteToString(memManager.getMaxOldGen(), 3, 1) + "/" + FormatBytes.byteToString(memManager.getMaxYoungGen(), 3, 1));
            } else {
                logger.log(2935, "Max Old Gen", FormatBytes.byteToString(memManager.getMaxOldGen(), 3, 1));
            }
            if (memManager.usesG1GC()) {
                logger.log(2935, "Using G1", "true");
            }
            logger.log(2935, "Encoding", this.sysinfo.getFileEncoding() + "/" + this.sysinfo.getJNUEncoding());
            this.fileEventCursor = new ServletFileEventCursor(logger);
            this.fileEventCursor.start();
            this.servletContext.setAttribute("fileEventCursor", (Object)this.fileEventCursor);
            this.settings = new SourceManagerSettings(this, Boolean.parseBoolean(config.getInitParameter("autorestart")), logger, this.fileEventCursor);
            this.settings.setMainManager(this);
            FSILogger apiLogger = new FSILogger(configHome, "APILogger", "com/neptunelabs/fsiserver/resources/api_codes.properties", "log4j", false);
            apiLogger.addCodes("com/neptunelabs/fsiservletframework/resources/log4j_codes.properties");
            apiLogger.start();
            this.settings.setAPILogger(apiLogger);
            this.settings.getServletContext().setAttribute("fsiSoftwareID", (Object)SoftwareVersion.getSoftwareID());
            if (this.checkPrerequisites(config, this.settings.getFSILogger(), Runtime.getRuntime().availableProcessors())) {
                long startMTime = System.currentTimeMillis();
                this.settings.initFileLockHandler();
                this.settings.getFSILogger().log(3204, "FileLockHandler", System.currentTimeMillis() - startMTime);
                this.ioController = new IOController();
                this.settings.setIOController(this.ioController);
                this.servletContext.setAttribute("IOController", (Object)this.ioController);
                this.start();
            } else {
                this.destroy();
            }
        }
        catch (Exception e) {
            this.uncaughtExceptionLogger.uncaughtException(null, e);
        }
    }

    private FSILogger initFSILogger(Path configHome) {
        FSILogger logger = new FSILogger(configHome, "SourceManager", "com/neptunelabs/fsiserver/resources/log4j_codes.properties", "log4j");
        logger.addCodes("com/neptunelabs/fsiframework/resources/log4j_codes.properties");
        logger.addCodes("com/neptunelabs/fsiservletframework/resources/log4j_codes.properties");
        logger.addCodes("com/neptunelabs/imagereader/resources/log4j_codes.properties");
        logger.addCodes("com/neptunelabs/imagemanipulator/resources/log4j_codes.properties");
        logger.start();
        this.uncaughtExceptionLogger.setLogger(logger);
        return logger;
    }

    protected void checkMigrationMode() throws IOException {
        boolean migrationMode = false;
        Path storageLocation = this.settings.getStorageLocation();
        Path v1001Subdir = storageLocation.resolve("V1001");
        if (Files.exists(v1001Subdir, new LinkOption[0])) {
            List<PathCached> entries = FileOperations.listAllFiles(v1001Subdir, "*", 0, 1);
            if (entries.size() > 0) {
                migrationMode = true;
            } else {
                FileOperations.deleteDir(v1001Subdir);
            }
        }
        this.settings.setMigrationModeEnabled(migrationMode);
        this.servletContext.setAttribute("V1001MigrationMode", (Object)migrationMode);
    }

    @Override
    public void start() {
        long startMTimeTotal;
        block36: {
            this.startTime = System.currentTimeMillis();
            this.servletRuntimeErrorMessage = null;
            this.servletRuntimeWarningMessage = null;
            startMTimeTotal = System.currentTimeMillis();
            try {
                Register r = new Register();
                r.initPlugins();
                long startMTime = System.currentTimeMillis();
                this.settings.readConfigs();
                this.settings.getFSILogger().log(3204, "ReadConfigs", System.currentTimeMillis() - startMTime);
                if (this.settings.hasSectionEnabled("application")) {
                    String cacheStartStr;
                    boolean cacheEnabled;
                    boolean directCache;
                    long maxBlockCache;
                    Path storageLocation = this.settings.getStorageLocation();
                    this.checkMigrationMode();
                    if (Files.notExists(storageLocation, new LinkOption[0])) {
                        this.settings.getFSILogger().log(2043, storageLocation);
                        this.servletRuntimeErrorMessage = "FSI Server not started: Storage Location does not exist.";
                        break block36;
                    }
                    if (!Files.isWritable(storageLocation)) {
                        this.settings.getFSILogger().log(2044, storageLocation);
                        this.servletRuntimeErrorMessage = "FSI Server not started: Storage Location not writable.";
                        break block36;
                    }
                    startMTime = System.currentTimeMillis();
                    String pluginBaseDirStr = System.getProperty("com.neptunelabs.fsiserver.plugin.home");
                    Path pluginBaseDir = null;
                    if (pluginBaseDirStr != null && !Files.isDirectory(pluginBaseDir = Paths.get(pluginBaseDirStr, new String[0]), new LinkOption[0])) {
                        pluginBaseDir = null;
                    }
                    if (pluginBaseDir == null) {
                        pluginBaseDir = ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("internal").resolve("plugins");
                    }
                    ClassLoader cl = this.servletContext.getClass().getClassLoader();
                    this.pluginLoader = new PluginLoader(this.settings.getFSILogger(), cl, this.sysinfo);
                    List<String> pluginList = PluginLoader.scanForPlugins(pluginBaseDir);
                    for (String plugin : pluginList) {
                        this.pluginLoader.loadPlugin(pluginBaseDir, plugin, "sourcemanager");
                    }
                    this.settings.setPluginLoader(this.pluginLoader);
                    this.settings.getFSILogger().log(3204, "Plugins", System.currentTimeMillis() - startMTime);
                    String hasherStr = this.settings.getPrefsString("application", "storagehasher");
                    StorageHelperV1002.Hasher hasher = null;
                    try {
                        if (hasherStr != null) {
                            hasherStr = hasherStr.toUpperCase();
                            hasher = StorageHelperV1002.Hasher.valueOf(hasherStr);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        hasher = StorageHelperV1002.Hasher.HASH32;
                    }
                    this.settings.setupStorageHelper(hasher, storageLocation);
                    this.settings.setupStorageID();
                    startMTime = System.currentTimeMillis();
                    this.initSwapPool();
                    this.settings.getFSILogger().log(3204, "SwapPool", System.currentTimeMillis() - startMTime);
                    startMTime = System.currentTimeMillis();
                    if (this.settings.hasSectionEnabled("cache")) {
                        maxBlockCache = this.settings.evaluateMaxBlockCache(this.settings.getPrefsString("cache", "maxmemory"));
                        directCache = this.settings.getPrefsBoolean("cache", "directmemory");
                        cacheEnabled = true;
                    } else {
                        cacheEnabled = false;
                        maxBlockCache = 0L;
                        directCache = false;
                    }
                    boolean useL1 = this.settings.getPrefsBoolean("cache", "l1");
                    int l1Size = this.settings.getPrefsInt("cache", "l1size");
                    if (l1Size <= 0) {
                        l1Size = 0;
                    }
                    boolean useL2 = this.settings.getPrefsBoolean("cache", "l2");
                    boolean cacheResponse = this.settings.getPrefsBoolean("cache", "response");
                    boolean packAsync = this.settings.getPrefsBoolean("cache", "packasync");
                    this.settings.initCacheManager(cacheEnabled, maxBlockCache, directCache, useL1, l1Size, useL2, cacheResponse, packAsync);
                    CacheManager cacheManager = this.settings.getCacheManager();
                    if (cacheManager != null && cacheManager.getAllocatedCacheSize() > 0L) {
                        long size = cacheManager.getAllocatedCacheSize();
                        long max = cacheManager.getMaximumCacheSize();
                        cacheStartStr = "CacheManager (" + FormatBytes.byteToString(size, 3, 1) + "/" + FormatBytes.byteToString(max, 3, 1) + ")";
                    } else {
                        cacheStartStr = "CacheManager (disabled)";
                    }
                    this.settings.getFSILogger().log(3204, cacheStartStr, System.currentTimeMillis() - startMTime);
                    boolean parallelRead = this.settings.getPrefsBoolean("application", "parallelread");
                    boolean parallelWrite = this.settings.getPrefsBoolean("application", "parallelwrite");
                    boolean parallelReadWrite = this.settings.getPrefsBoolean("application", "parallelreadwrite");
                    this.ioController.setParallelReadWriteLocks(parallelRead, parallelWrite, parallelReadWrite);
                    boolean logToStorage = this.settings.getPrefsBoolean("application", "logtostorage");
                    this.storageManager = new StorageManager(this.settings, this.settings.getStorageLocation(), logToStorage, this.settings.getCacheManager());
                    this.settings.setStorageManager(this.storageManager);
                    this.settings.initSourceConnectorWatcher();
                    startMTime = System.currentTimeMillis();
                    MetaDataFileReader metadatareader = new MetaDataFileReader(this.settings, this.ioController);
                    this.imagelistfilereader = new ImageListFileReader(this.settings, this.ioController, this.storageManager, true);
                    this.imagelistfilewriter = new ImageListFileWriter(this.settings, this.imagelistfilereader);
                    this.settings.getFSILogger().log(3204, "ImageList", System.currentTimeMillis() - startMTime);
                    startMTime = System.currentTimeMillis();
                    int conversionThreads = 3;
                    String conversionThreadsStr = this.settings.getPrefsString("application", "conversionthreads");
                    if (!conversionThreadsStr.equalsIgnoreCase("auto")) {
                        try {
                            conversionThreads = Integer.valueOf(conversionThreadsStr);
                        }
                        catch (NumberFormatException e) {
                            this.settings.getFSILogger().log(2503, "conversionthreads", conversionThreadsStr);
                        }
                    }
                    conversionThreads = conversionThreads <= 0 ? 1 : conversionThreads;
                    int[] res = this.settings.evaluateExecutorPoolThreads(conversionThreads);
                    int numberCruncherThreads = res[0];
                    int ioThreads = res[1];
                    int maxThreadsPerJobs = res[2];
                    ExecutorPool executorPool = this.settings.getExecutorPool();
                    if (executorPool == null) {
                        executorPool = new ExecutorPool(numberCruncherThreads, ioThreads, maxThreadsPerJobs);
                        this.servletContext.setAttribute("com.neptunelabs.fsiserver.ExecutorPool", (Object)executorPool);
                        this.settings.getFSILogger().log(2023, executorPool.getMaxThreads(ExecutorPool.Type.CONVERTER_CPU), executorPool.getMaxThreads(ExecutorPool.Type.CONVERTER_IO), executorPool.getMaxThreadsPerCPUJob());
                    } else {
                        executorPool.reinitialize(numberCruncherThreads, ioThreads, maxThreadsPerJobs);
                        this.settings.getFSILogger().log(2023, executorPool.getMaxThreads(ExecutorPool.Type.CONVERTER_CPU), executorPool.getMaxThreads(ExecutorPool.Type.CONVERTER_IO), executorPool.getMaxThreadsPerCPUJob());
                    }
                    this.settings.setExecutorPool(executorPool);
                    this.settings.setConversionThreads(conversionThreads);
                    this.initSystemMonitor();
                    this.settings.configureJMXSupport();
                    this.regularTempDir = this.settings.getWorkDirectory();
                    startMTime = System.currentTimeMillis();
                    this.deletePool = new DeletePool(this.settings.getFSILogger(), this.settings.getStorageLocation(), this.ioController);
                    this.deletePool.start();
                    if (Boolean.valueOf(System.getProperty("com.neptunelabs.useImageIOCache", "false")).booleanValue()) {
                        ImageIO.setUseCache(true);
                        ImageIO.setCacheDirectory(this.regularTempDir.toFile());
                    } else {
                        ImageIO.setUseCache(false);
                    }
                    boolean successInitMimes = this.settings.initMimeTypes(this.settings.getPrefsBoolean("scanner", "useMagicBytes"));
                    if (!successInitMimes) {
                        this.servletRuntimeErrorMessage = "MimeType declaration invalid";
                    }
                    this.settings.getFSILogger().log(3204, "DeletePool", System.currentTimeMillis() - startMTime);
                    startMTime = System.currentTimeMillis();
                    boolean converterRunning = this.settings.getPrefsBoolean("application", "import");
                    this.converterManagerV1002 = new Converter_V1002(this.uncaughtExceptionLogger, this.settings, executorPool, this.swapPool, this.scannerDaemon, this.pluginLoader, metadatareader, this.imagelistfilewriter, converterRunning);
                    this.converterManagerV1002.start();
                    if (!converterRunning) {
                        this.settings.getFSILogger().log(3204, "Converter disabled", System.currentTimeMillis() - startMTime);
                    } else if (this.settings.getPrefsBoolean("application", "prefetch")) {
                        int stct = this.settings.getConversionThreads();
                        this.settings.getFSILogger().log(3204, "Converter (" + stct + ") with prefetching", System.currentTimeMillis() - startMTime);
                    } else {
                        int stct = this.settings.getConversionThreads();
                        this.settings.getFSILogger().log(3204, "Converter (" + stct + ")", System.currentTimeMillis() - startMTime);
                    }
                    this.settings.setupSolrUpdater();
                    this.settings.initCacheDirectory();
                    startMTime = System.currentTimeMillis();
                    this.deleteDaemon = new DeleteDaemon(this.settings, this.deletePool, this.ioController, this.imagelistfilereader, this.imagelistfilewriter);
                    this.deleteDaemon.setDaemon(true);
                    this.deleteDaemon.setName("Delete Control Thread");
                    this.deleteDaemon.start();
                    this.settings.getFSILogger().log(3204, "Delete Daemon", System.currentTimeMillis() - startMTime);
                    startMTime = System.currentTimeMillis();
                    this.scannerDaemon = new ScannerDaemon(this.settings, this.converterManagerV1002, this.deleteDaemon, this.ioController, this.swapPool, executorPool, this.imagelistfilereader, this.imagelistfilewriter, this.storageManager, metadatareader);
                    this.scannerDaemon.setName("Scanner Thread V1002");
                    this.scannerDaemon.setDaemon(true);
                    if (this.settings.hasSectionEnabled("scanner")) {
                        this.settings.getFSILogger().log(3204, "Scanner Daemon", System.currentTimeMillis() - startMTime);
                    } else {
                        this.scannerDaemon.enableCountOnlyMode(true);
                        this.settings.getFSILogger().log(3214, new Object[0]);
                    }
                    this.scannerDaemon.start();
                    if (this.settings.hasSectionEnabled("search")) {
                        this.sdbChecker = new SDBChecker(this.settings, this.scannerDaemon);
                        this.sdbChecker.start();
                    }
                    this.jobProcessor = new DownloadJobProcessor(this.settings);
                    this.jobProcessor.start();
                    this.servletContext.setAttribute("JobProcessor", (Object)this.jobProcessor);
                    break block36;
                }
                this.settings.getFSILogger().log(2006, new Object[0]);
            }
            catch (Exception e) {
                this.settings.getFSILogger().logException(e, 9001, e.getLocalizedMessage());
                this.uncaughtExceptionLogger.uncaughtException(null, e);
            }
        }
        if (this.servletRuntimeErrorMessage != null) {
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.sourcemanager.startError", (Object)this.servletRuntimeErrorMessage);
        } else {
            this.running = true;
            if (this.servletRuntimeWarningMessage != null) {
                this.servletContext.setAttribute("com.neptunelabs.fsiserver.sourcemanager.startWarning", (Object)this.servletRuntimeWarningMessage);
            }
        }
        if (this.running) {
            this.settings.getFSILogger().log(3204, "SourceManager", System.currentTimeMillis() - startMTimeTotal);
            this.settings.getFSILogger().log(2019, new Object[0]);
        } else {
            this.settings.getFSILogger().log(2050, new Object[0]);
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.sendHaltSignalToConverter();
        if (this.settings.getFSILogger() != null) {
            this.settings.getFSILogger().log(2002, SoftwareVersion.getSoftware(true));
        }
        long startMTimeTotal = System.currentTimeMillis();
        if (!this.settings.isRestarting() && this.fileEventCursor != null) {
            this.fileEventCursor.halt();
        }
        if (this.jobProcessor != null) {
            this.jobProcessor.halt();
        }
        if (this.sdbChecker != null) {
            this.sdbChecker.halt();
        }
        if (this.storageManager != null) {
            this.storageManager.dispose();
        }
        this.sendStopSignalToScanner();
        this.stopDeletePoolAndDaemon();
        this.stopListBuffer();
        this.sendHaltNowSignalToConverter();
        this.waitForConverterStop();
        if (!this.settings.isRestarting()) {
            this.stopExecutorPool();
            this.hardStopExecutorPool();
        }
        this.shutdownSearchDatabase();
        this.settings.getFSILogger().log(3205, "Source Manager", System.currentTimeMillis() - startMTimeTotal);
        if (!this.settings.isRestarting()) {
            this.settings.getFSILogger().log(2018, new Object[0]);
            this.settings.dispose();
            if (this.settings.getAPILogger() != null) {
                this.settings.getAPILogger().shutdown();
            }
            this.settings.getFSILogger().shutdown();
        }
    }

    private void shutdownSearchDatabase() {
        if (this.settings.getSolrUpdater() != null) {
            long startMTime = System.currentTimeMillis();
            this.settings.getSolrUpdater().halt();
            if (this.settings.getSearchDatabaseSolr() != null) {
                this.settings.getSearchDatabaseSolr().halt();
            }
            this.settings.getFSILogger().log(3205, "SearchDatabase", System.currentTimeMillis() - startMTime);
        }
    }

    private void stopDeletePoolAndDaemon() {
        if (this.deletePool != null) {
            this.deletePool.halt();
            try {
                this.deletePool.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.deleteDaemon != null) {
            this.deleteDaemon.halt();
            try {
                this.deleteDaemon.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void stopExecutorPool() {
        if (this.settings.getExecutorPool() != null) {
            this.settings.getExecutorPool().shutdown();
            this.settings.getExecutorPool().waitUntilShutdown(5L, TimeUnit.SECONDS);
        }
    }

    private void hardStopExecutorPool() {
        if (this.settings.getExecutorPool() != null) {
            this.settings.getExecutorPool().shutdownNow();
        }
    }

    private void sendStopSignalToScanner() {
        if (this.scannerDaemon != null) {
            this.settings.getFSILogger().log(2016, this.scannerDaemon.getName());
            long startMTime = System.currentTimeMillis();
            this.scannerDaemon.halt();
            try {
                this.scannerDaemon.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.settings.getFSILogger().log(3205, "ScannerDaemon", System.currentTimeMillis() - startMTime);
        }
    }

    private void waitForConverterStop() {
        if (this.converterManagerV1002 != null) {
            long startMTime = System.currentTimeMillis();
            while (this.converterManagerV1002.isAlive()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.settings.getFSILogger().log(3205, "Converter", System.currentTimeMillis() - startMTime);
        }
        this.settings.getFSILogger().log(2016, "Converter");
    }

    private void stopListBuffer() {
        if (this.imagelistfilereader != null) {
            long startMTime = System.currentTimeMillis();
            this.imagelistfilereader.shutdownListBuffer();
            this.settings.getFSILogger().log(3205, "ImageListFileReader", System.currentTimeMillis() - startMTime);
        }
    }

    private void sendHaltNowSignalToConverter() {
        if (this.converterManagerV1002 != null) {
            this.converterManagerV1002.haltNow();
        }
    }

    private void sendHaltSignalToConverter() {
        if (this.converterManagerV1002 != null) {
            this.converterManagerV1002.halt();
        }
    }

    private void stopIOController() {
        if (this.ioController != null) {
            this.ioController.halt();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.stopIOController();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        if (drivers != null) {
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                try {
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException sQLException) {}
            }
        }
        Enumeration attrnames = this.settings.getServletContext().getAttributeNames();
        while (attrnames.hasMoreElements()) {
            this.settings.getServletContext().removeAttribute((String)attrnames.nextElement());
        }
        ThreadLocalsCleaner.removeThreadLocals();
        if (!this.settings.getSecured()) {
            super.destroy();
        }
    }

    public List<FileImportJob> getRecentConverterJobs() {
        List<FileImportJob> result = new ArrayList<FileImportJob>();
        if (this.converterManagerV1002 != null) {
            result = this.converterManagerV1002.getRecentJobs();
        }
        return result;
    }

    public List<ConverterState> getCurrentConverterJobs() {
        List<ConverterState> result = new ArrayList<ConverterState>();
        if (this.converterManagerV1002 != null) {
            result = this.converterManagerV1002.getCurrentJobStates();
        }
        return result;
    }

    public String getServletInfo() {
        return SoftwareVersion.getVersion(true);
    }

    public String getStatus() {
        if (this.running) {
            return "running";
        }
        if (this.settings.hasSectionEnabled("application")) {
            return "stopped";
        }
        return "disabled";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try (PrintWriter pw = resp.getWriter();){
            if (this.isPingAllowed(req)) {
                String path = req.getParameter("path");
                String profile = req.getParameter("profile");
                long position = this.handlePingRequest(path, profile);
                pw.println(position);
            } else {
                pw.println("ping rejected");
                resp.setStatus(403);
            }
            pw.flush();
        }
    }

    private boolean isPingAllowed(HttpServletRequest request) {
        List<String> allowedAddresses = this.settings.getPrefsValues("pingservice", "address");
        if (allowedAddresses != null) {
            for (String wildcardpattern : allowedAddresses) {
                if (!Pattern.matches(RegexUtils.wildcardToRegex(wildcardpattern), request.getRemoteAddr()) && !Pattern.matches(RegexUtils.wildcardToRegex(wildcardpattern), request.getRemoteHost())) continue;
                return true;
            }
        }
        return false;
    }

    public long handlePingRequest(String path, String profile) {
        SourceConnectorReader p;
        long position = -1L;
        if (profile != null && path != null && (p = this.settings.getSourceConnector(profile)) != null && p.isEnabled() && this.converterManagerV1002 != null) {
            try {
                position = this.converterManagerV1002.pingFile(profile + path);
            }
            catch (NotConfiguredException notConfiguredException) {
                // empty catch block
            }
        }
        return position;
    }

    private void initSwapPool() {
        this.swapPool = new SwapPool(this.settings.getFSILogger(), this.settings.getWorkDirectory());
    }

    public boolean hasErrors() {
        return this.servletInitErrorMessage != null || this.servletRuntimeErrorMessage != null;
    }

    public String getErrorMessage() {
        String result = this.servletInitErrorMessage;
        if (this.servletInitErrorMessage.trim().length() > 0 && this.servletRuntimeErrorMessage.trim().length() > 0) {
            result = result + "\n";
        }
        result = result + this.servletRuntimeErrorMessage;
        return result;
    }

    public boolean hasWarnings() {
        return this.servletInitWarningMessage != null || this.servletRuntimeWarningMessage != null;
    }

    public String getWarningMessage() {
        String result = this.servletInitWarningMessage;
        if (this.servletInitWarningMessage.trim().length() > 0 && this.servletRuntimeWarningMessage.trim().length() > 0) {
            result = result + "\n";
        }
        result = result + this.servletRuntimeWarningMessage;
        return result;
    }

    public String getStatisticsMessage() {
        return this.statisticsMessage;
    }

    public SourceManagerSettings getSettings() {
        return this.settings;
    }

    public DeleteDaemon getDeleteDaemon() {
        return this.deleteDaemon;
    }

    public ScannerDaemon getScannerDaemon() {
        return this.scannerDaemon;
    }

    public Converter_V1002 getConverterManager() {
        return this.converterManagerV1002;
    }

    public DownloadJobProcessor getJobProcessor() {
        return this.jobProcessor;
    }

    public String getQueuedImages() {
        if (this.scannerDaemon != null) {
            return Long.toString(this.scannerDaemon.getEnqueuedImages());
        }
        return "unknown";
    }

    public long getScanCount() {
        if (this.scannerDaemon != null) {
            return this.scannerDaemon.getScanCount();
        }
        return 0L;
    }

    public ImageListFileReader getImageListFileReader() {
        return this.imagelistfilereader;
    }

    public ImageListFileWriter getImageListFileWriter() {
        return this.imagelistfilewriter;
    }

    public SourceManagerSettings getSourceManagerSettings() {
        return this.settings;
    }

    public int getUptime() {
        return this.startTime != 0L ? (int)((System.currentTimeMillis() - this.startTime) / 1000L) : 0;
    }

    private boolean checkPrerequisites(ServletConfig config, FSILogger mainLogger, int threads) {
        int prereqErrorCode = 0;
        Prerequisites prerequisites = new Prerequisites(this.settings.getFSILogger(), config.getServletContext(), this.settings.getSystemInformation(), true);
        if (!mainLogger.hasNeLaDebug()) {
            prerequisites.setDisallow32bit(Prerequisites.Type.WARN, true);
            prerequisites.setThreadSettings(Prerequisites.Type.WARN, 4, -1);
            prerequisites.setServletAPIVersion(Prerequisites.Type.ERROR, 3.0, 3.1);
            prerequisites.setCheckMissingAllowEncodedSlash(Prerequisites.Type.WARN, false);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.ERROR, 0x10000000L);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.WARN, 0x40000000L);
            prerequisites.setRequiredMinMemoryPerCPU(Prerequisites.Type.ERROR, 0x2000000L, threads);
            prerequisites.setRequiredMinMemoryPerCPU(Prerequisites.Type.WARN, 0x8000000L, threads);
            prerequisites.setCheckLogHome(Prerequisites.Type.ERROR, true);
            prerequisites.setAllowSecureMode(Prerequisites.Type.ERROR, false);
            prerequisites.setAllowedFileEncoding(Prerequisites.Type.WARN, FileOperations.charsetUTF8);
            prerequisites.addPositiveJavaServletContainer(JavaEEServer.Tomcat, "7.0.6", "9.0.0");
            prerequisites.addPositiveJavaServletContainer(JavaEEServer.GlassFish, "3.0.0", "5.0.0");
            prerequisites.addErrorJavaServletContainer(JavaEEServer.Websphere);
            prerequisites.addPositiveVMVendor(VMVendor.Sun, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.Apple, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.Oracle, "1.7.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.OpenJDK, "1.7.0_0", "1.9.0_0");
            prerequisites.addErrorVMVendor(VMVendor.IBM, null, null);
            prerequisites.addErrorVMVendor(VMVendor.JRockit, null, null);
            prerequisites.addErrorVMVendor(VMVendor.OpenJDK, "1.7.0_21", "1.7.0_40");
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2003);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2008);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows2012);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows7);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows8);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Windows10);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.WindowsVista);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Linux);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.MacOSX);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.Solaris);
            if (this.sysinfo.getJVMVersion() == 1.8f) {
                prerequisites.addRequiredSystemProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider", Prerequisites.Type.ERROR, 2079);
            }
        }
        if (!mainLogger.hasNeLaDebug()) {
            int warnCode = prerequisites.check(Prerequisites.Type.WARN);
            if (warnCode != 0) {
                mainLogger.log(2009, warnCode);
                this.servletInitWarningMessage = "Recommended System Requirements not accomplished (" + prereqErrorCode + "). Please check the server log.";
            }
            prereqErrorCode = prerequisites.check(Prerequisites.Type.ERROR);
        }
        if (prereqErrorCode != 0) {
            this.servletInitErrorMessage = "Minimum System Requirements not accomplished (" + prereqErrorCode + "). Please check the server log.";
            mainLogger.log(2008, prereqErrorCode);
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.sourcemanager.startError", (Object)this.servletInitErrorMessage);
            return false;
        }
        return true;
    }

    private void initSystemMonitor() {
        SystemMonitor systemMonitor = new SystemMonitor(this.settings.getLicence(), this.settings.getStorageLocation(), this.settings.getExecutorPool());
        systemMonitor.start();
        this.settings.setSystemMonitor(systemMonitor);
        systemMonitor.setConnectorCount(this.settings.getSourceConnectorCount());
        this.servletContext.setAttribute("com.neptunelabs.fsiserver.SystemMonitor", (Object)systemMonitor);
    }

    private Path setupConfigHome() {
        String configHomeStr = System.getProperty("com.neptunelabs.fsiserver.config.home");
        Path configHome = configHomeStr == null ? ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("config") : Paths.get(configHomeStr, new String[0]);
        this.servletContext.setAttribute("com.neptunelabs.fsiserver.config.home", (Object)configHome);
        return configHome;
    }

    public GuruMeditationHook getUncaughtExceptionLogger() {
        return this.uncaughtExceptionLogger;
    }

    public SDBChecker getSDBChecker() {
        return this.sdbChecker;
    }
}

