/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.sourcemanager.filters.ContentTypeCheckFilter;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;

@WebListener
public class MainManagerContextListener
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger("FSIServer");

    public void contextInitialized(ServletContextEvent sce) {
        ContentTypeCheckFilter contentTypeCheckFilter;
        FilterRegistration.Dynamic dynamicCF;
        ServletContext servletContext = sce.getServletContext();
        ServletRegistration.Dynamic dynamicJersey = servletContext.addServlet("ServiceApplication", "org.glassfish.jersey.servlet.ServletContainer");
        if (dynamicJersey != null) {
            dynamicJersey.setInitParameter("javax.ws.rs.Application", "com.neptunelabs.fsiserver.service.ServiceApplication");
            dynamicJersey.setLoadOnStartup(5);
            dynamicJersey.addMapping(new String[]{"/service/*"});
        } else {
            LOGGER.log(Level.SEVERE, "Jersey not initiated");
        }
        if (!Boolean.valueOf(System.getProperty("com.neptunelabs.devmode", "false")).booleanValue()) {
            ServletRegistration.Dynamic dynamicCB = servletContext.addServlet("CacheBrowser", "com.neptunelabs.fsiserver.utils.cache.CacheBrowser");
            if (dynamicCB != null) {
                dynamicCB.addMapping(new String[]{"/cb"});
            } else {
                LOGGER.log(Level.SEVERE, "CacheBrowser not initiated");
            }
        }
        if ((dynamicCF = servletContext.addFilter("ContentTypeCheckFilter", (Filter)(contentTypeCheckFilter = new ContentTypeCheckFilter()))) != null) {
            dynamicCF.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/service/*"});
        } else {
            LOGGER.log(Level.SEVERE, "ContentTypeCheckFilter not initiated");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

