/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.DirectoryImportHandler;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageMover;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.SourceReverseRepairing;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.LDAPAuthentication;
import com.neptunelabs.fsiserver.utils.MetaDataFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.StorageMetrics;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.XMLFileAuthentication;
import com.neptunelabs.fsiserver.utils.comparators.FileComparator;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.URL;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ScannerDaemon
extends Thread {
    private static final int FORCE_FILE_SCAN_INTERVAL = 6;
    private static final long DEFAULT_PAUSE_BETWEEN_SCANS = 5000L;
    private static final long MAX_PAUSE_BETWEEN_SCANS = 15000L;
    private static final FileComparator simpleFileComparator = new FileComparator();
    private final SourceManagerSettings settings;
    private final ImageListFileWriter imagelistfilewriter;
    private final ImageListFileReader imagelistfilereader;
    private final MetaDataFileReader metadatareader;
    private final SystemMonitor sysmon;
    private final DeleteDaemon deleteDaemon;
    private final IOController ioController;
    private volatile long filecount = 0L;
    private volatile long sizecount = 0L;
    private StorageMetrics metrics;
    private volatile boolean requestPause = false;
    volatile STATE state;
    private volatile STATE prePauseState = this.state = STATE.IDLE;
    private final Set<String> pauseKeys = Collections.synchronizedSet(new HashSet());
    private boolean imageLimitExceededLogged = false;
    private boolean licenceExpiredLogged = false;
    private final Set<ScannerPauseReason> pauseReasons = Collections.synchronizedSet(new HashSet());
    private final Set<ScannerPauseReason> changesDuringLastPause = Collections.synchronizedSet(new HashSet());
    private final List<IOException> storageCorruptions = new ArrayList<IOException>();
    private int scanCycles = 0;
    final DirectoryImportHandler dirImportHandler;
    private final Converter_V1002 converterV1002;
    final StorageManager storageManager;
    private final ImageBuilder imageBuilder;
    final StorageHelperV1002 storageHelper;
    private boolean recheckErrorImages = true;
    private boolean forceFileScan = true;
    private boolean storageRepairMode = false;
    private boolean countOnlyMode = false;
    private boolean dirSorting = false;
    private DirectoryImportJob lastImportHandlerJob = null;
    private final DateFormat iso8601Formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    ScannerDaemon(SourceManagerSettings settings, Converter_V1002 converterV1002, DeleteDaemon deleteDaemon, IOController ioController, SwapPool swapPool, ExecutorPool executorPool, ImageListFileReader imagelistfilereader, ImageListFileWriter imagelistfilewriter, StorageManager storageManager, MetaDataFileReader metadatareader) throws NotConfiguredException {
        this.settings = settings;
        this.imagelistfilereader = imagelistfilereader;
        this.imagelistfilewriter = imagelistfilewriter;
        this.metadatareader = metadatareader;
        this.storageHelper = settings.getStorageHelper();
        this.deleteDaemon = deleteDaemon;
        this.ioController = ioController;
        this.converterV1002 = converterV1002;
        this.storageManager = storageManager;
        this.dirImportHandler = new DirectoryImportHandler(this, imagelistfilereader, imagelistfilewriter, settings, swapPool, executorPool, converterV1002, deleteDaemon, ioController, storageManager);
        this.imageBuilder = new ImageBuilder(settings, null, null, settings.getStorageLocation());
        this.sysmon = settings.getSystemMonitor();
        this.iso8601Formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.setupStorageMetrics();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void enableCountOnlyMode(boolean enabled) {
        this.countOnlyMode = enabled;
    }

    public void reportStorageCorruption(CorruptStorageException e) {
        this.settings.getFSILogger().log(3229, e.getLocalizedMessage());
        this.storageCorruptions.add(e);
    }

    public void reportStorageCorruption(IOException e) {
        this.settings.getFSILogger().log(3229, e.getLocalizedMessage());
        this.storageCorruptions.add(e);
    }

    public STATE getScannerState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseScanner(String pauseKey, ScannerPauseReason ... directoriesToBeModified) {
        ScannerDaemon scannerDaemon = this;
        synchronized (scannerDaemon) {
            this.pauseKeys.add(pauseKey);
            if (directoriesToBeModified != null) {
                for (ScannerPauseReason reason : directoriesToBeModified) {
                    this.pauseReasons.add(reason);
                }
            }
        }
        if (this.state != STATE.PAUSE && this.state != STATE.STOPPED && this.state != STATE.STOPPING && this.state != STATE.DELETING) {
            if (this.state == STATE.RESET || this.state == STATE.IDLE) {
                this.prePauseState = this.state;
                this.state = STATE.PAUSE;
            } else {
                this.requestPause = true;
            }
            while (this.isAlive() && this.state != STATE.PAUSE) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public boolean isPaused() {
        return this.state == STATE.PAUSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScanner(String pauseKey) {
        ScannerDaemon scannerDaemon = this;
        synchronized (scannerDaemon) {
            this.pauseKeys.remove(pauseKey);
            if (this.pauseKeys.size() == 0) {
                this.changesDuringLastPause.clear();
                this.changesDuringLastPause.addAll(this.pauseReasons);
                this.pauseReasons.clear();
                this.state = this.prePauseState;
            }
        }
    }

    public void resetScanner() {
        this.state = STATE.RESET;
        this.dirImportHandler.cancelCurrent();
        this.pauseKeys.clear();
    }

    long checkForRequestPause() {
        boolean reallyPaused = false;
        if (this.requestPause) {
            this.prePauseState = this.state;
            this.state = STATE.PAUSE;
            this.requestPause = false;
        }
        long startTime = System.currentTimeMillis();
        while (this.isAlive() && this.state == STATE.PAUSE && !this.isInterrupted()) {
            if (!reallyPaused) {
                reallyPaused = true;
            }
            if (this.state == STATE.STOPPING) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    private PoolList makeRootList(Path rootList) {
        if (Files.exists(rootList, new LinkOption[0])) {
            try {
                Files.delete(rootList);
            }
            catch (IOException e) {
                this.settings.getFSILogger().log(3200, rootList);
            }
        }
        ArrayList<PoolEntry> rootPoolList = new ArrayList<PoolEntry>();
        long rootHash = 0L;
        for (Map.Entry<String, SourceConnectorReader> entry : this.settings.getEnabledConnectors().entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            PoolDirectoryEntry rootDir = new PoolDirectoryEntry(entry.getValue().getPrefix(), 0L, 0L, 0L);
            rootHash = Math.max(rootHash, entry.getValue().getLastModfied());
            rootPoolList.add(rootDir);
        }
        return this.imagelistfilewriter.updateEntries(rootList, "/", null, null, rootPoolList, rootHash);
    }

    private void transferProfiles(Path metricsDir) {
        UserAuthenticationInterface uai;
        Path inMetricsDir;
        Path profilePath = this.settings.getSourceConnectorPath();
        if (Files.exists(profilePath, new LinkOption[0])) {
            try {
                List<PathCached> profileDirContent = FileOperations.listFiles(profilePath);
                if (profileDirContent != null) {
                    for (PathCached inFile : profileDirContent) {
                        if (!inFile.isRegularFile() || !inFile.isReadable()) continue;
                        Path inMetricsFile = metricsDir.resolve(inFile.getFileName() + ".profile");
                        boolean copy = false;
                        if (Files.exists(inMetricsFile, new LinkOption[0]) && (inFile.lastModified() != FileOperations.getSafeLastModified(inMetricsFile) || inFile.size() != Files.size(inMetricsFile))) {
                            copy = true;
                        } else if (Files.notExists(inMetricsFile, new LinkOption[0])) {
                            copy = true;
                        }
                        if (!copy) continue;
                        FileOperations.copy(this.settings.getFSILogger(), inFile.getPath(), inMetricsFile);
                    }
                }
            }
            catch (IOException profileDirContent) {
                // empty catch block
            }
        }
        if (Files.exists(inMetricsDir = metricsDir, new LinkOption[0])) {
            try {
                List<PathCached> inMetricsDirContent = FileOperations.listFiles(inMetricsDir);
                if (inMetricsDirContent != null) {
                    Pattern pat = Pattern.compile("(.+).profile");
                    for (PathCached inFile : inMetricsDirContent) {
                        String name;
                        Matcher mat;
                        if (!inFile.isRegularFile() || !inFile.isReadable() || !(mat = pat.matcher(name = inFile.getFileName())).find()) continue;
                        name = mat.group(1);
                        Path checkFile = this.settings.getSourceConnectorPath().resolve(name);
                        if (!Files.notExists(checkFile, new LinkOption[0])) continue;
                        try {
                            Files.delete(inFile.getPath());
                        }
                        catch (IOException e) {
                            this.settings.getFSILogger().log(3200, inFile);
                        }
                    }
                }
            }
            catch (IOException inMetricsDirContent) {
                // empty catch block
            }
        }
        if ((uai = this.settings.getUserAuthenticationInterface()) instanceof XMLFileAuthentication) {
            Path permissionsetsDir;
            Path groupsfile;
            XMLFileAuthentication xmluai = (XMLFileAuthentication)uai;
            Path usersfile = xmluai.getUsersFile();
            if (Files.exists(usersfile, new LinkOption[0])) {
                FileOperations.copy(this.settings.getFSILogger(), usersfile, inMetricsDir.resolve("users.xml"));
            }
            if (Files.exists(groupsfile = xmluai.getGroupsFile(), new LinkOption[0])) {
                FileOperations.copy(this.settings.getFSILogger(), groupsfile, inMetricsDir.resolve("groups.xml"));
            }
            if (Files.exists(permissionsetsDir = xmluai.getPermissionSetsDirectory(), new LinkOption[0])) {
                FileOperations.copy(this.settings.getFSILogger(), permissionsetsDir, inMetricsDir.resolve("permissionsets"));
            }
        } else if (uai instanceof LDAPAuthentication) {
            LDAPAuthentication ldapuai = (LDAPAuthentication)uai;
            uai.saveUsersToFile(inMetricsDir.resolve("users.xml"));
            uai.saveGroupsToFile(inMetricsDir.resolve("groups.xml"));
            Path permissionsetsDir = ldapuai.getPermissionSetsDirectory();
            if (Files.exists(permissionsetsDir, new LinkOption[0])) {
                FileOperations.copy(this.settings.getFSILogger(), permissionsetsDir, inMetricsDir.resolve("permissionsets"));
            }
        }
    }

    private boolean deleteObsoleteProfileData(PoolList poolList) throws NotConfiguredException, IOException {
        boolean result = false;
        if (poolList != null) {
            Set<String> dirs = poolList.getDirectoryNameSet();
            for (String dir : dirs) {
                this.checkForRequestPause();
                if (this.settings.getAllConnectors().containsKey(dir)) continue;
                this.imagelistfilewriter.forceClearingAllBuffers();
                this.settings.getFSILogger().log(3179, dir);
                STATE oldState = this.state;
                this.state = STATE.DELETING;
                if (this.settings.isMigrationModeEnabled()) {
                    try {
                        this.deleteDaemon.removeStorageDirectory(dir, "V1001");
                    }
                    catch (CorruptStorageException corruptStorageException) {
                        // empty catch block
                    }
                }
                this.deleteDaemon.removeProfileFromStorageV1002(dir);
                if (this.settings.getSolrUpdater() != null) {
                    this.settings.getSolrUpdater().deleteAssetWithPrefixAsync(dir + "/");
                }
                this.state = oldState;
                Path dirlistFile = this.storageHelper.getDirectoryFile("/");
                this.imagelistfilewriter.removeEntry(dirlistFile, "/", null, null, dir, FileOperations.getSafeLastModified(dirlistFile.getParent()));
                result = true;
            }
        }
        return result;
    }

    private void checkLicenceLimits() {
        if (this.settings.getLicence().hasLicence()) {
            long expireTime;
            long maxImages = this.settings.getLicence().getMaxImages();
            if (!this.imageLimitExceededLogged) {
                if (maxImages >= 0L && this.filecount > maxImages) {
                    this.settings.getFSILogger().log(7004, this.filecount, maxImages);
                    this.imageLimitExceededLogged = true;
                }
            } else if (this.filecount < maxImages) {
                this.imageLimitExceededLogged = false;
            }
            if ((expireTime = this.settings.getLicence().getExpireTime()) > 0L && !this.licenceExpiredLogged && this.settings.getLicence().getExpireTime() < System.currentTimeMillis()) {
                DateFormat df = DateFormat.getDateTimeInstance();
                this.settings.getFSILogger().log(7005, df.format(new Date(this.settings.getLicence().getExpireTime())));
                this.licenceExpiredLogged = true;
            }
        }
    }

    void updateSearchDatabaseEntryForAsset(String assetURLPath, FSIMetaData fsiMetadata, short importStatus) {
        if (this.settings.getSolrUpdater() != null) {
            String assetName = assetURLPath.substring(assetURLPath.lastIndexOf("/") + 1);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("file.name", assetName);
            String[] fileSplit = FileOperations.splitFilename(assetName);
            if (fileSplit != null) {
                metadata.put("file.prefix", fileSplit[0]);
                metadata.put("file.suffix", fileSplit[1]);
            }
            metadata.put("file.type", "file");
            metadata.put("file.status", String.valueOf(importStatus));
            if (fsiMetadata != null) {
                ImageMetaData md = ImageMetaData.getInstance(fsiMetadata);
                md.setAssetURLPath(assetURLPath);
                metadata.put("file.lastmodified", this.iso8601Formatter.format(new Date(md.getLastModified())));
                metadata.put("file.size", String.valueOf(((FileMetaData)md).getSourceFileSize()));
                ImageMetaData imd = md;
                metadata.put("file.width", String.valueOf(imd.getWidth()));
                metadata.put("file.height", String.valueOf(imd.getHeight()));
                metadata.put("file.resolution", String.valueOf((long)imd.getWidth() * (long)imd.getHeight()));
                ICCProfileWrap ipw = imd.getICC();
                if (ipw != null) {
                    metadata.put("file.icc", ipw.getName());
                }
                try {
                    List<Pair<String, String>> iptclist = ((MetaData)md).getSortedIPTCList();
                    for (Pair<String, String> pair : iptclist) {
                        metadata.put("iptc." + pair.getItem1(), pair.getItem2());
                    }
                }
                catch (Exception e) {
                    this.settings.getFSILogger().logException(e, 3231, assetURLPath);
                }
                try {
                    Map<Integer, Pair<String, String>> exifMap = ((MetaData)md).getExifSortedMap(this.settings.getFSILogger(), assetName, false);
                    for (Map.Entry entry : exifMap.entrySet()) {
                        if (((Pair)entry.getValue()).getItem1() == null || ((Pair)entry.getValue()).getItem2() == null) continue;
                        metadata.put("exif." + (String)((Pair)entry.getValue()).getItem1(), (String)((Pair)entry.getValue()).getItem2());
                    }
                }
                catch (Exception e) {
                    this.settings.getFSILogger().logException(e, 3230, assetURLPath);
                }
            }
            this.settings.getSolrUpdater().setMetaDataASync(assetURLPath, metadata, false);
        }
    }

    public boolean assetExists(String assetURLPath) throws NotConfiguredException {
        boolean found = false;
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
        try {
            this.imageBuilder.getImageMetaData(connector, assetURLPath, 0, true, null);
            found = true;
        }
        catch (IOException ioe1) {
            try {
                this.imageBuilder.getDirectoryMetaData(connector, assetURLPath, connector.getSourceFileFromAssetURLPath(assetURLPath), 0);
                found = true;
            }
            catch (IOException ioe2) {
                found = false;
            }
        }
        return found;
    }

    public boolean getMetaDataAndUpdateSearchDatabase(String assetURLPath, boolean explicitLog) throws NotConfiguredException {
        boolean success;
        block12: {
            success = false;
            SolrUpdater sdb = this.settings.getSolrUpdater();
            if (sdb != null) {
                SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
                if (connector == null) {
                    return false;
                }
                try {
                    MetaData md;
                    PathCached sourceFile = null;
                    boolean isDirectory = false;
                    if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                        isDirectory = this.isStorageDirectory(assetURLPath);
                    } else {
                        sourceFile = connector.getSourceFileFromAssetURLPath(assetURLPath);
                        isDirectory = sourceFile.isDirectory();
                    }
                    int readFlag = 29;
                    if (isDirectory) {
                        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                            md = this.imageBuilder.getDirectoryMetaData(assetURLPath);
                        } else {
                            sourceFile = connector.getSourceFileFromAssetURLPath(assetURLPath);
                            md = this.imageBuilder.getDirectoryMetaData(connector, assetURLPath, sourceFile, 29);
                        }
                    } else {
                        md = this.imageBuilder.getImageMetaData(connector, assetURLPath, 29, true, null);
                    }
                    if (md != null) {
                        md.setAssetURLPath(assetURLPath);
                        Map<String, String> metadata = this.getMetaDataMapFromImageMetaData(md);
                        success = sdb.setMetaDataASync(assetURLPath, metadata, explicitLog);
                        break block12;
                    }
                    sdb.deleteAssetAsync(assetURLPath);
                }
                catch (IOException iOException) {}
            } else {
                success = true;
            }
        }
        return success;
    }

    private boolean isStorageDirectory(String assetURLPath) throws NotConfiguredException {
        StorageHelperV1002 storageHelperV1002 = this.settings.getStorageHelper();
        return storageHelperV1002.isStorageDirectory(assetURLPath) || StorageHelperV1001.isStorageDirectory(this.settings.getStorageLocation(), assetURLPath);
    }

    private Map<String, String> getMetaDataMapFromImageMetaData(MetaData md) {
        Map<String, String> cmd;
        HashMap<String, String> result = new HashMap<String, String>();
        String filename = md.getAssetURLPath().substring(md.getAssetURLPath().lastIndexOf("/") + 1);
        result.put("file.name", filename);
        result.put("file.lastmodified", this.iso8601Formatter.format(new Date(md.getLastModified())));
        if (md instanceof DirectoryMetaData) {
            result.put("file.type", "directory");
        } else {
            result.put("file.type", "file");
        }
        if (md instanceof FileMetaData) {
            FileMetaData fmd = (FileMetaData)md;
            String[] fileSplit = FileOperations.splitFilename(filename);
            if (fileSplit != null) {
                result.put("file.prefix", fileSplit[0]);
                result.put("file.suffix", fileSplit[1]);
            }
            result.put("file.size", String.valueOf(fmd.getSourceFileSize()));
        }
        if (md instanceof ImageMetaData) {
            Map<Pair<String, String>, String> exifmap;
            ImageMetaData imd = (ImageMetaData)md;
            result.put("file.width", String.valueOf(imd.getWidth()));
            result.put("file.height", String.valueOf(imd.getHeight()));
            result.put("file.status", String.valueOf(imd.getImportStatus()));
            List<Pair<String, String>> iptclist = imd.getSortedIPTCList();
            if (iptclist != null) {
                for (Pair<String, String> iptcEntry : iptclist) {
                    result.put("iptc." + iptcEntry.getItem1(), iptcEntry.getItem2());
                }
            }
            if ((exifmap = imd.getExifFullMap(this.settings.getFSILogger(), md.getAssetURLPath(), false)) != null) {
                for (Map.Entry<Pair<String, String>, String> exifEntry : exifmap.entrySet()) {
                    result.put("exif." + exifEntry.getKey().getItem1(), exifEntry.getValue());
                }
            }
        }
        if ((cmd = md.getCustomMetaData()) != null) {
            for (Map.Entry<String, String> entry : cmd.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private boolean checkForDeletedDirectories(PoolList poolList, Deque<PathCached> directoryContents, String pathname) {
        Set<String> listentries = poolList.getDirectoryNameSet();
        for (PathCached fp : directoryContents) {
            if (this.isInterrupted() || this.state == STATE.STOPPING) break;
            if (!this.dirImportHandler.isRecursableDir(fp)) continue;
            listentries.remove(fp.getFileName().toString());
        }
        return listentries.size() > 0;
    }

    private List<PoolEntry> checkForNewDirectories(PoolList poolList, Deque<PathCached> directoryContents) {
        ArrayList<PoolEntry> newDirectories = new ArrayList<PoolEntry>();
        Set<String> listentries = poolList.getDirectoryNameSet();
        for (PathCached fp : directoryContents) {
            this.checkForRequestPause();
            if (this.isInterrupted() || this.state == STATE.STOPPING) break;
            if (!this.dirImportHandler.isRecursableDir(fp) || listentries.contains(fp.getFileName())) continue;
            try {
                newDirectories.add(new PoolDirectoryEntry(fp.getFileName(), fp.lastModified(), 0L, 0L));
            }
            catch (IOException iOException) {}
        }
        return newDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolList rebuildPoolList(SourceConnectorReader profile, Path directory, String assetURLPath, boolean includeFiles) throws NotConfiguredException {
        Path dirlistFile = this.settings.getStorageHelper().getDirectoryFile(assetURLPath);
        PoolList result = new PoolList(dirlistFile, assetURLPath);
        Deque<PathCached> dircontent = null;
        this.ioController.waitForRead();
        try {
            dircontent = this.listAllFiles(directory);
        }
        catch (IOException e) {
            dircontent = new ArrayDeque<PathCached>();
        }
        finally {
            this.ioController.unlockRead();
        }
        int inboxlength = profile.getInboxDirectory().getAbsoluteNameLength();
        for (PathCached fp : dircontent) {
            try {
                if (fp.isDirectory()) {
                    if (!fp.isReadable() || !this.dirImportHandler.isRecursableDir(fp)) continue;
                    result.addDirectory(new PoolDirectoryEntry(fp.getFileName(), 0L, 0L, 0L));
                    continue;
                }
                if (!includeFiles || !this.dirImportHandler.isValidFilename(fp, false)) continue;
                ImageFormatScanner ifs = ImageFormatScanner.getInstance();
                ImageFormat format = ifs.scanFile(fp);
                if (!format.isImage || format.type == ImageFormat.Type.UNK) continue;
                PoolFileEntry pe = null;
                if (this.settings.isMigrationModeEnabled()) {
                    String relativePath = profile.getPrefix() + fp.getAbsoluteName().substring(inboxlength).replace(File.separator, "/");
                    Path poolfile = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix(relativePath)).resolve(relativePath).resolve("info.spm");
                    try {
                        ImageMetaData imd = this.metadatareader.getMetaData(poolfile, 0);
                        pe = new PoolFileEntry(fp.getFileName(), fp.lastModified(), fp.size(), imd.getWidth(), imd.getHeight(), imd.getImportStatus());
                    }
                    catch (NoSuchFileException imd) {
                    }
                    catch (IOException ioe) {
                        this.settings.getFSILogger().log(3504, poolfile, ioe.getLocalizedMessage());
                    }
                }
                if (pe == null) {
                    try {
                        pe = new PoolFileEntry(fp.getFileName(), fp.lastModified(), fp.size(), -1, -1, 0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                result.addImage(pe);
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private Path getSPDFile(SourceConnectorReader profile, PathCached directory) {
        int indl = profile.getInboxDirectory().getAbsoluteNameLength();
        String basedir = directory.getPath().toAbsolutePath().toString().replace(File.separatorChar, '/');
        String pathname = profile.getPrefix() + basedir.substring(indl) + '/';
        String relativeDirlistFile = StorageHelperV1001.getStoragePrefix(pathname) + pathname;
        return this.settings.getStorageLocation().resolve(relativeDirlistFile).resolve("dirlist");
    }

    private void setupStorageMetrics() throws IOException, NotConfiguredException {
        Path metricsDir = this.storageHelper.getMetricsDir();
        if (Files.notExists(metricsDir, new LinkOption[0])) {
            Files.createDirectories(metricsDir, new FileAttribute[0]);
        }
        Path metricsFile = metricsDir.resolve("stats");
        if (this.settings.isMigrationModeEnabled() && Files.notExists(metricsFile, new LinkOption[0])) {
            this.migrateMetricsFiles(metricsDir);
        }
        this.metrics = new StorageMetrics(this.settings, metricsFile);
    }

    private void migrateMetricsFiles(Path newMetricsDir) throws IOException {
        Path metricsDirV1001 = this.settings.getStorageLocation().resolve(StorageHelperV1001.getVersionPrefix()).resolve("_metrics");
        if (Files.exists(metricsDirV1001, new LinkOption[0])) {
            Deque<PathCached> metricsFiles = this.listAllFiles(metricsDirV1001);
            for (PathCached mfile : metricsFiles) {
                FileOperations.move(mfile.getPath(), newMetricsDir.resolve(mfile.getFileName()));
            }
            FileOperations.removeEmptyParents(this.settings.getFSILogger(), metricsDirV1001, this.settings.getStorageLocation());
        }
    }

    public boolean isAcceptedFileForStorageConnector(Path f) {
        PathCached fp = new PathCached(f);
        ImageFormatScanner ifs = ImageFormatScanner.getInstance();
        ImageFormat format = ifs.scanFile(fp);
        try {
            return format.isImage && format.type != ImageFormat.Type.UNK && this.dirImportHandler.isValidFilename(fp, true);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean hasStorageID() {
        String sid = this.settings.getStorageID();
        return sid != null;
    }

    private void checkReverseLookup(Map<String, SourceConnectorReader> profiles) throws IOException {
        Path checkFile = this.settings.getStorageLocation().resolve(".rlcheck");
        if (Files.deleteIfExists(checkFile)) {
            for (Map.Entry<String, SourceConnectorReader> profileEntry : profiles.entrySet()) {
                if (this.state == STATE.STOPPING || this.state == STATE.RESET) continue;
                SourceConnectorReader connector = profileEntry.getValue();
                PathCached inbox = connector.getInboxDirectory();
                if (connector.getPrefix().equals("_downloads") || connector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGE || !inbox.exists()) continue;
                this.settings.getFSILogger().log(3180, connector.getPrefix());
                long startTime = System.currentTimeMillis();
                SourceReverseRepairing sfv = new SourceReverseRepairing(connector, this.storageHelper, this.storageManager, this.dirImportHandler, inbox);
                try {
                    Files.walkFileTree(connector.getInboxDirectory().getPath(), sfv);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                long totalTime = System.currentTimeMillis() - startTime;
                boolean hasChanged = sfv.hasChanged();
                this.settings.getFSILogger().log(3181, connector.getPrefix(), Long.toString(totalTime), hasChanged ? "yes" : "no");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.dirSorting = this.settings.getPrefsBoolean("scanner", "sorting");
        this.dirImportHandler.start();
        try {
            this.state = STATE.IDLE;
            Thread.sleep(5000L);
            this.checkForRequestPause();
            if (this.hasStorageID()) {
                Map<String, SourceConnectorReader> profiles = this.settings.getEnabledConnectors();
                PoolList rootlist = this.getRootDirlist();
                this.state = STATE.SCANNING;
                this.settings.getFSILogger().log(3194, profiles.size());
                long t0 = System.currentTimeMillis();
                rootlist = this.checkConnectorEntriesInRootList(profiles, rootlist);
                long t1 = System.currentTimeMillis();
                this.settings.getFSILogger().log(3195, t1 - t0);
                this.transferProfiles();
                if (this.state == STATE.STOPPING) {
                    this.state = STATE.STOPPED;
                    return;
                }
                this.state = STATE.IDLE;
                this.checkReverseLookup(this.settings.getEnabledConnectors());
                while (!this.isInterrupted() && this.state != STATE.STOPPING) {
                    DirectoryImportJob currentDirImportHandlerJob;
                    if (this.state == STATE.RESET) {
                        profiles = this.settings.getEnabledConnectors();
                        rootlist = this.checkConnectorEntriesInRootList(profiles, rootlist);
                        this.transferProfiles();
                    }
                    boolean skipScan = (currentDirImportHandlerJob = this.dirImportHandler.getCurrentJob()) != null && this.lastImportHandlerJob != null && currentDirImportHandlerJob.equals(this.lastImportHandlerJob) && currentDirImportHandlerJob.getStartTime() == this.lastImportHandlerJob.getStartTime();
                    this.lastImportHandlerJob = currentDirImportHandlerJob;
                    if (skipScan) {
                        this.settings.getFSILogger().log(3182, this.lastImportHandlerJob.assetURLPath, this.iso8601Formatter.format(new Date()));
                        try {
                            for (long countDown = 15000L; countDown > 0L; countDown -= 100L + this.checkForRequestPause()) {
                                Thread.sleep(100L);
                            }
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    if (this.storageCorruptions.size() > 0) {
                        this.checkForRequestPause();
                        ArrayList<IOException> tmp = new ArrayList<IOException>();
                        tmp.addAll(this.storageCorruptions);
                        this.storageCorruptions.clear();
                        for (IOException cse : tmp) {
                            if (!(cse instanceof CorruptReverseLookupException)) continue;
                            Path corruptReverseLookupFile = ((CorruptReverseLookupException)cse).getReverseLookupFile();
                            FileOperations.deleteDir(corruptReverseLookupFile.getParent());
                        }
                        this.storageRepairMode = true;
                    }
                    this.checkForRequestPause();
                    if (this.state == STATE.RESET) {
                        this.state = STATE.SCANNING;
                    } else {
                        if (this.state == STATE.STOPPING) {
                            this.state = STATE.STOPPED;
                            return;
                        }
                        this.state = STATE.SCANNING;
                    }
                    long scanStartTime = System.currentTimeMillis();
                    rootlist = this.getRootDirlist();
                    if (this.deleteObsoleteProfileData(rootlist)) {
                        rootlist = this.getRootDirlist();
                    }
                    boolean changes = false;
                    this.forceFileScan = this.scanCycles % 6 == 0;
                    for (Map.Entry entry : profiles.entrySet()) {
                        SourceConnectorReader connector;
                        this.checkForRequestPause();
                        if (this.state == STATE.STOPPING || this.state == STATE.RESET || (connector = (SourceConnectorReader)entry.getValue()).getPrefix().equals("_downloads") || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) continue;
                        PathCached profileFP = connector.getInboxDirectory();
                        if (profileFP.isReadable()) {
                            try {
                                long newConnectorImageCount;
                                long preConnectorCount = this.filecount;
                                changes |= this.recursiveFullScan(connector, profileFP);
                                long oldConnectorImageCount = connector.getCurrentImageCount();
                                if (oldConnectorImageCount == (newConnectorImageCount = this.filecount - preConnectorCount)) continue;
                                connector.setCurrentImageCount(newConnectorImageCount);
                            }
                            catch (Exception e) {
                                if (e instanceof InterruptedException || e instanceof NotConfiguredException) {
                                    throw e;
                                }
                                System.err.println("Caught Exception scanning contents of connector " + connector.getPrefix());
                                e.printStackTrace();
                            }
                            continue;
                        }
                        connector.setEnabled(false);
                    }
                    if (this.forceFileScan && this.state != STATE.STOPPING && this.state != STATE.RESET) {
                        if (this.recheckErrorImages) {
                            this.recheckErrorImages = false;
                        }
                        this.metrics.setValues(this.filecount, this.sizecount);
                        this.metrics.saveToFile();
                        this.checkLicenceLimits();
                        this.sysmon.setAssetCount(this.filecount);
                        this.sysmon.setAssetSize(this.sizecount);
                    }
                    long filesScanned = this.filecount;
                    this.resetCounters();
                    if (this.state != STATE.STOPPING && this.state != STATE.RESET) {
                        ++this.scanCycles;
                        this.sleepBetweenScans(scanStartTime, changes, filesScanned);
                    }
                    this.storageRepairMode = false;
                    if (!this.settings.isMigrationModeEnabled()) continue;
                    this.deleteObsoleteOldProfileData();
                    this.deleteOldStorageMetadata();
                    this.settings.getMainManager().checkMigrationMode();
                }
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 3260, e.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NotConfiguredException notConfiguredException) {
        }
        finally {
            this.dirImportHandler.shutdown();
            try {
                this.dirImportHandler.join(30000L);
            }
            catch (InterruptedException interruptedException) {}
            this.state = STATE.STOPPED;
        }
    }

    public final void triggerDirectoryCheck(Path directory, String assetURLPath) {
        boolean isEnqueued = this.dirImportHandler.isDirectoryEnqueued(directory, assetURLPath, false);
        if (!isEnqueued) {
            SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath);
            this.dirImportHandler.submitDirectory(connector, directory, FileOperations.getSafeLastModified(directory), assetURLPath, false, false);
        }
    }

    private final boolean recursiveFullScan(SourceConnectorReader connector, PathCached directory) throws NotConfiguredException, IOException {
        Deque<Object> directoryContents;
        boolean changeDetected = false;
        if (ScannerDaemon.isRootStorageDirectory(directory.getPath())) {
            return changeDetected;
        }
        this.checkForRequestPause();
        String assetURLPath = connector.getPrefix() + directory.getAbsoluteName().substring(connector.getInboxDirectory().getAbsoluteNameLength());
        assetURLPath = FileOperations.convertBackslash(assetURLPath);
        Path dirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
        PoolList poollist = null;
        try {
            poollist = this.imagelistfilereader.getListFileContents(dirlistfile, assetURLPath);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().logException(ioe, 3249, dirlistfile, assetURLPath);
        }
        if (poollist == null || poollist.lastmodified != directory.lastModified()) {
            changeDetected = true;
        } else {
            this.filecount += (long)poollist.getFileCount();
        }
        this.checkForRequestPause();
        if (this.state != STATE.STOPPING) {
            try {
                directoryContents = this.listAllFiles(directory.getPath());
            }
            catch (IOException e) {
                directoryContents = new ArrayDeque();
            }
        } else {
            directoryContents = new ArrayDeque();
        }
        if (this.state != STATE.STOPPING && !this.countOnlyMode) {
            boolean isEnqueued = this.dirImportHandler.isDirectoryEnqueued(directory.getPath(), assetURLPath, this.storageRepairMode);
            this.checkForRequestPause();
            if (!isEnqueued) {
                if (this.storageRepairMode) {
                    this.dirImportHandler.submitDirectory(connector, directory.getPath(), directory.lastModified(), assetURLPath, this.recheckErrorImages, this.storageRepairMode);
                } else {
                    if (!changeDetected && this.forceFileScan) {
                        changeDetected = this.checkFiles(poollist, directoryContents);
                    }
                    this.checkForRequestPause();
                    if (!changeDetected && (changeDetected = this.checkDirectories(poollist, directoryContents))) {
                        System.err.println("Change 1:" + directory.getPath() + " " + changeDetected);
                    }
                    this.checkForRequestPause();
                    if (!changeDetected) {
                        changeDetected = this.checkParentDirlistEntry(poollist, assetURLPath);
                    }
                    this.checkForRequestPause();
                    if (changeDetected && this.state != STATE.STOPPING && this.state != STATE.RESET) {
                        this.dirImportHandler.submitDirectory(connector, directory.getPath(), directory.lastModified(), assetURLPath, this.recheckErrorImages, this.storageRepairMode);
                    }
                }
            }
        }
        if (this.state != STATE.STOPPING && this.state != STATE.RESET) {
            if (this.dirSorting) {
                ArrayList<PathCached> recursableDirs = new ArrayList<PathCached>();
                for (PathCached pathCached : directoryContents) {
                    if (!this.dirImportHandler.isRecursableDir(pathCached)) continue;
                    recursableDirs.add(pathCached);
                }
                Collections.sort(recursableDirs, simpleFileComparator);
                for (PathCached pathCached : recursableDirs) {
                    changeDetected |= this.recursiveFullScan(connector, pathCached);
                }
            } else {
                for (PathCached pathCached : directoryContents) {
                    if (!this.dirImportHandler.isRecursableDir(pathCached)) continue;
                    changeDetected |= this.recursiveFullScan(connector, pathCached);
                }
            }
        }
        if (this.state == STATE.STOPPING || this.state == STATE.RESET) {
            return false;
        }
        return changeDetected;
    }

    private boolean checkParentDirlistEntry(PoolList poolList, String assetURLPath) throws NotConfiguredException {
        String parentAssetURLPath = URL.getParentAssetURLPath(assetURLPath);
        Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
        try {
            PoolList parentlist = this.imagelistfilereader.getListFileContents(parentDirlistFile, parentAssetURLPath);
            String dirname = parentAssetURLPath.length() > 1 ? assetURLPath.substring(parentAssetURLPath.length() + 1) : assetURLPath;
            PoolDirectoryEntry entryInParent = parentlist.getDirectory(dirname);
            if (entryInParent.files != (long)poolList.getFileCount()) {
                return true;
            }
            if (entryInParent.subdirectories != (long)poolList.getDirectoryCount()) {
                return true;
            }
            if (entryInParent.lastmodified != poolList.lastmodified) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkDirectories(PoolList poolList, Deque<PathCached> directoryContents) {
        Set<String> dirNames = poolList.getDirectoryNameSet();
        for (PathCached fp : directoryContents) {
            this.checkForRequestPause();
            if (!this.dirImportHandler.isRecursableDir(fp)) continue;
            if (dirNames.contains(fp.getFileName())) {
                dirNames.remove(fp.getFileName());
                continue;
            }
            return true;
        }
        return dirNames.size() > 0;
    }

    private boolean checkFiles(PoolList poolList, Deque<PathCached> directoryContents) throws NotConfiguredException {
        Set<String> imageNames = poolList.getImageNameSet();
        for (PathCached fp : directoryContents) {
            this.checkForRequestPause();
            try {
                if (this.settings.isMigrationModeEnabled()) {
                    Path eisFile;
                    String assetURLPath = poolList.getAssetURLPath() + '/' + fp.getFileName();
                    Path path = eisFile = fp.isRegularFile() ? this.storageHelper.getEisFile(assetURLPath) : this.storageHelper.getDirectoryFile(assetURLPath);
                    if (Files.notExists(eisFile, new LinkOption[0])) {
                        return true;
                    }
                }
                if (!fp.isRegularFile()) continue;
                ImageFormatScanner ifs = ImageFormatScanner.getInstance();
                ImageFormat format = ifs.scanFile(fp);
                if (!imageNames.remove(fp.getFileName()) && format.isImage && format.type != ImageFormat.Type.UNK && this.dirImportHandler.isValidFilename(fp, false)) {
                    return true;
                }
                PoolFileEntry pe = poolList.getImage(fp.getFileName());
                if (pe == null) continue;
                long filesize = fp.size();
                this.sizecount += filesize;
                if (pe.importStatus == 2 || pe.importStatus == 4 || this.recheckErrorImages && pe.importStatus != 1) {
                    return true;
                }
                if (pe.lastmodified == fp.lastModified() && pe.filesize == filesize) continue;
                return true;
            }
            catch (IOException e) {
                return true;
            }
        }
        return imageNames.size() > 0;
    }

    private void resetCounters() {
        this.filecount = 0L;
        this.sizecount = 0L;
    }

    private void sleepBetweenScans(long scanStartTime, boolean changes, long filesScanned) {
        long totalScanTime = System.currentTimeMillis() - scanStartTime;
        long sleepTime = !changes || this.converterV1002.isOverloaded() ? (15000L - totalScanTime < 0L ? 5000L : 15000L - totalScanTime) : 15000L;
        if (this.state != STATE.STOPPING) {
            this.sysmon.setScannerTime(totalScanTime);
            this.settings.getFSILogger().log(3183, filesScanned, totalScanTime, sleepTime, Boolean.toString(changes));
            this.state = STATE.IDLE;
        }
        try {
            for (long countDown = sleepTime; countDown > 0L; countDown -= 100L + this.checkForRequestPause()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private PoolList checkConnectorEntriesInRootList(Map<String, SourceConnectorReader> connectors, PoolList rootlist) throws NotConfiguredException {
        for (Map.Entry<String, SourceConnectorReader> profileEntry : connectors.entrySet()) {
            this.checkForRequestPause();
            SourceConnectorReader connector = profileEntry.getValue();
            if (connector.getPrefix().equals("_downloads")) continue;
            if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE && connector.getInboxDirectory().exists()) {
                this.newRecursiveDirectoryScan(connector, connector.getInboxDirectory(), false, false);
            } else if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                this.newAPIOnlyScan(connector);
            }
            rootlist = this.checkProfileEntryInRootList(rootlist, connector);
        }
        return rootlist;
    }

    private void newAPIOnlyScan(SourceConnectorReader connector) throws NotConfiguredException {
        String assetURLPath = connector.getPrefix();
        Path dirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
        try {
            PoolList poolList = this.imagelistfilereader.getListFileContents(dirlistfile, assetURLPath);
        }
        catch (NoSuchFileException fnfe) {
            String parentAssetURLPath = URL.getParentAssetURLPath(assetURLPath);
            Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
            ArrayList<PoolEntry> newDirectories = new ArrayList<PoolEntry>();
            this.imagelistfilewriter.updateEntries(dirlistfile, assetURLPath, parentDirlistFile, parentAssetURLPath, newDirectories, connector.getLastModfied());
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().logException(ioe, 3504, dirlistfile, ioe.getLocalizedMessage());
        }
    }

    private void newRecursiveDirectoryScan(SourceConnectorReader connector, PathCached directory, boolean forceCheck, boolean allowRebuild) throws NotConfiguredException {
        Deque<PathCached> directoryContents;
        this.checkForRequestPause();
        if (ScannerDaemon.isRootStorageDirectory(directory.getPath())) {
            return;
        }
        if (this.state == STATE.STOPPING || this.state == STATE.RESET) {
            return;
        }
        long lastmodified = 0L;
        try {
            lastmodified = directory.lastModified(true);
            directoryContents = this.listDirectories(directory.getPath());
        }
        catch (IOException e) {
            directoryContents = null;
        }
        if (directoryContents == null) {
            return;
        }
        for (PathCached fp : directoryContents) {
            if (!this.dirImportHandler.isRecursableDir(fp)) continue;
            this.checkForRequestPause();
            this.newRecursiveDirectoryScan(connector, fp, forceCheck, allowRebuild);
        }
        if (this.state == STATE.STOPPING || this.state == STATE.RESET) {
            return;
        }
        int indl = connector.getInboxDirectory().getAbsoluteNameLength();
        String basedir = directory.getAbsoluteName().replace(File.separatorChar, '/');
        String assetURLPath = connector.getPrefix() + basedir.substring(indl);
        Path dirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
        PoolList poollist = null;
        try {
            poollist = this.imagelistfilereader.getListFileContents(dirlistfile, assetURLPath);
        }
        catch (NoSuchFileException fnfe) {
            if (this.settings.isMigrationModeEnabled()) {
                poollist = this.migrateDirList(connector, directory, dirlistfile, assetURLPath);
            }
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().logException(ioe, 3504, dirlistfile, ioe.getLocalizedMessage());
        }
        if (poollist == null) {
            PoolList list = this.rebuildPoolList(connector, directory.getPath(), assetURLPath, allowRebuild);
            list.lastmodified = lastmodified;
            this.imagelistfilewriter.replaceAll(dirlistfile, list);
            this.getMetaDataAndUpdateSearchDatabase(assetURLPath, false);
        } else if (forceCheck || lastmodified != poollist.lastmodified) {
            this.checkForDeletedDirectories(poollist, directoryContents, assetURLPath);
            List<PoolEntry> newDirectories = this.checkForNewDirectories(poollist, directoryContents);
            if (newDirectories.size() > 0) {
                String parentAssetURLPath = URL.getParentAssetURLPath(assetURLPath);
                Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
                this.imagelistfilewriter.updateEntries(dirlistfile, assetURLPath, parentDirlistFile, parentAssetURLPath, newDirectories, lastmodified);
                this.getMetaDataAndUpdateSearchDatabase(assetURLPath, false);
            }
        }
    }

    private PoolList migrateDirList(SourceConnectorReader connector, PathCached directory, Path newDirListLocation, String assetURLPath) {
        PoolList poolList = null;
        Path v1001Dirlistfile = this.getSPDFile(connector, directory);
        if (Files.exists(v1001Dirlistfile, new LinkOption[0])) {
            this.settings.getFSILogger().log(3222, v1001Dirlistfile, newDirListLocation);
            EISImageMover mover = new EISImageMover(v1001Dirlistfile);
            mover.setAssetURLPath(assetURLPath);
            try {
                this.settings.getStorageManager().executeStorageDataProvider(newDirListLocation, mover);
                poolList = this.imagelistfilereader.getListFileContents(newDirListLocation, assetURLPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileOperations.removeEmptyParents(this.settings.getFSILogger(), v1001Dirlistfile.getParent(), this.settings.getStorageLocation());
        }
        return poolList;
    }

    private PoolList checkProfileEntryInRootList(PoolList rootlist, SourceConnectorReader profile) throws NotConfiguredException {
        if (!rootlist.containsDirectory(profile.getPrefix())) {
            ArrayList<PoolEntry> rootPoolList = new ArrayList<PoolEntry>();
            PoolDirectoryEntry rootDir = new PoolDirectoryEntry(profile.getPrefix(), profile.getLastModfied(), 0L, 0L);
            long lm = Math.max(rootlist.lastmodified, profile.getLastModfied());
            rootPoolList.add(rootDir);
            Path rootListFile = this.storageHelper.getDirectoryFile("/");
            this.imagelistfilewriter.updateEntries(rootListFile, "/", null, null, rootPoolList, lm);
            rootlist = this.getRootDirlist();
        }
        return rootlist;
    }

    void halt() {
        this.state = STATE.STOPPING;
        this.dirImportHandler.shutdown();
        this.interrupt();
    }

    public long getScanCount() {
        return this.filecount;
    }

    public long getEnqueuedImages() {
        return this.converterV1002.getQueuedImages();
    }

    public void manuallySubmitDirectory(DirectoryImportJob job) throws NotConfiguredException, IOException {
        try {
            this.dirImportHandler.processJob(job);
        }
        catch (CorruptStorageException e) {
            this.reportStorageCorruption(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean manuallySubmitNewJob(SourceConnectorReader connector, Path sourceFile) throws NotConfiguredException, IOException {
        boolean acceptFile;
        block11: {
            PathCached fp = new PathCached(sourceFile);
            ImageFormatScanner ifs = ImageFormatScanner.getInstance();
            ImageFormat format = ifs.scanFile(fp);
            if (!(connector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGE && connector.getMountType() != SourceConnectorReader.SourceConnectorType.STORAGEAPI || format.isImage && format.type != ImageFormat.Type.UNK && this.dirImportHandler.isValidFilename(fp, false))) {
                return false;
            }
            int inboxPathLength = connector.getInboxDirectory().getAbsoluteNameLength();
            String assetURLPath = connector.getPrefix() + fp.getAbsoluteName().substring(inboxPathLength);
            assetURLPath = FileOperations.convertBackslash(assetURLPath);
            String dirURLPath = URL.getParentAssetURLPath(assetURLPath);
            String pauseKey = "pk8-" + assetURLPath.hashCode();
            acceptFile = false;
            try {
                this.pauseScanner(pauseKey, new ScannerPauseReason(dirURLPath, ScannerPauseReason.ModificationType.FILE));
                if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                    Path dirlistfile;
                    if (!fp.isRegularFile()) break block11;
                    Path eisFile = this.storageHelper.getEisFile(assetURLPath);
                    FileImportJob fij = new FileImportJob(QueueType.API, connector, fp, format, eisFile, assetURLPath, Converter_V1002.evaluatePriority(QueueType.API), false);
                    EISImageWriter eisWriter = new EISImageWriter(this.settings, 2, -1);
                    eisWriter.setAssetURLPath(assetURLPath);
                    FSIMetaData metaData = new FSIMetaData(null);
                    metaData.filesize = fp.size();
                    eisWriter.setMetaData(metaData);
                    try {
                        this.storageManager.executeStorageDataProvider(eisFile, eisWriter);
                    }
                    catch (CorruptStorageException e) {
                        this.reportStorageCorruption(e);
                    }
                    fij.dirlistFile = dirlistfile = this.makeDirlistEntryForManuallySubmittedJob(fp, dirURLPath);
                    this.converterV1002.enqueueJob(fij);
                    acceptFile = true;
                    break block11;
                }
                if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
                    if (format.type == ImageFormat.Type.TIF || format.type == ImageFormat.Type.FPX) {
                        acceptFile = true;
                        this.makeDirlistEntryForManuallySubmittedJob(fp, dirURLPath);
                    }
                } else {
                    if (!connector.isVirtualViewerConnector()) {
                        this.makeDirlistEntryForManuallySubmittedJob(fp, dirURLPath);
                    }
                    acceptFile = true;
                }
            }
            finally {
                this.resumeScanner(pauseKey);
            }
        }
        return acceptFile;
    }

    private Path makeDirlistEntryForManuallySubmittedJob(PathCached fp, String dirURLPath) throws NotConfiguredException, IOException {
        PoolFileEntry pe = new PoolFileEntry(fp.getFileName(), fp.lastModified(), fp.size(), 0, 0, 2);
        ArrayList<PoolEntry> entriesToBeUpdated = new ArrayList<PoolEntry>();
        entriesToBeUpdated.add(pe);
        Path dirlistfile = this.storageHelper.getDirectoryFile(dirURLPath);
        String parentAssetURLPath = URL.getParentAssetURLPath(dirURLPath);
        Path parentDirlistFile = this.storageHelper.getDirectoryFile(parentAssetURLPath);
        this.imagelistfilewriter.updateEntries(dirlistfile, dirURLPath, parentDirlistFile, parentAssetURLPath, entriesToBeUpdated, FileOperations.getSafeLastModified(fp.getParent()));
        this.getMetaDataAndUpdateSearchDatabase(dirURLPath, false);
        return dirlistfile;
    }

    private PoolList getRootDirlist() throws NotConfiguredException {
        PoolList result = null;
        boolean rebuildRootList = true;
        Path rootListFile = this.storageHelper.getDirectoryFile("/");
        if (this.settings.isMigrationModeEnabled() && Files.notExists(rootListFile, new LinkOption[0])) {
            rebuildRootList = true;
            try {
                this.deleteOldRootDirlist();
            }
            catch (IOException iOException) {}
        } else {
            try {
                result = this.imagelistfilereader.getListFileContents(rootListFile, "/");
                if (result != null) {
                    rebuildRootList = false;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (rebuildRootList) {
            result = this.makeRootList(rootListFile);
        }
        return result;
    }

    public int getScanCycles() {
        return this.scanCycles;
    }

    void resetLicenceLogging() {
        this.licenceExpiredLogged = false;
        this.imageLimitExceededLogged = false;
    }

    private void deleteOldRootDirlist() throws IOException {
        Path v1001Dirlistfile = this.settings.getStorageLocation().resolve(StorageHelperV1001.getStoragePrefix("/") + "dirlist");
        if (Files.exists(v1001Dirlistfile, new LinkOption[0])) {
            this.determineObsoleteOldProfiles(v1001Dirlistfile);
            Files.delete(v1001Dirlistfile);
            FileOperations.removeEmptyParents(this.settings.getFSILogger(), v1001Dirlistfile.getParent(), this.settings.getStorageLocation());
        }
    }

    private void determineObsoleteOldProfiles(Path v1001Dirlistfile) {
        try {
            HashSet<String> obsoleteProfiles = new HashSet<String>();
            PoolList pl = this.imagelistfilereader.getListFileContents(v1001Dirlistfile, "/");
            this.imagelistfilereader.getListBuffer().invalidateAllBuffers();
            Set<String> oldProfileNames = pl.getDirectoryNameSet();
            Map<String, SourceConnectorReader> map = this.settings.getEnabledConnectors();
            for (String profileName : oldProfileNames) {
                if (map.get(profileName) != null) continue;
                obsoleteProfiles.add(profileName);
            }
            if (obsoleteProfiles.size() > 0) {
                Path output = this.settings.getStorageLocation().resolve(StorageHelperV1001.getVersionPrefix()).resolve(".ObsoleteProfiles");
                FileOperations.writeTextFileContent(output, StringUtils.join(obsoleteProfiles, (char)','), FileOperations.charsetUTF8);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteOldStorageMetadata() throws IOException {
        Path oldMetrics = this.settings.getStorageLocation().resolve(StorageHelperV1001.getVersionPrefix()).resolve("_metrics");
        FileOperations.deleteDir(oldMetrics);
        Path oldDatabase = this.settings.getStorageLocation().resolve(StorageHelperV1001.getVersionPrefix()).resolve("_database");
        FileOperations.deleteDir(oldDatabase);
        Path oldInternal = this.settings.getStorageLocation().resolve("_internal");
        FileOperations.deleteDir(oldInternal);
        Path oldTrash = this.settings.getStorageLocation().resolve("_trash");
        FileOperations.deleteDir(oldTrash);
    }

    private void deleteObsoleteOldProfileData() {
        Path v1001StorageDir = this.settings.getStorageLocation().resolve(StorageHelperV1001.getVersionPrefix());
        Path obsProfilesFile = v1001StorageDir.resolve(".ObsoleteProfiles");
        if (Files.exists(obsProfilesFile, new LinkOption[0])) {
            try {
                String[] profileNames;
                String list = FileOperations.getTextFileContent(obsProfilesFile, FileOperations.charsetUTF8);
                for (String profileName : profileNames = StringUtils.split((String)list, (char)',')) {
                    for (PathCached sub1 : this.listAllFiles(v1001StorageDir)) {
                        Deque<PathCached> secondLevel = this.listAllFiles(sub1.getPath());
                        if (secondLevel == null) continue;
                        for (PathCached sub2 : secondLevel) {
                            Deque<PathCached> tmplist = this.listAllFiles(sub2.getPath());
                            if (tmplist != null) {
                                for (PathCached tmp : tmplist) {
                                    if (!tmp.getFileName().toString().equals(profileName)) continue;
                                    FileOperations.deleteDir(tmp.getPath());
                                }
                            }
                            FileOperations.removeEmptyParents(this.settings.getFSILogger(), sub2.getPath(), v1001StorageDir);
                        }
                    }
                }
                Files.deleteIfExists(obsProfilesFile);
            }
            catch (Exception e) {
                System.err.println("Error removing old storage data");
                e.printStackTrace();
            }
        }
    }

    private static final boolean isRootStorageDirectory(Path directory) {
        Path storageIDFile = directory.resolve(".FSIServerStorage");
        return Files.exists(storageIDFile, new LinkOption[0]);
    }

    private void transferProfiles() throws NotConfiguredException {
        this.transferProfiles(this.storageHelper.getMetricsDir());
    }

    private Deque<PathCached> listAllFiles(final Path baseDir) throws IOException {
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> result = new ArrayDeque<PathCached>();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                if (baseDir.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                result.add(new PathCached(dir, attrs));
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                if (attrs.isRegularFile()) {
                    result.add(new PathCached(file, attrs));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    private Deque<PathCached> listDirectories(final Path baseDir) throws IOException {
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> result = new ArrayDeque<PathCached>();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                if (baseDir.equals(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                result.add(new PathCached(dir, attrs));
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.state == STATE.STOPPING) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    public static enum STATE {
        SCANNING,
        IDLE,
        PAUSE,
        RESET,
        STOPPING,
        STOPPED,
        DELETING;

    }
}

