/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerCache;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerScanner;
import com.neptunelabs.fsiserver.mbeans.FSISourceManagerStorage;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.LDAPAuthentication;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.XMLFileAuthentication;
import com.neptunelabs.fsiservletframework.jmx.MBeanUtils;
import com.neptunelabs.fsiservletframework.settings.Section;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;

public final class SourceManagerSettings
extends FSIServerSettings {
    private int conversionThreads;
    private MainManager mainManager;
    private UserAuthenticationInterface userAuthenticationInterface;
    private FSILogger apiLogger = null;
    private SolrUpdater sdb = null;
    private SearchDatabaseSolr solr = null;
    private StorageManager storageManager = null;
    private Path workDirectory;
    private FileLockHandler lockHandler;
    private boolean updatingLicence = false;
    private boolean migrationModeEnabled = false;
    private Path cacheDirectory = null;

    public SourceManagerSettings(HttpServlet servlet, boolean autorestart, FSILogger logger, ServletFileEventCursor fileEventCursor) {
        super(servlet, autorestart, fileEventCursor, false, false);
        this.setFSILogger(logger);
        if (this.getConfigHome() != null) {
            this.setSettingsFile(this.getConfigHome().resolve("sourcemanager.xml"));
            try {
                this.setLicenceFile(this.getLicenceLocation(), 22, 3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.initViewableDirectories();
        this.initBackupDirectories();
        this.initDefaults();
        this.initProtectedDirs();
    }

    protected void setMainManager(MainManager mainManager) {
        this.mainManager = mainManager;
        this.addRestartableServlet(mainManager);
    }

    public MainManager getMainManager() {
        return this.mainManager;
    }

    private void initBackupDirectories() {
        this.addBackupDir("/viewer/", true);
        this.addBackupDir("/js/", true);
        this.addBackupDir("/");
        this.addBackupDir("/WEB-INF/");
        this.addBackupDir("/WEB-INF/connectors/");
        this.addBackupDir("/WEB-INF/config/");
        this.addBackupDir("/configHome", true);
    }

    private void initViewableDirectories() {
        this.addViewableDir("/viewer/", true);
        this.addViewableDir("/js/", true);
        this.addViewableDir("/WEB-INF/");
        this.addViewableDir("/WEB-INF/connectors/");
        this.addViewableDir("/WEB-INF/config/");
        this.addViewableDir("/configHome/", true);
    }

    private void setAdministratorAccess() {
        if (this.getPrefsBoolean("application", "standalone")) {
            this.servletContext.setAttribute("Allow FSI Administrator", (Object)false);
        } else {
            this.servletContext.setAttribute("Allow FSI Administrator", (Object)true);
        }
    }

    public short getTileSize() {
        return 384;
    }

    protected void setupSolrUpdater() {
        this.sdb = null;
        if (this.hasSectionEnabled("search")) {
            String name = "FSI-Solr-Updater";
            this.solr = new SearchDatabaseSolr(this.logger, name);
            String dbType = this.getPrefsString("search", "type");
            if (dbType.equalsIgnoreCase("solr")) {
                try {
                    boolean proxy;
                    String solrServerURI = this.getPrefsString("search", "solrServerURI");
                    String core = this.getPrefsString("search", "core");
                    int maxConnections = this.getPrefsInt("search", "connectionpoolmax");
                    this.solr.setConnection(solrServerURI, core, maxConnections);
                    boolean authentication = this.getPrefsBoolean("search", "authentication");
                    if (authentication) {
                        String authenticationType = this.getPrefsString("search", "authenticationType");
                        String authenticationUsername = this.getPrefsString("search", "authenticationUsername");
                        String authenticationPassword = this.getPrefsString("search", "authenticationPassword");
                        this.solr.setAuthentication(authentication, authenticationType, authenticationUsername, authenticationPassword);
                    }
                    if (proxy = this.getPrefsBoolean("search", "proxy")) {
                        String proxyHostname = this.getPrefsString("search", "proxyHostname");
                        int proxyPort = this.getPrefsInt("search", "proxyPort");
                        boolean proxySSL = this.getPrefsBoolean("search", "proxySSL");
                        boolean proxyAuthentication = this.getPrefsBoolean("search", "proxyAuthentication");
                        String proxyUsername = this.getPrefsString("search", "proxyUsername");
                        String proxyPassword = this.getPrefsString("search", "proxyPassword");
                        this.solr.setProxy(proxy, proxyHostname, proxyPort, proxySSL, proxyAuthentication, proxyUsername, proxyPassword);
                    }
                    this.solr.init();
                    this.sdb = new SolrUpdater(this, this.solr, name);
                    this.sdb.start();
                    this.logger.log(3221, dbType);
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(3220, e.getLocalizedMessage());
                    this.sdb = null;
                }
            } else {
                this.sdb = null;
                this.logger.log(3210, "SearchDatabase", dbType);
            }
            if (this.sdb != null) {
                this.sdb.setEnabled(true);
            }
        } else {
            this.sdb = new SolrUpdater(this, null, "FSI-Solr-Deactivated");
            this.sdb.setEnabled(false);
        }
        this.servletContext.setAttribute("SolrUpdater", (Object)this.sdb);
    }

    public SolrUpdater getSolrUpdater() {
        return this.sdb;
    }

    public SearchDatabaseSolr getSearchDatabaseSolr() {
        return this.solr;
    }

    public int getConversionThreads() {
        return this.conversionThreads;
    }

    public void setConversionThreads(int conversionThreads) {
        this.conversionThreads = conversionThreads;
    }

    private void initDefaults() {
        HashMap<String, Section> defaultSections = new HashMap<String, Section>();
        Section application = new Section(Section.SectionTypes.valueNames);
        application.enable(true);
        application.put("standalone", "false");
        application.put("conversionthreads", "auto");
        application.put("importstrategy", "shared");
        application.put("logtostorage", "false");
        application.put("userdb", "xmlfile");
        application.put("ldapuri", "ldap://localhost:389/");
        application.put("ldapuser", "");
        application.put("ldappassword", "");
        application.put("ldapbasedn", "");
        application.put("usekrb", "false");
        application.put("krbdebug", "false");
        if (this.getWebInfPath() != null) {
            application.put("storage", this.getWebInfPath().resolve("storage").toString());
        }
        application.put("storagehasher", "crc32");
        application.put("byteorder", "litte_endian");
        application.put("maxcpu", "auto");
        application.put("hasht", "true");
        application.put("maxio", "auto");
        application.put("maxthreadsperjob", "auto");
        application.put("forcecputhreads", "");
        application.put("forceiothreads", "");
        application.put("forcethreadsperjob", "");
        application.put("maxscalememratio", "0.75");
        application.put("prefetch", "true");
        application.put("prefetchmaxsize", Integer.toString(0x3000000));
        application.put("tempdirectory", "auto");
        application.put("parallelread", "true");
        application.put("parallelwrite", "false");
        application.put("parallelreadwrite", "false");
        application.put("jmx", "false");
        application.put("import", "true");
        defaultSections.put("application", application);
        Section cache = new Section(Section.SectionTypes.valueNames);
        cache.put("maxmemory", "auto");
        cache.put("directmemory", "false");
        cache.put("l1", "true");
        cache.put("l1size", "1000");
        cache.put("l2", "true");
        cache.put("response", "true");
        cache.put("packasync", "true");
        cache.put("writecachedir", "");
        defaultSections.put("cache", cache);
        Section scanner = new Section(Section.SectionTypes.valueNames);
        scanner.enable(true);
        scanner.put("filescandelay", "1");
        scanner.put("sorting", "true");
        scanner.put("convertBefore1stScan", "false");
        scanner.put("useMagicBytes", "false");
        defaultSections.put("scanner", scanner);
        Section protected_dirs = new Section(Section.SectionTypes.valueList);
        protected_dirs.enable(true);
        defaultSections.put("protected_dirs", protected_dirs);
        Section protected_files = new Section(Section.SectionTypes.valueList);
        protected_files.enable(true);
        defaultSections.put("protected_files", protected_files);
        Section pingservice = new Section(Section.SectionTypes.valueList);
        pingservice.enable(true);
        defaultSections.put("pingservice", pingservice);
        Section cms = new Section(Section.SectionTypes.valueNames);
        cms.enable(true);
        cms.put("defaultcmykprofile", "auto");
        cms.put("defaultrgbprofile", "auto");
        cms.put("defaultgrayprofile", "auto");
        cms.put("fallbackiccconversion", "true");
        defaultSections.put("colormanagementsystem", cms);
        Section database = new Section(Section.SectionTypes.valueNames);
        database.enable(false);
        database.put("type", "solr");
        database.put("solrserveruri", "http://localhost/solr");
        database.put("core", "fsi-server-3");
        database.put("authentication", "false");
        database.put("authenticationtype", "basic");
        database.put("authenticationusername", "");
        database.put("authenticationpassword", "");
        database.put("proxy", "false");
        database.put("proxyhostname", "");
        database.put("proxyport", "80");
        database.put("proxyssl", "false");
        database.put("proxyauthentication", "false");
        database.put("proxyusername", "");
        database.put("proxypassword", "");
        database.put("connectionpoolmax", "500");
        defaultSections.put("search", database);
        this.setDefaultSection(defaultSections);
    }

    boolean readConfigs() {
        boolean ret = this.evalutateSettings();
        this.setAdministratorAccess();
        if (this.hasSectionEnabled("application")) {
            this.initWorkDirectory();
            String userdb = this.getPrefsString("application", "userdb");
            if ("xmlfile".equalsIgnoreCase(userdb)) {
                this.userAuthenticationInterface = new XMLFileAuthentication(this);
            } else if ("ldap".equalsIgnoreCase(userdb)) {
                this.userAuthenticationInterface = new LDAPAuthentication(this);
            }
            if (this.userAuthenticationInterface == null) {
                this.logger.log(2032, new Object[0]);
            } else {
                this.servletContext.setAttribute("AuthenticationInterface", (Object)this.userAuthenticationInterface);
            }
            this.readSourceConnectors();
        }
        return ret;
    }

    private void dumpConnectorAccess() {
        this.log("Connectors and access rules:");
        for (Map.Entry e : this.sourceConnectors.entrySet()) {
            this.log(((SourceConnectorReader)e.getValue()).getPrefix() + " - " + ((SourceConnectorReader)e.getValue()).getAccessPermissions());
        }
    }

    public Path getSourceConnectorPath() {
        return this.getConfigHome().resolve("connectors");
    }

    public void setAPILogger(FSILogger logger) {
        this.apiLogger = logger;
    }

    public FSILogger getAPILogger() {
        return this.apiLogger;
    }

    public boolean isPermissionSetInUse(String permissionSetName) {
        boolean result = false;
        if (permissionSetName.equals("public_images") || permissionSetName.equals("public_statics")) {
            result = true;
        } else {
            for (Users.User u : this.userAuthenticationInterface.users) {
                if (!permissionSetName.equals(u.permissionSet)) continue;
                return true;
            }
            for (Group g : this.userAuthenticationInterface.getGroups().values()) {
                if (!permissionSetName.equals(g.getPermissionSet())) continue;
                return true;
            }
            block2: for (SourceConnectorReader connector : this.sourceConnectors.values()) {
                for (PermissionSet ps : connector.getAccessPermissions().values()) {
                    if (!permissionSetName.equals(ps.getName())) continue;
                    result = true;
                    continue block2;
                }
            }
        }
        return result;
    }

    public boolean isPropertySetInUse(String setName) {
        boolean result = false;
        for (Users.User u : this.userAuthenticationInterface.users) {
            if (!setName.equals(u.propertySet)) continue;
            return true;
        }
        for (Group g : this.userAuthenticationInterface.getGroups().values()) {
            if (!setName.equals(g.getPropertySet())) continue;
            return true;
        }
        block2: for (SourceConnectorReader connector : this.sourceConnectors.values()) {
            for (String ps : connector.getAccessProperties().values()) {
                if (!setName.equals(ps)) continue;
                result = true;
                continue block2;
            }
        }
        return result;
    }

    public boolean isPublishingSetInUse(String setName) {
        List<PublishingSet> psetlist = this.userAuthenticationInterface.getAllUserPublishingSets();
        for (PublishingSet pset : psetlist) {
            if (!setName.equals(pset.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupInUse(String groupname) {
        boolean result = false;
        if (groupname.equals("public")) {
            result = true;
        } else {
            block0: for (SourceConnectorReader profile : this.sourceConnectors.values()) {
                for (Group g : profile.getAccessPermissions().keySet()) {
                    if (!g.getName().equals(groupname)) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    private void readSourceConnectors() {
        this.sourceConnectors.clear();
        Path sourceConnectorPath = this.getSourceConnectorPath();
        if (Files.exists(sourceConnectorPath, new LinkOption[0]) && Files.isDirectory(sourceConnectorPath, new LinkOption[0])) {
            try {
                List<PathCached> sourceConnectorfiles = FileOperations.listFiles(sourceConnectorPath, "*.xml");
                if (sourceConnectorfiles != null && sourceConnectorfiles.size() > 0) {
                    for (PathCached element : sourceConnectorfiles) {
                        if (!element.isReadable()) continue;
                        String sourceConnectorName = element.getFileName().substring(0, element.getFileName().length() - 4);
                        SourceConnectorReader sourceConnector = new SourceConnectorReader(this.logger, sourceConnectorName, element, this.getWebInfPath(), this.getWorkDirectory(), this.userAuthenticationInterface);
                        if (sourceConnector.isEnabled()) {
                            this.logger.log(2500, sourceConnectorName);
                        } else if (sourceConnector.hasError()) {
                            this.logger.log(2501, sourceConnectorName, "Error reading " + element.getAbsoluteName() + " - " + sourceConnector.getErrorMessage());
                        } else {
                            this.logger.log(2502, sourceConnectorName);
                        }
                        this.sourceConnectors.put(sourceConnectorName, sourceConnector);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.systemMonitor != null) {
            this.systemMonitor.setConnectorCount(this.sourceConnectors.size());
        }
        this.updateSourceConnectorAccessRules();
    }

    public void updateSourceConnectorAccessRules() {
        this.userAuthenticationInterface.updateSourceConnectors(this.sourceConnectors);
    }

    public Map<String, SourceConnectorReader> getEnabledConnectors() {
        HashMap<String, SourceConnectorReader> result = new HashMap<String, SourceConnectorReader>();
        for (Map.Entry entry : this.sourceConnectors.entrySet()) {
            if (!((SourceConnectorReader)entry.getValue()).isEnabled()) continue;
            result.put((String)entry.getKey(), (SourceConnectorReader)entry.getValue());
        }
        return result;
    }

    public Map<String, SourceConnectorReader> getAllConnectors() {
        HashMap<String, SourceConnectorReader> result = new HashMap<String, SourceConnectorReader>();
        result.putAll(this.sourceConnectors);
        return result;
    }

    public SourceConnectorReader getSourceConnector(String name) {
        return (SourceConnectorReader)this.sourceConnectors.get(name);
    }

    public Path getTrashLocation() {
        return this.getStorageLocation().resolve(".trash");
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private void initProtectedDirs() {
        this.addProtectedDir(this.getConfigHome());
    }

    protected void initCacheDirectory() {
        Path path;
        String wcd = this.getPrefsString("cache", "writecachedir");
        if (wcd != null && !wcd.equals("") && Files.isDirectory(path = Paths.get(wcd, new String[0]), new LinkOption[0]) && Files.isWritable(path)) {
            this.cacheDirectory = path;
        }
    }

    private void initWorkDirectory() {
        String tempDirStr;
        Path regularTempDir = this.getTempDirectory();
        if (Files.notExists(regularTempDir, new LinkOption[0])) {
            try {
                Files.createDirectories(regularTempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                regularTempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                this.logger.log(2010, regularTempDir);
            }
        }
        Path tempDir = (tempDirStr = this.getPrefsString("application", "tempDirectory")) == null || tempDirStr.equals("") || tempDirStr.equalsIgnoreCase("auto") ? regularTempDir : Paths.get(tempDirStr, new String[0]);
        Path tempDirectory = !tempDir.isAbsolute() ? ServletUtils.getRealPath(this.servletContext, tempDirStr) : tempDir;
        this.workDirectory = tempDirectory.resolve("sourcemanager");
        if (Files.notExists(this.workDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.workDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.log(3199, this.workDirectory);
            }
        } else {
            try {
                this.clearWorkDirectory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearWorkDirectory() throws IOException {
        List<PathCached> list = FileOperations.listAllFiles(this.workDirectory, "*", 0, 1);
        if (list.size() > 0) {
            try {
                FileOperations.deleteDir(this.workDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Files.createDirectory(this.workDirectory, new FileAttribute[0]);
        }
    }

    @Override
    public UserAuthenticationInterface getUserAuthenticationInterface() {
        return this.userAuthenticationInterface;
    }

    public Path getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public void dispose() {
        if (this.cacheManager != null) {
            this.cacheManager.dispose();
        }
        super.dispose();
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        this.updatingLicence = true;
        super.updateLicenceFromLicenceManager();
        MainManager importer = (MainManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
        if (importer != null && importer.getScannerDaemon() != null) {
            importer.getScannerDaemon().resetLicenceLogging();
        }
        if (this.cacheManager != null) {
            this.cacheManager.clearAll();
        }
        this.updatingLicence = false;
    }

    @Override
    public FileLockHandler getFileLockHandler() {
        return this.lockHandler;
    }

    public void initFileLockHandler() {
        this.lockHandler = new FileLockHandler();
        if (this.servletContext != null) {
            this.servletContext.setAttribute("com.neptunelabs.fsiserver.utils.FileLockHandler", (Object)this.lockHandler);
        }
    }

    void initSourceConnectorWatcher() {
        if (Boolean.parseBoolean(this.getServletConfig().getInitParameter("autorestart"))) {
            FileEventCallback callback = new FileEventCallback(this, "reReadSourceConnectorsAndResetScanner", null);
            ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
            cL.add(callback);
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path file) {
                    return file.getFileName().toString().endsWith(".xml");
                }
            };
            try {
                this.fileEventCursor.addPathMonitor(this.getSourceConnectorPath(), filter, false, cL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reReadSourceConnectorsAndResetScanner() {
        boolean sPaused = false;
        this.logger.log(2505, this.getSourceConnectorPath());
        try {
            if (this.mainManager != null && this.mainManager.getScannerDaemon() != null) {
                this.mainManager.getScannerDaemon().pauseScanner("pausedToRestart", new ScannerPauseReason[0]);
                sPaused = true;
            }
            this.readSourceConnectors();
            if (this.mainManager != null && this.mainManager.getDeleteDaemon() != null) {
                this.mainManager.getDeleteDaemon().updateProfileMap();
            }
        }
        finally {
            if (sPaused && this.mainManager != null) {
                this.mainManager.getScannerDaemon().resetScanner();
            }
        }
    }

    @Override
    public boolean isRestarting() {
        boolean restarting = super.isRestarting();
        if (!restarting) {
            restarting = this.updatingLicence;
        }
        if (!restarting) {
            restarting = this.fileEventCursor != null ? this.fileEventCursor.isRestarting() : false;
        }
        return restarting;
    }

    public final void setMigrationModeEnabled(boolean enabled) {
        boolean oldValue = this.migrationModeEnabled;
        this.migrationModeEnabled = enabled;
        if (this.migrationModeEnabled && !oldValue) {
            this.logger.log(2053, new Object[0]);
        } else if (oldValue && !this.migrationModeEnabled) {
            this.logger.log(2054, new Object[0]);
        }
    }

    @Override
    public final boolean isMigrationModeEnabled() {
        return this.migrationModeEnabled;
    }

    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    public final void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void setupStorageID() throws IOException {
        this.storageHelper.setupStorageID();
    }

    public Path getLicenceLocation() {
        if (this.getConfigHome() != null) {
            return this.getConfigHome().resolve(Defines.LICENCE_FILENAME);
        }
        return null;
    }

    @Override
    protected void initMBeans() {
        if (System.getProperty("com.sun.management.jmxremote") == null) {
            this.logger.log(2036, new Object[0]);
        } else if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            this.logger.log(2037, Integer.parseInt(System.getProperty("com.sun.management.jmxremote.port")));
        }
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=Cache", new FSISourceManagerCache(this.getCacheManager())));
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=Scanner", new FSISourceManagerScanner(this.getSystemMonitor())));
        this.mbeans.add(MBeanUtils.registerMBean(this.logger, "FSI Server:Type=Storage", new FSISourceManagerStorage(this.getSystemMonitor())));
    }
}

