/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.filters;

import com.neptunelabs.fsiframework.io.MimeHelper;
import com.neptunelabs.fsiserver.sourcemanager.filters.ContentTypeHttpRequest;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ContentTypeCheckFilter
implements Filter {
    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httprequest = (HttpServletRequest)request;
        String mime = null;
        if (httprequest.getMethod().equals("PUT")) {
            String path = httprequest.getPathInfo();
            if (!this.containsContentTypeHeader(httprequest)) {
                if (path != null) {
                    mime = MimeHelper.getMimeTypeFromFileExtension(path.toLowerCase());
                    request = new ContentTypeHttpRequest(httprequest, mime);
                }
            } else {
                mime = request.getContentType();
            }
            if (!(mime = mime != null ? MimeHelper.simplifyMime(mime) : "application/unknown").equals(httprequest.getContentType())) {
                request = new ContentTypeHttpRequest(httprequest, mime);
            }
        }
        chain.doFilter(request, response);
    }

    private boolean containsContentTypeHeader(HttpServletRequest request) {
        Enumeration headernames = request.getHeaderNames();
        while (headernames.hasMoreElements()) {
            String headerContent;
            String header = (String)headernames.nextElement();
            if (!header.equalsIgnoreCase("Content-Type") || (headerContent = request.getHeader(header).trim()).length() <= 7 || !headerContent.contains("/")) continue;
            return true;
        }
        return false;
    }
}

