/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class ContentTypeHttpRequest
extends HttpServletRequestWrapper {
    private final String contentType;
    private final Map<String, Set<String>> headers = new HashMap<String, Set<String>>();

    public ContentTypeHttpRequest(HttpServletRequest request, String contentType) {
        super(request);
        boolean wasSet = false;
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerKey = (String)headerNames.nextElement();
            if (!headerKey.equalsIgnoreCase("content-type")) {
                this.headers.put(headerKey, new HashSet(Collections.list(request.getHeaders(headerKey))));
                continue;
            }
            HashSet<String> s = new HashSet<String>();
            s.add(contentType);
            this.headers.put(headerKey, s);
            wasSet = true;
        }
        if (!wasSet) {
            HashSet<String> s = new HashSet<String>();
            s.add(contentType);
            this.headers.put("content-type", s);
        }
        this.headers.put("upgrade", Collections.emptySet());
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public String getHeader(String key) {
        Set<String> e = this.headers.get(key.toLowerCase());
        if (e != null) {
            Iterator<String> it = e.iterator();
            String s = it.next();
            return s;
        }
        return null;
    }

    public Enumeration<String> getHeaders(String key) {
        Set<String> r = this.headers.get(key.toLowerCase());
        if (r != null) {
            return Collections.enumeration(r);
        }
        return null;
    }
}

