/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.guru;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiservletframework.UncaughtExceptionLogger;
import javax.servlet.GenericServlet;

public final class GuruMeditationHook
extends UncaughtExceptionLogger {
    private PathCached affectedFile = null;

    public GuruMeditationHook(GenericServlet servlet) {
        super(servlet);
    }

    @Override
    public void uncaughtException(Thread t, Throwable th) {
        int i;
        String msg;
        String name = t != null ? t.getName() : "unknown thread";
        StackTraceElement[] ste = th.getStackTrace();
        StringBuffer errormessage = new StringBuffer();
        errormessage.append(name + " : ");
        errormessage.append(th.toString() + "\n");
        for (StackTraceElement element : ste) {
            errormessage.append("Thread Crash " + name + ": " + element.toString() + "\n");
        }
        if (this.affectedFile == null) {
            msg = th.getLocalizedMessage();
            if (this.logger != null) {
                if (this.logger.isDebugEnabled()) {
                    StackTraceElement[] trace = th.getStackTrace();
                    th.printStackTrace();
                    for (i = 0; i < trace.length; ++i) {
                        this.logger.log(9001, "\tat " + trace[i]);
                    }
                }
            } else {
                System.err.println(msg);
            }
        } else {
            msg = th.getLocalizedMessage() + "; Crash with image: " + this.affectedFile;
            if (this.logger != null) {
                this.logger.log(9001, msg);
                if (this.logger.isDebugEnabled()) {
                    StackTraceElement[] trace = th.getStackTrace();
                    for (i = 0; i < trace.length; ++i) {
                        this.logger.log(9001, "\tat " + trace[i]);
                    }
                }
            } else {
                this.servlet.log(msg, th);
            }
        }
    }

    public void setImage(PathCached file) {
        this.affectedFile = file;
    }
}

