/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class EISChainReader {
    public static Map<String, Integer> readAll(Path eisFile) throws IOException {
        Map<String, Integer> result;
        block13: {
            result = null;
            try (ReaderChannel draf = new ReaderChannel(eisFile, StandardOpenOption.READ);){
                EISChainReader.readAndEvaluateMagic(draf);
                EISChainReader.readAndHandleByteOrderEntry(draf);
                short version = EISChainReader.readVersion(draf);
                if (version == 1) {
                    result = EISChainReader.readAll(draf);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version: " + version + " in " + draf);
            }
        }
        return result;
    }

    public static boolean isChainFile(Path eisFile) throws IOException {
        try (FileChannel channel = (FileChannel)Files.newByteChannel(eisFile, StandardOpenOption.READ);){
            ByteBuffer b = ByteBuffer.allocate(8);
            if (channel.read(b) != 8) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(b.array(), EISEnvironment.EIS_CHAIN_MAGIC);
            return bl;
        }
    }

    public static int findChainEntryNumber(Path eisFile, String assetURLPath) throws IOException {
        int entryNumber;
        block13: {
            entryNumber = -1;
            try (ReaderChannel draf = new ReaderChannel(eisFile, StandardOpenOption.READ);){
                EISChainReader.readAndEvaluateMagic(draf);
                EISChainReader.readAndHandleByteOrderEntry(draf);
                short version = EISChainReader.readVersion(draf);
                if (version == 1) {
                    entryNumber = EISChainReader.readUntilEntryFound(draf, assetURLPath);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version: " + version + " in " + draf);
            }
        }
        return entryNumber;
    }

    public static int findChainEntryNumber(ReaderAbstract reader, String entryName) throws IOException {
        int result = -1;
        if (reader.position() != 8L) {
            reader.seek(8L);
        }
        EISChainReader.readAndHandleByteOrderEntry(reader);
        short version = EISChainReader.readVersion(reader);
        if (version != 1) {
            throw new IOException("Unknown EIS Chain Version: " + version + " in " + reader);
        }
        result = EISChainReader.readUntilEntryFound(reader, entryName);
        return result;
    }

    private static Map<String, Integer> readAll(ReaderAbstract reader) throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        while (reader.position() < reader.length()) {
            int chainNumber = reader.readInt();
            int entryLength = reader.readInt();
            byte[] rawEntryName = new byte[entryLength];
            reader.read(rawEntryName);
            String currentEntryName = new String(rawEntryName, FileOperations.charsetUTF8);
            result.put(currentEntryName, chainNumber);
        }
        return result;
    }

    private static int readUntilEntryFound(ReaderAbstract reader, String entryName) throws IOException {
        int result = -1;
        while (reader.position() < reader.length()) {
            int chainNumber = reader.readInt();
            int entryLength = reader.readInt();
            byte[] rawEntryName = new byte[entryLength];
            reader.read(rawEntryName);
            String currentEntryName = new String(rawEntryName, FileOperations.charsetUTF8);
            if (!currentEntryName.equals(entryName)) continue;
            result = chainNumber;
            break;
        }
        return result;
    }

    static void readAndEvaluateMagic(ReaderAbstract reader) throws IOException {
        byte[] magic = new byte[8];
        reader.read(magic);
        if (!Arrays.equals(magic, EISEnvironment.EIS_CHAIN_MAGIC)) {
            throw new IOException("Not a valid EIS Chain File (RAEM): " + reader);
        }
    }

    static void readAndEvaluateMagic(SeekableByteChannel channel) throws IOException {
        byte[] magic = new byte[8];
        ByteBuffer dst = ByteBuffer.wrap(magic);
        channel.read(dst);
        if (!Arrays.equals(magic, EISEnvironment.EIS_CHAIN_MAGIC)) {
            throw new IOException("Not a valid EIS Chain File: " + channel);
        }
    }

    static ByteOrder readAndHandleByteOrderEntry(ReaderAbstract reader) throws IOException {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        byte order = reader.readByte();
        if (order == 126) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == -66) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        reader.setByteOrder(byteOrder);
        return byteOrder;
    }

    static ByteOrder readAndHandleByteOrderEntry(SeekableByteChannel channel) throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(1);
        channel.read(dst);
        dst.flip();
        byte order = dst.get();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if (order == 126) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == -66) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return byteOrder;
    }

    static short readVersion(ReaderAbstract draf) throws IOException {
        return draf.readShort();
    }

    static short readVersion(SeekableByteChannel channel, ByteOrder bo) throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(2);
        channel.read(dst);
        dst.flip();
        dst.order(bo);
        return dst.getShort();
    }
}

