/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public final class EISChainWriter {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private Path eisFile = null;

    public EISChainWriter(FSILogger logger, Path eisFile) {
        this.eisFile = eisFile;
    }

    public void addEntry(int chainNumber, String entryName) throws IOException {
        if (Files.exists(this.eisFile, new LinkOption[0])) {
            this.addEntryToExistingChainFile(this.eisFile, chainNumber, entryName);
        } else {
            this.createNewChainFileWithEntry(this.eisFile, entryName, chainNumber);
        }
    }

    public void removeEntry(String entryName) throws IOException {
        if (Files.exists(this.eisFile, new LinkOption[0])) {
            Map<String, Integer> allEntries = EISChainReader.readAll(this.eisFile);
            allEntries.remove(entryName);
            if (allEntries.size() > 0) {
                this.createChainFileWithEntries(this.eisFile, allEntries);
            } else {
                Files.delete(this.eisFile);
            }
        } else {
            throw new NoSuchFileException(this.eisFile.toAbsolutePath().toString());
        }
    }

    private void createChainFileWithEntries(Path targetFile, Map<String, Integer> entries) throws IOException {
        int chainFilelength = EISEnvironment.EIS_CHAIN_MAGIC.length + 1 + 2;
        for (Map.Entry<String, Integer> entry : entries.entrySet()) {
            chainFilelength += 8 + entry.getKey().getBytes(FileOperations.charsetUTF8).length;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(chainFilelength);
        buffer.put(EISEnvironment.EIS_CHAIN_MAGIC);
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            buffer.put((byte)126);
        } else {
            buffer.put((byte)-66);
        }
        buffer.order(this.byteOrder);
        buffer.putShort((short)1);
        for (Map.Entry<String, Integer> entry : entries.entrySet()) {
            buffer.putInt(entry.getValue());
            byte[] entryBytes = entry.getKey().getBytes(FileOperations.charsetUTF8);
            buffer.putInt(entryBytes.length);
            buffer.put(entryBytes);
        }
        Path path = Files.createTempFile(targetFile.getParent(), targetFile.getFileName().toString(), ".tmp", new FileAttribute[0]);
        FileOperations.writeFile(path, buffer);
        FileOperations.move(path, targetFile);
    }

    private void createNewChainFileWithEntry(Path targetFile, String entryName, int chainNumber) throws IOException {
        HashMap<String, Integer> entryMap = new HashMap<String, Integer>();
        entryMap.put(entryName, chainNumber);
        this.createChainFileWithEntries(targetFile, entryMap);
    }

    private void addEntryToExistingChainFile(Path targetFile, int chainNumber, String entryName) throws IOException {
        block13: {
            try (SeekableByteChannel channel = Files.newByteChannel(targetFile, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                EISChainReader.readAndEvaluateMagic(channel);
                this.byteOrder = EISChainReader.readAndHandleByteOrderEntry(channel);
                short version = EISChainReader.readVersion(channel, this.byteOrder);
                if (version == 1) {
                    channel.position(channel.size());
                    byte[] entryBytes = entryName.getBytes(FileOperations.charsetUTF8);
                    ByteBuffer buf = ByteBuffer.allocateDirect(8 + entryBytes.length);
                    buf.order(this.byteOrder);
                    buf.putInt(chainNumber);
                    buf.putInt(entryBytes.length);
                    buf.put(entryBytes);
                    buf.flip();
                    channel.write(buf);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version in file " + targetFile);
            }
        }
    }
}

