/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TagInfo;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileContents;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.SPXMetaDataParser;
import com.neptunelabs.fsiserver.utils.cache.CacheableBytes;
import com.neptunelabs.fsiserver.utils.histogram.HistogramUtils;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagemanipulator.color.YCbCrToRGB;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.metrics.Histogram;
import com.neptunelabs.imagereader.reader.ImageIOHelper;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.InflaterOutputStream;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import sun.awt.image.ByteInterleavedRaster;

final class EISImageReader {
    private final FSIServerSettings settings;
    final CacheManager cacheManager;
    private final SwapPool swapPool;
    private final ReaderAbstract draf;
    private boolean headerRead = false;
    private final Path eisFile;
    ByteOrder byteOrder;
    private short eisVersion;
    private int numberOfHeaderTags;
    private TagInfo metadataInfo;
    private TagInfo customfsidataInfo;
    private TagInfo iptcInfo;
    private TagInfo exifInfo;
    private TagInfo xmpInfo;
    private TagInfo selectionsInfo;
    private TagInfo alphaNamesInfo;
    private TagInfo iccInfo;
    private TagInfo histogramInfo;
    private TagInfo tileMapInfo;
    private ImageMetaData imageMetaData = null;
    private int numberOfLevels;
    private final ExecutorPool executorPool;
    final boolean useCache;
    private final String assetURLPath;
    private final ReentrantLock lock = new ReentrantLock();
    private static volatile long instanceCounter;
    private volatile long openingTime;
    private volatile long headerTime;
    private volatile long rawReadTime;
    private final AtomicLong rawByteDataCalls = new AtomicLong(0L);
    private final AtomicLong rawByteDataCacheHits = new AtomicLong(0L);
    private volatile long tileLoading;
    volatile long tileParsingAndDecompressing;
    private volatile long closeTime;

    public EISImageReader(String assetURLPath, Path eisFile, ReaderAbstract draf, FSIServerSettings settings, SwapPool swapPool, ExecutorPool executorPool, boolean useCache) throws NoSuchFileException, IOException {
        ++instanceCounter;
        this.assetURLPath = assetURLPath;
        this.eisFile = eisFile;
        this.draf = draf;
        this.settings = settings;
        this.swapPool = swapPool;
        this.executorPool = executorPool;
        this.cacheManager = this.settings.getCacheManager();
        this.useCache = this.cacheManager != null ? useCache : false;
    }

    void readHeader() throws IOException {
        if (!this.headerRead) {
            long t0 = System.currentTimeMillis();
            CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageBaseHeader");
            byte[] headerBaseBytes = this.getRawByteData(cacheKey, 8L, 16);
            this.parseBaseHeaderBytes(headerBaseBytes);
            cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageTags");
            byte[] tagBytes = this.getRawByteData(cacheKey, 16L, this.numberOfHeaderTags * 24);
            this.parseTagMapBytes(tagBytes);
            this.headerRead = true;
            this.headerTime += System.currentTimeMillis() - t0;
        }
    }

    private void parseBaseHeaderBytes(byte[] bytes) {
        byte order = bytes[0];
        if (order == 126) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == -66) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteArrayWalker headerBuffer = ByteArrayWalker.wrap(bytes, this.byteOrder);
        headerBuffer.position(2);
        this.eisVersion = headerBuffer.getShort();
        this.numberOfHeaderTags = headerBuffer.getInt();
    }

    private void parseTagMapBytes(byte[] bytes) throws IOException {
        ByteArrayWalker tagMapBuffer = ByteArrayWalker.wrap(bytes, this.byteOrder);
        if (this.eisVersion == 3) {
            for (int i = 0; i < this.numberOfHeaderTags; ++i) {
                TagInfo ti = new TagInfo();
                ti.tag = tagMapBuffer.getLong();
                ti.position = tagMapBuffer.getLong();
                ti.length = (int)tagMapBuffer.getLong();
                ti.compressed = (ti.tag & 0x1000L) > 0L;
                ti.tag &= 0xFFFL;
                if (ti.tag == 501L) {
                    this.metadataInfo = ti;
                    continue;
                }
                if (ti.tag == 510L) {
                    this.customfsidataInfo = ti;
                    continue;
                }
                if (ti.tag == 503L) {
                    this.iptcInfo = ti;
                    continue;
                }
                if (ti.tag == 504L) {
                    this.exifInfo = ti;
                    continue;
                }
                if (ti.tag == 505L) {
                    this.xmpInfo = ti;
                    continue;
                }
                if (ti.tag == 520L) {
                    this.selectionsInfo = ti;
                    continue;
                }
                if (ti.tag == 521L) {
                    this.alphaNamesInfo = ti;
                    continue;
                }
                if (ti.tag == 506L) {
                    this.iccInfo = ti;
                    continue;
                }
                if (ti.tag == 507L) {
                    this.histogramInfo = ti;
                    continue;
                }
                if (ti.tag != 500L) continue;
                this.tileMapInfo = ti;
            }
        } else {
            throw new IOException("Unsupported EIS version " + this.eisVersion + " in " + this.eisFile);
        }
    }

    public short getEISVersion() {
        return this.eisVersion;
    }

    public ImageMetaData getImageMetaData() throws IOException {
        if (this.imageMetaData != null) {
            return this.imageMetaData;
        }
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageMeta");
        byte[] rawMetaData = this.getTagBytes(cacheKey, this.metadataInfo);
        if (rawMetaData != null) {
            this.imageMetaData = SPXMetaDataParser.getFromSPXBytes(rawMetaData, this.byteOrder);
        }
        return this.imageMetaData;
    }

    public byte[] getExifData() throws IOException {
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageEXIF");
        return this.getTagBytes(cacheKey, this.exifInfo);
    }

    public byte[] getIPTCData() throws IOException {
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageIPTC");
        return this.getTagBytes(cacheKey, this.iptcInfo);
    }

    public byte[] getXMPData() throws IOException {
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageXMP");
        return this.getTagBytes(cacheKey, this.xmpInfo);
    }

    public byte[] getSelectionsData() throws IOException {
        this.readHeader();
        byte[] selectionsData = null;
        if (this.selectionsInfo != null) {
            CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageSelections");
            selectionsData = this.getTagBytes(cacheKey, this.selectionsInfo);
        }
        return selectionsData;
    }

    public String[] getAlphaNames() throws IOException {
        this.readHeader();
        String[] alphaNames = null;
        if (this.alphaNamesInfo != null) {
            CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageAlphaNames");
            byte[] alphaNamesRaw = this.getTagBytes(cacheKey, this.alphaNamesInfo);
            ByteArrayWalker buffer = ByteArrayWalker.wrap(alphaNamesRaw, ByteOrder.LITTLE_ENDIAN);
            int alphaNameCount = buffer.getInt();
            alphaNames = new String[alphaNameCount];
            for (int a = 0; a < alphaNameCount; ++a) {
                int strLen = buffer.getInt();
                byte[] strRaw = new byte[strLen];
                buffer.get(strRaw);
                alphaNames[a] = new String(strRaw, FileOperations.charsetUTF8);
            }
        }
        return alphaNames;
    }

    public byte[] getICCData() throws IOException {
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageICC");
        return this.getTagBytes(cacheKey, this.iccInfo);
    }

    public Histogram getHistogram() throws IOException {
        this.readHeader();
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageHisto");
        Histogram result = null;
        byte[] histoData = this.getTagBytes(cacheKey, this.histogramInfo);
        if (histoData != null) {
            ByteArrayWalker histoBuffer = ByteArrayWalker.wrap(histoData, this.byteOrder);
            result = HistogramUtils.readHistogramFromByteBuffer(histoBuffer);
        }
        return result;
    }

    private byte[] getTagBytes(CacheKey cacheKey, TagInfo tag) throws IOException {
        if (tag == null) {
            return null;
        }
        byte[] byteRaw = this.getRawByteData(cacheKey, tag.position, (int)tag.length);
        if (tag.compressed) {
            try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(byteRaw.length);
                 InflaterOutputStream ios = new InflaterOutputStream(baos);){
                ios.write(byteRaw);
                ios.close();
                byteRaw = baos.toByteArray();
            }
        }
        return byteRaw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRawByteData(CacheKey cacheKey, long start, int length) throws IOException {
        byte[] data = null;
        if (start > 0L && length > 0) {
            CacheLoad cl;
            long t0 = System.currentTimeMillis();
            if (this.useCache && (cl = this.cacheManager.get(cacheKey, CacheType.BLOB)) != null) {
                data = cl.requestedL1Object != null ? ((CacheableBytes)cl.requestedL1Object).getData() : cl.data;
            }
            if (data != null) {
                this.rawByteDataCacheHits.incrementAndGet();
            } else {
                data = new byte[length];
                this.lock.lock();
                try {
                    this.draf.seek(start);
                    this.draf.read(data);
                }
                finally {
                    this.lock.unlock();
                }
                if (this.useCache) {
                    this.cacheManager.put(cacheKey, new CacheableBytes(data), true);
                }
            }
            if (data.length == 0) {
                data = null;
            }
            this.rawReadTime += System.currentTimeMillis() - t0;
            this.rawByteDataCalls.incrementAndGet();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRawByteData(long start, int length) throws IOException {
        long t0 = System.currentTimeMillis();
        byte[] data = new byte[length];
        this.lock.lock();
        try {
            this.draf.seek(start);
            this.draf.read(data);
        }
        finally {
            this.lock.unlock();
        }
        if (data.length == 0) {
            data = null;
        }
        this.rawReadTime += System.currentTimeMillis() - t0;
        this.rawByteDataCalls.incrementAndGet();
        return data;
    }

    private static double autoCorrectRangeParam(double start, double range) {
        if (start + range > 1.0) {
            range = 1.0 - start;
        }
        return range;
    }

    private FSIImage createResultImage(int width, int height) throws IOException {
        FSIImageMode mode = this.getImageMode();
        FSIImageLimited result = new FSIImageLimited(this.settings.getFSILogger(), this.swapPool, this.byteOrder, width, height, null, mode);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage getImage(int level, int leftPix, int topPix, int rangeWidthPix, int rangeHeightPix, int priority) throws IOException, NoSuchFileException, ProcessingException {
        FSIImage result;
        block19: {
            ArrayList futures;
            PriorityExecutorCompletionService completionService;
            int tilesTotal;
            int useThreadsPerRound;
            if (!this.headerRead) {
                this.readHeader();
            }
            Level[] levels = this.imageMetaData.getZoomLevels();
            int firstTileX = leftPix / levels[level].tileSizeX;
            int firstTileY = topPix / levels[level].tileSizeY;
            int totalWidthInLevel = levels[level].width;
            int levelTilesX = (int)Math.ceil((double)levels[level].width / (double)levels[level].tileSizeX);
            int levelTilesY = (int)Math.ceil((double)levels[level].height / (double)levels[level].tileSizeY);
            int numberOfTilesInRow = totalWidthInLevel / levels[level].tileSizeX;
            int currentResultOffsetX = 0;
            int currentResultOffsetY = 0;
            ExecutorPool.Type type = ExecutorPool.Type.RENDERER_CPU;
            int parCPUThreads = this.executorPool.getAvailableThreads(type);
            int n = useThreadsPerRound = parCPUThreads < (tilesTotal = (int)(Math.ceil((double)rangeWidthPix / (double)levels[level].tileSizeX) * Math.ceil((double)rangeHeightPix / (double)levels[level].tileSizeY))) ? parCPUThreads : tilesTotal;
            if (useThreadsPerRound == 1) {
                completionService = null;
                futures = null;
            } else {
                completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(type));
                futures = new ArrayList();
            }
            result = this.createResultImage(rangeWidthPix, rangeHeightPix);
            result.createExtraAlpha(this.imageMetaData.getExtraAlphaCount());
            Pair<Long, Integer>[][] tileMap = this.getLevelMap(level);
            boolean cacheTiles = tilesTotal != levelTilesX * levelTilesY;
            boolean error = false;
            try {
                int y = firstTileY;
                while (currentResultOffsetY < result.getHeight()) {
                    currentResultOffsetX = 0;
                    int n2 = 0;
                    if (y == firstTileY) {
                        n2 = topPix % levels[level].tileSizeY;
                    }
                    int x = firstTileX;
                    while (currentResultOffsetX < result.getWidth()) {
                        int tileOffsetX = 0;
                        if (x == firstTileX) {
                            tileOffsetX = leftPix % levels[level].tileSizeX;
                        }
                        int currentTileWidth = x == numberOfTilesInRow ? totalWidthInLevel % levels[level].tileSizeX : levels[level].tileSizeX;
                        Pair<Long, Integer> tileInfo = tileMap[x][y];
                        byte[] rawTile = this.getRawTileImageData(tileInfo.getItem1(), tileInfo.getItem2());
                        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "Tile-" + x + "-" + y + "-" + level);
                        TileTransferrerRawTile transferrer = new TileTransferrerRawTile(cacheKey, result.createSlice(), priority, rawTile, tileOffsetX, n2, currentResultOffsetX, currentResultOffsetY, currentTileWidth, cacheTiles);
                        if (completionService != null && futures != null) {
                            futures.add(completionService.submit(transferrer));
                        } else {
                            transferrer.run();
                        }
                        currentResultOffsetX += levels[level].tileSizeX - tileOffsetX;
                        ++x;
                    }
                    currentResultOffsetY += levels[level].tileSizeY - n2;
                    ++y;
                }
                if (completionService == null || futures == null) break block19;
                try {
                    for (int c = 0; c < completionService.count(); ++c) {
                        completionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    error = true;
                }
                finally {
                    for (Future future : futures) {
                        future.cancel(true);
                    }
                    if (error) {
                        result.dispose();
                    }
                }
            }
            catch (Exception e) {
                error = true;
                throw new ProcessingException(e.getCause());
            }
        }
        return result;
    }

    public FSIImage getImage(int level, double left, double top, double rangeWidth, double rangeHeight, int priority) throws IOException, NoSuchFileException, ProcessingException {
        if (!this.headerRead) {
            this.readHeader();
        }
        rangeWidth = EISImageReader.autoCorrectRangeParam(left, rangeWidth);
        rangeHeight = EISImageReader.autoCorrectRangeParam(top, rangeHeight);
        ImageMetaData imageMetaDataImage = this.getImageMetaData();
        Level[] levels = imageMetaDataImage.getZoomLevels();
        int totalWidthInLevel = levels[level].width;
        int totalHeightInLevel = levels[level].height;
        int resultWidth = FastMath.ceil((double)totalWidthInLevel * rangeWidth);
        int resultHeight = FastMath.ceil((double)totalHeightInLevel * rangeHeight);
        int xOffsetInLevel = FastMath.floor((double)totalWidthInLevel * left);
        int yOffsetInLevel = FastMath.floor((double)totalHeightInLevel * top);
        return this.getImage(level, xOffsetInLevel, yOffsetInLevel, resultWidth, resultHeight, priority);
    }

    private FSIImageMode getImageMode() throws IOException {
        FSIImageMode mode;
        byte format = this.getImageMetaData().getTileFormat();
        switch (format) {
            case 3: {
                mode = FSIImageMode.GRAY;
                break;
            }
            case 4: {
                mode = FSIImageMode.AGRAY;
                break;
            }
            case 1: {
                mode = FSIImageMode.RGB;
                break;
            }
            default: {
                mode = FSIImageMode.ARGB;
            }
        }
        return mode;
    }

    private byte[] getRawTileImageData(long start, int len) throws IOException {
        CacheLoad cl;
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageTileRawBytes-" + start);
        byte[] blob = null;
        if (this.useCache && (cl = this.cacheManager.get(cacheKey, CacheType.BLOB)) != null) {
            if (cl.requestedL1Object != null) {
                blob = ((CacheableBytes)cl.requestedL1Object).getData();
            } else if (cl.data != null) {
                blob = cl.data;
            }
            if (blob != null) {
                return blob;
            }
        }
        long t0 = System.currentTimeMillis();
        blob = this.getRawByteData(start, len);
        long t1 = System.currentTimeMillis();
        this.tileLoading += t1 - t0;
        if (this.useCache) {
            this.cacheManager.put(cacheKey, new CacheableBytes(blob), true);
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getYCbCrFromJPEGData(byte[] rawImageData) {
        byte[] result = null;
        ImageReader imageReader = ImageIOHelper.getReader("com.sun", "jpeg");
        if (imageReader != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(rawImageData);
                 MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(bais);){
                imageReader.setInput(mciis, false, false);
                Raster raster = imageReader.readRaster(0, null);
                if (raster instanceof ByteInterleavedRaster) {
                    ByteInterleavedRaster biRaster = (ByteInterleavedRaster)raster;
                    result = biRaster.getDataStorage();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                imageReader.dispose();
                imageReader = null;
            }
        }
        return result;
    }

    private static void filterRevSub4(byte[] data, int width) {
        int len = data.length;
        int width4 = width * 4;
        int rows = len / width4;
        for (int r = 0; r < rows; ++r) {
            int pos = r * width4 + width4 - 1;
            for (int c = 0; c < width4; c += 4) {
                int n = pos;
                data[n] = (byte)(data[n] + data[pos + 4]);
                int n2 = pos - 1;
                data[n2] = (byte)(data[n2] + data[pos + 5]);
                int n3 = pos - 2;
                data[n3] = (byte)(data[n3] + data[pos + 6]);
                int n4 = pos - 3;
                data[n4] = (byte)(data[n4] + data[pos + 7]);
                pos += 4;
            }
        }
    }

    TileContents parseTileContents(ByteArrayWalker buffer) {
        TileContents tile = new TileContents();
        int eaCount = 0;
        block17: while (buffer.remaining() > 0) {
            short tag = buffer.getShort();
            int tagContentLength = buffer.getInt();
            switch (tag) {
                case 14: {
                    tile.imageWidth = buffer.getShort();
                    continue block17;
                }
                case 15: {
                    tile.imageHeight = buffer.getShort();
                    continue block17;
                }
                case 101: {
                    tile.dataFormat = buffer.get();
                    continue block17;
                }
                case 103: {
                    tile.dataFilter = buffer.get();
                    continue block17;
                }
                case 102: {
                    tile.dataCompression = buffer.get();
                    continue block17;
                }
                case 200: {
                    tile.imageData = new byte[tagContentLength];
                    buffer.get(tile.imageData);
                    continue block17;
                }
                case 201: {
                    tile.imageAlpha = new byte[tagContentLength];
                    buffer.get(tile.imageAlpha);
                    tile.imageAlpha = EISImageReader.unpackDeflate(tile.imageAlpha, tile.imageWidth * tile.imageHeight);
                    continue block17;
                }
                case 300: {
                    tile.imageExtraAlphaCount = buffer.getInt();
                    tile.imageExtraAlpha = new byte[tile.imageExtraAlphaCount][];
                    continue block17;
                }
                case 301: {
                    if (tile.imageExtraAlpha != null) {
                        tile.imageExtraAlpha[eaCount] = new byte[tagContentLength];
                        buffer.get(tile.imageExtraAlpha[eaCount]);
                        tile.imageExtraAlpha[eaCount] = EISImageReader.unpackDeflate(tile.imageExtraAlpha[eaCount], tile.imageWidth * tile.imageHeight);
                    }
                    ++eaCount;
                    continue block17;
                }
            }
            buffer.position(buffer.position() + tagContentLength);
        }
        if (tile.dataFormat == TileCompression.LOSSLESS.ordinal()) {
            switch (tile.dataCompression) {
                case 2: {
                    tile.imageData = EISImageReader.unpackDeflate(tile.imageData, tile.imageWidth * tile.imageHeight * 4);
                }
            }
            switch (tile.dataFilter) {
                case 1: {
                    EISImageReader.filterRevSub4(tile.imageData, tile.imageWidth);
                }
            }
            tile.imageDataFormat = 1;
        } else if (tile.dataFormat == TileCompression.JPEG.ordinal()) {
            tile.imageData = EISImageReader.getYCbCrFromJPEGData(tile.imageData);
            tile.imageDataFormat = 2;
        }
        return tile;
    }

    /*
     * Exception decompiling
     */
    private static byte[] unpackDeflate(byte[] data, int maxlen) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pair<Long, Integer>[][] getLevelMap(int level) throws IOException {
        int tilesY;
        int tilesX;
        CacheKey cacheKey = CacheKey.getInstance(this.assetURLPath, 'A', "EisImageTileMap");
        byte[] tileMapRaw = this.getTagBytes(cacheKey, this.tileMapInfo);
        ByteArrayWalker mapBuffer = ByteArrayWalker.wrap(tileMapRaw, this.byteOrder);
        this.numberOfLevels = mapBuffer.getInt();
        for (int currentLevel = 0; currentLevel != level; ++currentLevel) {
            tilesX = mapBuffer.getInt();
            tilesY = mapBuffer.getInt();
            int bytesToSkip = tilesX * tilesY * 16;
            mapBuffer.position(mapBuffer.position() + bytesToSkip);
        }
        tilesX = mapBuffer.getInt();
        tilesY = mapBuffer.getInt();
        Pair[][] result = new Pair[tilesX][tilesY];
        for (int y = 0; y < tilesY; ++y) {
            for (int x = 0; x < tilesX; ++x) {
                long position = mapBuffer.getLong();
                int length = (int)mapBuffer.getLong();
                result[x][y] = new Pair<Long, Integer>(position, length);
            }
        }
        return result;
    }

    private void printStats() {
        System.err.println("EISImageReaderStats: ");
        System.err.println("-- Instances: " + instanceCounter);
        System.err.println("-- OpeningTime: " + this.openingTime);
        System.err.println("-- HeaderTime: " + this.headerTime);
        System.err.println("-- RawReadingTime: " + this.rawReadTime);
        System.err.println("-- RawByteDataCacheHits: " + this.rawByteDataCacheHits);
        System.err.println("-- RawByteDataCalls: " + this.rawByteDataCalls);
        System.err.println("-- tileLoading: " + this.tileLoading);
        System.err.println("-- tileParsingAndDecompressing: " + this.tileParsingAndDecompressing);
        System.err.println("-- CloseTime: " + this.closeTime);
    }

    public void dumpHeader() {
        System.err.println("EIS Image File header");
        System.err.println("---------------------");
        System.err.println("Number of Header Tags : " + this.numberOfHeaderTags);
        System.err.println("ImageMeta (Start|Len) : " + this.metadataInfo.toString());
        if (this.customfsidataInfo != null) {
            System.err.println("CustomMeta (Start|Len): " + this.customfsidataInfo.toString());
        }
        if (this.iptcInfo != null) {
            System.err.println("IPTC (Start|Len)      : " + this.iptcInfo.toString());
        }
        if (this.exifInfo != null) {
            System.err.println("EXIF (Start|Len)      : " + this.exifInfo.toString());
        }
        if (this.xmpInfo != null) {
            System.err.println("XMP (Start|Len)       : " + this.xmpInfo.toString());
        }
        if (this.selectionsInfo != null) {
            System.err.println("Selections (Start|Len)       : " + this.selectionsInfo.toString());
        }
        if (this.alphaNamesInfo != null) {
            System.err.println("AlphaNames (Start|Len)       : " + this.alphaNamesInfo.toString());
        }
        if (this.iccInfo != null) {
            System.err.println("ICC (Start|Len)       : " + this.iccInfo.toString());
        }
        if (this.histogramInfo != null) {
            System.err.println("histogram (Start|Len) : " + this.histogramInfo.toString());
        }
        if (this.tileMapInfo != null) {
            System.err.println("tileMap  (Start|Len)           : " + this.tileMapInfo.toString());
            System.err.println("# levels              : " + this.numberOfLevels);
        }
    }

    public static final int clampFT255(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 255.0f) {
            return 255;
        }
        return (int)(x + 0.5f);
    }

    private class TileTransferrerRawTile
    implements Runnable,
    PriorityExecutor.Important {
        private final CacheKey cacheKeyTile;
        private final FSIImage targetImage;
        private final int priority;
        private final byte[] rawTile;
        private final int tileOffsetX;
        private final int tileOffsetY;
        private final int currentResultOffsetX;
        private final int currentResultOffsetY;
        private final int currentTileWidth;
        private final boolean cacheTiles;

        TileTransferrerRawTile(CacheKey cacheKeyTile, FSIImage targetImage, int priority, byte[] rawTile, int tileOffsetX, int tileOffsetY, int targetOffsetX, int targetOffsetY, int currentTileWidth, boolean cacheTiles) {
            this.cacheKeyTile = cacheKeyTile;
            this.targetImage = targetImage;
            this.priority = priority;
            this.rawTile = rawTile;
            this.tileOffsetX = tileOffsetX;
            this.tileOffsetY = tileOffsetY;
            this.currentResultOffsetX = targetOffsetX;
            this.currentResultOffsetY = targetOffsetY;
            this.currentTileWidth = currentTileWidth;
            this.cacheTiles = cacheTiles;
        }

        @Override
        public void run() {
            block22: {
                int lineStartSkipBytesAlpha;
                int j;
                int i;
                int horizontalBarrier;
                int rasterStartAlpha;
                int banks;
                boolean hasExtraAlpha;
                byte[] argbData;
                TileContents tile;
                block23: {
                    CacheLoad cl;
                    tile = EISImageReader.this.useCache ? ((cl = EISImageReader.this.cacheManager.get(this.cacheKeyTile, CacheType.TILE)) != null ? (cl.requestedL1Object != null ? (TileContents)cl.requestedL1Object : TileContents.unpack(cl.data)) : null) : null;
                    long t0 = System.currentTimeMillis();
                    if (tile == null) {
                        ByteArrayWalker tileDataWalker = ByteArrayWalker.wrap(this.rawTile, EISImageReader.this.byteOrder);
                        tile = EISImageReader.this.parseTileContents(tileDataWalker);
                        if (EISImageReader.this.useCache && this.cacheTiles) {
                            EISImageReader.this.cacheManager.put(this.cacheKeyTile, tile, true);
                        }
                    }
                    long t2 = System.currentTimeMillis();
                    EISImageReader.this.tileParsingAndDecompressing += t2 - t0;
                    argbData = tile.imageData;
                    if (argbData == null) {
                        throw new RuntimeException("Invalid image data");
                    }
                    if (tile.imageExtraAlphaCount > 0) {
                        hasExtraAlpha = true;
                        banks = tile.imageExtraAlphaCount;
                    } else {
                        hasExtraAlpha = false;
                        banks = 0;
                    }
                    rasterStartAlpha = this.tileOffsetY * this.currentTileWidth + this.tileOffsetX;
                    horizontalBarrier = this.currentTileWidth - this.tileOffsetX;
                    i = 0;
                    j = this.currentResultOffsetY;
                    lineStartSkipBytesAlpha = this.tileOffsetX;
                    if (tile.imageDataFormat != 1) break block23;
                    int rasterStart = (this.tileOffsetY * this.currentTileWidth + this.tileOffsetX) * 4;
                    int lineStartSkipBytes = this.tileOffsetX * 4;
                    int p = rasterStart;
                    int a = rasterStartAlpha;
                    while (p < argbData.length) {
                        int x = i + this.currentResultOffsetX;
                        this.targetImage.setSample(x, j, (argbData[p] & 0xFF) << 24 | (argbData[p + 1] & 0xFF) << 16 | (argbData[p + 2] & 0xFF) << 8 | argbData[p + 3] & 0xFF);
                        if (hasExtraAlpha) {
                            for (int b = 0; b < banks; ++b) {
                                this.targetImage.setSampleExtraAlpha(b, x, j, tile.imageExtraAlpha[b][a]);
                            }
                        }
                        if (++i == horizontalBarrier) {
                            i = 0;
                            ++j;
                            if (lineStartSkipBytes != 0) {
                                p += lineStartSkipBytes;
                                a += lineStartSkipBytesAlpha;
                            }
                        } else if (this.currentResultOffsetX + i == this.targetImage.getWidth()) {
                            p += (this.currentTileWidth - i) * 4;
                            a += this.currentTileWidth - i;
                            i = 0;
                            ++j;
                        }
                        if (j != this.targetImage.getHeight()) {
                            p += 4;
                            ++a;
                            continue;
                        }
                        break block22;
                    }
                    break block22;
                }
                if (tile.imageDataFormat != 2) break block22;
                int rasterStart = (this.tileOffsetY * this.currentTileWidth + this.tileOffsetX) * 3;
                int lineStartSkipBytes = this.tileOffsetX * 3;
                int p = rasterStart;
                int a = rasterStartAlpha;
                while (p < argbData.length) {
                    int x = i + this.currentResultOffsetX;
                    int alpha = 255;
                    if (tile.imageAlpha != null) {
                        alpha = tile.imageAlpha[a];
                    }
                    this.targetImage.setSample(x, j, alpha << 24 | YCbCrToRGB.convertYCbCrToRGB(argbData[p] & 0xFF, argbData[p + 1] & 0xFF, argbData[p + 2] & 0xFF));
                    if (hasExtraAlpha) {
                        for (int b = 0; b < banks; ++b) {
                            this.targetImage.setSampleExtraAlpha(b, x, j, tile.imageExtraAlpha[b][a]);
                        }
                    }
                    if (++i == horizontalBarrier) {
                        i = 0;
                        ++j;
                        if (lineStartSkipBytes != 0) {
                            p += lineStartSkipBytes;
                            a += lineStartSkipBytesAlpha;
                        }
                    } else if (this.currentResultOffsetX + i == this.targetImage.getWidth()) {
                        p += (this.currentTileWidth - i) * 3;
                        a += this.currentTileWidth - i;
                        i = 0;
                        ++j;
                    }
                    if (j != this.targetImage.getHeight()) {
                        p += 3;
                        ++a;
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }
}

