/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISImageReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class EISReader
implements Closeable {
    private final FSIServerSettings settings;
    private final SwapPool swapPool;
    private ReaderAbstract draf;
    private Path eisFile;
    private final ExecutorPool executorPool;
    private EISImageReader eisImageReader;
    private final boolean useCache;
    private boolean closed = false;

    public EISReader(String assetURLPath, Path eisFile, FSIServerSettings settings, SwapPool swapPool, ExecutorPool executorPool, boolean useCache) throws NoSuchFileException, NotAValidEISFileException, IOException {
        this.eisFile = eisFile;
        this.settings = settings;
        this.swapPool = swapPool;
        this.executorPool = executorPool;
        this.useCache = useCache;
        this.init(assetURLPath);
    }

    private void init(String assetURLPath) throws NoSuchFileException, NotAValidEISFileException, IOException {
        block9: {
            LockerReadWrite.Value<String> eisLock = this.settings.getFileLockHandler().readLock(this.eisFile.toString());
            try {
                this.draf = new ReaderChannel(this.eisFile, StandardOpenOption.READ);
                byte[] magic = new byte[8];
                this.draf.read(magic);
                if (Arrays.equals(magic, EISEnvironment.EIS_CHAIN_MAGIC)) {
                    int foundChainNumber = EISChainReader.findChainEntryNumber(this.draf, assetURLPath);
                    this.draf.close();
                    if (foundChainNumber == -1) {
                        throw new NoSuchFileException("No such entry for " + assetURLPath + " in chain");
                    }
                    this.eisFile = StorageManager.getChainedDestination(this.eisFile, foundChainNumber);
                    this.draf = new ReaderChannel(this.eisFile, StandardOpenOption.READ);
                    this.draf.read(magic);
                }
                if (Arrays.equals(magic, EISEnvironment.EIS_IMAGE_MAGIC)) {
                    this.eisImageReader = new EISImageReader(assetURLPath, this.eisFile, this.draf, this.settings, this.swapPool, this.executorPool, this.useCache);
                    break block9;
                }
                this.draf.close();
                throw new NotAValidEISFileException(this.eisFile);
            }
            catch (IOException e) {
                if (this.draf != null) {
                    this.draf.close();
                }
                throw e;
            }
            finally {
                this.settings.getFileLockHandler().unlockRead(eisLock);
            }
        }
    }

    public ImageMetaData getImageMetaData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getImageMetaData();
    }

    public byte[] getExifData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getExifData();
    }

    public byte[] getIPTCData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getIPTCData();
    }

    public byte[] getXMPData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getXMPData();
    }

    public byte[] getSelectionsData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getSelectionsData();
    }

    public String[] getAlphaNames() throws NoSuchFileException, IOException {
        return this.eisImageReader.getAlphaNames();
    }

    public byte[] getICCData() throws NoSuchFileException, IOException {
        return this.eisImageReader.getICCData();
    }

    public Histogram getHistogram() throws NoSuchFileException, IOException {
        return this.eisImageReader.getHistogram();
    }

    public FSIImage getImage(int level, int left, int top, int rangeWidth, int rangeHeight, int priority) throws IOException, NoSuchFileException, ProcessingException {
        return this.eisImageReader.getImage(level, left, top, rangeWidth, rangeHeight, priority);
    }

    public FSIImage getImage(int level, double left, double top, double rangeWidth, double rangeHeight, int priority) throws IOException, NoSuchFileException, ProcessingException {
        return this.eisImageReader.getImage(level, left, top, rangeWidth, rangeHeight, priority);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.draf.close();
            }
            catch (IOException e) {
                this.settings.getFSILogger().logException(e, 3259, this.eisFile);
            }
        }
    }

    public Path getEISFile() {
        return this.eisFile;
    }

    public void dumpHeader() {
        this.eisImageReader.dumpHeader();
    }
}

