/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.imagereader.ImageFormat;
import java.nio.file.Path;

public class FileImportJob
implements Comparable<FileImportJob> {
    private QueueType queueType;
    private final PathCached sourceFile;
    public final Path eisFile;
    public final String assetURLPath;
    public final SourceConnectorReader sourceConnector;
    public final ImageFormat format;
    public final int priority;
    public final boolean reimportErrorImage;
    public ImportMode importMode = ImportMode.CONVERT;
    public SkipReason skipReason;
    public JobStatus status = JobStatus.PENDING;
    public Path dirlistFile = null;
    public int sourceWidth = -1;
    public int sourceHeight = -1;
    public boolean useSwap = false;
    public boolean makeHistogram = true;
    public long processTime;
    public long finishTime;
    public String id = null;

    public FileImportJob(QueueType queueType, SourceConnectorReader sourceConnector, PathCached sourceFile, ImageFormat format, Path eisFile, String assetURLPath, int priority, boolean reimportErrorImage) {
        this.queueType = queueType;
        this.sourceConnector = sourceConnector;
        this.sourceFile = sourceFile;
        this.format = format;
        this.eisFile = eisFile;
        this.assetURLPath = FileOperations.convertBackslash(assetURLPath);
        this.priority = priority;
        this.reimportErrorImage = reimportErrorImage;
    }

    public FileImportJob(QueueType queueType, PathCached sourceFile, ImageFormat format, String assetURLPath) {
        this.queueType = queueType;
        this.sourceFile = sourceFile;
        this.format = format;
        this.assetURLPath = assetURLPath;
        this.eisFile = null;
        this.sourceConnector = null;
        this.reimportErrorImage = true;
        this.priority = 0;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public void setQueueType(QueueType type) {
        this.queueType = type;
    }

    public String toString() {
        String result = "FileImportJob [ " + this.sourceFile + ", ImportMode " + this.importMode.name() + ", Profile " + this.sourceConnector + "]";
        return result;
    }

    public ImageFormat.Type getType() {
        if (this.sourceFile == null) {
            return ImageFormat.Type.UNK;
        }
        return this.format.type;
    }

    public final PathCached getSourceFile() {
        return this.sourceFile;
    }

    public final Path getEisFile() {
        return this.eisFile;
    }

    public final String getAssetURLPath() {
        return this.assetURLPath;
    }

    public final String getDirectoryURLPath() {
        int lslash = this.assetURLPath.lastIndexOf("/", this.assetURLPath.length() - 2);
        String parentdirpath = lslash != -1 ? this.assetURLPath.substring(0, lslash) : "/";
        return parentdirpath;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final SourceConnectorReader getProfile() {
        return this.sourceConnector;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileImportJob other = (FileImportJob)obj;
        return !(this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile));
    }

    @Override
    public int compareTo(FileImportJob other) {
        return this.priority < other.priority ? -1 : (this.priority > other.priority ? 1 : 0);
    }

    public static enum JobStatus {
        PENDING,
        ACTIVE,
        COMPLETED,
        FAILED;

    }

    public static enum SkipReason {
        QUEUED,
        ERROR,
        IGNORE;

    }

    public static enum ImportMode {
        CONVERT,
        SKIP;

    }
}

