/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.WriterAbstract;
import com.neptunelabs.fsiframework.io.WriterChannel;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;

public class DirListWriter
extends StorageDataProvider {
    private final FSILogger logger;
    private final StorageLogger storageLogger;
    private final PoolList poollist;

    public DirListWriter(FSILogger logger, PoolList poollist, StorageLogger storageLogger) {
        this.logger = logger;
        this.poollist = poollist;
        this.storageLogger = storageLogger;
    }

    @Override
    public boolean useTemporaryFile() {
        return true;
    }

    @Override
    public String getAssetURLPath() {
        return this.poollist.getAssetURLPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws IOException {
        boolean success = false;
        if (this.destinationPath == null) {
            throw new IllegalArgumentException("Tried to execute dirlistwriter without specifying the destination");
        }
        long t0 = System.currentTimeMillis();
        Collection<PoolFileEntry> imageList = this.poollist.getFilesAsCollection();
        try (WriterChannel sow = new WriterChannel(this.destinationPath, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            ByteArrayWalker baw;
            int len;
            ((WriterAbstract)sow).write(EISEnvironment.SPD_MAGIC);
            ByteOrder bo = ByteOrder.nativeOrder();
            sow.setByteOrder(bo);
            ((WriterAbstract)sow).writeByte((byte)(bo != ByteOrder.LITTLE_ENDIAN ? 1 : 0));
            ((WriterAbstract)sow).writeShort((short)2);
            List<PoolDirectoryEntry> directoryList = this.poollist.getDirectoriesAsList();
            ((WriterAbstract)sow).writeTagLong((short)10, imageList.size());
            ((WriterAbstract)sow).writeTagLong((short)11, this.poollist.getDirectories().size());
            ((WriterAbstract)sow).writeTagLong((short)100, this.poollist.lastmodified);
            for (PoolDirectoryEntry dir : directoryList) {
                byte[] dirBytes = dir.name.getBytes(FileOperations.charsetUTF8);
                len = 3 + dirBytes.length + 9 + 5 + 5;
                baw = ByteArrayWalker.allocate(len, bo);
                baw.put((byte)0);
                baw.putShort((short)dirBytes.length);
                baw.put(dirBytes);
                baw.put((byte)1);
                baw.putLong(dir.lastmodified);
                baw.put((byte)2);
                baw.putInt((int)dir.files);
                baw.put((byte)3);
                baw.putInt((int)dir.subdirectories);
                ((WriterAbstract)sow).writeTagBytes((short)102, baw.array());
                baw = null;
            }
            for (PoolFileEntry entry : imageList) {
                byte[] entryBytes = entry.name.getBytes(FileOperations.charsetUTF8);
                len = 3 + entryBytes.length + 9 + 9 + 5 + 5 + 2;
                baw = ByteArrayWalker.allocate(len, bo);
                baw.put((byte)1);
                baw.putShort((short)entryBytes.length);
                baw.put(entryBytes);
                baw.put((byte)2);
                baw.putLong(entry.filesize);
                baw.put((byte)3);
                baw.putLong(entry.lastmodified);
                baw.put((byte)4);
                baw.putInt(entry.width);
                baw.put((byte)5);
                baw.putInt(entry.height);
                baw.put((byte)0);
                baw.put(entry.importStatus);
                ((WriterAbstract)sow).writeTagBytes((short)101, baw.array());
                baw = null;
            }
            ((WriterAbstract)sow).writeShort((short)3854);
            success = true;
        }
        finally {
            if (success) {
                FileOperations.setSafeLastModified(this.destinationPath, this.poollist.lastmodified);
            }
        }
        long t1 = System.currentTimeMillis();
        this.storageLogger.log('D', StorageLogger.LogCMD.U, this.poollist.getAssetURLPath());
        this.logger.log(3506, this.poollist.getAssetURLPath(), this.destinationPath, t1 - t0, imageList.size(), this.poollist.getDirectories().size());
        return success;
    }
}

