/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TagInfo;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class EISImageStatusUpdater
extends StorageDataProvider {
    private short newImportStatus;
    private ByteOrder byteOrder;
    private int numberOfHeaderTags;
    private short eisVersion;
    private TagInfo metadataInfo;

    @Override
    public boolean useTemporaryFile() {
        return false;
    }

    public void setNewStatus(short importStatus) {
        this.newImportStatus = importStatus;
    }

    @Override
    public boolean execute() throws IOException {
        boolean success;
        block29: {
            success = false;
            try (SeekableByteChannel channel = Files.newByteChannel(this.destinationPath, StandardOpenOption.WRITE, StandardOpenOption.READ);){
                ByteBuffer dst = ByteBuffer.allocate(8);
                channel.read(dst);
                dst.flip();
                if (Arrays.equals(dst.array(), EISEnvironment.EIS_IMAGE_MAGIC)) {
                    this.readHeader(channel);
                    this.updateMetaData(channel);
                    success = true;
                    break block29;
                }
                if (Arrays.equals(dst.array(), EISEnvironment.EIS_CHAIN_MAGIC)) {
                    int index = EISChainReader.findChainEntryNumber(this.destinationPath, this.getAssetURLPath());
                    Path chainEIS = StorageManager.getChainedDestination(this.destinationPath, index);
                    try (SeekableByteChannel chainChannel = Files.newByteChannel(chainEIS, StandardOpenOption.WRITE, StandardOpenOption.READ);){
                        ByteBuffer dstChain = ByteBuffer.allocate(8);
                        chainChannel.read(dstChain);
                        dstChain.flip();
                        if (Arrays.equals(dstChain.array(), EISEnvironment.EIS_IMAGE_MAGIC)) {
                            this.readHeader(chainChannel);
                            this.updateMetaData(chainChannel);
                        }
                    }
                    success = true;
                    break block29;
                }
                throw new IOException("Not a valid EIS Image file: " + this.destinationPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    private void readHeader(SeekableByteChannel channel) throws IOException {
        byte[] headerBaseBytes = this.getRawByteData(channel, 8L, 16);
        this.parseBaseHeaderBytes(headerBaseBytes);
        byte[] tagBytes = this.getRawByteData(channel, 16L, this.numberOfHeaderTags * 24);
        this.parseTagMapBytes(tagBytes);
    }

    private void parseBaseHeaderBytes(byte[] bytes) {
        byte order = bytes[0];
        if (order == 126) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (order == -66) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteArrayWalker headerBuffer = ByteArrayWalker.wrap(bytes, this.byteOrder);
        headerBuffer.position(2);
        this.eisVersion = headerBuffer.getShort();
        this.numberOfHeaderTags = headerBuffer.getInt();
    }

    private void parseTagMapBytes(byte[] bytes) throws IOException {
        ByteArrayWalker tagMapBuffer = ByteArrayWalker.wrap(bytes, this.byteOrder);
        if (this.eisVersion == 3) {
            for (int i = 0; i < this.numberOfHeaderTags; ++i) {
                TagInfo ti = new TagInfo();
                ti.tag = tagMapBuffer.getLong();
                ti.position = tagMapBuffer.getLong();
                ti.length = (int)tagMapBuffer.getLong();
                ti.compressed = (ti.tag & 0x1000L) > 0L;
                ti.tag &= 0xFFFL;
                if (ti.tag != 501L) continue;
                this.metadataInfo = ti;
            }
        } else {
            throw new IOException("Unsupported EIS version " + this.eisVersion + " in " + this.destinationPath);
        }
    }

    private byte[] getRawByteData(SeekableByteChannel channel, long start, int length) throws IOException {
        byte[] data = null;
        if (start > 0L && length > 0) {
            channel.position(start);
            data = new byte[length];
            ByteBuffer dst = ByteBuffer.wrap(data);
            channel.read(dst);
            if (data.length == 0) {
                data = null;
            }
        }
        return data;
    }

    private boolean updateMetaData(SeekableByteChannel channel) throws IOException {
        boolean result = false;
        long metadataStart = this.metadataInfo.position;
        long metadataEnd = metadataStart + this.metadataInfo.length;
        channel.position(metadataStart);
        while (channel.position() < metadataEnd) {
            ByteBuffer dst = ByteBuffer.allocate(2);
            dst.order(this.byteOrder);
            channel.read(dst);
            dst.flip();
            short tag = dst.getShort();
            dst = ByteBuffer.allocate(4);
            dst.order(this.byteOrder);
            channel.read(dst);
            dst.flip();
            int tagContentLength = dst.getInt();
            if (tag == 2) {
                dst = ByteBuffer.allocate(2);
                dst.order(this.byteOrder);
                dst.putShort(this.newImportStatus);
                dst.flip();
                channel.write(dst);
                result = true;
                break;
            }
            channel.position(channel.position() + (long)tagContentLength);
        }
        return result;
    }
}

