/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.BasicImageMetaData;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.RawDataWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.RawDataWriterResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TagInfo;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileEncoder;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileEncoderResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.histogram.HistogramUtils;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagemanipulator.area.scale.UniScaler;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class EISImageWriter
extends StorageDataProvider {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private final StorageLogger storageLogger;
    private final UniScaler scaler;
    private final TileCompression tileFormat;
    private final int tileSize;
    private final SourceConnectorReader.LevelQuality levelQuality;
    private final JPEGPreparation jpegPreparation;
    private final int imageReaderVersion;
    private final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private byte format = (byte)-1;
    private int sourceWidth = 0;
    private int sourceHeight = 0;
    private FSIMetaData metaData = null;
    private FSIImage image = null;
    private FSIImage smartBuffer = null;
    private FSIImage scaledImage = null;
    private int extraAlphaCount = 0;
    private Level[] zoomLevels;
    private List<Pair<Integer, Integer>> tilesForZoomLevel;
    private boolean dataWritten = false;
    private volatile boolean pause = false;
    private volatile boolean stop = false;
    private volatile boolean error = false;
    private ImageFormat sourceFormat = null;
    private int srcImageCount = 1;
    private WriterMode mode;
    private final int priority;
    private short predefinedImportStatus = 0;
    private boolean maximumScaleQuality = false;
    private final boolean useCompression = true;

    public EISImageWriter(FSILogger logger, ExecutorPool executorPool, StorageLogger storageLogger, TileCompression tileFormat, int tileSize, SourceConnectorReader.LevelQuality levelQuality, JPEGPreparation jpegPreparation, int priority, int imageReaderVersion) {
        this.logger = logger;
        this.executorPool = executorPool;
        this.storageLogger = storageLogger;
        this.tileFormat = tileFormat;
        this.tileSize = tileSize;
        this.levelQuality = levelQuality;
        this.imageReaderVersion = imageReaderVersion;
        this.jpegPreparation = jpegPreparation;
        this.mode = WriterMode.COMPLETE;
        this.priority = priority;
        this.scaler = new UniScaler(logger, executorPool);
    }

    public EISImageWriter(SourceManagerSettings settings, short predefinedImportStatus, int imageReaderVersion) {
        this(settings.getFSILogger(), settings.getExecutorPool(), settings.getStorageManager().getStorageLogger(), null, 0, null, null, 0, imageReaderVersion);
        this.predefinedImportStatus = predefinedImportStatus;
        this.mode = WriterMode.METADATA_ONLY;
    }

    @Override
    public boolean useTemporaryFile() {
        return true;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public void setJobType(ImageFormat format) {
        this.sourceFormat = format;
    }

    public void setSrcImageCount(int count) {
        this.srcImageCount = count;
    }

    public void setMetaData(FSIMetaData metaData) {
        this.metaData = metaData;
    }

    public void setImage(FSIImage image, FSIMetaData metaData) {
        this.image = image;
        this.metaData = metaData;
        this.sourceWidth = image.getWidth();
        this.sourceHeight = image.getHeight();
        switch (image.getMode()) {
            case RGB: {
                this.format = 1;
                break;
            }
            case ARGB: {
                this.format = (byte)2;
                break;
            }
            case GRAY: {
                this.format = (byte)3;
                break;
            }
            case AGRAY: {
                this.format = (byte)4;
            }
        }
        if (this.levelQuality == SourceConnectorReader.LevelQuality.HIGH) {
            this.zoomLevels = EISImageWriter.calculateZoomLevels(this.sourceWidth, this.sourceHeight, 32, 0.6666666666666666, this.tileSize);
            this.maximumScaleQuality = false;
        } else if (this.levelQuality == SourceConnectorReader.LevelQuality.NORMAL) {
            this.zoomLevels = EISImageWriter.calculateZoomLevels(this.sourceWidth, this.sourceHeight, 32, 0.5, this.tileSize);
            this.maximumScaleQuality = false;
        } else if (this.levelQuality == SourceConnectorReader.LevelQuality.ULTRA) {
            this.zoomLevels = EISImageWriter.calculateZoomLevels(this.sourceWidth, this.sourceHeight, 32, 0.6666666666666666, this.tileSize);
            this.maximumScaleQuality = true;
        }
        this.tilesForZoomLevel = EISImageWriter.calculateTilesForZoomLevels(this.zoomLevels);
    }

    private int[] numberOfTilesPerZoomLevel() {
        int[] result = new int[this.zoomLevels.length];
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            Pair<Integer, Integer> tiles = this.tilesForZoomLevel.get(i);
            result[i] = tiles.getItem1() * tiles.getItem2();
        }
        return result;
    }

    private ZoomLevelResults writeImageTiles(FSIImage scaledImageWrite, int zoomlevel, SeekableByteChannel channel) throws IOException, ProcessingException, InterruptedException {
        boolean success = true;
        ZoomLevelResults result = new ZoomLevelResults();
        long compressiontime = 0L;
        long waitingTimeIOExecutorPool = 0L;
        long writingTime = 0L;
        int width = scaledImageWrite.getWidth();
        int height = scaledImageWrite.getHeight();
        int tileCounter = 0;
        int columns = FastMath.ceil((double)width / (double)this.tileSize);
        int rows = FastMath.ceil((double)height / (double)this.tileSize);
        result.tileMap = new Pair[columns][rows];
        block7: for (int row = 0; row < rows && !this.stop; ++row) {
            TileEncoderResult ter;
            int column;
            long startCompression = System.currentTimeMillis();
            TileEncoderResult[] terSorted = new TileEncoderResult[columns];
            PriorityExecutorCompletionService<TileEncoderResult> completionService = new PriorityExecutorCompletionService<TileEncoderResult>(this.executorPool.getExecutorService(ExecutorPool.Type.CONVERTER_CPU), columns);
            ArrayList<Future<TileEncoderResult>> futures = new ArrayList<Future<TileEncoderResult>>();
            for (column = 0; column < columns && !this.stop; ++column) {
                TileEncoder tileEncoder = new TileEncoder(this.logger, this.priority, scaledImageWrite, this.byteOrder, column * this.tileSize, row * this.tileSize, zoomlevel, column, row, this.tileSize, this.tileFormat, this.jpegPreparation);
                futures.add(completionService.submit(tileEncoder));
            }
            try {
                for (int c = 0; c < completionService.count(); ++c) {
                    terSorted[ter.tileX] = ter = (TileEncoderResult)completionService.take().get();
                }
            }
            catch (ExecutionException e) {
                throw new ProcessingException(e.getCause());
            }
            finally {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
            compressiontime += System.currentTimeMillis() - startCompression;
            for (column = 0; column < columns; ++column) {
                try {
                    ter = terSorted[column];
                    if (ter == null) continue;
                    boolean bl = success = success && ter.success;
                    if (!success) continue block7;
                    RawDataWriterResult tdwr = new RawDataWriterResult();
                    long submissionTime = System.currentTimeMillis();
                    tdwr.waitingTimeIOExecutorPool = System.currentTimeMillis() - submissionTime;
                    long t0 = System.currentTimeMillis();
                    tdwr.start = this.skipToAlignedStartingPosition(channel);
                    channel.write(ByteBuffer.wrap(ter.tiledata));
                    long t2 = System.currentTimeMillis();
                    tdwr.length = (int)(channel.position() - tdwr.start);
                    tdwr.writingTime = t2 - t0;
                    result.tileMap[ter.tileX][ter.tileY] = new Pair<Long, Long>(tdwr.start, tdwr.length);
                    writingTime += tdwr.writingTime;
                    waitingTimeIOExecutorPool += tdwr.waitingTimeIOExecutorPool;
                    ++tileCounter;
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ProcessingException(e);
                }
            }
        }
        if (!success && !this.stop) {
            throw new IOException("Exception saving image tiles.");
        }
        result.tilesSaved = tileCounter;
        result.compressionTime = (int)compressiontime;
        result.writingTime = (int)writingTime;
        result.waitingTimeIOExecutorPool = (int)waitingTimeIOExecutorPool;
        return result;
    }

    private long skipToAlignedStartingPosition(SeekableByteChannel channel) throws IOException {
        long currentPosition = channel.position();
        long bytesToSkip = 8L - (currentPosition & 7L) & 7L;
        if (bytesToSkip == 0L) {
            return currentPosition;
        }
        channel.position(currentPosition + bytesToSkip);
        return currentPosition + bytesToSkip;
    }

    private static Level[] calculateZoomLevels(int width, int height, int minDim, double ratio, int tileSize) {
        ArrayList<Pair<Integer, Integer>> tempLevels = new ArrayList<Pair<Integer, Integer>>();
        int levelWidth = width;
        int levelHeight = height;
        tempLevels.add(new Pair<Integer, Integer>(levelWidth, levelHeight));
        double zoomlevel = 1.0;
        while (levelWidth > minDim && levelHeight > minDim && levelWidth > 1 && levelHeight > 1) {
            double level = Math.pow(ratio, zoomlevel);
            levelWidth = FastMath.ceil((double)width * level);
            levelHeight = FastMath.ceil((double)height * level);
            tempLevels.add(new Pair<Integer, Integer>(levelWidth, levelHeight));
            zoomlevel += 1.0;
        }
        Level[] rZoomLevels = new Level[tempLevels.size()];
        for (int i = 0; i < tempLevels.size(); ++i) {
            Pair pair = (Pair)tempLevels.get(i);
            rZoomLevels[i] = new Level();
            rZoomLevels[i].width = (Integer)pair.getItem1();
            rZoomLevels[i].height = (Integer)pair.getItem2();
            rZoomLevels[i].tileSizeX = tileSize;
            rZoomLevels[i].tileSizeY = tileSize;
        }
        return rZoomLevels;
    }

    private static List<Pair<Integer, Integer>> calculateTilesForZoomLevels(Level[] vZoomLevels) {
        ArrayList<Pair<Integer, Integer>> rTilesForZoomLevel = new ArrayList<Pair<Integer, Integer>>(vZoomLevels.length);
        for (Level vZoomLevel : vZoomLevels) {
            int tilesX = FastMath.ceil((double)vZoomLevel.width / (double)vZoomLevel.tileSizeX);
            int tilesY = FastMath.ceil((double)vZoomLevel.height / (double)vZoomLevel.tileSizeY);
            rTilesForZoomLevel.add(new Pair<Integer, Integer>(tilesX, tilesY));
        }
        return rTilesForZoomLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMetaDataOnlyEISFile() throws IOException, ProcessingException {
        boolean result = false;
        try (SeekableByteChannel fc = Files.newByteChannel(this.destinationPath, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);){
            long filesize;
            long lastModified;
            boolean tags = true;
            ByteBuffer header = this.generateHeader(1);
            this.writeRawDataToChannel(fc, header, false);
            long tagStartPos = fc.position();
            fc.position(tagStartPos + 24L);
            String iccName = null;
            if (this.metaData != null) {
                lastModified = this.metaData.lastModified;
                filesize = this.metaData.filesize;
                ICCProfileWrap ipw = this.metaData.getICC();
                if (ipw != null) {
                    iccName = ipw.getName();
                }
            } else {
                lastModified = -1L;
                filesize = -1L;
            }
            BasicImageMetaData metadata = new BasicImageMetaData(this.sourceFormat, this.sourceWidth, this.sourceHeight, lastModified, filesize, this.srcImageCount, iccName, this.predefinedImportStatus, TileCompression.LOSSLESS, -1, JPEGPreparation.ChromaSubsampling.CS444, SourceConnectorReader.LevelQuality.NORMAL, 0, null);
            ByteBuffer metadataBuffer = this.getImageMetadataByteBuffer(metadata);
            RawDataWriterResult writerResult = this.writeRawDataToChannel(fc, metadataBuffer, false);
            Pair<Long, Long> imageMetaDataHeaderInfo = new Pair<Long, Long>(writerResult.start, writerResult.length);
            fc.position(tagStartPos);
            ByteBuffer buffer = ByteBuffer.allocateDirect(24);
            buffer.order(this.byteOrder);
            buffer.putLong(501L);
            buffer.putLong(imageMetaDataHeaderInfo.getItem1());
            buffer.putLong(imageMetaDataHeaderInfo.getItem2());
            buffer.rewind();
            this.writeRawDataToChannel(fc, buffer, false);
            result = true;
        }
        catch (RuntimeException e) {
            this.logger.logException(e, 3258, this.destinationPath, e.getClass().getName(), e.getLocalizedMessage());
            if (e.getCause() instanceof IOException) {
                throw (ProcessingException)e.getCause();
            }
        }
        finally {
            this.storageLogger.log('A', StorageLogger.LogCMD.D, this.getAssetURLPath());
        }
        this.dataWritten = true;
        return result;
    }

    @Override
    public boolean execute() throws IOException, InterruptedException {
        boolean success = false;
        try {
            if (this.mode == WriterMode.COMPLETE) {
                success = this.saveEISImageFile();
            } else if (this.mode == WriterMode.METADATA_ONLY) {
                success = this.saveMetaDataOnlyEISFile();
            }
        }
        catch (ProcessingException e) {
            throw new IOException(e);
        }
        return success;
    }

    /*
     * Unable to fully structure code
     */
    private boolean saveEISImageFile() throws IOException, ProcessingException, InterruptedException {
        block64: {
            success = false;
            scalingTime = 0L;
            compressionTime = 0L;
            waitingTimeIOExecutorPool = 0L;
            writingTime = 0L;
            tilesSaved = 0;
            if (this.dataWritten) {
                return success;
            }
            if (this.image == null || this.image.getWidth() < 1 || this.image.getHeight() < 1) {
                throw new IOException("Invalid Image Data");
            }
            this.extraAlphaCount = this.image.getExtraAlphaCount();
            resolution = (long)this.image.getWidth() * (long)this.image.getHeight();
            startTotal = System.currentTimeMillis();
            try {
                fc = Files.newByteChannel(this.destinationPath, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);
                var16_12 = null;
                try {
                    ipw = this.metaData.getICC();
                    if (ipw != null) {
                        icc = ipw.getBytes();
                        iccName = ipw.getName();
                    } else {
                        icc = null;
                        iccName = null;
                    }
                    tags = 0;
                    ++tags;
                    ++tags;
                    ++tags;
                    if (this.metaData.getIPTC() != null) {
                        ++tags;
                    }
                    if (this.metaData.getExif() != null) {
                        ++tags;
                    }
                    if (this.metaData.getXMP() != null) {
                        ++tags;
                    }
                    if (this.metaData.getSelections() != null) {
                        ++tags;
                    }
                    if (this.metaData.getAlphaNames() != null) {
                        ++tags;
                    }
                    if (icc != null) {
                        ++tags;
                    }
                    if (this.metaData.histogram != null) {
                        ++tags;
                    }
                    header = this.generateHeader(tags);
                    writerResult = this.writeRawDataToChannel(fc, header, false);
                    tagStartPos = fc.position();
                    writingTime += writerResult.writingTime;
                    waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                    fc.position(tagStartPos + (long)(tags * 24));
                    mCompression = this.tileFormat;
                    mQuality = -1;
                    mSubsampling = JPEGPreparation.ChromaSubsampling.CS444;
                    if (this.jpegPreparation != null) {
                        mQuality = (int)(this.jpegPreparation.getQuality() * 100.0f);
                        mSubsampling = this.jpegPreparation.getChromaSubsampling();
                    }
                    tagList = new ArrayList<TagInfo>();
                    if (this.image.getExtraAlphaCount() > 0 && this.metaData.getAlphaTypes() == null) {
                        extraAlphaTypes = new byte[this.image.getExtraAlphaCount()];
                        for (i = 0; i < this.image.getExtraAlphaCount(); ++i) {
                            extraAlphaTypes[i] = 0;
                        }
                    } else {
                        alphaTypes = this.metaData.getAlphaTypes();
                        if (alphaTypes != null) {
                            extraAlphaTypes = new byte[alphaTypes.length];
                            for (i = 0; i < alphaTypes.length; ++i) {
                                extraAlphaTypes[i] = (byte)alphaTypes[i];
                            }
                        } else {
                            extraAlphaTypes = null;
                        }
                    }
                    metadata = new BasicImageMetaData(this.sourceFormat, this.sourceWidth, this.sourceHeight, this.metaData.lastModified, this.metaData.filesize, this.srcImageCount, iccName, 1, mCompression, mQuality, mSubsampling, this.levelQuality, this.extraAlphaCount, extraAlphaTypes);
                    metadataBuffer = this.getImageMetadataByteBuffer(metadata);
                    writerResult = this.writeRawDataToChannel(fc, metadataBuffer, false);
                    writingTime += writerResult.writingTime;
                    waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                    tagList.add(new TagInfo(501L, writerResult.start, writerResult.length, writerResult.compressed));
                    tileMapBytes = this.calculateTileMapLength() + 4;
                    writerResult = this.writeRawDataToChannel(fc, ByteBuffer.allocateDirect(tileMapBytes), false);
                    waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                    tagList.add(new TagInfo(500L, writerResult.start, writerResult.length, writerResult.compressed));
                    tileMapStartPosition = writerResult.start;
                    tileMapLength = writerResult.length;
                    iptc = this.metaData.getIPTC();
                    if (iptc != null) {
                        writerResult = this.writeRawDataToChannel(fc, iptc, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(503L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if ((exif = this.metaData.getExif()) != null) {
                        writerResult = this.writeRawDataToChannel(fc, exif, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(504L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if ((xmp = this.metaData.getXMP()) != null) {
                        writerResult = this.writeRawDataToChannel(fc, xmp, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(505L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if ((selections = this.metaData.getSelections()) != null) {
                        writerResult = this.writeRawDataToChannel(fc, selections, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(520L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if ((alphaNames = this.metaData.getAlphaNames()) != null) {
                        writerResult = this.writeRawDataToChannel(fc, alphaNames, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(521L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if (icc != null) {
                        writerResult = this.writeRawDataToChannel(fc, icc, true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(506L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    if (this.metaData.histogram != null) {
                        writerResult = this.writeRawDataToChannel(fc, HistogramUtils.writeHistogramToByteBuffer(this.metaData.histogram, this.byteOrder), true);
                        writingTime += writerResult.writingTime;
                        waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                        tagList.add(new TagInfo(507L, writerResult.start, writerResult.length, writerResult.compressed));
                    }
                    writerResult = this.writeRawDataToChannel(fc, ByteBuffer.allocate(0), true);
                    waitingTimeIOExecutorPool += writerResult.waitingTimeIOExecutorPool;
                    tagList.add(new TagInfo(510L, -1L, 0L, false));
                    keepNext = this.maximumScaleQuality != false;
                    levelMap = new ArrayList<ZoomLevelResults>();
                    for (currentlevel = 0; currentlevel < this.zoomLevels.length; ++currentlevel) {
                        width = this.zoomLevels[currentlevel].width;
                        height = this.zoomLevels[currentlevel].height;
                        newImage = false;
                        if (width == this.sourceWidth) ** GOTO lbl167
                        scaleThreadType = this.image instanceof FSIImageUnlimited != false ? ExecutorPool.Type.CONVERTER_IO : ExecutorPool.Type.CONVERTER_CPU;
                        startScaleCurrentLevel = System.currentTimeMillis();
                        this.scaledImage = this.scaler.transform(this.priority, scaleThreadType, UniScaler.Interpolation.LANCZOS, 3.0, this.image, width, height, 0.0, 0.0, 0.0, 0.0, keepNext);
                        scalingTime += System.currentTimeMillis() - startScaleCurrentLevel;
                        if (this.scaledImage != null) {
                            if (this.maximumScaleQuality) {
                                newImage = true;
                                keepNext = true;
                            } else if ((width > 1500 || height > 1500) && this.smartBuffer == null) {
                                if (this.image != null && !this.image.isDisposed()) {
                                    this.image.dispose();
                                }
                                this.image = this.scaledImage;
                                newImage = false;
                            } else if (this.smartBuffer == null) {
                                this.image = this.smartBuffer = this.scaledImage.createCopy();
                                newImage = true;
                                keepNext = true;
                            } else {
                                this.image = this.smartBuffer;
                                newImage = true;
                                keepNext = true;
                            }
                        } else {
                            this.error = true;
                            if (this.image == null) break;
                            this.image.dispose();
                            break;
lbl167:
                            // 1 sources

                            newImage = false;
                            keepNext = this.maximumScaleQuality != false;
                            this.scaledImage = this.image;
                        }
                        this.allowPause();
                        if (!this.stop && this.scaledImage != null) {
                            levelEncoderResults = null;
                            try {
                                levelEncoderResults = this.writeImageTiles(this.scaledImage, currentlevel, fc);
                                if (levelEncoderResults != null) {
                                    levelMap.add(levelEncoderResults);
                                    tilesSaved += levelEncoderResults.tilesSaved;
                                    compressionTime += (long)levelEncoderResults.compressionTime;
                                    waitingTimeIOExecutorPool += (long)levelEncoderResults.waitingTimeIOExecutorPool;
                                    writingTime += (long)levelEncoderResults.writingTime;
                                }
                            }
                            catch (IOException e) {
                                throw new IOException(e);
                            }
                            finally {
                                if (newImage) {
                                    this.scaledImage.dispose();
                                }
                            }
                        }
                        if (this.stop) break;
                        this.allowPause();
                    }
                    this.disposeAll();
                    if (!this.error && !this.stop) {
                        buffer = ByteBuffer.allocateDirect(tags * 24);
                        buffer.order(this.byteOrder);
                        for (TagInfo tag : tagList) {
                            tagNum = tag.compressed != false ? tag.tag | 4096L : tag.tag;
                            buffer.putLong(tagNum);
                            buffer.putLong(tag.position);
                            buffer.putLong(tag.length);
                        }
                        buffer.rewind();
                        fc.position(tagStartPos);
                        headerUpdateWriterResult = this.writeRawDataToChannel(fc, buffer, false);
                        waitingTimeIOExecutorPool += headerUpdateWriterResult.waitingTimeIOExecutorPool;
                        writingTime += headerUpdateWriterResult.writingTime;
                        tileMapBuffer = ByteBuffer.allocateDirect((int)tileMapLength);
                        tileMapBuffer.order(this.byteOrder);
                        tileMapBuffer.putInt(this.zoomLevels.length);
                        for (currentLevel = 0; currentLevel < this.zoomLevels.length; ++currentLevel) {
                            zoomlevelresult = (ZoomLevelResults)levelMap.get(currentLevel);
                            map = zoomlevelresult.tileMap;
                            tilesX = this.tilesForZoomLevel.get(currentLevel).getItem1();
                            tilesY = this.tilesForZoomLevel.get(currentLevel).getItem2();
                            tileMapBuffer.putInt(tilesX);
                            tileMapBuffer.putInt(tilesY);
                            for (y = 0; y < tilesY; ++y) {
                                for (x = 0; x < tilesX; ++x) {
                                    tileInfo = map[x][y];
                                    tileMapBuffer.putLong(tileInfo.getItem1());
                                    tileMapBuffer.putLong(tileInfo.getItem2());
                                }
                            }
                        }
                        tileMapBuffer.rewind();
                        fc.position(tileMapStartPosition);
                        tileMapResult = this.writeRawDataToChannel(fc, tileMapBuffer, false);
                        waitingTimeIOExecutorPool += tileMapResult.waitingTimeIOExecutorPool;
                        writingTime += tileMapResult.writingTime;
                    }
                    success = true;
                }
                catch (Throwable ipw) {
                    var16_12 = ipw;
                    throw ipw;
                }
                finally {
                    if (fc != null) {
                        if (var16_12 != null) {
                            try {
                                fc.close();
                            }
                            catch (Throwable ipw) {
                                var16_12.addSuppressed(ipw);
                            }
                        } else {
                            fc.close();
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                this.stop = true;
                if (!(e.getCause() instanceof IOException)) break block64;
                throw (ProcessingException)e.getCause();
            }
        }
        if (this.logger.isTraceEnabled()) {
            time = System.currentTimeMillis() - startTotal;
            mpixsec = this.image != null ? (float)resolution / 1000000.0f / ((float)time / 1000.0f) : -1.0f;
            otherOperationsTime = time - scalingTime - writingTime - compressionTime - waitingTimeIOExecutorPool;
            this.logger.log(3147, new Object[]{this.metaData.source, time, Float.valueOf(mpixsec), scalingTime, compressionTime, writingTime, waitingTimeIOExecutorPool, otherOperationsTime, tilesSaved});
        }
        this.dataWritten = true;
        return success;
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel channel, ByteBuffer dataIn, boolean canCompress) throws ProcessingException {
        RawDataWriterResult writerResult = null;
        if (dataIn != null && dataIn.capacity() > 0) {
            ByteBuffer data;
            boolean compressed = false;
            if (canCompress && dataIn.capacity() > 128) {
                ByteBuffer compBuffer = EISImageWriter.compressByteBuffer(dataIn);
                float saveComp = (float)dataIn.capacity() / (float)compBuffer.capacity();
                if ((double)saveComp > 1.1) {
                    data = compBuffer;
                    compressed = true;
                } else {
                    data = dataIn;
                }
                data.rewind();
            } else {
                data = dataIn;
            }
            RawDataWriter rdw = new RawDataWriter(this.priority, channel, data);
            try {
                writerResult = rdw.call();
            }
            catch (IOException e) {
                throw new ProcessingException(e);
            }
            writerResult.compressed = compressed;
        } else {
            writerResult = new RawDataWriterResult();
        }
        return writerResult;
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel channel, ByteArrayWalker data, boolean canCompressed) throws ProcessingException {
        return this.writeRawDataToChannel(channel, data.array(), canCompressed);
    }

    private RawDataWriterResult writeRawDataToChannel(SeekableByteChannel channel, byte[] data, boolean canCompress) throws ProcessingException {
        return this.writeRawDataToChannel(channel, ByteBuffer.wrap(data), canCompress);
    }

    /*
     * Exception decompiling
     */
    private ByteBuffer getImageMetadataByteBuffer(BasicImageMetaData metadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ByteBuffer generateHeader(int tags) {
        ByteBuffer result = ByteBuffer.allocate(16);
        result.put(EISEnvironment.EIS_IMAGE_MAGIC);
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            result.put((byte)126);
        } else {
            result.put((byte)-66);
        }
        result.order(this.byteOrder);
        result.put((byte)0);
        result.putShort((short)3);
        result.putInt(tags);
        result.rewind();
        return result;
    }

    private int calculateTileMapLength() {
        int length = 8;
        if (this.sourceWidth > 0 && this.sourceHeight > 0) {
            int[] tilesPerLevel = this.numberOfTilesPerZoomLevel();
            int sizePerChannel = 0;
            for (int element : tilesPerLevel) {
                int sizePerLevel = 8 + element * 16;
                sizePerChannel += sizePerLevel;
            }
            length += 1 * sizePerChannel;
        }
        return length;
    }

    private void disposeAll() {
        if (this.smartBuffer != null && !this.smartBuffer.isDisposed()) {
            this.smartBuffer.dispose();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        if (this.scaledImage != null && !this.scaledImage.isDisposed()) {
            this.scaledImage.dispose();
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void cancel() {
        this.stop = true;
    }

    private void allowPause() {
        try {
            while (this.pause) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] compressBytes(byte[] input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteBuffer compressByteBuffer(ByteBuffer input) {
        byte[] dst = new byte[input.limit()];
        input.position(0);
        input.get(dst);
        dst = EISImageWriter.compressBytes(dst);
        return ByteBuffer.wrap(dst);
    }

    private static class ZoomLevelResults {
        Pair<Long, Long>[][] tileMap;
        int tilesSaved;
        int compressionTime;
        int writingTime;
        int waitingTimeIOExecutorPool;
    }

    private static enum WriterMode {
        COMPLETE,
        METADATA_ONLY;

    }
}

