/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.RawDataWriterResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.Callable;

public final class RawDataWriter
implements Callable<RawDataWriterResult>,
PriorityExecutor.Important {
    final int priority;
    final long submissionTime;
    final SeekableByteChannel channel;
    final ByteBuffer dataBuffer;

    public RawDataWriter(int priority, SeekableByteChannel channel, ByteBuffer data) {
        this.priority = priority;
        this.dataBuffer = data;
        this.channel = channel;
        this.submissionTime = System.currentTimeMillis();
    }

    @Override
    public RawDataWriterResult call() throws IOException {
        RawDataWriterResult result = new RawDataWriterResult();
        if (this.channel.isOpen()) {
            result.waitingTimeIOExecutorPool = System.currentTimeMillis() - this.submissionTime;
            long t0 = System.currentTimeMillis();
            result.start = this.skipToAlignedStartingPosition();
            this.channel.write(this.dataBuffer);
            result.length = (int)(this.channel.position() - result.start);
            long t2 = System.currentTimeMillis();
            result.writingTime = t2 - t0;
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private long skipToAlignedStartingPosition() throws IOException {
        long currentPosition = this.channel.position();
        long bytesToSkip = 8L - (currentPosition & 7L) & 7L;
        if (bytesToSkip == 0L) {
            return currentPosition;
        }
        this.channel.position(currentPosition + bytesToSkip);
        return currentPosition + bytesToSkip;
    }
}

