/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReverseLookupUtils {
    private static final byte[] MAGIC = new byte[]{78, 69, 76, 65, 83, 82, 76, 49};
    private static final ConcurrentHashMap<Path, Map<String, Map<Integer, String>>> revCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Path, Long> revCacheAge = new ConcurrentHashMap();
    private static final int maxCacheSize = 16;

    public static boolean writeRevLookupFile(Map<String, Map<Integer, String>> theMap, Path targetFile) throws IOException {
        Path parentDir = targetFile.getParent();
        if (!Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        revCache.put(targetFile, theMap);
        revCacheAge.put(targetFile, System.currentTimeMillis());
        if (revCache.size() > 16) {
            Path rmEntry = null;
            long oldestTime = Long.MAX_VALUE;
            for (Map.Entry<Path, Long> entry : revCacheAge.entrySet()) {
                long entryTime = entry.getValue();
                if (entryTime >= oldestTime) continue;
                oldestTime = entryTime;
                rmEntry = entry.getKey();
            }
            if (rmEntry != null) {
                revCache.remove(rmEntry);
                revCacheAge.remove(rmEntry);
            }
        }
        return ReverseLookupUtils.writeFile(targetFile, theMap);
    }

    private static final void writeIntToBAOS(int value, ByteArrayOutputStreamFast baos) {
        baos.write(value & 0xFF);
        baos.write(value >>> 8 & 0xFF);
        baos.write(value >>> 16 & 0xFF);
        baos.write(value >>> 24 & 0xFF);
    }

    private static byte[] serializeReverseLookupMap(Map<String, Map<Integer, String>> data) throws IOException {
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(512);){
            baos.write(MAGIC);
            ReverseLookupUtils.writeIntToBAOS(data.size(), baos);
            for (Map.Entry<String, Map<Integer, String>> entry : data.entrySet()) {
                String key1 = entry.getKey();
                byte[] key1Bytes = key1.getBytes(FileOperations.charsetUTF8);
                ReverseLookupUtils.writeIntToBAOS(key1Bytes.length, baos);
                baos.write(key1Bytes);
                Map<Integer, String> subMap = entry.getValue();
                ReverseLookupUtils.writeIntToBAOS(subMap.size(), baos);
                for (Map.Entry<Integer, String> subEntry : subMap.entrySet()) {
                    ReverseLookupUtils.writeIntToBAOS(subEntry.getKey(), baos);
                    String value = subEntry.getValue();
                    byte[] valueBytes = value.getBytes(FileOperations.charsetUTF8);
                    ReverseLookupUtils.writeIntToBAOS(valueBytes.length, baos);
                    baos.write(valueBytes);
                }
            }
            Object object = baos.toByteArray();
            return object;
        }
    }

    private static boolean writeFile(Path targetPath, Map<String, Map<Integer, String>> data) throws IOException {
        byte[] bytes = ReverseLookupUtils.serializeReverseLookupMap(data);
        Path tmpPath = Files.createTempFile(targetPath.getParent(), ".reverseLookup", ".tmp", new FileAttribute[0]);
        if (FileOperations.writeFile(tmpPath, bytes)) {
            FileOperations.move(tmpPath, targetPath);
            return true;
        }
        throw new CorruptReverseLookupException(targetPath);
    }

    public static Map<String, Map<Integer, String>> readFile(Path sourceFile) throws CorruptReverseLookupException, IOException {
        Map<String, Map<Integer, String>> result;
        block8: {
            result = revCache.get(sourceFile);
            if (result != null) {
                return result;
            }
            try {
                byte[] rawBytes = FileOperations.readFile(sourceFile);
                boolean isRLFile = false;
                ByteArrayWalker bb = null;
                if (rawBytes != null && rawBytes.length > MAGIC.length) {
                    bb = ByteArrayWalker.wrap(rawBytes, ByteOrder.LITTLE_ENDIAN);
                    byte[] magic = new byte[MAGIC.length];
                    bb.get(magic);
                    if (Arrays.equals(MAGIC, magic)) {
                        isRLFile = true;
                    }
                }
                if (isRLFile && bb != null) {
                    int count = bb.getInt();
                    result = new HashMap<String, Map<Integer, String>>(count + 1);
                    for (int c = 0; c < count; ++c) {
                        int key1Length = bb.getInt();
                        byte[] key1Bytes = new byte[key1Length];
                        bb.get(key1Bytes);
                        String key1 = new String(key1Bytes, FileOperations.charsetUTF8);
                        int subCount = bb.getInt();
                        HashMap<Integer, String> subMap = new HashMap<Integer, String>(subCount + 1);
                        result.put(key1, subMap);
                        for (int s = 0; s < subCount; ++s) {
                            int keySub = bb.getInt();
                            Integer key = keySub;
                            int valueSize = bb.getInt();
                            byte[] valueBytes = new byte[valueSize];
                            bb.get(valueBytes);
                            String value = new String(valueBytes, FileOperations.charsetUTF8);
                            subMap.put(key, value);
                        }
                    }
                    break block8;
                }
                throw new CorruptReverseLookupException(sourceFile);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new CorruptReverseLookupException(sourceFile);
            }
        }
        return result;
    }
}

