/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class SPXOutputStream
extends OutputStream {
    private final ByteOrder bo;
    private final OutputStream os;

    public SPXOutputStream(ByteOrder bo, OutputStream os) {
        this.bo = bo;
        this.os = os;
    }

    public ByteOrder getOrder() {
        return this.bo;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void write(byte b) throws IOException {
        this.write(b & 0xFF);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        for (byte c : bytes) {
            this.write(c & 0xFF);
        }
    }

    public void write(float[] floats) throws IOException {
        for (float f : floats) {
            this.writeFloat(f);
        }
    }

    public void writeShort(short value) throws IOException {
        if (this.bo == ByteOrder.BIG_ENDIAN) {
            this.write(value >> 8 & 0xFF);
            this.write(value & 0xFF);
        } else {
            this.write(value & 0xFF);
            this.write(value >> 8 & 0xFF);
        }
    }

    public void writeInt(int value) throws IOException {
        if (this.bo == ByteOrder.BIG_ENDIAN) {
            this.write(value >>> 24 & 0xFF);
            this.write(value >> 16 & 0xFF);
            this.write(value >> 8 & 0xFF);
            this.write(value & 0xFF);
        } else {
            this.write(value & 0xFF);
            this.write(value >> 8 & 0xFF);
            this.write(value >> 16 & 0xFF);
            this.write(value >>> 24 & 0xFF);
        }
    }

    public void writeLong(long value) throws IOException {
        if (this.bo == ByteOrder.BIG_ENDIAN) {
            this.write((int)(value >>> 56) & 0xFF);
            this.write((int)(value >> 48) & 0xFF);
            this.write((int)(value >> 40) & 0xFF);
            this.write((int)(value >> 32) & 0xFF);
            this.write((int)(value >> 24) & 0xFF);
            this.write((int)(value >> 16) & 0xFF);
            this.write((int)(value >> 8) & 0xFF);
            this.write((int)value & 0xFF);
        } else {
            this.write((int)value & 0xFF);
            this.write((int)(value >> 8) & 0xFF);
            this.write((int)(value >> 16) & 0xFF);
            this.write((int)(value >> 24) & 0xFF);
            this.write((int)(value >> 32) & 0xFF);
            this.write((int)(value >> 40) & 0xFF);
            this.write((int)(value >> 48) & 0xFF);
            this.write((int)(value >>> 56) & 0xFF);
        }
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeTagByte(short tag, byte value) throws IOException {
        this.writeTag(tag, 1);
        this.write(value);
    }

    public void writeTagBytes(short tag, byte[] values) throws IOException {
        this.writeTag(tag, values.length);
        this.write(values);
    }

    public void writeTagFloat(short tag, float value) throws IOException {
        this.writeTag(tag, 4);
        this.writeFloat(value);
    }

    public void writeTagFloats(short tag, float[] values) throws IOException {
        this.writeTag(tag, values.length * 4);
        this.write(values);
    }

    public void writeTagShort(short tag, short value) throws IOException {
        this.writeTag(tag, 2);
        this.writeShort(value);
    }

    public void writeTagInt(short tag, int value) throws IOException {
        this.writeTag(tag, 4);
        this.writeInt(value);
    }

    public void writeTagLong(short tag, long value) throws IOException {
        this.writeTag(tag, 8);
        this.writeLong(value);
    }

    public void writeTagDouble(short tag, double value) throws IOException {
        this.writeTagLong(tag, Double.doubleToRawLongBits(value));
    }

    public void writeTagUTF8(short tag, String value) throws IOException {
        byte[] bytes = value.getBytes(FileOperations.charsetUTF8);
        this.writeTag(tag, bytes.length);
        this.write(bytes);
    }

    private void writeTag(short tag, int len) throws IOException {
        this.writeShort(tag);
        this.writeInt(len);
    }
}

