/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.sourcemanager.DirectoryImportHandler;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SourceReverseRepairing
implements FileVisitor<Path> {
    private final SourceConnectorReader connector;
    private final StorageManager storageManager;
    private final DirectoryImportHandler dirImportHandler;
    private final PathCached inbox;
    private final StorageHelperV1002 storageHelper;
    private boolean hasChanged = false;
    private volatile boolean cancel = false;

    public SourceReverseRepairing(SourceConnectorReader connector, StorageHelperV1002 storageHelper, StorageManager storageManager, DirectoryImportHandler dirImportHandler, PathCached inbox) {
        this.connector = connector;
        this.storageHelper = storageHelper;
        this.storageManager = storageManager;
        this.dirImportHandler = dirImportHandler;
        this.inbox = inbox;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void stop() {
        this.cancel = true;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(attrs);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        PathCached fp = new PathCached(file);
        if (fp.isRegularFile()) {
            ImageFormatScanner ifs = ImageFormatScanner.getInstance();
            ImageFormat format = ifs.scanFile(fp);
            if (format.isImage && format.type != ImageFormat.Type.UNK && this.dirImportHandler.isValidFilename(fp, false)) {
                int connectorLen = this.connector.getInboxDirectory().getAbsoluteNameLength();
                String assetURLPath = FileOperations.convertBackslash(this.connector.getPrefix() + this.inbox.getAbsoluteName().substring(connectorLen));
                assetURLPath = assetURLPath + '/';
                assetURLPath = assetURLPath + FileOperations.convertBackslash(fp.getAbsoluteName().substring(connectorLen + 1));
                try {
                    Path eisFile = this.storageHelper.getEisFile(assetURLPath);
                    boolean eisFileExists = Files.exists(eisFile, new LinkOption[0]);
                    Path reverseLoopupFile = eisFile.resolveSibling(".reverseLookup");
                    boolean reverseLoopupFileExists = Files.exists(reverseLoopupFile, new LinkOption[0]);
                    Path realEis = this.storageManager.getRealEISImageFile(assetURLPath);
                    boolean realEisExists = realEis != null ? Files.exists(realEis, new LinkOption[0]) : false;
                    boolean allOkay = eisFileExists & reverseLoopupFileExists & realEisExists;
                    if (!reverseLoopupFileExists) {
                        if (eisFileExists) {
                            if (EISChainReader.isChainFile(eisFile)) {
                                Map<String, Integer> chainMap = EISChainReader.readAll(eisFile);
                                if (chainMap != null) {
                                    TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
                                    for (Map.Entry<String, Integer> entry : chainMap.entrySet()) {
                                        sortedMap.put(entry.getValue(), entry.getKey());
                                    }
                                    for (Map.Entry<String, Integer> entry : sortedMap.entrySet()) {
                                        this.storageManager.addReverseLookupEntry(eisFile, (String)((Object)entry.getValue()), (Integer)((Object)entry.getKey()));
                                        this.hasChanged = true;
                                    }
                                }
                            } else {
                                this.storageManager.addReverseLookupEntry(eisFile, assetURLPath, 0);
                                this.hasChanged = true;
                            }
                        }
                    } else if (eisFileExists && !realEisExists) {
                        Map<Integer, String> map = StorageManager.getReverseLookupEntries(eisFile);
                        if (EISChainReader.isChainFile(eisFile)) {
                            Map<String, Integer> chainMap = EISChainReader.readAll(eisFile);
                            if (chainMap != null) {
                                TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
                                for (Map.Entry<String, Integer> entry : chainMap.entrySet()) {
                                    sortedMap.put(entry.getValue(), entry.getKey());
                                }
                                for (Map.Entry entry : sortedMap.entrySet()) {
                                    this.storageManager.addReverseLookupEntry(eisFile, (String)entry.getValue(), (Integer)entry.getKey());
                                    this.hasChanged = true;
                                }
                            }
                        } else {
                            this.storageManager.addReverseLookupEntry(eisFile, assetURLPath, 0);
                            this.hasChanged = true;
                        }
                    }
                }
                catch (NotConfiguredException e) {
                    return FileVisitResult.TERMINATE;
                }
            }
        }
        if (this.cancel) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        Objects.requireNonNull(file);
        throw exc;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc == null) {
            if (this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
        throw exc;
    }
}

