/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StorageLogger
extends Thread {
    private final FSILogger logger;
    private final Path directory;
    private BufferedWriter fw = null;
    private final CacheManager cacheManager;
    private final int maxDays;
    private final ReentrantLock lock = new ReentrantLock();
    public static final char LogTypeAsset = 'A';
    public static final char LogTypeDir = 'D';
    public static final char LogTypeAll = '*';
    private final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final String logPrefix = "storage";
    private final String logSuffix = "log";
    private final Pattern patternLogfile = Pattern.compile("storage\\.(\\d{4}\\-\\d{2}\\-\\d{2})\\.log");
    private final DateFormat logDate = new SimpleDateFormat("yyyy-MM-dd");
    private boolean running = false;
    private volatile boolean newData = false;

    public StorageLogger(FSILogger logger, Path directory, int maxDays, CacheManager cacheManager) {
        this.logger = logger;
        this.cacheManager = cacheManager;
        this.directory = directory;
        this.maxDays = maxDays;
        this.setName("StorageLogger");
    }

    @Override
    public void run() {
        this.running = true;
        long nextRotateTime = 0L;
        this.openFile();
        while (this.running) {
            GregorianCalendar nextDate = new GregorianCalendar();
            long cTime = nextDate.getTimeInMillis();
            nextDate.set(11, 0);
            nextDate.set(12, 0);
            nextDate.set(13, 0);
            nextDate.set(14, 0);
            ((Calendar)nextDate).add(5, 1);
            if (cTime >= nextRotateTime) {
                this.rotateLog();
            }
            nextRotateTime = nextDate.getTimeInMillis();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.running = false;
            }
            if (!this.newData || this.fw == null) continue;
            try {
                this.fw.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        this.running = false;
        this.interrupt();
        if (this.fw != null) {
            this.lock.lock();
            try {
                this.closeFile();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(char type, LogCMD command, String assetURLPath) {
        CacheKey cacheKey = CacheKey.getInstance(assetURLPath, type);
        if (this.cacheManager != null) {
            this.cacheManager.touchChangedFile(cacheKey);
        }
        if (this.fw != null) {
            this.lock.lock();
            try {
                String pubDate = this.formatter.format(new Date());
                this.fw.write(pubDate);
                this.fw.write(58);
                this.fw.write(command.name());
                this.fw.write(58);
                this.fw.write(cacheKey.get());
                this.fw.write(10);
            }
            catch (IOException e) {
                this.logger.logException(e, 3247, e.getLocalizedMessage());
            }
            finally {
                this.lock.unlock();
            }
        }
        this.newData = true;
    }

    private boolean openFile() {
        boolean result = false;
        try {
            if (Files.notExists(this.directory, new LinkOption[0])) {
                Files.createDirectories(this.directory, new FileAttribute[0]);
            }
            String filename = "storage." + this.logDate.format(new Date()) + '.' + "log";
            Path logFile = this.directory.resolve(filename);
            this.fw = Files.newBufferedWriter(logFile, FileOperations.charsetUTF8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            result = true;
        }
        catch (IOException e) {
            this.logger.logException(e, 2011, e.getLocalizedMessage());
        }
        return result;
    }

    private boolean closeFile() {
        boolean result = false;
        if (this.fw != null) {
            try {
                this.fw.close();
                this.fw = null;
                result = true;
            }
            catch (IOException e) {
                this.logger.logException(e, 2011, e.getLocalizedMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateLog() {
        this.lock.lock();
        try {
            block13: {
                this.closeFile();
                GregorianCalendar oldestCal = new GregorianCalendar();
                oldestCal.set(11, 0);
                oldestCal.set(12, 0);
                oldestCal.set(13, 0);
                oldestCal.set(14, 0);
                ((Calendar)oldestCal).add(5, 1);
                ((Calendar)oldestCal).add(13, -1);
                Date newestDate = oldestCal.getTime();
                ((Calendar)oldestCal).add(13, 1);
                ((Calendar)oldestCal).add(5, -this.maxDays);
                Date oldestDate = oldestCal.getTime();
                try {
                    List<PathCached> logFiles = FileOperations.listAllFiles(this.directory);
                    if (logFiles == null) break block13;
                    for (PathCached file : logFiles) {
                        boolean delete = false;
                        String name = file.getFileName().toString();
                        Matcher match = this.patternLogfile.matcher(name);
                        if (match.find()) {
                            try {
                                Date dateOfLog = this.logDate.parse(match.group(1));
                                if (dateOfLog.before(oldestDate) || dateOfLog.after(newestDate)) {
                                    delete = true;
                                }
                            }
                            catch (ParseException e) {
                                delete = true;
                            }
                        } else {
                            delete = true;
                        }
                        if (!delete) continue;
                        try {
                            Files.deleteIfExists(file.getPath());
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.openFile();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum LogCMD {
        U,
        D;

    }
}

