/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.concurrent.Locker;
import com.neptunelabs.fsiframework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageCopier;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageMover;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.StorageDataProvider;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.ReverseLookupUtils;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class StorageManager {
    private final FSIServerSettings settings;
    private final IOController ioController;
    private final StorageHelperV1002 storageHelper;
    private final StorageLogger storageLogger;
    private volatile boolean acceptExecutionRequests = true;
    private final Locker<String> locker = new Locker();
    private final FileLockHandler lockHandler;
    private ReentrantLock localLock = new ReentrantLock();

    public StorageManager(FSIServerSettings settings, Path storageLocation, boolean logToStorage, CacheManager cacheManager) {
        this.settings = settings;
        this.lockHandler = settings.getFileLockHandler();
        this.ioController = settings.getIOController();
        this.storageHelper = settings.getStorageHelper();
        Path logDir = storageLocation.resolve(".log");
        this.storageLogger = new StorageLogger(settings.getFSILogger(), logDir, 7, cacheManager);
        this.storageLogger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStorageDataProvider(Path finalDestinationEIS, StorageDataProvider provider) throws CorruptReverseLookupException {
        boolean success;
        block51: {
            if (!this.acceptExecutionRequests) {
                return false;
            }
            success = false;
            String assetURLPath = provider.getAssetURLPath();
            if (assetURLPath.startsWith("/")) {
                assetURLPath = assetURLPath.substring(1);
            }
            if (assetURLPath.endsWith("/")) {
                assetURLPath = assetURLPath.substring(0, assetURLPath.length() - 1);
            }
            String finalDestinationEISStr = finalDestinationEIS.getFileName().toString();
            LockerReadWrite.Value<String> eisLock = this.lockHandler.writeLock(finalDestinationEIS.toString());
            try {
                Path usedDestination;
                this.localLock.lock();
                try {
                    Path wDir;
                    if (provider.useTemporaryFile()) {
                        wDir = finalDestinationEIS.getParent();
                        if (!Files.exists(wDir, new LinkOption[0])) {
                            Files.createDirectories(wDir, new FileAttribute[0]);
                        }
                        usedDestination = Files.createTempFile(wDir, finalDestinationEISStr, ".tmp", new FileAttribute[0]);
                    } else {
                        usedDestination = finalDestinationEIS;
                        wDir = finalDestinationEIS.getParent();
                        if (!Files.exists(wDir, new LinkOption[0])) {
                            Files.createDirectories(wDir, new FileAttribute[0]);
                        }
                    }
                }
                catch (IOException e) {
                    usedDestination = null;
                }
                finally {
                    this.localLock.unlock();
                }
                if (usedDestination == null) break block51;
                Locker.Value<String> exeLock = this.locker.lock(assetURLPath);
                try {
                    provider.setDestination(usedDestination);
                    provider.execute();
                    success = true;
                }
                catch (InterruptedException e) {
                    success = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.acceptExecutionRequests) {
                        this.settings.getFSILogger().logException(e, 3228, e.getLocalizedMessage(), provider.getAssetURLPath(), finalDestinationEIS);
                    }
                    success = false;
                }
                finally {
                    this.locker.unlock(exeLock);
                }
                if (success && provider.useTemporaryFile()) {
                    this.localLock.lock();
                    try {
                        if (!Files.exists(finalDestinationEIS, new LinkOption[0])) {
                            success = this.addReverseLookupEntry(finalDestinationEIS, assetURLPath, 0);
                            FileOperations.move(usedDestination, finalDestinationEIS);
                        } else if (EISChainReader.isChainFile(finalDestinationEIS)) {
                            Map<String, Integer> ecMap = EISChainReader.readAll(finalDestinationEIS);
                            Integer index = ecMap.get(assetURLPath);
                            if (index == null) {
                                int sIndex = 0;
                                for (Integer fIndex : ecMap.values()) {
                                    if (fIndex <= sIndex) continue;
                                    sIndex = fIndex;
                                }
                                Path finalImageDestination = StorageManager.getChainedDestination(finalDestinationEIS, ++sIndex);
                                FileOperations.move(usedDestination, finalImageDestination);
                                if (this.addReverseLookupEntry(finalDestinationEIS, assetURLPath, sIndex)) {
                                    EISChainWriter eiscw = new EISChainWriter(this.settings.getFSILogger(), finalDestinationEIS);
                                    eiscw.addEntry(sIndex, assetURLPath);
                                }
                            } else {
                                Path finalImageDestination = StorageManager.getChainedDestination(finalDestinationEIS, index);
                                FileOperations.move(usedDestination, finalImageDestination);
                            }
                        } else {
                            int foundIndex = -1;
                            Map<Integer, String> revMap = StorageManager.getReverseLookupEntries(finalDestinationEIS);
                            if (revMap != null) {
                                for (Map.Entry<Integer, String> revEntry : revMap.entrySet()) {
                                    if (!revEntry.getValue().equals(assetURLPath)) continue;
                                    foundIndex = revEntry.getKey();
                                }
                            }
                            if (foundIndex >= 0) {
                                FileOperations.move(usedDestination, finalDestinationEIS);
                            } else {
                                String previouslyUnchainedAssetURLPath = StorageManager.getRevLookupAssetURLPathForIndex(finalDestinationEIS, 0);
                                if (previouslyUnchainedAssetURLPath != null) {
                                    this.removeReverseLookUpEntry(finalDestinationEIS, 0);
                                    Path previouslyUnchained = StorageManager.getChainedDestination(finalDestinationEIS, 1);
                                    FileOperations.move(finalDestinationEIS, previouslyUnchained);
                                    if (this.addReverseLookupEntry(finalDestinationEIS, previouslyUnchainedAssetURLPath, 1)) {
                                        EISChainWriter eiscw = new EISChainWriter(this.settings.getFSILogger(), finalDestinationEIS);
                                        eiscw.addEntry(1, previouslyUnchainedAssetURLPath);
                                        Path nextUnchained = StorageManager.getChainedDestination(finalDestinationEIS, 2);
                                        FileOperations.move(usedDestination, nextUnchained);
                                        if (this.addReverseLookupEntry(finalDestinationEIS, assetURLPath, 2)) {
                                            EISChainWriter eiscw2 = new EISChainWriter(this.settings.getFSILogger(), finalDestinationEIS);
                                            eiscw2.addEntry(2, assetURLPath);
                                        }
                                    }
                                } else {
                                    System.err.println("Index:" + foundIndex + " " + finalDestinationEIS + " " + assetURLPath);
                                }
                            }
                        }
                        break block51;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(0);
                        try {
                            Files.delete(usedDestination);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        break block51;
                    }
                    finally {
                        this.localLock.unlock();
                    }
                }
                if (!success && provider.useTemporaryFile()) {
                    System.err.println("here we are: " + usedDestination);
                    try {
                        Files.delete(usedDestination);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this.lockHandler.unlockWrite(eisLock);
            }
        }
        return success;
    }

    public StorageLogger getStorageLogger() {
        return this.storageLogger;
    }

    public void dispose() {
        this.acceptExecutionRequests = false;
        this.storageLogger.dispose();
    }

    public Path getRealEISImageFile(String assetURLPath) throws NotConfiguredException {
        Path eisFile = this.storageHelper.getEisFile(assetURLPath);
        int index = -1;
        Map<Integer, String> relevantEntries = StorageManager.getReverseLookupEntries(eisFile);
        if (relevantEntries != null) {
            for (Map.Entry<Integer, String> entry : relevantEntries.entrySet()) {
                if (!entry.getValue().equals(assetURLPath)) continue;
                index = entry.getKey();
                break;
            }
        }
        if (index < 0) {
            return null;
        }
        return StorageManager.getChainedDestination(eisFile, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveStorageFileToTrash(Path eisFile, String assetURLPath, Path trashEisFile) throws CorruptReverseLookupException, IOException {
        int index = -1;
        Locker.Value<String> theLock = this.locker.lock(eisFile.toString());
        try {
            block13: {
                try {
                    index = EISChainReader.isChainFile(eisFile) ? EISChainReader.findChainEntryNumber(eisFile, assetURLPath) : 0;
                }
                catch (IOException e) {
                    if (!e.getMessage().equals("Not a valid EIS Chain File (MSFT)")) break block13;
                    index = 0;
                }
            }
            Path eisImageFile = StorageManager.getChainedDestination(eisFile, index);
            if (trashEisFile == null) {
                try {
                    Files.delete(eisImageFile);
                }
                catch (NoSuchFileException noSuchFileException) {}
            } else {
                try {
                    FileOperations.move(eisImageFile, trashEisFile);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            if (index > 0) {
                EISChainWriter writer = new EISChainWriter(this.settings.getFSILogger(), eisFile);
                writer.removeEntry(assetURLPath);
            }
            if (index != -1) {
                this.removeReverseLookUpEntry(eisFile, index);
            }
            this.storageLogger.log('A', StorageLogger.LogCMD.D, assetURLPath);
            StorageManager.cleanStorageDir(eisFile.getParent());
        }
        finally {
            this.locker.unlock(theLock);
        }
        return true;
    }

    public boolean removeFromStorage(Path eisFile, String assetURLPath) throws CorruptReverseLookupException, IOException {
        return this.moveStorageFileToTrash(eisFile, assetURLPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyStorageFile(String fromAssetURLPath, String toAssetURLPath) throws CorruptReverseLookupException, NotConfiguredException {
        boolean success;
        if (!fromAssetURLPath.equals(toAssetURLPath)) {
            EISImageCopier copier = new EISImageCopier(this.getRealEISImageFile(fromAssetURLPath));
            copier.setAssetURLPath(toAssetURLPath);
            Path toEis = this.storageHelper.getEisFile(toAssetURLPath);
            Locker.Value<String> l1 = this.locker.lock(fromAssetURLPath);
            try {
                success = this.executeStorageDataProvider(toEis, copier);
            }
            finally {
                this.locker.unlock(l1);
            }
        } else {
            success = false;
        }
        return success;
    }

    public boolean moveExternalFileToStorage(Path sourceEis, String targetPath, Path targetEis) throws CorruptReverseLookupException {
        boolean success;
        if (Files.exists(sourceEis, new LinkOption[0])) {
            EISImageMover mover = new EISImageMover(sourceEis);
            mover.setAssetURLPath(targetPath);
            success = this.executeStorageDataProvider(targetEis, mover);
        } else {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveStorageFile(Path fromEis, String fromAssetURLPath, Path toEis, String toAssetURLPath) throws CorruptReverseLookupException, NotConfiguredException, IOException {
        Path fromEisImageFile = null;
        int index = -1;
        Locker.Value<String> theLock = this.locker.lock(toEis.toString());
        try {
            block7: {
                try {
                    index = EISChainReader.findChainEntryNumber(fromEis, fromAssetURLPath);
                    fromEisImageFile = StorageManager.getChainedDestination(fromEis, index);
                    EISChainWriter chainWriter = new EISChainWriter(this.settings.getFSILogger(), fromEis);
                    chainWriter.removeEntry(fromAssetURLPath);
                }
                catch (IOException e) {
                    if (e.getMessage().startsWith("Not a valid EIS Chain File")) {
                        fromEisImageFile = fromEis;
                        index = 0;
                    }
                    if (!this.acceptExecutionRequests) break block7;
                    this.settings.getFSILogger().logException(e, 3228, e.getLocalizedMessage(), fromEis, toEis);
                }
            }
            if (index != -1) {
                this.removeReverseLookUpEntry(fromEis, index);
            }
        }
        finally {
            this.locker.unlock(theLock);
        }
        EISImageMover mover = new EISImageMover(fromEisImageFile);
        mover.setAssetURLPath(toAssetURLPath);
        boolean success = this.executeStorageDataProvider(toEis, mover);
        StorageManager.cleanStorageDir(fromEis.getParent());
        return success;
    }

    public static Path getChainedDestination(Path destination, int index) {
        if (index <= 0) {
            return destination;
        }
        String[] splitName = FileOperations.splitFilename(destination.getFileName().toString());
        String newFilename = splitName[0] + '.' + index + '.' + splitName[1];
        return Paths.get(destination.getParent().toString(), newFilename);
    }

    public static Path getDestinationWithoutChainIndex(Path destination) {
        Path parent = destination.getParent();
        String[] splitName1 = FileOperations.splitFilename(destination.getFileName().toString());
        if (splitName1 == null) {
            return destination;
        }
        String[] splitName2 = FileOperations.splitFilename(splitName1[0]);
        if (splitName2 == null) {
            return destination;
        }
        String resultFilename = splitName2[0] + "." + splitName1[1];
        return parent.resolve(resultFilename);
    }

    private boolean removeReverseLookUpEntry(Path destination, int index) throws CorruptReverseLookupException, IOException {
        String filename;
        Path revLookupFile = StorageManager.getReverseLookupFile(destination);
        Map<String, Map<Integer, String>> theMap = StorageManager.readRevLookupFile(destination);
        Map<Integer, String> entry = theMap.get(filename = destination.getFileName().toString());
        if (entry != null) {
            entry.remove(index);
            if (entry.isEmpty()) {
                theMap.remove(filename);
            }
        }
        return ReverseLookupUtils.writeRevLookupFile(theMap, revLookupFile);
    }

    public boolean addReverseLookupEntry(Path destination, String assetURLPath, int index) throws CorruptReverseLookupException, IOException {
        Map<String, Map<Integer, String>> theMap;
        Path revLookupFile = StorageManager.getReverseLookupFile(destination);
        if (Files.exists(revLookupFile, new LinkOption[0])) {
            try {
                theMap = StorageManager.readRevLookupFile(destination);
            }
            catch (IOException e) {
                theMap = new HashMap<String, Map<Integer, String>>();
            }
        } else {
            theMap = new HashMap<String, Map<Integer, String>>(1);
        }
        if (theMap.containsKey(destination.getFileName().toString())) {
            theMap.get(destination.getFileName().toString()).put(index, assetURLPath);
        } else {
            HashMap<Integer, String> newEntry = new HashMap<Integer, String>(1);
            newEntry.put(index, assetURLPath);
            theMap.put(destination.getFileName().toString(), newEntry);
        }
        return ReverseLookupUtils.writeRevLookupFile(theMap, revLookupFile);
    }

    public static Map<Integer, String> getReverseLookupEntries(Path destination) {
        Map<String, Map<Integer, String>> map;
        try {
            map = StorageManager.readRevLookupFile(destination);
        }
        catch (IOException e) {
            map = new HashMap<String, Map<Integer, String>>(4);
        }
        return map.get(destination.getFileName().toString());
    }

    public static Map<String, Map<Integer, String>> readRevLookupFile(Path destination) throws CorruptReverseLookupException, IOException {
        Path revLookupFile = StorageManager.getReverseLookupFile(destination);
        return ReverseLookupUtils.readFile(revLookupFile);
    }

    private static String getRevLookupAssetURLPathForIndex(Path destination, int index) {
        Map<Integer, String> map = StorageManager.getReverseLookupEntries(destination);
        if (map != null) {
            return map.get(index);
        }
        return null;
    }

    private static Path getReverseLookupFile(Path destination) {
        return Paths.get(destination.getParent().toString(), ".reverseLookup");
    }

    private static void cleanStorageDir(Path directory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            int c;
            Iterator<Path> pathIT = stream.iterator();
            Path path = null;
            for (c = 0; pathIT.hasNext() && c != 2; ++c) {
                path = pathIT.next();
            }
            if (c == 1 && path != null && path.getFileName().toString().equals(".reverseLookup")) {
                Files.delete(path);
                Files.delete(directory);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

